var GAMEID = 706;

var PS_GENERAL_CATEGORY		=	0;

var debug = new ActiveXObject("Statsmaster.DebugLog");
var it = new ActiveXObject("Statsmaster.IndexedTable");
var ps = new ActiveXObject("Statsmaster.KVPersistStorage");
var st = new ActiveXObject("Statsmaster.StringTable");
var fileSystem = new ActiveXObject("Scripting.FileSystemObject");
var kv;

var LOG_SUCCESS       = 0;
var LOG_ERROR         = 1;
var LOG_WARNING       = 2;
var LOG_INFORMATION   = 4;

var CAT_GENERAL				= 0
// Column enumeration
var COL_NUM_GAMES     		= 0;
var COL_RATING				= 1;
var COL_RATING_NICK			= 2;
var COL_BEST_SCORE			= 3;

// These column numbers are relative to the gametype column offsets above
var COL_HIGH_SCORE  		= 0;	
var COL_HIGH_COMBO  		= 1;
var COL_HIGH_SCORE_NICK		= 2;
var COL_HIGH_COMBO_NICK		= 3;

// Best day score columns
var COL_DAY_HIGH_SCORE 		= 0;	
var COL_DAY_HIGH_COMBO 		= 1;
var COL_DAY_HIGH_NICK		= 2;
var COL_DAY_HIGH_SCORE_LEVEL= 3;
var COL_DAY_HIGH_COMBO_LEVEL= 4;

//				 	 Load_NJ	 Load_NY	 Load_FL	 Load_SD	 Load_HI	 Load_VC	Load_SJ	   Load_RU	   Load_SE	    Load_VN	  	Load_HN		Load_SC2	
var int_map_crcs = [ -154656044, 1920361226, -680391191, -300129329, 966513896, 219087401, 161763016, -1648921988, -1726262439, 1941864084, -1476443829, -1935473659 ];
//					  nettrickattack	netgraffiti netscorechallenge	netcombomambo	netslap		netking		netgoalattack netctf	  netfirefight
var gametype_crcs = [ 818085795,		1580115212, 345515018, 		-989134896,		-103425741, 1861811616, -333443414,   1818227302, -1074579968 ];


function ProcessResults()
{
	var pid, i, j, level, index, player, gametype, score, combo, num, highScore, highCombo, match;
	var level_index, cat_offset, max_players, bestScore, bestDayScore, day, day_cat, cheats;
	// Get the results for this game.
	/////////////////////////////////
	kv = Processor.GetGameResults();

	debug.LogString(GAMEID, LOG_INFORMATION, "Processing results..." );

	var filename = "thug/web/process.txt";
    var file = fileSystem.OpenTextFile( filename, 2, true );
	var rating, time_limit;
	
	var all_keys;
	
	//debug.LogString(GAMEID, LOG_INFORMATION, "Processing results..." );

	all_keys = kv.GetKeyValues( 0 );
	//debug.LogString(GAMEID, LOG_INFORMATION, "Keys: " + all_keys );

	// Only accept 2-minute games for now
	time_limit = kv.GetIntValue("timelimit", 0);

	// We store a boolean for 'cheating enabled' in a key entitled 'highscore' to throw
	// hackers off the scent
/*	cheats = kv.GetIntValue( "highscore", 0 );
	if( cheats != 0 )
	{
		debug.LogString(GAMEID, LOG_INFORMATION, "Exiting due to enabled cheats" );
		file.close();
		return;
	}
*/
	// Get the level checksum.
	/////////////////
	level = kv.GetIntValue("mapcrc", 0);
	match = false;
	for( j = 0; j < int_map_crcs.length; j++ )
	{
		if( level == int_map_crcs[j] )
		{
			level_index = j;
			match = true;
			break;
		}
	}

	if( match == false )
	{
		debug.LogString(GAMEID, LOG_ERROR, "Error while processing gameid: " + Processor.GetDBGameID() + " (invalid map name) " + level );
		file.close();
		return;
	}

	// Get the gametype checksum.
	/////////////////
	gametype = kv.GetIntValue("gametypecrc", 0);
	match = false;
	for( j = 0; j < gametype_crcs.length; j++ )
	{
		var gametype_crc;

		gametype_crc = gametype_crcs[j];
		if( gametype == gametype_crc )
		{
			match = true;
			break;
		}
	}

	if( match == false )
	{
		debug.LogString(GAMEID, LOG_ERROR, "Error while processing gameid: " + Processor.GetDBGameID() + " (invalid game type) " + gametype );
		file.close();
		return;
	}
	
	// Don't accept results from goal attack
	if( gametype == -333443414 )
	{
		debug.LogString(GAMEID, LOG_INFORMATION, "Exiting due to goal attack" );
		file.close();
		return;
	}

	var date = new Date();
	var ms = date.getTime();

	day = (((( ms / 1000 ) / 60 ) / 60 ) / 24 );	// number of days since January 1, 1970
	day_cat = day;
	max_players = kv.GetIntValue("maxplayers", 8);
	for( i = 0; i < max_players; i++ )
	{
		// Get the player's profile id.
		///////////////////////////////
		pid = kv.GetPlayerIntValue( i, "id", 0);
		
		// Check for no player.
		///////////////////////
		if(pid == 0)
		{
			//debug.LogString(GAMEID, LOG_ERROR, "1-Error while processing gameid: " + Processor.GetDBGameID() + " (no id for player " + i + " )" );
			continue;
		}
	
		// Check for a validation error.
		////////////////////////////////
		if(pid < 0)
		{
			debug.LogString(GAMEID, LOG_ERROR, "2-Error while processing gameid: " + Processor.GetDBGameID() + " (no validation for player " + i + " )");
			continue;
		}
	
		// Update the number of times the player has skated this level.
		//////////////////////////////////////////////////////////////
		num = it.GetIntValue(GAMEID, pid, CAT_GENERAL, COL_NUM_GAMES, 0);
		it.SetIntValue(GAMEID, pid, CAT_GENERAL, COL_NUM_GAMES, num + 1);
	
		cat_offset = 1;
			
		// Get the player's name
		//////////////////
		player = kv.GetPlayerStringValue( i, "player", "Pro-Skater" );
		
		// Get the player's score.
		/////////////////////////
		score = kv.GetPlayerIntValue( i, "score", -1);
		if(score == -1)
		{
			debug.LogString(GAMEID, LOG_ERROR, "4-Error while processing gameid: " + Processor.GetDBGameID() + " (no score)");
			file.Close();
			return;
		}

		// Get the player's best combo of this game.
		/////////////////////////
		combo = kv.GetPlayerIntValue( i, "combo", 0);
		
		// Log what we got.
		///////////////////
		debug.LogString(GAMEID, LOG_INFORMATION, "Processing " + Processor.GetDBGameID() + ": pid = " + pid + ", level = " + level + ", score = " + score + ", combo = " + combo );
    
		bestScore = it.GetIntValue(GAMEID, pid, CAT_GENERAL, COL_BEST_SCORE, 0);
		bestDayScore = it.GetIntValue(GAMEID, pid, day_cat, COL_DAY_HIGH_SCORE, 0 );
        // Update high score if needed.
		//////////////////////////////
		if(( gametype == 0x30c2ffa3 ) && ( time_limit == 120 ))
		{
			// Test against all-time high score
			if( score > bestScore )
			{
				it.SetIntValue(GAMEID, pid, CAT_GENERAL, COL_BEST_SCORE, score );
				index = it.GetIntValue(GAMEID, pid, CAT_GENERAL, COL_RATING_NICK, -1 );
				if( index == -1 )
				{
					index = st.PutString( GAMEID, player );
					it.SetIntValue(GAMEID, pid, CAT_GENERAL, COL_RATING_NICK, index );
				}
				else
				{
					st.UpdString( index, player );
				}
			}
			if( score > bestDayScore )
			{
				debug.LogString(GAMEID, LOG_INFORMATION, "Player: " + player + " beat previous day high for level (" + bestDayScore + ")" );

				it.SetIntValue(GAMEID, pid, day_cat, COL_DAY_HIGH_SCORE, score );
				it.SetIntValue(GAMEID, pid, day_cat, COL_DAY_HIGH_SCORE_LEVEL, level_index );
				index = it.GetIntValue(GAMEID, pid, day_cat, COL_DAY_HIGH_NICK, -1 );
				if( index == -1 )
				{
					index = st.PutString( GAMEID, player );
					it.SetIntValue(GAMEID, pid, day_cat, COL_DAY_HIGH_NICK, index );
				}
				else
				{
					st.UpdString( index, player );
				}
			}

			// test against per-level high score
			highScore = it.GetIntValue(GAMEID, pid, level_index + cat_offset, COL_HIGH_SCORE, 0);
			if( score > highScore )
			{
				debug.LogString(GAMEID, LOG_INFORMATION, "beat previous high for level (" + highScore + ")" );
				// They beat their high score. Store the new score
				it.SetIntValue(GAMEID, pid, level_index + cat_offset, COL_HIGH_SCORE, score);
				// We also want to store the nickname they used when they got this score.
				// First, see if we already have a nickname string associated with the high 
				// score for this level.
				index = it.GetIntValue(GAMEID, pid, level_index + cat_offset, COL_HIGH_SCORE_NICK, -1 );
				if( index == -1 )
				{
					// We don't. Create a new string and store the index to that string (which resides
					// in the StringTable) in the IndexTable
					index = st.PutString( GAMEID, player );
					it.SetIntValue(GAMEID, pid, level_index + cat_offset, COL_HIGH_SCORE_NICK, index );
				}
				else
				{
					// We do. Just update that string
					st.UpdString( index, player );
				}
			}

            var category = level_index + 1; // General category is zero, so offset from that
			var record = ps.LoadRecord(GAMEID, pid, category, 2 );
			var old_high = record.GetIntValue( "HighScore", 1 );
			if( score > old_high )
			{
				record.SetIntValue( "HighScore", score );
				ps.SaveRecord(GAMEID, pid, category, 2, record );
			}
		}
	
		debug.LogString(GAMEID, LOG_INFORMATION, "4)Processing results..." );
		// Update high combo if needed.
		//////////////////////////////
		highCombo = it.GetIntValue(GAMEID, pid, level_index + cat_offset, COL_HIGH_COMBO, 0);
		bestDayScore = it.GetIntValue(GAMEID, pid, day_cat, COL_DAY_HIGH_COMBO, 0 );
		if( combo > highCombo )
		{
			debug.LogString(GAMEID, LOG_INFORMATION, "beat previous combo for level (" + highCombo + ")" );
			// They beat their high combo. Store the new score
			it.SetIntValue(GAMEID, pid, level_index + cat_offset, COL_HIGH_COMBO, combo);
			// We also want to store the nickname they used when they got this combo.
			// First, see if we already have a nickname string associated with the high 
			// combo for this level.
			index = it.GetIntValue(GAMEID, pid, level_index + cat_offset, COL_HIGH_COMBO_NICK, -1 );
			if( index == -1 )
			{
				// We don't. Create a new string and store the index to that string (which resides
				// in the StringTable) in the IndexTable
				index = st.PutString( GAMEID, player );
				it.SetIntValue(GAMEID, pid, level_index + cat_offset, COL_HIGH_COMBO_NICK, index );
			}
			else
			{
				// We do. Just update that string
				st.UpdString( index, player );
			}
		}
		if( combo > bestDayScore )
		{
			debug.LogString(GAMEID, LOG_INFORMATION, "Player: " + player + " beat previous day high for level (" + bestDayScore + ")" );

			it.SetIntValue(GAMEID, pid, day_cat, COL_DAY_HIGH_COMBO, combo );
			it.SetIntValue(GAMEID, pid, day_cat, COL_DAY_HIGH_COMBO_LEVEL, level_index );
			index = it.GetIntValue(GAMEID, pid, day_cat, COL_DAY_HIGH_NICK, -1 );
			if( index == -1 )
			{
				index = st.PutString( GAMEID, player );
				it.SetIntValue(GAMEID, pid, day_cat, COL_DAY_HIGH_NICK, index );
			}
			else
			{
				st.UpdString( index, player );
			}
	
			//debug.LogString(GAMEID, LOG_INFORMATION, "Setting high combo to " + combo + " for level " + level_index + " for index " + index );
		}

		var category = level_index + 1; // General category is zero, so offset from that
		var record = ps.LoadRecord(GAMEID, pid, category, 2 );
		var old_high = record.GetIntValue( "HighCombo", 1 );
		if( combo > old_high )
		{
			record.SetIntValue( "HighCombo", combo );
			ps.SaveRecord(GAMEID, pid, category, 2, record );
		}
	}
		
	debug.LogString(GAMEID, LOG_INFORMATION, "Game successfully processed!");
	
	file.Close();
}
