/******
sample1Dlg.cpp
GameSpy C Engine SDK
  
Copyright 1999-2001 GameSpy Industries, Inc

18002 Skypark Circle
Irvine, California 92614
949.798.4200 (Tel)
949.798.4299 (Fax)
devsupport@gamespy.com

******

 Please see the GameSpy C Engine SDK documentation for more 
 information

******/

#include "stdafx.h"
#include "sample1.h"
#include "sample1Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// #define LIST_GAMENAME "unreal" //the type of server list we are getting

/////////////////////////////////////////////////////////////////////////////
// CSample1Dlg dialog

CSample1Dlg::CSample1Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSample1Dlg::IDD, pParent), m_serverlist(NULL)
{
	//{{AFX_DATA_INIT(CSample1Dlg)
	m_strGame = _T("ut");
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSample1Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSample1Dlg)
	DDX_Control(pDX, IDC_PROGRESS, m_ProgressBar);
	DDX_Control(pDX, IDC_SERVERLIST, m_ServerListBox);
	DDX_Control(pDX, IDC_PLAYERLIST, m_PlayerListBox);
	DDX_Text(pDX, IDC_EDIT_GAME, m_strGame);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSample1Dlg, CDialog)
	//{{AFX_MSG_MAP(CSample1Dlg)
	ON_NOTIFY(NM_DBLCLK, IDC_SERVERLIST, OnDblclkServerlist)
	ON_BN_CLICKED(IDC_REFRESH, OnRefresh)
	ON_NOTIFY(NM_CLICK, IDC_SERVERLIST, OnClickServerlist)
	ON_WM_TIMER()
	ON_NOTIFY(LVN_COLUMNCLICK, IDC_SERVERLIST, OnColumnclickServerlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSample1Dlg message handlers

//crt -- callback function for the server list
void ListCallBack(GServerList serverlist, int msg, void *instance, void *param1, void *param2)
{
	CSample1Dlg *pDlg = (CSample1Dlg *)instance;
	if (msg == LIST_PROGRESS) // a progress / new server message
	{
		pDlg->AddServer((GServer)param1);
		pDlg->m_ProgressBar.SetPos((int)param2);

	} else 
		if (msg == LIST_STATECHANGED) //list state changed
		{
			switch (ServerListState(serverlist))
			{
			case sl_idle : //done updating
				if (pDlg->m_TimerID != 0) //kill the async timer
				{
					pDlg->KillTimer(pDlg->m_TimerID);
					pDlg->m_TimerID = 0;
				}
				pDlg->m_ProgressBar.SetPos(0);
				pDlg->SetDlgItemText(IDC_STATUS,"Done");
				break;
			case sl_listxfer:
				pDlg->SetDlgItemText(IDC_STATUS,"Getting List");
				break;
			case sl_lanlist:
				pDlg->SetDlgItemText(IDC_STATUS,"Searching LAN...");
				break;
			case sl_querying:
				pDlg->SetDlgItemText(IDC_STATUS,"Querying Servers");
				break;
				
			}
		}
		


}

//when the form is initialized
BOOL CSample1Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// crt -- set up the columns on the listview
	m_ServerListBox.InsertColumn( COL_SERVERNAME, "Server Name", LVCFMT_LEFT, 150, -1 );
	m_ServerListBox.InsertColumn( COL_PING, "Ping", LVCFMT_LEFT, 50, 0 );
	m_ServerListBox.InsertColumn( COL_PLAYERS, "Players", LVCFMT_LEFT, 75, 1 );
	m_ServerListBox.InsertColumn( COL_MAPNAME, "Map", LVCFMT_LEFT, 75, 2 );
	m_ServerListBox.InsertColumn( COL_GAMETYPE, "GameType", LVCFMT_LEFT, 100, 3 );
	m_PlayerListBox.InsertColumn( COL_PNAME, "Player Name",LVCFMT_LEFT, 100, -1 );
	m_PlayerListBox.InsertColumn( COL_PPING, "Ping",LVCFMT_LEFT, 75, 0 );
	m_PlayerListBox.InsertColumn( COL_PFRAGS, "Frags",LVCFMT_LEFT, 75, 1 );
	ListView_SetExtendedListViewStyle(m_ServerListBox.m_hWnd,LVS_EX_FULLROWSELECT);
	ListView_SetExtendedListViewStyle(m_PlayerListBox.m_hWnd,LVS_EX_FULLROWSELECT);

	m_ProgressBar.SetRange(0,100); //set the progress bar range
	CheckRadioButton(IDC_INTERNET, IDC_LAN, IDC_INTERNET); //check the inet button
	
	//create our serverlist
	m_TimerID = 0; 
	return TRUE;  // return TRUE  unless you set the focus to a control
}


//add a server to the listview
void CSample1Dlg::AddServer(GServer server)
{
	char temp[20];
	int index = m_ServerListBox.GetItemCount( );

	m_ServerListBox.InsertItem(index,ServerGetStringValue(server, "hostname","(NONE)"));
	sprintf(temp,"%d",ServerGetPing(server));
	m_ServerListBox.SetItem(index,COL_SERVERNAME,LVIF_PARAM,NULL,-1,0,0,(LPARAM)server);
	m_ServerListBox.SetItem(index,COL_PING,LVIF_TEXT,temp,-1,0,0,0);
	sprintf(temp,"%d/%d",ServerGetIntValue(server,"numplayers",0), ServerGetIntValue(server,"maxplayers",0));
	m_ServerListBox.SetItem(index,COL_PLAYERS,LVIF_TEXT,temp,-1,0,0,0);
	m_ServerListBox.SetItem(index,COL_MAPNAME,LVIF_TEXT,ServerGetStringValue(server,"mapname","(NO MAP)"),-1,0,0,0);
	m_ServerListBox.SetItem(index,COL_GAMETYPE,LVIF_TEXT,ServerGetStringValue(server,"gametype",""),-1,0,0,0);
	
	
}


//when the item is doubleclicked
void CSample1Dlg::OnDblclkServerlist(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// launch the game here
	MessageBox("If this were a real server browser, you would be launched now!","Go!");
	
	*pResult = 0;
}


//when the refresh button is pressed
#define ASYNCTIMERID 6000
void CSample1Dlg::OnRefresh() 
{
	CreateServerList( );

	if( !m_serverlist )
		return;

	// check it we are updating.. if so, cancel it
	if (ServerListState(m_serverlist) != sl_idle)
	{
		ServerListHalt(m_serverlist);
		return;
	}
	//clear the old list
	ServerListClear(m_serverlist);
	//and the listview
	m_ServerListBox.DeleteAllItems();
	if (m_TimerID == 0) //need a processing timer
		m_TimerID = SetTimer(ASYNCTIMERID, 10,NULL); //the async processing timer
	if (IsDlgButtonChecked(IDC_INTERNET) == BST_CHECKED) //internet update
		ServerListUpdate(m_serverlist,true); //do an async list update
	else
		ServerListLANUpdate(m_serverlist,true,START_PORT,START_PORT+100,1); //do an async LAN list update
	
}

//when the window closes
BOOL CSample1Dlg::DestroyWindow() 
{
	// free the server list

	if( m_serverlist )
		ServerListFree(m_serverlist);
	
	return CDialog::DestroyWindow();
}

//when they click an item on the list
void CSample1Dlg::OnClickServerlist(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;
	//clear the player box
	m_PlayerListBox.DeleteAllItems();

	//find the item they selected
	POSITION pos = m_ServerListBox.GetFirstSelectedItemPosition();
	if (pos == NULL)
		return;
	int nItem = m_ServerListBox.GetNextSelectedItem(pos);
      
	LVITEM item;
	item.mask = LVIF_PARAM ;
	item.iItem = nItem;
	item.iSubItem = 0;

	m_ServerListBox.GetItem(&item);
	//get the server out of the item
	GServer server = (GServer)item.lParam;
	//count the players
	int numplayers = ServerGetIntValue(server,"numplayers",0);
	//add the info for each player
	for (int i = 0 ; i < numplayers ; i++)
	{
		m_PlayerListBox.InsertItem(0,ServerGetPlayerStringValue(server, i, "player",""));
		m_PlayerListBox.SetItem(0,1,LVIF_TEXT,ServerGetPlayerStringValue(server,i,"ping","0"),-1,0,0,0);
		m_PlayerListBox.SetItem(0,2,LVIF_TEXT,ServerGetPlayerStringValue(server,i,"frags","0"),-1,0,0,0);
	}

}

//called every 10ms when updates are in progress
void CSample1Dlg::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent == m_TimerID) //we need to do a server list think now!
		ServerListThink(m_serverlist);
		
	CDialog::OnTimer(nIDEvent);
}


//called when clicking the column list to sort
// we don't use the ListView sort routines, instead, we clear the listview
// use the internal server list sorting, and then repopulate it
// not fast, but very simple
void CSample1Dlg::OnColumnclickServerlist(NMHDR* pNMHDR, LRESULT* pResult) 
{
	static bool ascending = false;
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	int i;
	
	ascending = !ascending;
	//figure out which they clicked on
	switch (pNMListView->iSubItem)
	{

	case COL_SERVERNAME:
		ServerListSort(m_serverlist,ascending, "hostname",cm_stricase);
		break;
	case COL_PING:
		ServerListSort(m_serverlist,ascending, "ping",cm_int);
		break;
	case COL_PLAYERS:
		ServerListSort(m_serverlist,ascending, "numplayers",cm_int);
		break;
	case COL_MAPNAME:
		ServerListSort(m_serverlist,ascending, "mapname",cm_stricase);
		break;
	case COL_GAMETYPE:
		ServerListSort(m_serverlist,ascending, "gametype",cm_stricase);
		break;

	}
	m_ServerListBox.DeleteAllItems(); //clear it out
	//add them back
	for (i = 0; i < ServerListCount(m_serverlist) ; i++)
	{
		AddServer(ServerListGetServer(m_serverlist,i));

	}

	
	*pResult = 0;
}

void CSample1Dlg::CreateServerList( )
{
	if( !m_serverlist )
	{
		UpdateData( );

		if( m_strGame.IsEmpty() )
		{
			AfxMessageBox( "Please make sure you specify a game!" );
			GetDlgItem(IDC_EDIT_GAME)->SetFocus( );
			return;
		}
		m_serverlist = ServerListNew((LPSTR)(LPCSTR)m_strGame,"gmtest","HA6zkS",10,ListCallBack,GCALLBACK_FUNCTION,this);
	}
}