max_wheel_speed = 16.0
tree_speed_x = 16
tree_speed_y = 16
branch_speed_x = 16

// whether the camera resets when you reload a model
ResetCameraToViewerObject = 1

// this is the minimum amount of time you need to hold
// down the left/right keys before the frame incrementing
// will auto repeat
ViewerAutoRepeatTime = 30
	
// this is how fast the frame incrementing will auto repeat
ViewerAutoRepeatSpeed = 0

script create_human_model_set

	// THPS5 stuff	
	make_select_view_model_line text = "THPS5 Skater" skater_profile_index=0 animName=animload_thps5_human skeletonName=thps5_human AnimEventTableName=SkaterAnimEventTable
    make_select_view_model_line text = "Test Facial" modelName = "test_facial\test_facial.skin" animName=animload_Test_Facial skeletonName=test_facial
    make_select_view_model_line text = "Eric_Head" modelName = "Cutscenes\Eric_Head.skin" animName=animload_Eric_Head skeletonName=Eric_Head
    make_select_view_model_line text = "Peralta_Head" modelName = "Cutscenes\Head_Peralta.skin" animName=animload_Head_Peralta skeletonName=Head_Peralta
    make_select_view_model_line text = "Ped_Eric" modelName = "Peds\Ped_Eric\Ped_Eric.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Hawk_Head" modelName = "Cutscenes\Hawk_Head.skin" animName=animload_Hawk_Head skeletonName=Hawk_Head
    make_select_view_model_line text = "Muska_Head" modelName = "Cutscenes\Muska_Head.skin" animName=animload_Muska_Head skeletonName=Muska_Head
    make_select_view_model_line text = "Lasek_Head" modelName = "Cutscenes\Lasek_Head.skin" animName=animload_Lasek_Head skeletonName=Lasek_Head
    make_select_view_model_line text = "Magera_Head" modelName = "Cutscenes\Magera_Head.skin" animName=animload_Magera_Head skeletonName=Magera_Head
    make_select_view_model_line text = "Mullen_Head" modelName = "Cutscenes\Mullen_Head.skin" animName=animload_Mullen_Head skeletonName=Mullen_Head
    make_select_view_model_line text = "Rowley_Head" modelName = "Cutscenes\Rowley_Head.skin" animName=animload_Rowley_Head skeletonName=Rowley_Head
    make_select_view_model_line text = "Vallely_Head" modelName = "Cutscenes\Vallely_Head.skin" animName=animload_Vallely_Head skeletonName=Vallely_Head
    make_select_view_model_line text = "Manager_Head" modelName = "Cutscenes\Manager_Head.skin" animName=animload_Manager_Head skeletonName=Manager_Head
    make_select_view_model_line text = "Trooper_Head" modelName = "Cutscenes\Trooper_Head.skin" animName=animload_Head_Trooper skeletonName=Head_Trooper
    make_select_view_model_line text = "Head_Cas_male " modelName = "Cutscenes\Head_cas_male01.skin" animName=animload_Head_cas_male01 skeletonName=Head_cas_male01
    make_select_view_model_line text = "Head_CAS_Male_Facemap" modelName = "Cutscenes\Head_CAS_Male02.skin" animName=animload_Head_cas_male01 skeletonName=Head_cas_male01
    make_select_view_model_line text = "Head_CAS_female" modelName = "Cutscenes\Head_CAS_female01.skin" animName=animload_Head_cas_male01 skeletonName=Head_cas_male01
    make_select_view_model_line text = "NewPro Head" modelName = "Cutscenes\NewPro_Head.skin" animName=animload_Eric_Head skeletonName=Eric_Head
    make_select_view_model_line text = "Official_FL Head" modelName = "Cutscenes\Official_FL_Head.skin" animName=animload_Eric_Head skeletonName=Eric_Head
	make_select_view_model_line text = "Official_RU_Head" modelName = "Cutscenes\Official_RU_Head.skin" animName=animload_Manager_Head skeletonName=Manager_Head
    make_select_view_model_line text = "Cutscene Bodyguard" modelName = "Cutscenes\Cut_Bodyguard_FULL.skin" animName=animload_thps5_human skeletonName=thps5_human

    make_select_view_model_line text = "NY1_Skater_Head" modelName = "Cutscenes\Skater_NY1_Head.skin" animName=animload_Lasek_Head skeletonName=Lasek_Head

    make_select_view_model_line text = "Ped_Bum1" modelName = "Peds\Ped_Bum1\Ped_Bum1.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_CrackHead" modelName = "Peds\Ped_CrackHead\Ped_CrackHead.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_DrugDealer1" modelName = "Peds\Ped_DrugDealer1\Ped_DrugDealer1.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_DrugDealer2" modelName = "Peds\Ped_DrugDealer2\Ped_DrugDealer2.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_DrugDealer3" modelName = "Peds\Ped_DrugDealer3\Ped_DrugDealer3.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_FactoryWorker1" modelName = "Peds\Ped_FactoryWorker1\Ped_FactoryWorker1.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_FactoryWorker2" modelName = "Peds\Ped_FactoryWorker2\Ped_FactoryWorker2.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_Security_Train" modelName = "Peds\Ped_Security_Train\Ped_Security_Train.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_StreetWarrior1" modelName = "Peds\Ped_StreetWarrior1\Ped_StreetWarrior1.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_StreetWarrior2" profile=Ped_Street_Warrior_02 animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_StreetWarrior3" profile=Ped_Street_Warrior_03 animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_Tombstone" modelName = "Peds\Ped_Tombstone\Ped_Tombstone.skin" animName=animload_thps5_human skeletonName=thps5_human

    make_select_view_model_line text = "Ped_BusinessMan1" modelName = "Peds\Ped_BusinessMan1\Ped_BusinessMan1.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_BusinessMan2" modelName = "Peds\Ped_BusinessMan2\Ped_BusinessMan2.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_BusinessMan3" modelName = "Peds\Ped_BusinessMan3\Ped_BusinessMan3.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_M_NYPD_01" profile = Ped_M_NYPD_01 animName=animload_thps5_human skeletonName=thps5_human
	make_select_view_model_line text = "Ped_F_NYPD_01" profile = Ped_F_NYPD_01 animName=animload_Ped_Female skeletonName=Ped_Female
	make_select_view_model_line text = "Ped_Construction_Jhammer" profile = Ped_Construction_Jhammer animName=animload_thps5_human skeletonName=thps5_human
	make_select_view_model_line text = "Ped_Construction_Manhole" profile = Ped_Construction_Manhole animName=animload_thps5_human skeletonName=thps5_human
	make_select_view_model_line text = "Ped_Peralta" profile = Ped_Peralta animName=animload_thps5_human skeletonName=thps5_human
	make_select_view_model_line text = "Ped_NY Skater1" profile = Ped_Skater_NY1 animName=animload_thps5_human skeletonName=thps5_human 
	make_select_view_model_line text = "Ped_NY Skater2" profile = Ped_Skater_NY2 animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_BlkKid1" modelName = "Peds\Ped_BlkKid1\Ped_BlkKid1.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_BlkKid2" modelName = "Peds\Ped_BlkKid2\Ped_BlkKid2.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_BlkKid3" modelName = "Peds\Ped_BlkKid3\Ped_BlkKid3.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_Trooper" modelName = "Peds\Ped_Trooper\Ped_Trooper.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_Todd" modelName = "Peds\Ped_Todd\Ped_Todd.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_F_Dancer1" modelName = "Peds\Ped_F_Dancer1\Ped_F_Dancer1.skin" animName=animload_Ped_Female skeletonName=Ped_Female
    make_select_view_model_line text = "Ped_F_Dancer2" modelName = "Peds\Ped_F_Dancer2\Ped_F_Dancer2.skin" animName=animload_Ped_Female skeletonName=Ped_Female
    make_select_view_model_line text = "Ped_Female" modelName = "Ped_Female\Ped_Female.skin" animName=animload_Ped_Female skeletonName=Ped_Female
    make_select_view_model_line text = "Ped_Chef" modelName = "Peds\Ped_Chef\Ped_Chef.skin" animName=animload_thps5_human extraAnim=animload_ped_Video Defaultanim = Ped_Video_PhotoIdle skeletonName=thps5_human
   //VC
    make_select_view_model_line text = "CutScene official_SC" modelName = "Cutscenes\Official_SC_Full.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_Official_SC" modelName = "Peds\Ped_Official_SC\Ped_official_SC.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_F_deskclerk" modelName = "Peds\Ped_F_deskclerk\Ped_F_deskclerk.skin" animName=animload_Ped_Female skeletonName=Ped_Female
    make_select_view_model_line text = "Ped_DeskClerk" modelName = "Peds\Ped_deskclerk1\Ped_deskclerk1.skin" animName=animload_thps5_human skeletonName=thps5_human
    make_select_view_model_line text = "Ped_Doorman" modelName = "Peds\Ped_Doorman\Ped_Doorman.skin" animName=animload_thps5_human skeletonName=thps5_human              
	make_select_view_model_line text = "Ped_Businesswoman" modelName = "Peds\Ped_Businesswoman\Ped_Businesswoman.skin" animName=animload_Ped_Female skeletonName=Ped_Female	
	make_select_view_model_line text = "Monster Ped A 01" modelName = "Peds\Ped_Crowds\Ped_CrowdA_01.skin" animName=animload_Monsterped skeletonName=Monsterped
	make_select_view_model_line text = "Monster Ped A 01B" modelName = "Peds\Ped_Crowds\Ped_CrowdA_01B.skin" animName=animload_Monsterped skeletonName=Monsterped  	    	  
	make_select_view_model_line text = "Monster Ped B 01" modelName = "Peds\Ped_Crowds\Ped_CrowdB_01.skin" animName=animload_Monsterped skeletonName=Monsterped 
	make_select_view_model_line text = "Monster Ped C 01" modelName = "Peds\Ped_Crowds\Ped_CrowdC_01.skin" animName=animload_Monsterped skeletonName=Monsterped
	make_select_view_model_line text = "Monster Ped A 02" modelName = "Peds\Ped_Crowds\Ped_CrowdA_02.skin" animName=animload_Monsterped skeletonName=Monsterped  	  
	make_select_view_model_line text = "Monster Ped B 02" modelName = "Peds\Ped_Crowds\Ped_CrowdB_02.skin" animName=animload_Monsterped skeletonName=Monsterped 
	make_select_view_model_line text = "Monster Ped C 02" modelName = "Peds\Ped_Crowds\Ped_CrowdC_02.skin" animName=animload_Monsterped skeletonName=Monsterped
	make_select_view_model_line text = "Monster Ped A 03" modelName = "Peds\Ped_Crowds\Ped_CrowdA_03.skin" animName=animload_Monsterped skeletonName=Monsterped  	  
	make_select_view_model_line text = "Monster Ped B 03" modelName = "Peds\Ped_Crowds\Ped_CrowdB_03.skin" animName=animload_Monsterped skeletonName=Monsterped 
	make_select_view_model_line text = "Monster Ped C 03" modelName = "Peds\Ped_Crowds\Ped_CrowdC_03.skin" animName=animload_Monsterped skeletonName=Monsterped
	make_select_view_model_line text = "Monster Ped A 04" modelName = "Peds\Ped_Crowds\Ped_CrowdA_04.skin" animName=animload_Monsterped skeletonName=Monsterped  	  
	make_select_view_model_line text = "Monster Ped B 04" modelName = "Peds\Ped_Crowds\Ped_CrowdB_04.skin" animName=animload_Monsterped skeletonName=Monsterped 
	make_select_view_model_line text = "Monster Ped C 04" modelName = "Peds\Ped_Crowds\Ped_CrowdC_04.skin" animName=animload_Monsterped skeletonName=Monsterped
	make_select_view_model_line text = "Ped_QBert" modelName = "Peds\Ped_QBert\Ped_QBert.skin" animName=animload_thps5_human extraAnim=animload_ped_djqbert Defaultanim = Ped_DJQBert_Scratch3 skeletonName=thps5_human              
    make_select_view_model_line text = "Ped_DV Guy" modelName = "Peds\Ped_Video\Ped_Video.skin" animName=animload_thps5_human extraAnim=animload_ped_Video Defaultanim = Ped_Video_PhotoIdle skeletonName=thps5_human              
	make_select_view_model_line text = "Ped_Photo" modelName = "Peds\Ped_Photo\Ped_Photo.skin" animName=animload_thps5_human extraAnim=animload_ped_Photo Defaultanim = Ped_Photo_Shoot3 skeletonName=thps5_human 
	make_select_view_model_line text = "Ped_Leafblower" profile = Ped_Leafblower animName=animload_thps5_human extraAnim=animload_ped_Leafblower Defaultanim = Ped_Leafblower_blowing2 skeletonName=thps5_human
    make_select_view_model_line text = "Ped_SCJ_Judge" profile = Ped_SCJ_Judge_04 animName=animload_thps5_human skeletonName=thps5_human
   //Tampa
   make_select_view_model_line text = "Ped_Clemens" profile = Ped_Clemens animName=animload_thps5_human skeletonName=thps5_human
   make_select_view_model_line text = "Ped_AfroJim" profile = Ped_AfroJim animName=animload_thps5_human skeletonName=thps5_human
   //San Diego
    make_select_view_model_line text = "Ped_Security_01" profile = Ped_Security_01 animName=animload_thps5_human skeletonName=thps5_human
	make_select_view_model_line text = "Ped_Security_02" profile = Ped_Security_02 animName=animload_thps5_human skeletonName=thps5_human
	make_select_view_model_line text = "Ped_Security_03" profile = Ped_Security_03 animName=animload_thps5_human skeletonName=thps5_human
	make_select_view_model_line text = "Ped_F_Security" modelName = "Peds\Ped_Security\Ped_F_Security.skin" animName=animload_thps5_human skeletonName=thps5_human
	make_select_view_model_line text = "Ped_Gardener_01" profile = Ped_Gardener_01 animName=animload_thps5_human extraAnim=animload_ped_Video Defaultanim = Ped_Video_PhotoIdle skeletonName=thps5_human
	make_select_view_model_line text = "Ped_Gardener_02" profile = Ped_Gardener_02 animName=animload_thps5_human extraAnim=animload_ped_Video Defaultanim = Ped_Video_PhotoIdle skeletonName=thps5_human
	make_select_view_model_line text = "Ped_F_Gardener" modelName = "Peds\Ped_Gardener\Ped_F_Gardener.skin" animName=animload_thps5_human extraAnim=animload_ped_Video Defaultanim = Ped_Video_PhotoIdle skeletonName=thps5_human
	//Moscow
	make_select_view_model_line text = "Ped_F_Moscow_Celeb" modelName = "Peds\Ped_F_MCeleb\Ped_F_MCeleb.skin" animName=animload_Ped_Female extraAnim=animload_Ped_F_Presenter Defaultanim = ped_f_presenter_talk1  skeletonName=Ped_Female
	make_select_view_model_line text = "Ped_F_KGB" modelName = "Peds\Ped_KGB\Ped_F_KGB.skin" animName=animload_thps5_human extraAnim=animload_ped_KGB Defaultanim = Ped_KGB_CheckEar skeletonName=thps5_human			  
	make_select_view_model_line text = "Ped_KGB01" profile = Ped_KGB_01 animName=animload_thps5_human extraAnim=animload_ped_KGB Defaultanim = Ped_KGB_CheckEar skeletonName=thps5_human	  
	make_select_view_model_line text = "Ped_KGB02" profile = Ped_KGB_02 animName=animload_thps5_human extraAnim=animload_ped_KGB Defaultanim = Ped_KGB_CheckEar skeletonName=thps5_human	
	make_select_view_model_line text = "Ped_RGuard01" profile = Ped_RGuard_01 animName=animload_thps5_human skeletonName=thps5_human 
	make_select_view_model_line text = "Ped_RGuard02" profile = Ped_RGuard_02 animName=animload_thps5_human skeletonName=thps5_human  	  			  
	make_select_view_model_line text = "Ped_Babushka" profile = Ped_F_Babushka animName=animload_Ped_Female skeletonName=Ped_Female
	make_select_view_model_line text = "Ped_Cameraman" profile = Ped_Cameraman animName=animload_thps5_human skeletonName=thps5_human			  
	//Hawaii
	make_select_view_model_line text = "Ped_F_Hula" modelName = "Peds\Ped_Hula\Ped_Hula.skin" animName=animload_Ped_Female extraAnim=animload_Ped_Hula Defaultanim = ped_Hula_Dance3  skeletonName=Ped_Female			  
	make_select_view_model_line text = "Ped_F_Hula2" modelName = "Peds\Ped_Hula\Ped_Hula2.skin" animName=animload_Ped_Female extraAnim=animload_Ped_Hula Defaultanim = ped_Hula_Dance3  skeletonName=Ped_Female			  
	make_select_view_model_line text = "Ped_F_Bikini_1" modelName = "Peds\Ped_Bikini\Ped_Bikini_1.skin" animName=animload_Ped_Female extraAnim=animload_Ped_Bikini Defaultanim = ped_Bikini_Showering  skeletonName=Ped_Female
	make_select_view_model_line text = "Ped_F_Bikini_2" modelName = "Peds\Ped_Bikini\Ped_Bikini_2.skin" animName=animload_Ped_Female extraAnim=animload_Ped_Bikini Defaultanim = ped_Bikini_Showering  skeletonName=Ped_Female
    make_select_view_model_line text = "Ped_F_Bikini_3" modelName = "Peds\Ped_Bikini\Ped_Bikini_3.skin" animName=animload_Ped_Female extraAnim=animload_Ped_Bikini Defaultanim = ped_Bikini_Showering  skeletonName=Ped_Female
    make_select_view_model_line text = "Ped_Bartender" profile = Ped_Bartender animName=animload_thps5_human skeletonName=thps5_human			  
	make_select_view_model_line text = "Ped_Bride" modelName = "Peds\Ped_Bride\Ped_Bride.skin" animName=animload_Ped_Female extraAnim=animload_Ped_Bikini Defaultanim = ped_Bikini_Showering  skeletonName=Ped_Female
	make_select_view_model_line text = "Ped_Surfer" modelName = "Peds\Ped_Surfer\Ped_Surfer.skin" animName=animload_thps5_human skeletonName=thps5_human			  
	//Secret Level
	make_select_view_model_line text = "Ped_KISS_Paul" modelName = "Peds\Ped_KISS\Ped_KISS_Paul.skin" animName=animload_thps5_human skeletonName=thps5_human 
	make_select_view_model_line text = "Ped_KISS_Peter" modelName = "Peds\Ped_KISS\Ped_KISS_Peter.skin" animName=animload_thps5_human skeletonName=thps5_human   		  
	make_select_view_model_line text = "Ped_KISS_Ace" modelName = "Peds\Ped_KISS\Ped_KISS_Ace.skin" animName=animload_thps5_human skeletonName=thps5_human   		  
	make_select_view_model_line text = "Ped_KISS_Gene" modelName = "Peds\Ped_KISS\Ped_KISS_Gene.skin" animName=animload_thps5_human skeletonName=thps5_human
	make_select_view_model_line text = "Ped_Freak_Sledge" profile = Ped_Freak_Sledge animName=animload_thps5_human extraAnim=animload_ped_Sword Defaultanim = Ped_Sword_Chop skeletonName=thps5_human	
	make_select_view_model_line text = "Ped_Freak_Sword" profile = Ped_Freak_Sword animName=animload_thps5_human extraAnim=animload_ped_Sword Defaultanim = Ped_Sword_Swallow1 skeletonName=thps5_human	
	//Ped Pros
        make_select_view_model_line text = "PedPro_Hawk" profile = PedPro_Hawk animName=animload_thps5_human skeletonName=thps5_human			  
        make_select_view_model_line text = "PedPro_Koston" profile = PedPro_Koston animName=animload_thps5_human skeletonName=thps5_human			  
        make_select_view_model_line text = "PedPro_Burnquist" profile = PedPro_Burnquist animName=animload_thps5_human skeletonName=thps5_human			  
        make_select_view_model_line text = "PedPro_Lasek" profile = PedPro_Lasek animName=animload_thps5_human skeletonName=thps5_human			  
        make_select_view_model_line text = "PedPro_Mullen" profile = PedPro_Mullen animName=animload_thps5_human skeletonName=thps5_human			  
        make_select_view_model_line text = "PedPro_Muska" profile = PedPro_Muska animName=animload_thps5_human skeletonName=thps5_human			  
        make_select_view_model_line text = "PedPro_Margera" profile = PedPro_Margera animName=animload_thps5_human skeletonName=thps5_human			  
        make_select_view_model_line text = "PedPro_Rodrigez" profile = PedPro_Rodrigez animName=animload_thps5_human skeletonName=thps5_human			  
        make_select_view_model_line text = "PedPro_Reynolds" profile = PedPro_Reynolds animName=animload_thps5_human skeletonName=thps5_human			  
        make_select_view_model_line text = "PedPro_Vallely" profile = PedPro_Vallely animName=animload_thps5_human skeletonName=thps5_human			  
   //Ped Pro Teamates
     make_select_view_model_line text = "Ped_Skeezo" profile = Ped_Skeezo animName=animload_thps5_human skeletonName=thps5_human   		  
	 make_select_view_model_line text = "Ped_Bender" profile = Ped_Bender animName=animload_thps5_human skeletonName=thps5_human   		  
	 make_select_view_model_line text = "Ped_Ralphie" profile = Ped_Ralphie animName=animload_thps5_human skeletonName=thps5_human   		  
				  // Tree Stuff
    make_select_view_model_line text = "Tree test" modelName = "treetest\treetest.skin" animName=animload_treetest skeletonName=treetest
    make_select_view_model_line text = "Tree test 2" modelName = "treetest\treetest2.skin" animName=animload_treetest2 skeletonName=treetest2

make_select_view_model_line {
		text="Steve Ganem"
		model="ped_male\ped_sganem.skin"

		// 15 feet to first lod
		modelLOD1="ped_male\ped_sganem_lod1.skin"
		modelLODDist1=300.0

		// 10 feet for each additional one
		modelLOD2="ped_male\ped_sganem_lod2.skin"
		modelLODDist2=420.0

		// 10 feet for each additional one
		modelLOD3="ped_male\ped_sganem_lod3.skin"
		modelLODDist3=540.0

		// 10 feet for each additional one
		modelLOD4="ped_male\ped_sganem_lod4.skin"
		modelLODDist4=660.0

		animName=animload_thps5_human
		skeletonName=thps5_human
	}
endscript

    
        
        script create_animal_model_set

	// animals here
    make_select_view_model_line text = "Horse" modelName = "west\horse.skin" animName = animload_anl_horse skeletonName=horse
    make_select_view_model_line text = "Dog" modelName = "animals\anl_dog\anl_dog.skin" animName = animload_anl_dog skeletonName=dog
	make_select_view_model_line text = "Cockatoo" modelName = "animals\anl_cockatoo\anl_cockatoo.skin" animName = animload_anl_cockatoo skeletonName=Cockatoo    
    make_select_view_model_line text = "Elephant" modelName = "animals\anl_elephant\anl_elephant.skin" animName = animload_anl_elephant skeletonName=elephant
    make_select_view_model_line text = "Chicken" modelName = "animals\anl_chicken\anl_chicken.skin" animName = animload_anl_chicken skeletonName=chicken
    make_select_view_model_line text = "Giraffe" modelName = "animals\anl_giraffe\anl_giraffe.skin" animName = animload_anl_giraffe skeletonName=giraffe
    make_select_view_model_line text = "Gorilla" modelName = "animals\anl_gorilla\anl_gorilla.skin" animName = animload_anl_gorilla skeletonName=gorilla
    make_select_view_model_line text = "Hippo" modelName = "animals\anl_hippo\anl_hippo.skin" animName = animload_anl_hippo skeletonName=hippo
    make_select_view_model_line text = "Lioness" modelName = "animals\anl_lion\anl_lion.skin" animName = animload_anl_lion skeletonName=lion
    make_select_view_model_line text = "Lion" modelName = "animals\anl_lion_m\anl_lion_m.skin" animName = animload_anl_lion skeletonName=lion
    make_select_view_model_line text = "Meerkat" modelName = "animals\anl_meerkat\anl_meerkat.skin" animName = animload_anl_meerkat skeletonName=meerkat
    make_select_view_model_line text = "Monkey" modelName = "animals\anl_monkey\anl_monkey.skin" animName = animload_anl_monkey skeletonName=monkey
    make_select_view_model_line text = "Penguin" modelName = "animals\anl_penguin\anl_penguin.skin" animName = animload_anl_penguin skeletonName=penguin
 	make_select_view_model_line text = "Pigeon" modelName = "animals\anl_pigeon\anl_pigeon.skin" animName = animload_anl_pigeon skeletonName=pigeon
    make_select_view_model_line text = "Rhino" modelName = "animals\anl_rhino\anl_rhino.skin" animName = animload_anl_rhino skeletonName=rhino
    make_select_view_model_line text = "Seal" modelName = "animals\anl_seal\anl_seal.skin" animName = animload_anl_gorilla skeletonName=seal
    make_select_view_model_line text = "Pig" modelName = "animals\anl_pig\anl_pig.skin" animName = animload_anl_pig skeletonName=pig
	make_select_view_model_line text = "Sharky Boy" modelName = "animals\anl_shark\anl_shark.skin" animName = animload_anl_shark skeletonName=shark

endscript

script create_car_model_set
    // cars here
    make_select_view_model_line text = "Flower Cart" modelName = "veh\veh_sdkart_gardens\veh_sdkart_gardens.mdl" skeletonName=car
    make_select_view_model_line text = "Custom" modelName = "veh\veh_custom\veh_custom.mdl" skeletonName=car
    make_select_view_model_line text = "Tree" modelName = "treetest3\treetest3.mdl" skeletonName=treetest3
    make_select_view_model_line text = "BMX Bike" modelName = "veh\veh_bmx\veh_bmx.mdl"
    make_select_view_model_line text = "Bus" modelName = "veh\veh_busuk\veh_busuk.mdl" skeletonName=car
    make_select_view_model_line text = "Bus UK 2" modelName = "veh\veh_busuk_02\veh_busuk_02.mdl"
    make_select_view_model_line text = "Bus UK 3" modelName = "veh\veh_busuk_03\veh_busuk_03.mdl"
    make_select_view_model_line text = "Bus US" modelName = "veh\veh_busus\busus.mdl"
	make_select_view_model_line text = "Generic Pickup" modelName = "veh\veh_chevypickup\veh_chevypickup.mdl" skeletonName=car
    make_select_view_model_line text = "Generic Pickup B" modelName = "veh\veh_chevypickup_B\veh_chevypickup_B.mdl" skeletonName=car
    make_select_view_model_line text = "Generic Pickup SWB" modelName = "veh\veh_chevypickup_SWB\veh_chevypickup_SWB.mdl" skeletonName=car
    make_select_view_model_line text = "Cosa Nostra" modelName = "veh\veh_cosanostra\veh_cosanostra.mdl" skeletonName=car
	make_select_view_model_line text = "Big Fat Tank Car" modelName = "veh\veh_crownvic\veh_crownvic.mdl" skeletonName=car
    make_select_view_model_line text = "Elephant Truck" modelName = "levels\lon\veh_elephanttruck\veh_elephanttruck.mdl"
    make_select_view_model_line text = "El Train" modelName = "veh\veh_El_Train\veh_El_Train.mdl"
    make_select_view_model_line text = "Book Float" modelName = "levels\sch\veh_float_book\veh_float_book.mdl"
    make_select_view_model_line text = "Bowl Float" modelName = "levels\sch\veh_float_bowl\veh_float_bowl.mdl"
	make_select_view_model_line text = "Sea Float" modelName = "levels\sch\veh_float_sea\veh_float_sea.mdl"
    make_select_view_model_line text = "Rally Type Car" modelName = "veh\veh_focus\veh_focus.mdl" skeletonName=car
	make_select_view_model_line text = "Fork Lift" modelName = "veh\veh_forklift\veh_forklift.mdl" skeletonName=car
    make_select_view_model_line text = "Sixties Big Car" modelName = "veh\veh_galaxie\veh_galaxie.mdl" skeletonName=car
    make_select_view_model_line text = "Garbage Truck" modelName = "veh\veh_garbagetruck\veh_garbagetruck.mdl"
    make_select_view_model_line text = "Sixties Type Hearse" modelName = "veh\veh_hearse\veh_hearse.mdl" skeletonName=car
    make_select_view_model_line text = "HiRez Sportster" modelName = "veh\veh_hirez_viper\veh_hirez_viper.mdl"
    make_select_view_model_line text = "Old British Off Roader" modelName = "veh\veh_lrover_safari\veh_lrover_safari.mdl" skeletonName=car
    make_select_view_model_line text = "Old British Off Roader Short" modelName = "veh\veh_lrover_SWB\veh_lrover_SWB.mdl"
	make_select_view_model_line text = "European Compact Minivan" modelName = "veh\veh_AClass\veh_AClass.mdl"
    make_select_view_model_line text = "Old British Small Car" modelName = "veh\veh_mini\veh_mini.mdl" 
    make_select_view_model_line text = "Generic Minivan" modelName = "veh\veh_minivan\veh_minivan.mdl" skeletonName=car
    make_select_view_model_line text = "Generic Minivan 2" modelName = "veh\veh_minivan_gold\veh_minivan_gold.mdl" skeletonName=car
    make_select_view_model_line text = "French Style Rally Car" modelName = "veh\veh_peugeot_206\veh_peugeot_206.mdl"
    make_select_view_model_line text = "Police Motorcycle" modelName = "veh\Veh_CopperBike\Veh_CopperBike.mdl"
    make_select_view_model_line text = "Retro Car" modelName = "veh\veh_ptcruiser\veh_ptcruiser.mdl" skeletonName=car
    make_select_view_model_line text = "Station Wagon" modelName = "veh\veh_wagon\veh_wagon.mdl" skeletonName=car
    make_select_view_model_line text = "Sport Utility" modelName = "veh\veh_SUV\veh_SUV.mdl" skeletonName=car
    make_select_view_model_line text = "Japanese Style Rally Car" modelName = "veh\veh_Subaru\veh_Subaru.mdl"
    make_select_view_model_line text = "Taxi UK" modelName = "veh\veh_taxiuk\veh_taxiuk.mdl" skeletonName=car
    make_select_view_model_line text = "Taxi US" modelName = "veh\veh_taxius\veh_taxius.mdl" skeletonName=car
    make_select_view_model_line text = "Tour Bus" modelName = "veh\veh_TourBus\veh_TourBus.mdl"
    make_select_view_model_line text = "Beat up old US Car" modelName = "veh\veh_TransAm\veh_TransAm.mdl" skeletonName=car
    make_select_view_model_line text = "Trolley Cart" modelName = "veh\veh_trolley\veh_trolley.mdl"
    make_select_view_model_line text = "Sportster" modelName = "veh\veh_viper\veh_viper.mdl" skeletonName=car
	make_select_view_model_line text = "Beetle Type Car" modelName = "veh\veh_VWBug\veh_VWBug.mdl" skeletonName=car
    make_select_view_model_line text = "Flower Power" modelName = "veh\veh_VWBug_FP\veh_VWBug_FP.mdl" skeletonName=car
    make_select_view_model_line text = "Zoo Tram" modelName = "levels\zoo\veh_zootram\veh_zootram.mdl" skeletonName=car
    make_select_view_model_line text = "Alca-Tram" modelName = "levels\alc\veh_AlcTram\veh_AlcTram.mdl" skeletonName=car
	make_select_view_model_line text = "Alca-Trailer" modelName = "levels\alc\veh_AlcTram_Trailer\veh_AlcTram_Trailer.mdl" skeletonName=car
    make_select_view_model_line text = "Panel Truck" modelName = "veh\veh_IsuzuTruck\veh_IsuzuTruck.mdl" skeletonName=car
    make_select_view_model_line text = "SF Tram" modelName = "levels\sf\veh_SFTram\veh_SFTram.mdl"
    make_select_view_model_line text = "SHINY!" modelName = "Veh\veh_black_cab_shiny\veh_black_cab_shiny.mdl"

	// test car
    make_select_view_model_line text = "Veh_Testcar" modelName = "veh_testcar\veh_testcar.mdl" skeletonName=car

endscript

script create_full_model_set
    create_human_model_set
    create_animal_model_set
    create_car_model_set   

endscript

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&										 		   &&
//&&												   &&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

script add_view_models_to_menu
	if not GotParam model_set
        create_full_model_set
        return
    endif
    
    switch <model_set>
        case human
            create_human_model_set
        case animal
            create_animal_model_set
        case car
            create_car_model_set
       
        default
            create_full_model_set
    endswitch
endscript

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&										 		   &&
//&&												   &&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

script add_change_skater_appearance_to_menu
    make_select_change_skater_appearance_line text = "Bob Burnquist" default_appearance=appearance_burnquist
    make_select_change_skater_appearance_line text = "Steve Caballero" default_appearance=appearance_caballero
	make_select_change_skater_appearance_line text = "Kareem Campbell" default_appearance=appearance_campbell
    make_select_change_skater_appearance_line text = "Rune Glifberg" default_appearance=appearance_glifberg
    make_select_change_skater_appearance_line text = "Tony Hawk" default_appearance=appearance_hawk
    make_select_change_skater_appearance_line text = "Tony Hawk Alt" default_appearance=appearance_hawk2
    make_select_change_skater_appearance_line text = "Eric Koston" default_appearance=appearance_koston
    make_select_change_skater_appearance_line text = "Bucky Lasek" default_appearance=appearance_lasek
    make_select_change_skater_appearance_line text = "Bam Margera" default_appearance=appearance_margera
    make_select_change_skater_appearance_line text = "Rodney Mullen" default_appearance=appearance_mullen
//    make_select_change_skater_appearance_line text = "Chad Muska" default_appearance=appearance_muska
    make_select_change_skater_appearance_line text = "Andrew Reynolds" default_appearance=appearance_reynolds
    make_select_change_skater_appearance_line text = "Geoff Rowley" default_appearance=appearance_rowley
    make_select_change_skater_appearance_line text = "Elissa Steamer" default_appearance=appearance_steamer
	make_select_change_skater_appearance_line text = "Jamie Thomas" default_appearance=appearance_thomas
endscript

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&										 		   &&
//&&												   &&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

script add_set_pro_skater_to_menu
    make_select_set_pro_skater_line text = "Bob Burnquist" name=burnquist
    make_select_set_pro_skater_line text = "Steve Caballero" name=caballero
	make_select_set_pro_skater_line text = "Kareem Campbell" name=campbell
    make_select_set_pro_skater_line text = "Rune Glifberg" name=glifberg
    make_select_set_pro_skater_line text = "Tony Hawk" name=hawk
	make_select_set_pro_skater_line text = "Tony Hawk Alt" name=hawk2
    make_select_set_pro_skater_line text = "Eric Koston" name=koston
	make_select_set_pro_skater_line text = "Bucky Lasek" name=lasek
    make_select_set_pro_skater_line text = "Bam Margera" name=margera
    make_select_set_pro_skater_line text = "Rodney Mullen" name=mullen
//    make_select_set_pro_skater_line text = "Chad Muska" name=muska
    make_select_set_pro_skater_line text = "Andrew Reynolds" name=reynolds
    make_select_set_pro_skater_line text = "Geoff Rowley" name=rowley
    make_select_set_pro_skater_line text = "Elissa Steamer" name=steamer
	make_select_set_pro_skater_line text = "Jamie Thomas" name=thomas
endscript

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&										 		   &&
//&&												   &&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

script SetBg
	SetBackgroundColor { r=120, g=120, b=120, alpha=0 } 
	SetBSPAmbientColor { r=0, g=0, b=0, alpha=0 } 
	SetDFFAmbientColor { r=120, g=120, b=120, alpha=0 }
endscript

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&										 		   &&
//&&												   &&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

script draw_viewer_object_panel
    if ObjectExists id=vo_line1
		SetScreenElementProps { id=vo_line1 text=<line1> }
        SetScreenElementProps { id=vo_line2 text=<line2> }
        SetScreenElementProps { id=vo_line3 text=<line3> }
        SetScreenElementProps { id=vo_line4 text=<line4> }
    else
		create_panel_message id=vo_line1 text=<line1> style=panel_message_viewobj_line params={ xy=(40,380) }
        create_panel_message id=vo_line2 text=<line2> style=panel_message_viewobj_line params={ xy=(40,400) }
        create_panel_message id=vo_line3 text=<line3> style=panel_message_viewobj_line params={ xy=(40,420) }
        create_panel_message id=vo_line4 text=<line4> style=panel_message_viewobj_line params={ xy=(40,440) }
    endif
endscript

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&										 		   &&
//&&												   &&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

script kill_viewer_object_panel
    if ObjectExists id=vo_line1
        RunScriptOnScreenElement id=vo_line1 kill_panel_message
    endif
    if ObjectExists id=vo_line2
        RunScriptOnScreenElement id=vo_line2 kill_panel_message
    endif
    if ObjectExists id=vo_line3
        RunScriptOnScreenElement id=vo_line3 kill_panel_message
    endif
    if ObjectExists id=vo_line4
        RunScriptOnScreenElement id=vo_line4 kill_panel_message
    endif
endscript

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&										 		   &&
//&&												   &&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

script panel_message_viewobj_line
    SetProps just=[left center] rgba=[10 128 10 115]    
    DoMorph pos=<xy> alpha=1 scale=1.0
endscript

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&										 		   &&
//&&												   &&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

script randomize_viewer_ped
    view_model profile=randomized_pedestrian_profile animName=animload_thps5_human skeletonName=thps5_human
endscript

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&										 		   &&
//&&												   &&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

script randomize_viewer_femaleped
    view_model profile=random_female_profile animName=animload_Ped_Female skeletonName=Ped_Female
endscript

//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
//&&										 		   &&
//&&												   &&
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

script viewerobj_add_components

    printstruct <...>

    if GotParam animName
		if not GotParam animEventTableName
			// get anim event table name based on the skeleton used
			// (by default it will use the PedAnimEventTable)
			GetAnimEventTableName animName=<animName>	
		endif
				
        CreateComponentFromStructure AnimEventTableName=<animEventTableName> component=animation <...>        
    endif

    if GotParam skeletonName
        CreateComponentFromStructure {
			component=skeleton
			<...>
			skeleton=<skeletonName>
			max_bone_skip_lod=0			 // turns off bone LODs in the viewer
		}
    endif

    // always create an empty model component
    CreateComponentFromStructure component=model        
	
	// prevent skater sound anim events from causing asserts
    CreateComponentFromStructure component=skatersound
    CreateComponentFromStructure component=skaterloopingsound
	
endscript


script viewerobj_init_model
    
    // general cases (either profile or 
    // explicit model)   
    if GotParam profile
        if GotParam skater_profile_index
            // need to give it a texture dictionary offset
            // that won't conflict with any skaters on the screen
            // so I just chose a value > GameNet::vMAX_SKATERS
            Obj_InitModelFromProfile {
                texDictOffset=8
                struct=<profile>
                use_asset_manager=0
            }
        else    
            // need to give it a texture dictionary offset
            // that won't conflict with any skaters on the screen
            // so I just chose a value > GameNet::vMAX_SKATERS
            Obj_InitModelFromProfile {
                texDictOffset=8
                struct=<profile>
                use_asset_manager=1
            }
        endif
    else
		if GotParam modelName
			Obj_InitModel use_asset_manager=1 <...>
 		else
			if GotParam model
				Obj_InitModel use_asset_manager=1 <...>
			else
				script_assert "no model name!"
			endif
		endif	
    endif

	Obj_GetID
	RunScriptOnObject id=<objID> set_viewerobj_anim_handlers

endscript

// ************************************
//      Model viewer menu  
// ************************************

// @script | launch_view_models_menu | skeleton of view models menu
// filled in by code
script launch_view_models_menu
    RunScriptOnScreenElement id=current_menu_anchor animate_out callback=create_view_models_menu callback_params={<...>}
endscript

script make_select_view_model_line { 	 focus_script=simple_focus
										 unfocus_script=simple_unfocus
                                         rgba=[50 50 50 100]
									}
    
	CreateScreenElement {
				type=textelement 
				parent=current_menu
                
				text=<text>
				font=small
				rgba=<rgba>
                event_handlers=[
					{focus              <focus_script> params=<focus_params>}
					{unfocus            <unfocus_script> params=<unfocus_params>}
					{pad_choose         view_model params=<...>}
					{pad_start          view_model params=<...>}
				]
			}
endscript

script simple_focus
	GetTags
	SetScreenElementProps id=<id> rgba=[0 50 0 100]
endscript

script simple_unfocus
	GetTags
	SetScreenElementProps id=<id> rgba=[50 50 50 100]
endscript

                       
// @script | create_view_models_menu |                                                             
script create_view_models_menu
    make_new_menu menu_id=view_models_menu vmenu_id=view_models_vmenu menu_title="MODELS" type=vscrollingmenu dims=(320,200) pos=(30,20)
    
	// Define pad_back event - go back to the pause menu
    SetScreenElementProps { id=view_models_menu event_handlers=[
                                            {pad_back       create_test_menu}
                                         ]
                          }     
	add_view_models_to_menu	<...>
	
	RunScriptOnScreenElement id=current_menu_anchor animate_in
endscript

script view_model
    printf "View Model here"
	// added by SP: in THPS5 game would assert if the anims were not loaded in the level
	// so I added a call to the animload (it's passed in as animName in models.q) right here
	// and this seems to work
    if GotParam animName
	    <animName>
    endif
    
	if GotParam extraAnim
		<extraAnim>
	endif
	
	
	SetViewerModel <...>
    
	if GotParam defaultAnim
		SetViewerAnim <defaultAnim>
	endif
	
	;restore_start_key_binding
	;RunScriptOnScreenElement id=current_menu_anchor menu_offscreen
endscript


   
