/*****************************************************************************
**																			**
**			              Neversoft Entertainment	                        **
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		Sys Library												**
**																			**
**	Module:			Memory Manager (Mem)									**
**																			**
**	Created:		03/20/00	-	mjb										**
**																			**
**	File name:		core/sys/mem/pile.h										**
**																			**
*****************************************************************************/

#ifndef	__SYS_MEM_PILE_H
#define	__SYS_MEM_PILE_H

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/

#ifndef __CORE_DEFINES_H
#include <core/defines.h>
#endif
#include "alloc.h"

/*****************************************************************************
**								   Defines									**
*****************************************************************************/

namespace Mem
{



/*****************************************************************************
**							     Type Defines								**
*****************************************************************************/

class Region;

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/
	
class  Pile : public  Allocator 			
{
	
	
	friend class Manager;

public :
		
							Pile( Region* region, Direction dir = vBOTTOM_UP );
	virtual					~Pile( void );
	
	virtual		void		PushContext( void );
	virtual		void		PopContext( void );

private :
	
	virtual		void*		allocate( size_t size, bool assert_on_fail );
	virtual		void		free( BlockHeader* pHeader );
	
	void*					mp_base;
	
	Dbg_Code
	(
		sint				m_depth;
		sint				m_alloc_count;
	)
};


/*****************************************************************************
**							 Private Declarations							**
*****************************************************************************/

/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/

/*****************************************************************************
**							  Public Declarations							**
*****************************************************************************/

/*****************************************************************************
**							   Public Prototypes							**
*****************************************************************************/

/*****************************************************************************
**								Inline Functions							**
*****************************************************************************/

} // namespace Mem

#endif  // __SYS_MEM_PILE_H
