/*****************************************************************************
**																			**
**			              Neversoft Entertainment			                **
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		GEL (Game Engine Library)								**
**																			**
**	Module:			Objects (OBJ) 											**
**																			**
**	File name:		gel/objsearch.h											**
**																			**
**	Created:		05/27/99	-	mjb										**
**																			**
*****************************************************************************/

#ifndef __GEL_OBJSEARCH_H
#define __GEL_OBJSEARCH_H

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/

#ifndef __GEL_OBJECT_H
#include <gel/object.h>
#endif
#include <core/list.h>

/*****************************************************************************
**								   Defines									**
*****************************************************************************/

namespace Obj
{



/*****************************************************************************
**							     Type Defines								**
*****************************************************************************/

class  Search : public  Lst::Search< CObject > 
{
	

public :

	CObject*			FindFirstObjectOfType  ( Lst::Head< CObject >& head, sint type );

	CObject*			FindNextObjectOfType  ( void );

private :

	sint			obj_type;
	
};

/*****************************************************************************
**							 Private Declarations							**
*****************************************************************************/

/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/

/*****************************************************************************
**							  Public Declarations							**
*****************************************************************************/

/*****************************************************************************
**							   Public Prototypes							**
*****************************************************************************/

/*****************************************************************************
**								Inline Functions							**
*****************************************************************************/

} // namespace Obj

#endif	// __GEL_OBJSEARCH_H
