/*****************************************************************************
**																			**
**					   	  Neversoft Entertainment							**
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		Core Library											**
**																			**
**	Module:			Task (TSK_)												**
**																			**
**	File name:		core/task/list.h										**
**																			**
**	Created: 		05/27/99	-	mjb										**
**																			**
*****************************************************************************/

#ifndef	__CORE_TASK_LIST_H
#define	__CORE_TASK_LIST_H

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/

#ifndef __CORE_DEFINES_H
#include <core/defines.h>
#endif
#include <core/list.h>
#include "core/support/lock.h"


/*****************************************************************************
**								   Defines									**
*****************************************************************************/

namespace Tsk
{




/*****************************************************************************
**							Class Definitions								**
*****************************************************************************/

class BaseTask;		// forward declaration

class  List : public  Spt::Access 
{
	

public :
							List ( void );
							~List ( void );
	
	void					RemoveAllTasks ( void );
	void					Process ( bool time, uint mask );
	void					Dump ( void );	   	
	void					AddTask ( BaseTask& task );
	bool					IsEmpty ( void );
	void					SignalListChange( void );

private :

	Lst::Head<BaseTask>		list;
	uint					stamp;
	bool					list_changed;

};

/*****************************************************************************
**							 Private Declarations							**
*****************************************************************************/


/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/


/*****************************************************************************
**							  Public Declarations							**
*****************************************************************************/


/*****************************************************************************
**							   Public Prototypes							**
*****************************************************************************/


/*****************************************************************************
**								Inline Functions							**
*****************************************************************************/
 
inline bool			List::IsEmpty ( void )
{
	

	return list.IsEmpty();
}


} // namespace Tsk

#endif	// __CORE_TASK_LIST_H


