/*****************************************************************************
**																			**
**					   	  Neversoft Entertainment							**
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		Core Library											**
**																			**
**	Module:			Support	(SPT)											**
**																			**
**	File name:		core/support/lock.h										**
**																			**
**	Created: 		03/16/00	-	mjb										**
**																			**
*****************************************************************************/

#ifndef __CORE_REF_H
#define __CORE_REF_H

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/

#include <core/support.h>

/*****************************************************************************
**								   Defines									**
*****************************************************************************/

namespace Spt
{



/*****************************************************************************
**							Class Definitions								**
*****************************************************************************/

class  Ref  : public Spt::Class
{
	

public :

				Ref();
				Ref( const Ref& rhs );

	void		Acquire( void );
	void		Release( void );
	bool		InUse( void );

private :

	sint		m_count;
};


/*****************************************************************************
**							 Private Declarations							**
*****************************************************************************/



/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/



/*****************************************************************************
**							  Public Declarations							**
*****************************************************************************/



/*****************************************************************************
**							   Public Prototypes							**
*****************************************************************************/


/*****************************************************************************
**						Inline Functions									**
*****************************************************************************/

inline	Ref::Ref ()
: m_count( 0 )
{
	
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/


inline	Ref::Ref( const Ref& rhs )
: m_count( 0 )
{
	
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline	void		Ref::Acquire ( void )
{
	

	m_count++;
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline	void		Ref::Release ( void )
{
	

	Dbg_MsgAssert(m_count>0,("Tried to call Release when m_count was already zero"));
	m_count--;
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

inline	bool		Ref::InUse ( void )
{
	

	return ( m_count != 0 );
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

} // namespace Spt

#endif	// __CORE_REF_H

