/*****************************************************************************
**																			**
**					   	  Neversoft Entertainment							**
**																		   	**
**				   Copyright (C) 1999 - All Rights Reserved				   	**
**																			**
******************************************************************************
**																			**
**	Project:		Core Library											**
**																			**
**	Module:			List (LST_)												**
**																			**
**	File name:		core/list/search.h										**
**																			**
**	Created: 		04/02/99	-	mjb										**
**																			**
*****************************************************************************/

#ifndef	__CORE_LIST_SEARCH_H
#define	__CORE_LIST_SEARCH_H

/*****************************************************************************
**							  	  Includes									**
*****************************************************************************/

#include <core/list/node.h>

/*****************************************************************************
**								   Defines									**
*****************************************************************************/

namespace Lst
{



/*****************************************************************************
**							Class Definitions								**
*****************************************************************************/

nTemplateBaseClass ( _T, Search )
{
	

public:
					Search ( void );
	virtual			~Search ( void );


	_T*				FirstItem ( Head<_T>& head );
	_T*				LastItem ( Head<_T>& head );
	_T*				NextItem ( void );
	_T*				PrevItem ( void );

private:

	Node< _T >*	node;

};

/*****************************************************************************
**							 Private Declarations							**
*****************************************************************************/


/*****************************************************************************
**							  Private Prototypes							**
*****************************************************************************/


/*****************************************************************************
**							  Public Declarations							**
*****************************************************************************/


/*****************************************************************************
**							   Public Prototypes							**
*****************************************************************************/


/*****************************************************************************
**								Inline Functions							**
*****************************************************************************/

template <class _T> inline 
Search<_T>::Search ( void )
: node ( NULL )
{
	
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

template <class _T> inline 
Search<_T>::~Search ( void )
{
	
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

template <class _T> inline 
_T*	Search<_T>::FirstItem ( Head<_T>& head )
{
	
	
	Dbg_AssertType ( &head, Head<_T> );

	node = &head;

	return ( NextItem () );
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

template <class _T> inline 
_T*	Search<_T>::LastItem ( Head<_T>& head )
{
	
	
	Dbg_AssertType ( &head, Head<_T> );

	node = &head;

	return ( PrevItem () );
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

template <class _T> inline 
_T*	Search<_T>::NextItem ( void )
{
	
	
	Dbg_AssertType ( node, Node< _T > );

	node = node->GetNext();

	if ( !node )
	{
		return NULL;
	}

	Dbg_AssertType ( node, Node<_T> );

	return ( node->GetData() );
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

template <class _T> inline 
_T*	Search<_T>::PrevItem ( void )
{
	
	
	Dbg_AssertType ( node, Node< _T > );

	node = node->GetPrev();

	if ( !node )
	{
		return NULL;
	}

	Dbg_AssertType ( node, Node<_T> );

	return ( node->GetData() );
}

/******************************************************************/
/*                                                                */
/*                                                                */
/******************************************************************/

} // namespace Lst

#endif	//	__CORE_LIST_SEARCH_H 
