/*
	wavio.h
	Routines for reading and writing wave files
	AML - 3-19-01
*/

#ifndef __WAVIO__
#define __WAVIO__

struct SampleLoop
{
	long dwIdentifier;
	long dwType;
	long dwStart;
	long dwEnd;
	long dwFraction;
	long dwPlayCount;
};

struct SamplerChunk
{
	long dwManufacturer;
	long dwProduct;
	long dwSamplePeriod;
	long dwMIDIUnityNote;
	long dwMIDIPitchFraction;
	long dwSMPTEFormat;
	long cSampleLoops;
	long cbSamplerData;
};

void DispWAVInfo(WAVEFORMATEX* fmt);
//bool SaveWAV(char* Filename,WAVEFORMATEX* fmt,void* data,int size);
bool SaveWAV(char* Filename,WAVEFORMATEX* fmt,void* data,int size, SamplerChunk* schunk=NULL, int schunkSize=0);
bool LoadWAV(char* Filename,WAVEFORMATEX** fmt,void** data,int* size);
bool WAVLoops(char* Filename,bool* bLooped);
bool GetSamplerChunk(char* Filename, SamplerChunk** schunk, int* cbSize);

#endif
