/*
	GapTool.h
	Gap layout tool
*/

#ifndef __GAPTOOL__
#define __GAPTOOL__

#include "../UI/MSWindow.h"
#include "max.h"
#include "utilapi.h"
#include "iparamb2.h"
#include "../PropEdit/ScriptIniParser.h"
#include "../PropEdit/MapFileParser.h"
#include "../PropEdit/ConfigData.h"
#include "../PropEdit/PropBufGen.h"
#include "../UI/ProgressBar.h"

#define GAPTOOL_CLASS_ID           Class_ID(0x68824c55, 0xd8819da)
#define vGAPTOOL_SHORTCUT_ID       0xd8819da

class GapToolDlg;
class NodeSelect;
class PropList;

ActionTable* GetGapActions( void );
bool RegGapActionAccelerators();
void UnRegGapActionAccelerators();

class GapActionCB : public ActionCallback {
public:
	BOOL ExecuteAction(int id);
};

class GapTool: public UtilityObj
{
	Interface*  ip;
	GapToolDlg* gapToolDlg;

	// From UtilityObj
	void BeginEditParams(Interface *ip,IUtil *iu);
	void EndEditParams(Interface *ip,IUtil *iu);
	void SelectionSetChanged(Interface *ip,IUtil *iu);
	void DeleteThis() { delete this; }

public:
	GapTool();
	~GapTool();
};

class GapToolClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) { return new GapTool(); }
	const TCHAR *	ClassName() {return _T("NeverSoft Gap Tool"); }
	SClass_ID		SuperClassID() {return UTILITY_CLASS_ID;}
	Class_ID 		ClassID() {return GAPTOOL_CLASS_ID;}
	const TCHAR* 	Category() {return _T("GapTool");}
	const TCHAR*	InternalName() { return _T("GapTool"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }			// returns owning module handle	

	int           NumActionTables()     { return 1; }
	ActionTable*  GetActionTable(int i) { return GetGapActions(); }
};

enum GapType
{
	STARTGAP,
	ENDGAP,
};

struct GapInfo
{
	INode*               node;
	GapType              type;
	LinkList<ConfigProp> props;
};

struct GapDesc
{
	CStr                 gapID;			// The gap ID name
	LinkList<GapInfo>    refs;

	bool operator== (GapDesc& right)
	{
		if (gapID == right.gapID)
			return true;

		return false;
	}
};

//class GapToolDlg: public MSDlgWindow, public MapFileParser, public PropBufGen
class GapToolDlg: public MSDlgWindow, public PropBufGen
{
	Interface*     ip;

	ICustEdit*     IEditGapID;
	NodeSelect*    nsNodeA;
	NodeSelect*    nsNodeB;
	PropList*      plistStartGap;		// Starting gap properties
	PropList*      plistEndGap;		// Ending gap properties
	MapFileParser* mapfile;
	ProgressBar*   pbar;
	bool           bLockSelChange;		// Lock selection set change
	bool           bInternalSet;		// True if processing internal nodes

	LinkList<GapDesc> gapList;

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void BuildGapList();
	void BuildGapTextList();
	void BuildStartEndGapLists();
	void SelGapGroup();
	void SelGapText();
	void SelGapStart();
	void SelGapEnd();
	void GapIDChanged();
	void GapListChanged();
	void RemoveGap(CStr gapID);

	CStr DumpListProps(CStr strGapObj, PropList* plist);

	void UpdateGapFile(INode* nodeA,INode* nodeB,CStr strCtrlName,bool bUpdateOnly);
	void ReadGapProps();
	void ParseGapData(INode* node,CStr* buf);

	void AssignProps(PropList* plist, GapInfo* gapInfo);
	void CleanEmptyScripts();

public:
	GapToolDlg(HINSTANCE hInstance, HWND hwndParent, Interface* ip, MapFileParser* pMapFileParser);
	~GapToolDlg();

	void SelSetChanged();

	void FindGapsStatus();
	void FindGaps(INode* node=NULL, int iProgress=0, ProgressBar* pbar=NULL);	// Finds all uniquely named gaps in the scene
	void FindRelatedGaps(CStr gapid,INode* root=NULL);

	void Apply(bool bUpdateOnly = false);
};


#endif
