/*
	ScriptSelect.cpp
	Script Select Custom UI
*/

#include "ScriptSelect.h"
#include "../Resource.h"
#include "../UI/ListView.h"
#include "../PropEdit/ParseFuncs.h"
#include <io.h>
#include <sys/stat.h>
#include <direct.h>
#include "../path.h"
#define  CUSTIDC_BUTTON  1

///////////////////// ScriptSelectDlg

ScriptSelectDlg::ScriptSelectDlg(HINSTANCE hInstance,HWND hwndParent) :
	ModalDlgWindow(hInstance,MAKEINTRESOURCE(IDD_SCRIPTSELECT),hwndParent)
{
	swCount = 0;	
}

ScriptSelectDlg::~ScriptSelectDlg()
{

}

void ScriptSelectDlg::SetScript(char* name)
{
	strName = name;
	SetDlgItemText(hwnd,IDC_EDIT,name);
}

char* ScriptSelectDlg::GetScript()
{
	return strName;
}

void ScriptSelectDlg::AddScripts()
{
	Refresh();
}

int ScriptSelectDlg::CountFiles(char* sdir,char* prefix)
{
	_finddata_t fdata;
	int         count=0;

	_chdir(sdir);
	long handle=_findfirst("*.*",&fdata);
	int  bContinue;

	if (handle)
		bContinue=0;

	while(bContinue==0)
	{
		// Recurse subdirectories
		if (fdata.attrib & _A_SUBDIR)
		{
			if (strcmp(fdata.name,".")!=0 &&
				strcmp(fdata.name,"..")!=0)
			{
				char strPath[1024];
				strcpy(strPath,sdir);
				strcat(strPath,"\\");
				strcat(strPath,fdata.name);

				count+=CountFiles(strPath,prefix);
				_chdir(sdir);
			}
		}
		else
		{
			char strPath[1024];
			strcpy(strPath,sdir);
			strcat(strPath,"\\");
			strcat(strPath,fdata.name);

			if (MatchPattern(CStr(fdata.name),CStr(prefix)))
				count++;
		}

		bContinue=_findnext(handle,&fdata);
	}

	return count;
}

void ScriptSelectDlg::Find(char* sdir,char* prefix,char* search)
{
	_finddata_t fdata;

	_chdir(sdir);
	long handle=_findfirst("*.*",&fdata);
	int  bContinue=-1;

	if (handle)
		bContinue=0;

	while(bContinue==0)
	{
		// Recurse subdirectories
		if (fdata.attrib & _A_SUBDIR)
		{
			if (strcmp(fdata.name,".")!=0 &&
				strcmp(fdata.name,"..")!=0)
			{
				char strPath[1024];
				strcpy(strPath,sdir);
				strcat(strPath,"\\");
				strcat(strPath,fdata.name);

				Find(strPath,prefix,search);
				_chdir(sdir);
			}
		}
		else
		{
			char strPath[2048];
			strcpy(strPath,sdir);
			strcat(strPath,"\\");
			strcat(strPath,fdata.name);

			if (MatchPattern(CStr(fdata.name),CStr(prefix)))
			{
				FILE* fp;
				char buf[1024]="";
				int  line=0;
				fp=fopen(fdata.name,"r");

				while(MatchContent(fp,search,buf,&line))
				{
					char strNew[1024];
					char strNum[256];
					_itoa(line,strNum,10);

					/*
					strcpy(strNew,strPath);
					strcat(strNew," (");
					strcat(strNew,strNum);
					strcat(strNew,")        ");
					strcat(strNew,buf);
					*/

					CStr strBuf=buf;
					strBuf.toLower();

					int pos=Instr(strBuf,"script ");
					if (pos!=-1 && pos<strBuf.Length())
					{
						strcpy(strNew,buf+pos+7);

						// Terminate after first word
						for(int i=0;i<strlen(strNew);i++)
						{
							if ((strNew[i]==' ' &&  !LineContainsAll(strNew,' ')) ||
								strNew[i]=='\t' ||
								strNew[i]=='\n' ||
								strNew[i]=='\r')
							{
								strNew[i]='\0';
								break;
							}
						}

						CStr str=StripLeft(strNew);

						if (str.Length()>0)
						{
							//int index=SendDlgItemMessage(hwnd,IDC_SCRIPTLIST,LB_ADDSTRING,0,(LPARAM)(char*)str);
							int index = list->AddItem(str);
						
							// Add filename to the newly added entry
							char path[512];
							_getcwd(path,511);

							CStr strFilename=CStr(path)+CStr("\\")+CStr(fdata.name);
							list->AddSubItem(strFilename);
						}
					}

					// Check for cancel
					MSG msg;

					if (PeekMessage(&msg,GetDlgItem(hwnd,IDC_CANCEL),0,0,PM_REMOVE))
					{
						if (msg.message==WM_LBUTTONDOWN)
							return;
					}
				}

				fclose(fp);

				if (bAbort)
					return;

				// Check for cancel
				MSG msg;

				if (PeekMessage(&msg,GetDlgItem(hwnd,IDC_CANCEL),0,0,PM_REMOVE))
				{
					if (msg.message==WM_LBUTTONDOWN)
						return;
				}

				// Update progress bar
				int val=SendDlgItemMessage(hwnd,IDC_PROGBAR,PBM_GETPOS,0,0);
				SendDlgItemMessage(hwnd,IDC_PROGBAR,PBM_SETPOS,(WPARAM)val+1,0);
				InvalidateRect(GetDlgItem(hwnd,IDC_PROGBAR),NULL,TRUE);
				
			}
		}

		bContinue=_findnext(handle,&fdata);
	}
}

bool ScriptSelectDlg::MatchContent(FILE* fp,char* wildcard,char* buf,int* line)
{
	char  tempBuf[512];

	if (!fp)
		return false;

	while(!feof(fp))
	{
		fgets(tempBuf,510,fp);
		(*line)++;

		CStr strBuf=tempBuf;
		strBuf.toLower();

		CStr strWildcard=wildcard;
		strWildcard.toLower();

		if (MatchPattern(strBuf,strWildcard))
		{
			tempBuf[511]='\0';
			strcpy(buf,tempBuf);
			return true;
		}

		// Check for cancel
		MSG msg;

		if (PeekMessage(&msg,GetDlgItem(hwnd,IDC_CANCEL),0,0,PM_REMOVE))
		{
			if (msg.message==WM_LBUTTONDOWN)
			{
				bAbort=true;
				return false;
			}
		}
	}
	
	return false;
}

BOOL ScriptSelectDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		{
			list = new ListView(GetDlgItem(hwnd,IDC_SCRIPTLIST));
			list->AddColumn("Name");
			list->AddColumn("File");
			SetDlgItemText(hwnd,IDC_EDIT,strName);
			Refresh();

			RECT  winRect;
			POINT pos;
			GetCursorPos(&pos);
			GetWindowRect(hwnd,&winRect);

			SetWindowPos(hwnd,
					     HWND_TOPMOST,
						 pos.x,pos.y,
						 winRect.right-winRect.left,
						 winRect.bottom-winRect.top,
						 SWP_SHOWWINDOW);
		}
		return TRUE;

	case WM_DESTROY:
		{
			if (list)
				delete list;
		}
		return TRUE;

	case WM_NOTIFY:
		{
			LPNMHDR nmhdr=(LPNMHDR)lParam;

			switch(nmhdr->code)
			{
			case LVN_ITEMCHANGED:
				SelChange((LPNMLISTVIEW)lParam);
				return TRUE;
			}
		}
		return FALSE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_REFRESH:
			Refresh();
			return TRUE;

		case IDC_CANCEL:
			EndDialog(hwnd,0);
			return TRUE;

		case IDC_DONE:
			{
				char strBuf[512];
				GetDlgItemText(hwnd,IDC_EDIT,strBuf,511);
				strName = strBuf;
				EndDialog(hwnd,0);
				return TRUE;
			}
		}
	}

	return FALSE;
}

void ScriptSelectDlg::SelChange(LPNMLISTVIEW item)
{
	int index=item->iItem;
	
//	if (!(item->uNewState & LVIS_SELECTED))
	{
		char name[512];

		list->GetItem(index,name,511);
		SetDlgItemText(hwnd,IDC_EDIT,name);
		return;
	}
}

void ScriptSelectDlg::Refresh()
{
	CStr strPath=getenv(APP_ENV);
	strPath+=SCRIPT_PATH;
	strPath=strPath.Substr(0,strPath.Length()-1);

	int count=CountFiles(strPath,"*.q");
	SendDlgItemMessage(hwnd,IDC_PROGBAR,PBM_SETRANGE,0,MAKELPARAM(0,count));
	SendDlgItemMessage(hwnd,IDC_PROGBAR,PBM_SETPOS,0,0);
	list->Clear();

	bAbort=false;
	Find(strPath,"*.q","script *");
}

///////////////////// End ScriptSelectDlg

ScriptSelect::ScriptSelect(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{
	selectWindow = NULL;
}

ScriptSelect::ScriptSelect(HINSTANCE hInstance, HWND hwnd) :
	UIControl(hInstance, hwnd, CLASS)
{
	selectWindow = NULL;
}

ScriptSelect::~ScriptSelect()
{
	if (selectWindow)
		delete selectWindow;	
}

ScriptSelect::ScriptSelect(ScriptSelect& right) :
	UIControl(right.hInstance, CLASS)
{
	hwndButton = NULL;
	selectWindow = NULL;
}

ScriptSelect& ScriptSelect::operator= (ScriptSelect& right)
{
	hwndButton = NULL;
	selectWindow = NULL;

	return *this;
}

LRESULT ScriptSelect::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_SETTEXT:
		{
			char* txt = (char*)lParam;
			
			if (strlen(txt)==0)
				SetWindowText(hwndButton,"None");
			else
				SetWindowText(hwndButton,(char*)lParam);
		}
		return TRUE;

	case WM_GETTEXT:
		{
			char buf[256];
			GetWindowText(hwndButton,buf,255);

			char* str    = (char*)lParam;
			int   maxlen = (int)wParam;

			if (CStr(buf)==CStr("None"))
			{
				str[0] = '\0';
				return 1;
			}

			for(int i=0;i<strlen(buf) && i<maxlen-1;i++)
				str[i] = buf[i];

			str[i] = '\0';

			return strlen(str);
		}
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case CUSTIDC_BUTTON:
			SetScript();
			break;
		}
	}

	return UIControl::WndProc(hwnd, msg, wParam, lParam);
	//return DefWindowProc(hwnd,msg,wParam,lParam);
}

void ScriptSelect::BuildControlUI()
{
	RECT wndRect;
	GetClientRect(hwnd,&wndRect);

	hwndButton = CreateWindow("button",
		                      "None",
							  WS_CHILD|WS_VISIBLE,
							  0,
							  0,
							  wndRect.right - wndRect.left,
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)CUSTIDC_BUTTON,
							  hInstance,
							  NULL);

	selectWindow = new ScriptSelectDlg(hInstance, hwnd);
}

void ScriptSelect::SetScript()
{
	char name[256];
	GetWindowText(hwndButton,name,255);

	HWND hwndParent = GetParent(hwnd);
	int  ID = (int)GetWindowLong(hwnd,GWL_ID);

	SendMessage(hwndParent,WM_CHILDGOTFOCUS,(WPARAM)ID,0);

	selectWindow->SetScript(name);
	SetWindowText(hwndButton,"Wait...");
	selectWindow->Show();
	SetWindowText(hwndButton,selectWindow->GetScript());

	if (strcmp(selectWindow->GetScript(),name)!=0)
			SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
}

CStr ScriptSelect::GetValue()
{
	char name[256];
	GetWindowText(hwndButton,name,255);

	return CStr(name);
}

void ScriptSelect::SetValue(CStr value)
{
	SetWindowText(hwndButton,value);
}

HWND ScriptSelect::GetFocusWindow()
{
	return hwndButton;
}
