/*
	OptFile.h
	Optional Filename UI control
	Used in cutscene exporter to allow optional specification of filenames
*/

#ifndef __OPTFILE__
#define __OPTFILE__

#include "UIControl.h"
#include "max.h"

#define OPTFILE_CLASSNAME  "OptFile"

class OptFile: public UIControl
{
	HWND          hwndFileButton;	// Button to bring up FileSelect
	HWND          hwndList;			// Dropdown list storing the last used files
	HWND          hwndEdit;			// The MAX Edit control for manual type-ins
	HFONT         hFont;			// The font to use with the combo box control
	ICustEdit*    IEdit;

	CStr          value;
	CStr          rootDir;			// The root directory in which the file selector
									// starts at and all values are considered to be appended to

	CStr          caption;			// Caption displayed in file select dialog
	const char*   filter;			// Filter of allowable files

	CStr          configFile;		// Name of the file containing the history list

	LRESULT WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

	void BuildControlUI();
	void FileDlg();
	HWND GetFocusWindow();

public:
	CLASSNAME(OPTFILE_CLASSNAME)

	OptFile(HINSTANCE hInstance);
	~OptFile();

	void SetRoot(char* root);
	void SetCaption(char* txt);
	void SetFilter(const char* txt);
	
	void SetConfigFile(char* txt);
	inline CStr GetConfigFile() { return configFile; }

	void SetValue(char* val);
	CStr GetValue();

	void ReadConfigFile();
	void SaveConfigFile();

	void AddUnique(char* buf);
};

#endif
