/*
	MultiPropList.h
	Multi-Property List.  This is a property list that has categorical control.
	Visually it's a property list with a MultiList on top that lists out the categories and
	will update the property list to correspond to the selected category, it behaves like
	a standard property list though.  This works functionally the same, but categories are
	defined by /'s between levels for each property name
*/

#ifndef __MULTIPROPLIST__
#define __MULTIPROPLIST__

#include "PropList.h"
#include "MultiList.h"
//#include "../PreProcessor.h"

#define MULTIPROPLIST_CLASSNAME "MultiPropList"

struct PropEntry
{
	CStr      category;
	PropList* proplist;

	int operator== (PropEntry& right)
	{
		return (category == right.category);
	}
};

class MultiPropList: public PropList, public UIControl
{
	MultiList*            mlist;
	LinkList<CStr>        names;			// Names of all properties including path info

	HWND                  hwndTab;			// This is the proplist subcategory tab sheet
	HWND                  hwndMultiList;
	HWND                  hwndPropList;		// The window that the current property list is displayed in
	HFONT                 hfNormal;			// Font displayed when all elements are being displayed in list
	HFONT                 hfBold;			// Font displayed when additional elements exist in other categories

	// Creation parameters to be propagated to categorical property lists
	HINSTANCE             hInstance;
	HWND                  hwdParent;
	int                   x,y;
	int                   width, height;
	CStr                  DlgText;
	bool                  bExtCreateMethod;	// True if the extended constructor method was used
	int                   cols;
	INode*                ruleNode;			// The current object name for rule evaluation

	BOOL                  bPropChangeLock;	// If true prevents property change callback from being processed

	LRESULT WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void AssignVisibility();
	void CategoryChange();
	void CategoryChangeNR();

	void BreakPathRoot(CStr& src, CStr& path, CStr& root);

	bool UpdateRules();
	bool UpdateRulesOr();
	bool UpdateRulesAnd();

	// MultiPropLists intercept property list changes so we need to redirect if the user of a property
	// list wants their own change notification so we're still notified
	void(*fpChange)(PropList*,void*);		// Callback function called when the property list is updated
	void* pChangeData;						// Callback retained data

	static void PropChange(PropList* plist, void* pData);
	void        UpdateInitialVisibility();
	void        ResetInitialVisibility();

public:
	CLASSNAME(MULTIPROPLIST_CLASSNAME)

	MultiPropList(HINSTANCE hInstance,HWND hwdParent=0,int x=0,int y=0,int width=300,int height=263,CStr DlgText="");
	MultiPropList(HINSTANCE hInstance,int cols);
	~MultiPropList();

	void          BuildNameList();

	void          BuildControlUI();
	void          BuildUI();
	void          DestroyUI();
	void          SetCategory(char* name);
	void          GetCategory(CStr& category);
	void          AddRule(Link<Property>* prop, RuleType type, char* value, char* expr);
	inline void   SetRuleObj(INode* node) { ruleNode = node; }
	void          SetChangeCB(void(*Func)(PropList*,void*),void* pData);
};

#endif
