/*
	PropMerge.cpp
	Property merging dialog
*/

#include "PropMerge.h"
#include "Resource.h"
#include "../UI/MultiList.h"
#include "../UI/PropList.h"

PropMergeDlg::PropMergeDlg(HINSTANCE hInstance,
						   HWND hwndParent,
						   LinkList<ConfigClass>* configDB,
						   void(*fpPropMergeCB)(PropMergeDlg*,void*),
						   void* pData) :
	MSDlgWindow(hInstance,MAKEINTRESOURCE(IDD_MERGEDLG),hwndParent)
{
	this->configDB = configDB;
	this->fpPropMergeCB = fpPropMergeCB;
	this->pData = pData;

	mlistClass = new MultiList(hInstance,GetDlgItem(hwnd,IDC_MCLASS));
	mlistType  = new MultiList(hInstance,GetDlgItem(hwnd,IDC_MTYPE));

	mlistClass->DispFullPath(true);
	mlistClass->EvalFullPath(true);

	mlistType->DispFullPath(true);
	mlistType->EvalFullPath(true);

	IEdit = GetICustEdit(GetDlgItem(hwnd,IDC_MERGECAT));

	ResetProps();
}

void PropMergeDlg::ResetProps()
{
	mlistClass->Reset();
	mlistType->Reset();

	Link<ConfigClass>* curclass = configDB->GetHead();
	CStr name;
	int  id;

	while(curclass)
	{
//		if (curclass->data.strGroup.Length()>0)
//			name = curclass->data.strGroup + CStr("/") + curclass->data.name;
//		else
			name = curclass->data.name;

		id = mlistClass->AddItem(name);
		mlistClass->SetUserData(id,(DWORD)curclass);

		curclass = curclass->next;
	}
}

PropMergeDlg::~PropMergeDlg()
{
	delete mlistClass;
	delete mlistType;

	ReleaseICustEdit(IEdit);
}

BOOL PropMergeDlg::DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch(msg)
	{
	case WM_CLOSE:
		Hide();
		return TRUE;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_MCLASS:
			switch(HIWORD(wParam))
			{
			case CBN_SELCHANGE:
				ClassChange();
				return TRUE;
			}
			break;

		case IDC_MTYPE:
			switch(HIWORD(wParam))
			{
			case CBN_SELCHANGE:
				TypeChange();
				return TRUE;
			}
			break;

		case IDC_MERGEPROPS:
			ProcMerge();
			return TRUE;
		}
		break;
	}

	return FALSE;
}

void PropMergeDlg::ProcMerge()
{
	Hide();
	fpPropMergeCB(this,pData);
}

void PropMergeDlg::ClassChange()
{
	int id = mlistClass->GetCurSel();
	Link<ConfigClass>* curclass = (Link<ConfigClass>*)mlistClass->GetUserData(id);

	mlistType->Reset();

	Link<ConfigType>* typeHead = curclass->data.types.GetHead();
	Link<ConfigType>* curtype = typeHead;
	CStr name;

	while(curtype)
	{
//		if (curtype->data.strGroup.Length() > 0)
//			name = curtype->data.strGroup + CStr("/") + curtype->data.name;
//		else
			name = curtype->data.name;

		mlistType->AddItem(curtype->data.name);
		curtype = curtype->next;
	}

	if (typeHead)
		mlistType->SetValue(typeHead->data.name);

	UpdateCategory();
}

void PropMergeDlg::TypeChange()
{
	UpdateCategory();
}

void PropMergeDlg::UpdateCategory()
{
	CStr catName = mlistClass->GetValue();
	CStr typeName = mlistType->GetValue();

	if (typeName.Length()>0)
		catName += CStr("/") + typeName;

	IEdit->SetText(catName);
}

CStr PropMergeDlg::GetClass()
{
	return mlistClass->GetValue();
}

CStr PropMergeDlg::GetType()
{
	return mlistType->GetValue();
}

CStr PropMergeDlg::GetCat()
{
	char buf[256];
	IEdit->GetText(buf,255);

	return CStr(buf);
}
