/*
	ClusterFind.h
	A tool to browse and select cluster nodes
*/

#ifndef __CLUSTERFIND__
#define __CLUSTERFIND__

#include "max.h"
#include "../UI/MSWindow.h"
#include "../misc/llist.h"

class ProgressBar;

struct ClusterRecord
{
	CStr             cluster;	// Name of the cluster
	LinkList<INode*> nodes;		// Nodes that contain this cluster

	int operator ==(ClusterRecord& right)
	{
		return (cluster == right.cluster);
	}
};

class ClusterFindDlg: public MSDlgWindow
{
	LinkList<ClusterRecord> clusterList;	// List of all the unique clusters

	ProgressBar* pbar;

	BOOL DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

public:
	ClusterFindDlg(HINSTANCE hInstance, HWND hwndParent);
	~ClusterFindDlg();

	void ScanClusters();
	void SelChange();
};

#endif
