/*
	ClusterFind.cpp
	A tool to browse and select cluster nodes
*/

#include "ClusterFind.h"
#include "Resource.h"
#include "../UI/ProgressBar.h"
#include "../misc/maxutil.h"
#include "../PropEdit/ConfigData.h"

extern Interface* gInterface;

ClusterFindDlg::ClusterFindDlg(HINSTANCE hInstance, HWND hwndParent) :
	MSDlgWindow(hInstance, MAKEINTRESOURCE(IDD_CLUSTERFIND), hwndParent)
{

}

ClusterFindDlg::~ClusterFindDlg()
{

}

BOOL ClusterFindDlg::DlgProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_CLUSTERLIST:
			{
				switch(HIWORD(wParam))
				{
				case LBN_SELCHANGE:
					SelChange();
				}
			}
		}
	}

	return FALSE;
}

void ClusterFindDlg::SelChange()
{
	int *selSet;
	int nSel = SendDlgItemMessage(hwnd, IDC_CLUSTERLIST, LB_GETSELCOUNT, 0, 0);

	if (nSel == 0)
		return;

	selSet = new int[nSel];
	SendDlgItemMessage(hwnd, IDC_CLUSTERLIST, LB_GETSELITEMS, (WPARAM)nSel, (LPARAM)selSet);

	Link<ClusterRecord>* link;

	gInterface->ClearNodeSelection();

	int i;

	// Scan through all the selected clusters
	for(i = 0; i < nSel; i++)
	{
		link = (Link<ClusterRecord>*)SendDlgItemMessage(hwnd, IDC_CLUSTERLIST, LB_GETITEMDATA, 0, 0);
		
		// Select all the nodes that share the selected cluster
		Link<INode*>* curnode = link->data.nodes.GetHead();

		while(curnode)
		{
			gInterface->SelectNode(curnode->data, 0);
			curnode = curnode->next;
		}
	}
}

void ClusterFindDlg::ScanClusters()
{
	INodeTab nodes;
	GetAllNodes(nodes);

	int nNodes = nodes.Count();
	int idx;

	pbar = new ProgressBar(hInstance, hwnd, "Scanning Scene for Clusters...", 0, nNodes);

	SendDlgItemMessage(hwnd, IDC_CLUSTERLIST, LB_RESETCONTENT, 0, 0);

	clusterList.Clear();

	for(int i = 0; i < nNodes; i++)
	{
		CStr propBuffer, cluster;
		nodes[i]->GetUserPropBuffer(propBuffer);

		ParseNodeConfigProps(NULL, NULL, nodes[i], NULL, &cluster);

		ClusterRecord clusterRecord;
		clusterRecord.cluster = cluster;

		Link<ClusterRecord>* link = clusterList.AddToTailFindUnique(&clusterRecord);
		link->data.nodes.AddToTail(&nodes[i]);

		idx = SendDlgItemMessage(hwnd, IDC_CLUSTERLIST, LB_ADDSTRING, (WPARAM)i, (LPARAM)(char*)cluster);
		SendDlgItemMessage(hwnd, IDC_CLUSTERLIST, LB_SETITEMDATA, (WPARAM)idx, (LPARAM)link);
	}

	delete pbar;
	pbar = NULL;
}
