#include <windows.h>
#include <stdio.h>
#include <process.h>
#include <path.h>
#include "util.h"
#include "llist.h"
#include "../PropEdit/ParseFuncs.h"

bool	IsPowerOfTwo( int value )
{
	int num_bits_set;
	int mask;

	num_bits_set = 0;

	for( mask = 1; mask <= 0x8000000; mask <<= 1 )
	{
		if( mask & value )
		{
			num_bits_set++;
		}
	}
	
	return ( num_bits_set == 1 );
}

int	GetLog2( int value )
{
	int i;

	i = 0;
	if( value > 0 )
	{		
		while( value != 1 )
		{
			value >>= 1;
			i++;
		}

		return i;
	}
	
	return -1;
}

bool FileExists( char* path )
{
	HANDLE file_handle;
	WIN32_FIND_DATA find_data;
	
	file_handle = FindFirstFile( path, &find_data );  
	
	if( file_handle != INVALID_HANDLE_VALUE )
	{
		FindClose( file_handle );
	}
	
	return ( file_handle != INVALID_HANDLE_VALUE );
}

// Is file 2 newer than file one
bool FileIsNewer( char* file1, char* file2 )
{
	HANDLE file_handle_1, file_handle_2;
	WIN32_FIND_DATA find_data_1, find_data_2;
	
	file_handle_1 = FindFirstFile( file1, &find_data_1 );  
	if( file_handle_1 == INVALID_HANDLE_VALUE )
	{
		return true;
	}

	file_handle_2 = FindFirstFile( file2, &find_data_2 );  
	if( file_handle_2 == INVALID_HANDLE_VALUE )
	{
		FindClose( file_handle_1 );
		return false;
	}
	
	FindClose( file_handle_1 );
	FindClose( file_handle_2 );
	return( CompareFileTime( &find_data_2.ftLastWriteTime, &find_data_1.ftLastWriteTime ) > 0 );
}

int	ExecuteCommand( char** args, bool synchronous )
{
	//return spawnvp( _P_WAIT, args[0], args );
	STARTUPINFO startup_info;
	PROCESS_INFORMATION process_info;
	DWORD status;
	char command_line[_MAX_PATH];
	int i;
	
	command_line[0] = '\0';
	i = 0;
	while( args[i] )
	{
		if( i > 0 )
		{
			// add a space between arguments
			strcat( command_line, " " );
		}
		strcat( command_line, args[i] );
		i++;
	}
	
	memset( &startup_info, 0, sizeof( STARTUPINFO ));
	startup_info.cb = sizeof( STARTUPINFO );
	startup_info.dwFlags = STARTF_USESHOWWINDOW;
	startup_info.wShowWindow = SW_SHOWMINNOACTIVE;	// SW_HIDE

	CreateProcess( NULL, command_line, NULL, NULL, FALSE, 0, NULL, NULL, 
					&startup_info, &process_info );
	if( synchronous )
	{
		WaitForSingleObject( process_info.hProcess, INFINITE );	
	
		do
		{
			GetExitCodeProcess( process_info.hProcess, &status ); 
		} while( status == STILL_ACTIVE );
	}

	return status;
}

void	GetLatestTextures( void )
{
	char  path[256];
	char cmdLine[_MAX_PATH];
	char *proj_root;
	char* args[4];

	proj_root = getenv( APP_ENV );
	proj_root += strlen( "C:/" );
	sprintf( path, "//depot/%s/assets/...", proj_root );

	args[0] = "p4";
	args[1] = "sync";
	args[2] = path;
	args[3] = NULL;

	sprintf( cmdLine, "p4 sync %s", path );
	//spawnvp( _P_WAIT, path, args );
	ExecuteCommand( args );
}

void BuildList(LinkList<CStr>* list, CStr buf, bool bShaveEntries)
{
	int pos = 0;
	int len = buf.Length();

	while (pos < len)
	{
		CStr line = GetRemainLineExact(buf,&pos);

		if (bShaveEntries)
			line = Shave(line);

		list->Add(&line);
	}
}

bool BuildList(CStr Filename,LinkList<CStr>* list)
{
	FILE* fp;
	char lineBuf[1024];

	list->Clear();

	fp = fopen(Filename,"r");

	if (!fp)
		return false;

	while(!feof(fp))
	{
		if (fgets(lineBuf,1023,fp))
			list->Add(&Shave(lineBuf));
	}

	fclose(fp);

	return true;
}

CStr BuildBuf(LinkList<CStr>* list)
{
	CStr buf;
	Link<CStr>* curline = list->GetHead();

	while(curline)
	{
		buf += curline->data + CStr("\n");	
		curline = curline->next;
	}

	return buf;
}

CStr BuildBufCRLF(LinkList<CStr>* list)
{
	CStr buf;
	Link<CStr>* curline = list->GetHead();

	while(curline)
	{
		buf += curline->data + CStr("\r\n");	
		curline = curline->next;
	}

	return buf;
}
