/*
	MaxUtil.h
	Commonly used utility functions related to max
	aml - 10-17-02
*/

#ifndef __MAXUTIL__
#define __MAXUTIL__

#include "max.h"

struct UVChannel
{
	UVVert* verts;		// Vertex list for the channel
	TVFace* faces;		// Face list for the channel

	int     nVerts;		// Number of verts in this copied channel
	int     nFaces;		// Number of faces in this copied channel

	inline void setVerts(int num)
	{
		verts = new UVVert[num];
		nVerts = num;
	}

	inline void setFaces(int num)
	{
		faces  = new TVFace[num];
		nFaces = num;
	}

	UVChannel()
	{
		verts  = NULL;
		faces  = NULL;
		nVerts = 0;
		nFaces = 0;
	}

	~UVChannel()
	{
		if (verts)
			delete [] verts;

		if (faces)
			delete [] faces;
	}
};

void GetAllNodes(Tab<INode*>& nodes, INode* root);
void GetAllNodes(Tab<INode*>& nodes);
void GetSelSetNodes(INodeTab& nodes);
int  GetNodeCount();
ClassDesc* GetClassDesc(SClass_ID scid, Class_ID cid);
Modifier* FindModifier(INode* node, Class_ID cid);
Modifier* FindModifier(Object* obj, Class_ID cid);
void RemapChannel(Mesh& mesh, int srcChannel, int destChannel);
void CopyChannelFrom(UVChannel& channel, Mesh& mesh, int chanID);
void CopyChannelTo(UVChannel& channel, Mesh& mesh, int chanID);
Mtl* ForceFindSceneMtlByName(CStr name);
bool VerifyParentExists(INode* nodeParent, INode* node);
bool Overlapping( INode* node1, INode* node2, float obj_tolerance, float node_tolerance );
void CheckForOverlappingNodes( float obj_tolerance, float node_tolerance );
bool GetObjectExtents(INode* node, Matrix3 tm, Point3& min, Point3& max);
bool NodeExistsInSel(INode* checkNode);
INode* FindNode(CStr name, INode* node);

#endif
