/*
	GwRender.h
	Graphics Window Rendering Functions

	The standard MAX graphics window class doesn't draw much beyond polyline primitives
	this file contains drawing functions for other primitives

	aml - 4-16-03
*/

#ifndef __GWRENDER__
#define __GWRENDER__

#include "max.h"

enum Plane2D
{
	PLANE_XY,
	PLANE_YZ,
	PLANE_XZ,
};

void GetCirclePts(Point3* pts, float radius, Plane2D plane, int nPts);
void ApplyPtTransform(Point3* pts, int nPts, Matrix3 mat);

void DrawCircle(GraphicsWindow* gw, float radius, Plane2D plane = PLANE_XY, int nPts = 20);
void DrawCircleSphere(GraphicsWindow* gw, float radius, int nPts = 20);

#endif
