/*
	MatMergeList.h
	4-1-01
*/

#ifndef __MATMERGELIST__
#define __MATMERGELIST__

//#include "../UI/MSWindow.h"
#include "../UI/ModalDlg.h"
#include "MergeTypes.h"
#include "merge.h"

class Multi;
class PropList;
class ColorListBox;

struct ReassignEntry
{
	int    oldID;
	int    newID;

	bool operator ==(ReassignEntry& right)
	{
		if (right.oldID == oldID)
			return true;

		return false;
	}
};

struct ReassignRecord
{
	Multi* oldMtl;							// The old material that will be mapped to the new one
	LinkList<ReassignEntry> reassignDB;		// A list of IDs and what they should correspond to in the new material

	bool operator ==(ReassignRecord& right)
	{
		if (right.oldMtl == oldMtl)
			return true;

		return false;
	}
};

struct ReassignDB
{
	Multi* newMtl;							// A new merged material that the included old material will be mapped to
	int    norigSubs;						// Number of original sub materials before the merge (so it can be remapped for looped ids)
	LinkList<ReassignRecord> DB;			// A list of the old materials to map to the new one

	bool operator ==(ReassignDB& right)
	{
		if (right.newMtl == newMtl)
			return true;

		return false;
	}
};

class MatMergeList: public ModalDlgWindow
{
	Interface* ip;
	ICustEdit* IEdit;

	LinkList<MatEntry>*      srcList;		// Source nodes
	LinkList<MatEntry>*      mergeList;		// Merge file nodes
	LinkList<MatEntry>       finalList;		// Combined nodes
	LinkList<ReassignDB>     reassignList;	// Material ID reassignment list
											// (need to change all at once so we don't destroy our references
											//  when assigning the new material to the node)

	ColorListBox*            listbox;

	PropList*                plist;			// Used for listing out custom stat values
	bool                     bAutoMerge;	// Automatically will do material merge for all items in list

	int                      lastNum;		// Stores number of last renamed element to reduce searching

	int  AddItems(LinkList<MatEntry>* list);
	void DeleteNodes();

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

	void DeleteNonMergedMtls();
	void DeleteMtlFromScene(Mtl* mtl);
	void RemapMtlRefs(Mtl* mtlSrc, Mtl* mtlDest);
	void MergeMultiMtls();
	void ProcMerge();

	void ReassignMtlIDs(Multi* oldMtl, int oldMtlID,
						Multi* newMtl, int newMtlID);

	void ReassignMtlIDs();

	void BuildFinalList();

	void SelAll();
	void SelNone();
	void SelInvert();
	void SelChange();

	bool MtlExists(MatEntry* mat);
	void CountMats(int& iSame, int& iNew);
	void UpdateMtlProps();
	bool MtlInScene(Mtl* mtl,INode* root=NULL);
	bool MtlInScene(CStr name,INode* root=NULL);

	void UpdateMatching();
	bool IsSelected(MatEntry* me);

	Link<MatEntry>* GetSrcMtl(MatEntry* mat);

	bool MakeUniqueMtlName(CStr& name);

	void NonSubMerge();							// Perform a non-sublevel material merge

public:
	MatMergeList(HINSTANCE hInstance,HWND hwndParent,
		          LinkList<MatEntry>* srclist, LinkList<MatEntry>* mergelist,
				  Interface* ip);
	~MatMergeList();

	int  NumSelItems();
	bool GetItem(int i,char* name);

	inline void SetAutoMerge(bool val) { bAutoMerge = val; }
};

#endif
