/*
	MemDebug.cpp
	Functions for debugging memory problems
	aml
*/

#include <windows.h>
#include <malloc.h>
#include <stdio.h>
#include "MemDebug.h"

//#define DUMP_CHK_LINES

bool _VerifyMemory(char* file, const int line)
{
#ifdef DUMP_CHK_LINES
	char buf[1024];
	sprintf(buf, "%s(%i): VerifyMemory: HEAP CORRUPTION prior to point\n", file, line);
	OutputDebugString(buf);
#endif

	int memStatus = _heapchk();

	if (memStatus == _HEAPOK)
		return true;
	
	char strErrBuf[1024];
	char error[256];

	switch(memStatus)
	{
	case _HEAPBADBEGIN:
		strcpy(error, "_HEAPBADBEGIN");
		break;

	case _HEAPBADNODE:
		strcpy(error, "_HEAPBADNODE");
		break;

	case _HEAPBADPTR:
		strcpy(error, "_HEAPBADPTR");
		break;

	case _HEAPEMPTY:
		strcpy(error, "_HEAPBADBEGIN");
		break;
	}

	sprintf(strErrBuf, "%s(%i): VerifyMemory: HEAP CORRUPTION prior to point (%s)\n", file, line, error);
	OutputDebugString(strErrBuf);
	MessageBox(NULL, strErrBuf, "VerifyMemory", MB_ICONSTOP|MB_OK);
	return false;
}

#ifdef ENABLE_MEMLEAK_CHECKS

//#include <../crt/src/dbgint.h>		// Contains debug definitions for standard C runtime

// Ripped from ../crt/src/dbgint.h
// This is the block header definition for news and mallocs in the standard debug runtime library
#define nNoMansLandSize 4

typedef struct _CrtMemBlockHeader
{
        struct _CrtMemBlockHeader * pBlockHeaderNext;
        struct _CrtMemBlockHeader * pBlockHeaderPrev;
        char *                      szFileName;
        int                         nLine;
        size_t                      nDataSize;
        int                         nBlockUse;
        long                        lRequest;
        unsigned char               gap[nNoMansLandSize];
        /* followed by:
         *  unsigned char           data[nDataSize];
         *  unsigned char           anotherGap[nNoMansLandSize];
         */
} _CrtMemBlockHeader;

// Given a block of memory allocated by malloc or new this function
// will dump the location of the function in code that allocated it
// to the debugger's debug panel  aml
void _DumpAllocSource(void* pMem)
{
	char buf[1024];
	_CrtMemBlockHeader* pBlockHeader;
	pBlockHeader = (_CrtMemBlockHeader*)(((unsigned char*)pMem) - sizeof(_CrtMemBlockHeader));
	
	sprintf(buf, "%s(%i) : MemDbg: 0x%.8X alloc origin (%i bytes)\n", pBlockHeader->szFileName, pBlockHeader->nLine, pMem, pBlockHeader->nDataSize);
	OutputDebugString(buf);
}

static _CrtMemState gMemState;
static char gMemLogStartFile[1024];
static int  gMemLogStartLine;

void _MemLogStart(char* file, int line)
{
	strcpy(gMemLogStartFile, file);
	gMemLogStartLine = line;

	_CrtMemCheckpoint(&gMemState);
}

void _MemLogEnd(char* file, int line)
{
	char buf[1024];
	sprintf(buf, "%s(%i): Memory leak logging started //////////////////////////////////////////////\n", gMemLogStartFile, gMemLogStartLine);
	OutputDebugString(buf);

	_CrtMemDumpAllObjectsSince(&gMemState);
	_CrtMemDumpStatistics(&gMemState);

	sprintf(buf, "%s(%i): Memory leak logging ended ////////////////////////////////////////////////\n", file, line);
	OutputDebugString(buf);
}

#endif
