#include "../Engine/Engine.h"
#include <max.h>
#include "../next.h"
#include "../resource.h"
#include <stdmat.h>
#include <iparamm2.h>
#include "../Misc/GenCrc.h"
#include <Sk/GameNet/ExportMsg.h>
#include "../Material/NExtMat.h"
#include "../Texture/NExtTexture.h"
#include "../Texture/ViewportTexture.h"

extern HINSTANCE hInstance;
extern ClassDesc* GetNExtTextureDesc( void );

extern TCHAR *GetString(int id);

#ifdef FOUR_PARAM_BLOCKS
enum
{
	vNEXT_REF_MAT_PROPS,
	vNEXT_REF_VC_WIBBLE,
	vNEXT_REF_DESIGN_PROPS,
	vNEXT_REF_PASS_1,
	vNEXT_REF_PASS_2,
	vNEXT_REF_PASS_3,
	vNEXT_REF_PASS_4,	
	vNEXT_REF_MAP_1,	
	vNEXT_REF_MAP_2,	
	vNEXT_REF_MAP_3,	
	vNEXT_REF_MAP_4,
	vNUM_REFS
	
} RefIds;

enum
{
	vNEXT_ANM_VC_WIBBLE,
	vNEXT_ANM_REF_MAP_1,
	vNEXT_ANM_REF_MAP_2,
	vNEXT_ANM_REF_MAP_3,
	vNEXT_ANM_REF_MAP_4,
	vNUM_SUB_ANMS
} AnimRegIds;

#else
enum
{
	vNEXT_REF_MAT_PROPS,
	vNEXT_REF_VC_WIBBLE,
	vNEXT_REF_DESIGN_PROPS,
	vNEXT_REF_PASS_1,
	vNEXT_REF_PASS_2,	
	vNEXT_REF_MAP_1,	
	vNEXT_REF_MAP_2,	
	vNUM_REFS	
} RefIds;

enum
{
	vNEXT_ANM_VC_WIBBLE,
	vNEXT_ANM_REF_MAP_1,
	vNEXT_ANM_REF_MAP_2,	
	vNUM_SUB_ANMS
} AnimRegIds;
#endif

#ifdef FOUR_PARAM_BLOCKS
enum 
{ 
	vNEXT_PB_MAT_PROPS,
	vNEXT_PB_VC_WIBBLE,
	vNEXT_PB_DESIGN_PROPS,
	vNEXT_PB_PASS_1,
	vNEXT_PB_PASS_2,	
	vNEXT_PB_PASS_3,
	vNEXT_PB_PASS_4,	
	vNUM_PARAM_BLOCKS

} BlockIds;
#else
enum 
{ 
	vNEXT_PB_MAT_PROPS,
	vNEXT_PB_VC_WIBBLE,
	vNEXT_PB_DESIGN_PROPS,
	vNEXT_PB_PASS_1,
	vNEXT_PB_PASS_2,	
	vNUM_PARAM_BLOCKS

} BlockIds;
#endif
enum 
{
	vNEXT_PARAM_MAP,
	vNEXT_PARAM_COLOR,
	vNEXT_PARAM_FIXED,
	vNEXT_PARAM_ENABLED,
	vNEXT_PARAM_ONE_SIDED,
	vNEXT_PARAM_UVEL,
	vNEXT_PARAM_VVEL,	
	vNEXT_PARAM_UAMP,
	vNEXT_PARAM_VAMP,
	vNEXT_PARAM_UPHASE,
	vNEXT_PARAM_VPHASE,
	vNEXT_PARAM_UFREQUENCY,
	vNEXT_PARAM_VFREQUENCY,
	vNEXT_PARAM_UV_ENABLED,
	vNEXT_PARAM_OVERRIDE,
	vNEXT_PARAM_COLOR_A,
	vNEXT_PARAM_COLOR_D,
	vNEXT_PARAM_COLOR_S,
	vNEXT_PARAM_ALPHA_A,
	vNEXT_PARAM_ALPHA_D,
	vNEXT_PARAM_ALPHA_S,
	vNEXT_PARAM_TERRAIN_TYPE,
	vNEXT_PARAM_VC_COLOR_1,
	vNEXT_PARAM_VC_COLOR_2,
	vNEXT_PARAM_VC_COLOR_3,
	vNEXT_PARAM_VC_COLOR_4,
	vNEXT_PARAM_VC_COLOR_5,
	vNEXT_PARAM_VC_COLOR_6,
	vNEXT_PARAM_VC_COLOR_7,
	vNEXT_PARAM_VC_COLOR_8,
	vNEXT_PARAM_INVISIBLE,
	vNEXT_PARAM_FRONT_FACING,
	vNEXT_PARAM_TRANSPARENT,	
	vNEXT_PARAM_DECAL,	
	vNEXT_PARAM_DRAW_ORDER_ID_OLD,
	vNEXT_PARAM_MAPPING_MODE,
	vNEXT_PARAM_BLEND_MODE,
	vNEXT_PARAM_ALPHA_CUTOFF,	// This is obsolete as it stored a bad default value
	vNEXT_PARAM_ALPHA_CUTOFF_NEW,
	vNEXT_PARAM_HASCOLOR,
	vNEXT_PARAM_DRAW_ORDER_ID,
	vNEXT_PARAM_SORTED,
	vNEXT_PARAM_CUTOFFFUNC,
	vNEXT_PARAM_2SIDED,
	vNEXT_PARAM_VC_ALPHA_1,
	vNEXT_PARAM_VC_ALPHA_2,
	vNEXT_PARAM_VC_ALPHA_3,
	vNEXT_PARAM_VC_ALPHA_4,
	vNEXT_PARAM_VC_ALPHA_5,
	vNEXT_PARAM_VC_ALPHA_6,
	vNEXT_PARAM_VC_ALPHA_7,
	vNEXT_PARAM_VC_ALPHA_8,
	vNEXT_PARAM_RENDERMULTI,	// To enable multi-pass rendering in the viewports
	vNEXT_PARAM_GRASSIFY,		// To make things grassy :)  with Dave's real-time grass stuff on XBox
	vNEXT_PARAM_GRASSHEIGHT,
	vNEXT_PARAM_GRASSLAYERS,
	vNEXT_PARAM_COLOR_LOCKED,
	vNEXT_PARAM_UNLIT,
	vNEXT_PARAM_USEDEFAC,
	vNEXT_PARAM_SPECULAR_POWER,
	vNEXT_PARAM_SPECULAR_COLOR,
	vNEXT_PARAM_USE_SPECULAR,
	vNEXT_PARAM_ENV_TILE_U,
	vNEXT_PARAM_ENV_TILE_V,
	vNEXT_PARAM_IGNORE_VERTEX_ALPHA,
	vNEXT_PARAM_INVERT_VERTEX_ALPHA_UNUSED,
	vNEXT_PARAM_BASE_PASS,
	vNEXT_PARAM_WATER,
	vNEXT_PARAM_ABSENT_IN_NETGAMES,
} ParamIds;

//static char terrain_types[ NxPlugin::CustomMaterialData::vNUM_TERRAIN_TYPES ][32] = {	
// ! Update vNUM_TERRAIN_TYPES in NExtMat.h !   AML

#include "TerrainTypes.h"

#define vNEXT_SHINE_AMT		0.2f
#define vNUM_TEX_PER_PASS	1
#define vFIRST_PASS_PARAM_BLOCK	vNEXT_PB_PASS_1

#define vCONFIG_FILENAME	"config.ini"

#ifdef FOUR_PARAM_BLOCKS
#	define vNUM_PASSES			4
#	define vLAST_PASS_PARAM_BLOCK	vNEXT_PB_PASS_4
#else
#	define vNUM_PASSES			2
#	define vLAST_PASS_PARAM_BLOCK	vNEXT_PB_PASS_2
#endif

static char mapping_modes[2][32] = {
	{ "Explicit" },
	{ "EnvironmentMap" }
};

enum
{
	MAPPING_MODE_EXPLICIT,
	MAPPING_MODE_ENVIRONMENTMAPPED,
};

static char mag_filtering_modes[2][32] = {
	{ "Nearest (None)" },
	{ "Linear (Summed Area)" }	
};

static char min_filtering_modes[6][40] = {
	{ "Nearest (None)" },
	{ "Linear (Summed Area)" },
	{ "Nearest Mipmap Nearest" },
	{ "Nearest Mipmap Linear" },
	{ "Linear Mipmap Nearest" },
	{ "Linear Mipmap Linear (Pyramidal)" }
};

static char blend_modes[vNUM_BLEND_MODES][32] = {
	{ "Diffuse" },
	{ "Add" },
	{ "Add (Fixed Alpha) " },
	{ "Subtract" },
	{ "Subtract (Fixed Alpha)" },
	{ "Blend" },
	{ "Blend (Fixed Alpha)" },
	{ "Modulate" },
	{ "Modulate (Fixed Alpha)" },
	{ "Brighten" },
	{ "Brighten (Fixed Alpha )" },
	{ "Gloss Map" },
	{ "Blend Previous Mask" },
	{ "Blend Inv. Previous Mask" },
};

typedef struct
{
	Color color_a;
	Color color_d;
	Color color_s;
	
	Color color;	
	Texmap *map;
	int blend_mode;
	int fixed;
	BOOL enabled;
	BOOL absent_in_netgames;
	BOOL uv_wibble_enabled;
	float u_vel;
	float v_vel;
	float u_amp;
	float v_amp;
	float u_phase;
	float v_phase;
	float u_frequency;
	float v_frequency;
	int mapping_mode;	
	BOOL colorEnabled;
	BOOL color_locked;
	BOOL unlit;
	float env_tile_u;
	float env_tile_v;
	BOOL ignore_vertex_alpha;	
} PassInfo;

class DesignProperties
{
public:
	int m_TerrainType;
};


class NExtMatDlg;
class NExtMaterial: public Mtl, public INExtMaterial
{
	Bitmap*          vpBmp;
	ViewportTexture* vptex;
	BOOL             bUpdateViewportTex;
	BOOL             bTexturesLoaded;

	void CombineMultipass(Color& dest,Color& src,int pass);

	public:
		IParamBlock2 *pblock[vNUM_PARAM_BLOCKS];
		
		NExtMatDlg *paramDlg;
		Interval ivalid;
		
		PassInfo m_pass_info[vNUM_PASSES];		
		BOOL   m_one_sided;
		BOOL   m_two_sided;
		BOOL   m_invisible;
		BOOL   m_front_facing;
		BOOL   m_transparent;
		BOOL   m_decal;
		BOOL   m_water;
		BOOL   m_grassify;
		float  m_grassHeight;
		int    m_grassLayers;
		BOOL   m_UseSpecular;
		float  m_SpecularPower;
		Color  m_SpecularColor;

		float	   m_draw_order_id;
		int		   m_base_pass;
		BOOL	   m_sorted;
		int	       m_alpha_cutoff;
		BOOL       m_useDefaultAlphaCutoff;
		CutoffFunc m_cutoff_func;

		DesignProperties m_design_props;

		NExtMaterial( BOOL loading );
		~NExtMaterial( void );

		void Enable( void );

		void Update(TimeValue t, Interval& valid);
		void UpdatePS2( PassInfo *orig_pass, PassInfo *new_pass );
		void PS2LoadTexture( int pass );

		void Reset();
		
		IOResult LoadPassData( ILoad *iload, int pass );
		IOResult SavePassData( ISave *isave, int pass );

		Interval Validity(TimeValue t);
		void GetClassName(TSTR& s) { s= TSTR(_T("NExt Material")); }  
		ParamDlg* CreateParamDlg(HWND hwMtlEdit, IMtlParams *imp);
		Color GetAmbient(int mtlNum=0, BOOL backFace=FALSE);
		Color GetDiffuse(int mtlNum=0, BOOL backFace=FALSE);
		Color GetSpecular(int mtlNum=0, BOOL backFace=FALSE);
		float GetShininess(int mtlNum=0, BOOL backFace=FALSE);
		float GetShinStr(int mtlNum=0, BOOL backFace=FALSE);
		float GetXParency(int mtlNum=0, BOOL backFace=FALSE);
		void SetAmbient(Color c, TimeValue t);
		void SetDiffuse(Color c, TimeValue t);
		void SetSpecular(Color c, TimeValue t);
		void SetShininess(float v, TimeValue t);
		BOOL MapEnabled( int i );
		BOOL PassEnabled( int pass );
		BOOL PassEnabledInNetGames( int pass );
		Class_ID ClassID();
		void DeleteThis();
    	RefResult NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, 
	    	PartID& partID,  RefMessage message);
		void Shade(ShadeContext& sc);
		Color ShadeUsingLights(ShadeContext& sc, int pass);

		void SetShadColor(Color c, TimeValue t){  m_pass_info[0].color = c;	pblock[vNEXT_PB_PASS_1]->SetValue(vNEXT_PARAM_COLOR, t, c); }

		int NumSubMtls() { return 0; }
		Mtl* GetSubMtl(int i) { return NULL; }

		// Methods to access texture maps of material
		int NumSubTexmaps() { return vNUM_PASSES; }
		Texmap* GetSubTexmap( int i ) 
		{ 
			return m_pass_info[i].map;
		}
		void SetSubTexmap(int i, Texmap *m) 
		{
			ReplaceReference(vNEXT_REF_MAP_1+i,m);			
		}
		TSTR GetSubTexmapSlotName(int i) { return _T("Map"); }
		
		// Interface implementations
		void SetReference(int i, RefTargetHandle rtarg);
		RefTargetHandle GetReference(int i);
		int NumRefs() {return vNUM_REFS;}

		IOResult Save(ISave *isave);
        IOResult Load(ILoad *iload);
		RefTargetHandle Clone(RemapDir &remap = NoRemap());

		// INExtMaterial implementations
		bool    ColorEnabled( int pass );
		Color	GetColor( int pass );
		Texmap *GetTexmap( int pass );
		int		GetBlendMode( int pass );
		int		GetFixedValue( int pass );
		int		GetNumPasses( void );
		bool	IsOneSided( void );
		bool    IsTwoSided( void );
		bool	IsInvisible( void );
		bool	IsTransparent( void );
		bool	IsFrontFacing( void );
		bool	IsDecal( void );
		float	GetEnvTileU( int pass );
		float	GetEnvTileV( int pass );
		float	GetUVel( int pass );
		float	GetVVel( int pass );
		float	GetUAmplitude( int pass );
		float	GetVAmplitude( int pass );
		float	GetUPhase( int pass );
		float	GetVPhase( int pass );
		float	GetUFrequency( int pass );
		float	GetVFrequency( int pass );
		bool	UVWibbleDataEnabled( int pass );
		AColor	GetAmbientColor( int pass );
		AColor	GetDiffuseColor( int pass );
		AColor	GetSpecularColor( int pass );
		int		GetNumSurfacePropertySets( void );
		int		GetTerrainType( void );		
		Color	GetTransColor( int pass );
		float	GetDrawOrderId( void );		
		int		GetBasePass( void );
		int		   GetAlphaCutoff( void );
		CutoffFunc GetCutoffFunc( void );
		bool	IsSorted( void );
		bool    IsGrassified( void );
		bool    IsWater( void );
		float   GetGrassHeight( void );
		int     GetGrassLayers( void );
		int		VCWibbleNumSequences( void );
		int		VCWibbleNumKeyframes( int sequence );
		WibbleKeyframe VCWibbleKeyFrame( int sequence, int keyframe );
		bool	ManualMip( int pass );
		int		NumMipLevels( int pass );
		float	GetMipMapK( int pass );
		int		GetMipMapL( int pass );
		int		GetMappingMode( int pass );
		int		GetMinFilteringMode( int pass );
		int		GetMagFilteringMode( int pass );
		BOOL    GetColorLocked( int pass );
//		BOOL    GetUnlit( int pass );

		BOOL	VertexAlphaEnabled( int pass );
		
		Color   GetSpecularColor();		// Specular color for material as a whole
		float   GetSpecularPower();
		BOOL    GetUseSpecular();

		CStr    GetName( void );

		// Mtl Implementations
		void SetSubMtl(int i, Mtl *m) {}
		
		int NumSubs() { return vNUM_SUB_ANMS; }  
	    Animatable* SubAnim(int i);
		TSTR SubAnimName(int i);
		int SubNumToRefNum(int subNum);

		// Animatable interface implementations
		int NumParamBlocks( void ) { return vNUM_PARAM_BLOCKS; }
		IParamBlock2* GetParamBlock(int i) {return pblock[i]; }			
		IParamBlock2* GetParamBlockByID(short id) 
		{ 
			for( int i = 0; i < vNUM_PARAM_BLOCKS; i++ )
			{
				if(( pblock[i] != NULL ) && ( pblock[i]->ID() == id ))
				{
					return pblock[i];
				}
			}
			return NULL;
		}

		// Builds the multipass texture buffer for the viewport display
		void SetViewportTexture();
		void LoadTextures();
		inline void InvalidateViewportTexture()  { bUpdateViewportTex = true; }

		int VPDisplaySubMtl() 
		{ 
			//SetActiveTexmap(m_pass_info[1].map);
			//gInterface->ActivateTexture(m_pass_info[1].map,this);
			//SetActiveTexmap(tmap);

			//return vNEXT_REF_MAP_1+1; 
			return -1;
		}
};

class NExtMatDlg: public ParamDlg 
{
public:
	NExtMatDlg( void ) {}
	NExtMatDlg( HWND hwMtlEdit, IMtlParams *imp, NExtMaterial *m ); 
	~NExtMatDlg( void );

	Class_ID ClassID( void ) { return NEXT_MATERIAL_CLASS_ID; }
	void SetThing(ReferenceTarget *m);
	ReferenceTarget* GetThing( void ) { return (ReferenceTarget*) mtl; }
	void SetTime( TimeValue t );
	void ReloadDialog( void );
	void DeleteThis( void ) {}
	void ActivateDlg( BOOL onOff );

private:
	IMtlParams			*ip;
	NExtMaterial	*mtl;	 // current mtl being edited.
	TimeValue			curTime;

};

NExtMatDlg::NExtMatDlg( HWND hwMtlEdit, IMtlParams *imp, NExtMaterial *m )
{
	ip = imp;
}

void NExtMatDlg::SetTime( TimeValue t )
{
	if( t != curTime ) 
	{
		Interval v;
		
		curTime = t;		
		mtl->Update( ip->GetTime(), v );		
	}	
}

NExtMatDlg::~NExtMatDlg( void )
{
}

void NExtMatDlg::ReloadDialog() 
{
	Interval v;
	mtl->Update( ip->GetTime(), v );
}

void NExtMatDlg::ActivateDlg(BOOL onOff) 
{
	MessageBox(gInterface->GetMAXHWnd(),"ActivateDlg Called","Debug",MB_OK);
}

void NExtMatDlg::SetThing( ReferenceTarget *m ) 
{
	assert( m->SuperClassID() == MATERIAL_CLASS_ID );
	assert( m->ClassID() == NEXT_MATERIAL_CLASS_ID );
	if( mtl ) 
	{
		mtl->paramDlg = NULL;
	}

	mtl = (NExtMaterial *) m;
	if( mtl )
	{
		mtl->paramDlg = this;
	}	
}

class NExtMatClassDesc:public ClassDesc2 {
	public:
	int 			IsPublic() {return 1;}
	void *			Create(BOOL loading) {return new NExtMaterial(loading);}
	const TCHAR *	ClassName() {return _T("NExt Material"); } // mjm - 2.3.99
	SClass_ID		SuperClassID() {return MATERIAL_CLASS_ID;}
	Class_ID 		ClassID() {return NEXT_MATERIAL_CLASS_ID;}
	const TCHAR* 	Category() {return _T("NExt Material");}
	const TCHAR*	InternalName() { return _T("NExt Material"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance() { return hInstance; }			// returns owning module handle	
};

static NExtMatClassDesc nextCD;
ClassDesc2* GetNExtMatDesc() {return &nextCD;}

NExtMaterial::NExtMaterial( BOOL loading )
{ 
	int i;

	// Allocate viewport texture
	vptex = new ViewportTexture(vMAX_MATERIAL_PASSES);

	m_one_sided = FALSE;
	m_two_sided = FALSE;
	m_invisible = FALSE;
	m_transparent = FALSE;		
	m_front_facing = FALSE;
	m_grassify = FALSE;
	m_water = FALSE;
	m_decal = FALSE;
	m_draw_order_id = 0.0f;
	m_base_pass = 1;
	m_sorted = FALSE;
	m_alpha_cutoff = 1;
	m_cutoff_func = CUTOFF_FUNC_NO_UPDATE;

	//m_design_props.m_TerrainType = NxPlugin::CustomMaterialData::vTERRAIN_DEFAULT;
	m_design_props.m_TerrainType = 0;
	for( i = 0; i < vNUM_PARAM_BLOCKS; i++ )
	{
		pblock[i] = NULL;		
	}
	for( i = 0; i < vNUM_PASSES; i++ )
	{				
		m_pass_info[i].color = Color( 1, 1, 1 );
		m_pass_info[i].colorEnabled = FALSE;
		
		m_pass_info[i].color_a = Color( 1, 1, 1 );
		m_pass_info[i].color_d = Color( 0, 0, 0 );
		m_pass_info[i].color_s = Color( 0, 0, 0 );
		
		m_pass_info[i].map = NULL;
		m_pass_info[i].blend_mode = vBLEND_MODE_DIFFUSE;
		m_pass_info[i].fixed = 0;
		m_pass_info[i].u_vel = 0;
		m_pass_info[i].v_vel = 0;
		m_pass_info[i].u_amp = 0;
		m_pass_info[i].v_amp = 0;
		m_pass_info[i].u_phase = 0;
		m_pass_info[i].v_phase = 0;
		m_pass_info[i].u_frequency = 0;
		m_pass_info[i].v_frequency = 0;
		m_pass_info[i].uv_wibble_enabled = FALSE;		
		m_pass_info[i].mapping_mode = 0;
		m_pass_info[i].ignore_vertex_alpha = FALSE;
		m_pass_info[i].absent_in_netgames = FALSE;
		
		if( i == 0 )
		{
			m_pass_info[i].enabled = TRUE;	// First pass is always 
		}
		else
		{
			m_pass_info[i].enabled = FALSE;
		}		
	}

	ivalid.SetEmpty();
	
	if (!loading) 
	{
		nextCD.MakeAutoParamBlocks(this);	// make and intialize paramblock2	

		// At creation, create 4 dummy NExt Textures for this material so that artists don't have
		// to select it manually	
		// ... and assign the mapping channel to 1, 2, 3, 4
		for(int i=0;i<4;i++)
		{
			Texmap* tex = (Texmap*)GetNExtTextureDesc()->Create();

			if (tex)
			{
				SetSubTexmap( i, tex );

				UVGen* uvgen = tex->GetTheUVGen();

				if (uvgen)
					uvgen->SetMapChannel( i + 1 );
			}
		}		
	}

	bUpdateViewportTex = true;
	//bUpdateViewportTex = false;		// Don't update unless reselected to avoid loading everything
	bTexturesLoaded = false;
}

NExtMaterial::~NExtMaterial( void )
{ 
//	if (vpBmp)
//		vpBmp->DeleteThis();

	delete vptex;
}

#define MTL_HDR_CHUNK		0xF000
#define PASS1_CHUNK			0xFF00
#define PASS2_CHUNK			0xFF01
#define PASS3_CHUNK			0xFF02
#define PASS4_CHUNK			0xFF03
#define COLOR_A_CHUNK		0xFF04
#define COLOR_D_CHUNK		0xFF05				
#define COLOR_S_CHUNK		0xFF06
//#define OVERRIDE_CHUNK		0xFF07
#define COLOR_CHUNK			0xFF08
#define FIXED_CHUNK			0xFF0A
#define ENABLED_CHUNK		0xFF0B
#define UV_WIBBLE_ENABLED_CHUNK	0xFF0C
#define U_VEL_CHUNK			0xFF0D
#define V_VEL_CHUNK			0xFF0E
#define U_AMP_CHUNK			0xFF10
#define V_AMP_CHUNK			0xFF11
#define U_PHASE_CHUNK		0xFF12
#define V_PHASE_CHUNK		0xFF13
#define U_FREQUENCY_CHUNK	0xFF14
#define V_FREQUENCY_CHUNK	0xFF15
#define ONE_SIDED_CHUNK		0xFF16
#define INVISIBLE_CHUNK		0xFF17
#define FRONT_FACING_CHUNK	0xFF18
#define DESIGN_PROPS_CHUNK	0xFF19		
#define TRANSPARENT_CHUNK	0xFF1A
#define DECAL_CHUNK			0xFF1D
#define CHANGE_TRANS_CHUNK	0xFF1E
#define TRANS_COLOR_CHUNK	0xFF1F
#define DRAW_ORDER_ID_CHUNK	0xFF20
#define MANUAL_MIP_CHUNK	0xFF21
#define MANUAL_MIP_LEVELS_CHUNK	0xFF22
#define MIPMAP_K_CHUNK		0xFF24
#define MAPPING_MODE_CHUNK	0xFF25
#define MIN_FILTERING_MODE_CHUNK	0xFF26
#define MAG_FILTERING_MODE_CHUNK	0xFF27
#define MIPMAP_L_CHUNK		    0xFF28
#define BLEND_MODE_CHUNK	    0xFF29
#define ALPHA_CUTOFF_CHUNK	    0xFF2A
#define ALPHA_CUTOFF_CHUNK_NEW	0xFF2B
#define HASCOLOR_CHUNK          0xFF2C		// aml
#define SORTED_CHUNK		    0xFF2D
#define CUTOFF_FUNC_CHUNK       0xFF2E		// aml
#define TWO_SIDED_CHUNK         0xFF2F      // aml		
#define GRASSIFY_CHUNK          0xFF30		// aml
#define GRASSHEIGHT_CHUNK		0xFF31		// aml
#define GRASSLAYERS_CHUNK       0xFF32		// aml
#define USEDEFALPHACUTOFF_CHUNK 0xFF33		// aml
#define USESPECULAR_CHUNK       0xFF34		// aml
#define SPECULAR_POWER_CHUNK    0xFF35      // aml
#define SPECULAR_COLOR_CHUNK    0xFF36		// aml
#define ENV_TILE_U_CHUNK		0xFF37
#define ENV_TILE_V_CHUNK		0xFF38
#define IGNORE_VERTEX_ALPHA_CHUNK 0xFF39
#define BASE_PASS_CHUNK			0xFF3B
#define WATER_CHUNK				0xFF3C	
#define ABSENT_IN_NETGAMES_CHUNK 0xFF3D

IOResult NExtMaterial::Save(ISave *isave) 
{ 
	int i;
	ULONG nb;
	IOResult res;
	// Save common stuff
	isave->BeginChunk( MTL_HDR_CHUNK );
	res = MtlBase::Save( isave );
	if( res != IO_OK ) 
	{
		return res;
	}
	isave->EndChunk();

	// Save Per-Pass Info
	for( i = 0; i < vNUM_PASSES; i++ )
	{
		SavePassData( isave, i );
	}

	isave->BeginChunk( ONE_SIDED_CHUNK );
	res = isave->Write( &m_one_sided, sizeof( BOOL ), &nb );		
	if( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( INVISIBLE_CHUNK );
	res = isave->Write( &m_invisible, sizeof( BOOL ), &nb );		
	if( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( TRANSPARENT_CHUNK );
	res = isave->Write( &m_transparent, sizeof( BOOL ), &nb );		
	if( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();	

	isave->BeginChunk( FRONT_FACING_CHUNK );
	res = isave->Write( &m_front_facing, sizeof( BOOL ), &nb );		
	if( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( DESIGN_PROPS_CHUNK );
	res = isave->Write( &m_design_props, sizeof( DesignProperties ), &nb );		
	if( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( DECAL_CHUNK );
	res = isave->Write( &m_decal, sizeof( BOOL ), &nb );		
	if( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();	

	isave->BeginChunk( DRAW_ORDER_ID_CHUNK );
	res = isave->Write( &m_draw_order_id, sizeof( float ), &nb );
	if( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( BASE_PASS_CHUNK );
	res = isave->Write( &m_base_pass, sizeof( int), &nb );
	if( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( ALPHA_CUTOFF_CHUNK_NEW );
	res = isave->Write( &m_alpha_cutoff, sizeof( int ), &nb );
	if( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( CUTOFF_FUNC_CHUNK );
	res = isave->Write( &m_cutoff_func, sizeof( int ), &nb );
	if( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( SORTED_CHUNK );
	res = isave->Write( &m_sorted, sizeof( BOOL ), &nb );
	if( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( TWO_SIDED_CHUNK );
	res = isave->Write( &m_two_sided, sizeof( BOOL ), &nb );
	if ( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( WATER_CHUNK );
	res = isave->Write( &m_water, sizeof( BOOL ), &nb );
	if ( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( GRASSIFY_CHUNK );
	res = isave->Write( &m_grassify, sizeof( BOOL ), &nb );
	if ( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( GRASSHEIGHT_CHUNK );
	res = isave->Write( &m_grassHeight, sizeof(float), &nb);
	if ( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( GRASSLAYERS_CHUNK );
	res = isave->Write( &m_grassLayers, sizeof(int), &nb);
	if ( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( USEDEFALPHACUTOFF_CHUNK );
	res = isave->Write( &m_useDefaultAlphaCutoff, sizeof(bool), &nb);
	if ( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( USESPECULAR_CHUNK );
	res = isave->Write( &m_UseSpecular, sizeof(BOOL), &nb);
	if ( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( SPECULAR_POWER_CHUNK );
	res = isave->Write( &m_SpecularPower, sizeof(float), &nb);
	if ( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	isave->BeginChunk( SPECULAR_COLOR_CHUNK );
	res = isave->Write( &m_SpecularColor, sizeof(Color), &nb);
	if ( res != IO_OK )
	{
		return res;
	}
	isave->EndChunk();

	return IO_OK;	
}

IOResult NExtMaterial::SavePassData( ISave *isave, int pass )
{
	IOResult res;
	ULONG nb;
	
	isave->BeginChunk( PASS1_CHUNK + pass );
	
	{
		AColor col;

		isave->BeginChunk( COLOR_A_CHUNK );
		col = AColor( m_pass_info[pass].color_a.r, m_pass_info[pass].color_a.g, 
						m_pass_info[pass].color_a.b, 1.0f );
					//m_pass_info[pass].color_a.b, m_pass_info[pass].alpha_a / 255.0f );
		res = isave->Write( &col, sizeof( AColor ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( COLOR_D_CHUNK );
		col = AColor( m_pass_info[pass].color_d.r, m_pass_info[pass].color_d.g, 
						m_pass_info[pass].color_d.b, 1.0f );
					//m_pass_info[pass].color_d.b, m_pass_info[pass].alpha_d / 255.0f );
		res = isave->Write( &col, sizeof( AColor ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( COLOR_S_CHUNK );
		col = AColor( m_pass_info[pass].color_s.r, m_pass_info[pass].color_s.g, 
						m_pass_info[pass].color_s.b, 1.0f );
					//m_pass_info[pass].color_s.b, m_pass_info[pass].alpha_s / 255.0f );
		res = isave->Write( &col, sizeof( AColor ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		/*isave->BeginChunk( OVERRIDE_CHUNK );
		res = isave->Write( &m_pass_info[pass].override, sizeof( BOOL ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();*/

		isave->BeginChunk( HASCOLOR_CHUNK );
		res = isave->Write( &m_pass_info[pass].colorEnabled, sizeof( BOOL ), &nb );
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( COLOR_CHUNK );
		res = isave->Write( &m_pass_info[pass].color, sizeof( Color ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( BLEND_MODE_CHUNK );
		res = isave->Write( &m_pass_info[pass].blend_mode, sizeof( int ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( FIXED_CHUNK );
		res = isave->Write( &m_pass_info[pass].fixed, sizeof( int ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( ENABLED_CHUNK );
		res = isave->Write( &m_pass_info[pass].enabled, sizeof( BOOL ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( ABSENT_IN_NETGAMES_CHUNK );
		res = isave->Write( &m_pass_info[pass].absent_in_netgames, sizeof( BOOL ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( UV_WIBBLE_ENABLED_CHUNK );
		res = isave->Write( &m_pass_info[pass].uv_wibble_enabled, sizeof( BOOL ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( U_VEL_CHUNK );
		res = isave->Write( &m_pass_info[pass].u_vel, sizeof( float ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( V_VEL_CHUNK );
		res = isave->Write( &m_pass_info[pass].v_vel, sizeof( float ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( U_AMP_CHUNK );
		res = isave->Write( &m_pass_info[pass].u_amp, sizeof( float ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( V_AMP_CHUNK );
		res = isave->Write( &m_pass_info[pass].v_amp, sizeof( float ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( U_PHASE_CHUNK );
		res = isave->Write( &m_pass_info[pass].u_phase, sizeof( float ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( V_PHASE_CHUNK );
		res = isave->Write( &m_pass_info[pass].v_phase, sizeof( float ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( U_FREQUENCY_CHUNK );
		res = isave->Write( &m_pass_info[pass].u_frequency, sizeof( float ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( V_FREQUENCY_CHUNK );
		res = isave->Write( &m_pass_info[pass].v_frequency, sizeof( float ), &nb );		
		if( res != IO_OK )
		{
			return res;
		}
		isave->EndChunk();

		isave->BeginChunk( MAPPING_MODE_CHUNK );		
		res = isave->Write( &m_pass_info[pass].mapping_mode, sizeof( int), &nb );		
		if( res != IO_OK )
		{
			return res;
		} 
		isave->EndChunk();

		isave->BeginChunk( ENV_TILE_U_CHUNK );		
		res = isave->Write( &m_pass_info[pass].env_tile_u, sizeof( float ), &nb );		
		if( res != IO_OK )
		{
			return res;
		} 
		isave->EndChunk();

		isave->BeginChunk( ENV_TILE_V_CHUNK );		
		res = isave->Write( &m_pass_info[pass].env_tile_v, sizeof( float ), &nb );		
		if( res != IO_OK )
		{
			return res;
		} 
		isave->EndChunk();

		isave->BeginChunk( IGNORE_VERTEX_ALPHA_CHUNK );
		res = isave->Write( &m_pass_info[pass].ignore_vertex_alpha, sizeof( BOOL ), &nb );		
		if( res != IO_OK )
		{
			return res;
		} 
		isave->EndChunk();				
	}

	isave->EndChunk();	
	return IO_OK;
}

IOResult NExtMaterial::LoadPassData( ILoad *iload, int pass )
{
	ULONG nb;
	IOResult res;
	int id;

	while( IO_OK == ( res = iload->OpenChunk()))
	{
		switch( id = iload->CurChunkID())
		{
			case COLOR_A_CHUNK:
			{
				AColor col;
				res = iload->Read( &col, sizeof(AColor), &nb );
				m_pass_info[pass].color_a = Color( col.r, col.g, col.b );
				//m_pass_info[pass].alpha_a = col.a * 255.0f;				
				break;
			}
			case COLOR_D_CHUNK:
			{
				AColor col;
				res = iload->Read( &col, sizeof(AColor), &nb );
				m_pass_info[pass].color_d = Color( col.r, col.g, col.b );
				//m_pass_info[pass].alpha_d = col.a * 255.0f;				
				break;
			}
			case COLOR_S_CHUNK:
			{
				AColor col;
				res = iload->Read( &col, sizeof(AColor), &nb );
				m_pass_info[pass].color_s = Color( col.r, col.g, col.b );				
				//m_pass_info[pass].alpha_s = col.a * 255.0f;				
				break;
			}
			/*case OVERRIDE_CHUNK:
				res = iload->Read( &m_pass_info[pass].override, sizeof( BOOL ), &nb );
				break;*/
			case HASCOLOR_CHUNK:
				res = iload->Read( &m_pass_info[pass].colorEnabled, sizeof( BOOL ), &nb );
				break;
			case COLOR_CHUNK:
				res = iload->Read( &m_pass_info[pass].color, sizeof(Color), &nb );				
				break;
			case BLEND_MODE_CHUNK:
				res = iload->Read( &m_pass_info[pass].blend_mode, sizeof( int ), &nb );
				break;
			case FIXED_CHUNK:
				res = iload->Read( &m_pass_info[pass].fixed, sizeof( int ), &nb );
				break;
			case ENABLED_CHUNK:
				res = iload->Read( &m_pass_info[pass].enabled, sizeof( BOOL ), &nb );
				break;
			case ABSENT_IN_NETGAMES_CHUNK:
				res = iload->Read( &m_pass_info[pass].absent_in_netgames, sizeof( BOOL ), &nb );
				break;
			case UV_WIBBLE_ENABLED_CHUNK:
				res = iload->Read( &m_pass_info[pass].uv_wibble_enabled, sizeof( BOOL ), &nb );
				break;
			case U_VEL_CHUNK:
				res = iload->Read( &m_pass_info[pass].u_vel, sizeof( float ), &nb );
				break;
			case V_VEL_CHUNK:
				res = iload->Read( &m_pass_info[pass].v_vel, sizeof( float ), &nb );
				break;
			case U_AMP_CHUNK:
				res = iload->Read( &m_pass_info[pass].u_amp, sizeof( float ), &nb );
				break;
			case V_AMP_CHUNK:
				res = iload->Read( &m_pass_info[pass].v_amp, sizeof( float ), &nb );
				break;
			case U_PHASE_CHUNK:
				res = iload->Read( &m_pass_info[pass].u_phase, sizeof( float ), &nb );
				break;
			case V_PHASE_CHUNK:
				res = iload->Read( &m_pass_info[pass].v_phase, sizeof( float ), &nb );
				break;
			case U_FREQUENCY_CHUNK:
				res = iload->Read( &m_pass_info[pass].u_frequency, sizeof( float ), &nb );
				break;
			case V_FREQUENCY_CHUNK:			
				res = iload->Read( &m_pass_info[pass].v_frequency, sizeof( float ), &nb );
				break;
			case MAPPING_MODE_CHUNK:
				res = iload->Read( &m_pass_info[pass].mapping_mode, sizeof(int), &nb );				
				break;
			case ENV_TILE_U_CHUNK:
				res = iload->Read( &m_pass_info[pass].env_tile_u, sizeof(float), &nb );				
				break;
			case ENV_TILE_V_CHUNK:
				res = iload->Read( &m_pass_info[pass].env_tile_v, sizeof(float), &nb );				
				break;
			case IGNORE_VERTEX_ALPHA_CHUNK:
				res = iload->Read( &m_pass_info[pass].ignore_vertex_alpha, sizeof(BOOL), &nb );				
				break;			
		}

		iload->CloseChunk();
		if (res!=IO_OK) 
		{
			return res;		
		}		
	}

	return IO_OK;
}

IOResult NExtMaterial::Load(ILoad *iload) 
{ 	
	ULONG nb;
	IOResult res;
	int id;
	while( IO_OK == ( res = iload->OpenChunk())) 
	{
		switch( id = iload->CurChunkID())  
		{
			case MTL_HDR_CHUNK:
				res = MtlBase::Load(iload);
				break;
			case PASS1_CHUNK:
				LoadPassData( iload, 0 );
				break;
			case PASS2_CHUNK:
				LoadPassData( iload, 1 );
				break;
#ifdef FOUR_PARAM_BLOCKS
			case PASS3_CHUNK:
			case PASS4_CHUNK:
				break;
#endif
			case ONE_SIDED_CHUNK:
				res = iload->Read( &m_one_sided, sizeof( BOOL ), &nb );
				break;
			case INVISIBLE_CHUNK:
				res = iload->Read( &m_invisible, sizeof( BOOL ), &nb );
				break;
			case TRANSPARENT_CHUNK:
				res = iload->Read( &m_transparent, sizeof( BOOL ), &nb );
				break;
			case FRONT_FACING_CHUNK:
				res = iload->Read( &m_front_facing, sizeof( BOOL ), &nb );
				break;
			case DECAL_CHUNK:
				res = iload->Read( &m_decal, sizeof( BOOL ), &nb );
				break;
			case DRAW_ORDER_ID_CHUNK:
				res = iload->Read( &m_draw_order_id, sizeof( float ), &nb );
				break;
			case BASE_PASS_CHUNK:
				res = iload->Read( &m_base_pass, sizeof( int ), &nb );
				break;
			case SORTED_CHUNK:
				res = iload->Read( &m_sorted, sizeof( BOOL ), &nb );
				break;
			case ALPHA_CUTOFF_CHUNK_NEW:
				res = iload->Read( &m_alpha_cutoff, sizeof( int ), &nb );
				break;
			case CUTOFF_FUNC_CHUNK:
				res = iload->Read( &m_cutoff_func, sizeof( int ), &nb );
				break;
			case DESIGN_PROPS_CHUNK:
				res = iload->Read( &m_design_props, sizeof( DesignProperties ), &nb );
				break;			
			case TWO_SIDED_CHUNK:
				res = iload->Read( &m_two_sided,sizeof( BOOL ), &nb );
				break;
			case WATER_CHUNK:
				res = iload->Read( &m_water,sizeof( BOOL ), &nb );
				break;
			case GRASSIFY_CHUNK:
				res = iload->Read( &m_grassify,sizeof( BOOL ), &nb );
				break;
			case GRASSHEIGHT_CHUNK:
				res = iload->Read( &m_grassHeight, sizeof( float ), &nb );
				break;
			case GRASSLAYERS_CHUNK:
				res = iload->Read( &m_grassLayers, sizeof( int ), &nb );
				break;
			case USEDEFALPHACUTOFF_CHUNK:
				res = iload->Read( &m_useDefaultAlphaCutoff, sizeof( bool ), &nb );
				break;
			case USESPECULAR_CHUNK:
				res = iload->Read( &m_UseSpecular, sizeof(BOOL), &nb );
				break;
			case SPECULAR_POWER_CHUNK:
				res = iload->Read( &m_SpecularPower, sizeof(float), &nb );
				break;
			case SPECULAR_COLOR_CHUNK:
				res = iload->Read( &m_SpecularColor, sizeof(Color), &nb );
				break;
		}
		iload->CloseChunk();
		if (res!=IO_OK) 
			return res;
	}

	/*if (Param1)
	{
		ParamBlock2PLCB* plcb = new ParamBlock2PLCB(versions, 1, &doublesided_param_blk, this, PB_REF);
		iload->RegisterPostLoadCallback(plcb);

		DoubleSidedPostLoadCallback* doubleSidedplcb = new DoubleSidedPostLoadCallback(this,Param1);
		iload->RegisterPostLoadCallback(doubleSidedplcb);
	}*/

	return IO_OK;
}

RefTargetHandle NExtMaterial::Clone(RemapDir &remap)
{
	int i;
	int pass_ref, map_ref;

	NExtMaterial *mtl = new NExtMaterial( FALSE );
	*((MtlBase*)mtl) = *((MtlBase*)this);  // copy superclass stuff
	
	mtl->m_one_sided     = m_one_sided;
	mtl->m_two_sided     = m_two_sided;
	mtl->m_invisible     = m_invisible;
	mtl->m_transparent   = m_transparent;
	mtl->m_front_facing  = m_front_facing;
	mtl->m_decal = m_decal;
	mtl->m_draw_order_id = m_draw_order_id;
	mtl->m_base_pass = m_base_pass;
	mtl->m_alpha_cutoff  = m_alpha_cutoff;
	mtl->m_cutoff_func   = m_cutoff_func;
	mtl->m_design_props.m_TerrainType = m_design_props.m_TerrainType;
	mtl->m_water = m_water;
	mtl->m_grassify      = m_grassify;
	mtl->m_grassHeight   = m_grassHeight;
	mtl->m_grassLayers   = m_grassLayers;
	mtl->m_UseSpecular   = m_UseSpecular;
	mtl->m_SpecularPower = m_SpecularPower;
	mtl->m_SpecularColor = m_SpecularColor;

	mtl->ReplaceReference( vNEXT_REF_DESIGN_PROPS, remap.CloneRef(pblock[vNEXT_PB_DESIGN_PROPS] ));
	mtl->ReplaceReference( vNEXT_REF_MAT_PROPS, remap.CloneRef(pblock[vNEXT_PB_MAT_PROPS] ));
	mtl->ReplaceReference( vNEXT_REF_VC_WIBBLE, remap.CloneRef(pblock[vNEXT_REF_VC_WIBBLE] ));
	for( i = 0; i < vNUM_PASSES; i++ )
	{
		pass_ref = vNEXT_REF_PASS_1 + i;
		map_ref = vNEXT_REF_MAP_1 + i;

		mtl->ReplaceReference( pass_ref,remap.CloneRef(pblock[pass_ref]));
		mtl->m_pass_info[i].enabled = m_pass_info[i].enabled;
		mtl->m_pass_info[i].absent_in_netgames = m_pass_info[i].absent_in_netgames;
		mtl->m_pass_info[i].color = m_pass_info[i].color;
		mtl->m_pass_info[i].colorEnabled = m_pass_info[i].colorEnabled;		// aml
		mtl->m_pass_info[i].color_a = m_pass_info[i].color_a;
		mtl->m_pass_info[i].color_d = m_pass_info[i].color_d;
		mtl->m_pass_info[i].color_s = m_pass_info[i].color_s;
		//mtl->m_pass_info[i].alpha_a = m_pass_info[i].alpha_a;
		//mtl->m_pass_info[i].alpha_d = m_pass_info[i].alpha_d;
		//mtl->m_pass_info[i].alpha_s = m_pass_info[i].alpha_s;
		//mtl->m_pass_info[i].override = m_pass_info[i].override;
		
		if( m_pass_info[i].map )
		{ 
			mtl->ReplaceReference( map_ref, remap.CloneRef( m_pass_info[i].map ));
		}
		
		mtl->m_pass_info[i].blend_mode = m_pass_info[i].blend_mode;
		mtl->m_pass_info[i].fixed = m_pass_info[i].fixed;
		mtl->m_pass_info[i].u_vel = m_pass_info[i].u_vel;
		mtl->m_pass_info[i].v_vel = m_pass_info[i].v_vel;
		mtl->m_pass_info[i].u_frequency = m_pass_info[i].u_frequency;
		mtl->m_pass_info[i].v_frequency = m_pass_info[i].v_frequency;
		mtl->m_pass_info[i].u_amp = m_pass_info[i].u_amp;
		mtl->m_pass_info[i].v_amp = m_pass_info[i].v_amp;
		mtl->m_pass_info[i].u_phase = m_pass_info[i].u_phase;
		mtl->m_pass_info[i].v_phase = m_pass_info[i].v_phase;
		mtl->m_pass_info[i].uv_wibble_enabled = m_pass_info[i].uv_wibble_enabled;		
		mtl->m_pass_info[i].mapping_mode = m_pass_info[i].mapping_mode;		
		mtl->m_pass_info[i].env_tile_u = m_pass_info[i].env_tile_u;
		mtl->m_pass_info[i].env_tile_v = m_pass_info[i].env_tile_v;
		mtl->m_pass_info[i].ignore_vertex_alpha = m_pass_info[i].ignore_vertex_alpha;		
	}

	return mtl;
}

void NExtMaterial::PS2LoadTexture( int pass )
{
}

void NExtMaterial::LoadTextures()
{
	if (!bTexturesLoaded)
	{
		for(int pass=0;pass<vNUM_PASSES;pass++)
		{
			Texmap* tmap = GetTexmap(pass);

			if (tmap)
				tmap->LoadMapFiles(0);
		}

		bTexturesLoaded = true;
	}
}

void NExtMaterial::UpdatePS2( PassInfo *orig_pass, PassInfo *new_pass )
{
	int i;
		
	for( i = 0; i < vNUM_PASSES; i++ )
	{
		if( ( orig_pass[i].color != new_pass[i].color ) ||
			( orig_pass[i].blend_mode != new_pass[i].blend_mode ) ||
			( orig_pass[i].fixed != new_pass[i].fixed ) ||
			( orig_pass[i].uv_wibble_enabled != new_pass[i].uv_wibble_enabled ) ||
			( orig_pass[i].u_vel != new_pass[i].u_vel ) ||
			( orig_pass[i].v_vel != new_pass[i].v_vel ) ||
			( orig_pass[i].u_amp != new_pass[i].u_amp ) ||
			( orig_pass[i].v_amp != new_pass[i].v_amp ) ||
			( orig_pass[i].u_phase != new_pass[i].u_phase ) ||
			( orig_pass[i].v_phase != new_pass[i].v_phase ) ||
			( orig_pass[i].u_frequency != new_pass[i].u_frequency ) ||
			( orig_pass[i].v_frequency != new_pass[i].v_frequency ) ||
			( orig_pass[i].mapping_mode != new_pass[i].mapping_mode ) ||
			( orig_pass[i].env_tile_u != new_pass[i].env_tile_u ) ||
			( orig_pass[i].env_tile_v != new_pass[i].env_tile_v ))
			
		{
			// This pass has changed.  Compute the pass' checksum on the PS2 and send over
			// the new material pass data
			Net::MsgMaterialUpdate msg;

			// Each pass is its own material on the PS2 with a checksum of (base checksum + pass_number)
			msg.MaterialChecksum = ( GenerateCRC( GetName()) + i );
			msg.m_BlendMode = new_pass[i].blend_mode;
			msg.m_FixedAlpha = new_pass[i].fixed;
			msg.m_MappingMode = new_pass[i].mapping_mode;
			msg.m_UVWibbleEnabled = (bool) new_pass[i].uv_wibble_enabled;
			msg.m_UVel = new_pass[i].u_vel;
			msg.m_VVel = new_pass[i].v_vel;
			msg.m_UAmplitude = new_pass[i].u_amp;
			msg.m_VAmplitude = new_pass[i].v_amp;
			msg.m_UPhase = new_pass[i].u_phase;
			msg.m_VPhase = new_pass[i].v_phase;
			msg.m_UFrequency = new_pass[i].u_frequency;
			msg.m_VFrequency = new_pass[i].v_frequency;
			
			// Send this new material data over to the PS2. If the server is up and has this material loaded,
			// it should change that material's properties in a real-time fashion
			Net::MsgDesc msgdesc;
			msgdesc.m_Id     = Net::vMSG_ID_UPDATE_MATERIAL;
			msgdesc.m_Length = sizeof( Net::MsgMaterialUpdate );
			msgdesc.m_Data   = &msg;

			//gClient->EnqueueMessageToServer( &msgdesc );
		}
	}
}

void NExtMaterial::Update(TimeValue t, Interval& valid)
{
	int i;
	int val;
	PassInfo orig_pass[vNUM_PASSES];

	ivalid = FOREVER;

	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_ONE_SIDED, t, m_one_sided, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_2SIDED, t, m_two_sided, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_INVISIBLE, t, m_invisible, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_TRANSPARENT, t, m_transparent, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_FRONT_FACING, t, m_front_facing, ivalid );	
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_DECAL, t, m_decal, ivalid );	
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_DRAW_ORDER_ID, t, m_draw_order_id, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_BASE_PASS, t, m_base_pass, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_SORTED, t, m_sorted, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_ALPHA_CUTOFF_NEW, t, m_alpha_cutoff, ivalid );	
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_CUTOFFFUNC, t, val, ivalid );	
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_WATER, t, m_water, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_GRASSIFY, t, m_grassify, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_GRASSHEIGHT, t, m_grassHeight, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_GRASSLAYERS, t, m_grassLayers, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_USEDEFAC, t, m_useDefaultAlphaCutoff, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_SPECULAR_POWER, t, m_SpecularPower, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_SPECULAR_COLOR, t, m_SpecularColor, ivalid );
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_USE_SPECULAR, t, m_UseSpecular, ivalid );

	m_cutoff_func = (CutoffFunc)val;

	pblock[vNEXT_PB_DESIGN_PROPS]->GetValue( vNEXT_PARAM_TERRAIN_TYPE, t, m_design_props.m_TerrainType, ivalid );
		
	for( i = 0; i < vNUM_PASSES; i++ )
	{
		int block_idx;
		
		block_idx = vFIRST_PASS_PARAM_BLOCK + i;
		
		orig_pass[i] = m_pass_info[i];

		if( pblock[block_idx] )
		{
			pblock[block_idx]->GetValue( vNEXT_PARAM_ENABLED, t, m_pass_info[i].enabled, ivalid );		
			pblock[block_idx]->GetValue( vNEXT_PARAM_ABSENT_IN_NETGAMES, t, m_pass_info[i].absent_in_netgames, ivalid );		
			pblock[block_idx]->GetValue( vNEXT_PARAM_COLOR, t, m_pass_info[i].color, ivalid );			
			pblock[block_idx]->GetValue( vNEXT_PARAM_HASCOLOR, t, m_pass_info[i].colorEnabled, ivalid );

			pblock[block_idx]->GetValue( vNEXT_PARAM_COLOR_A, t, m_pass_info[i].color_a, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_COLOR_D, t, m_pass_info[i].color_d, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_COLOR_S, t, m_pass_info[i].color_s, ivalid );
			
			pblock[block_idx]->GetValue( vNEXT_PARAM_BLEND_MODE, t, m_pass_info[i].blend_mode, ivalid );

			// Force any 2nd pass or higher blend modes set to diffuse to blend
			if (i > 0 && m_pass_info[i].blend_mode == vBLEND_MODE_DIFFUSE)
			{
				pblock[block_idx]->SetValue( vNEXT_PARAM_BLEND_MODE, t, vBLEND_MODE_BLEND);
				m_pass_info[i].blend_mode = vBLEND_MODE_BLEND;
			}

			pblock[block_idx]->GetValue( vNEXT_PARAM_FIXED, t, m_pass_info[i].fixed, ivalid );
			
			pblock[block_idx]->GetValue( vNEXT_PARAM_UVEL, t, m_pass_info[i].u_vel, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_VVEL, t, m_pass_info[i].v_vel, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_UAMP, t, m_pass_info[i].u_amp, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_VAMP, t, m_pass_info[i].v_amp, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_UPHASE, t, m_pass_info[i].u_phase, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_VPHASE, t, m_pass_info[i].v_phase, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_UFREQUENCY, t, m_pass_info[i].u_frequency, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_VFREQUENCY, t, m_pass_info[i].v_frequency, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_UV_ENABLED, t, m_pass_info[i].uv_wibble_enabled, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_MAPPING_MODE, t, m_pass_info[i].mapping_mode, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_COLOR_LOCKED, t, m_pass_info[i].color_locked, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_ENV_TILE_U, t, m_pass_info[i].env_tile_u, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_ENV_TILE_V, t, m_pass_info[i].env_tile_v, ivalid );
			pblock[block_idx]->GetValue( vNEXT_PARAM_IGNORE_VERTEX_ALPHA, t, m_pass_info[i].ignore_vertex_alpha, ivalid );			
			

			//pblock[block_idx]->GetValue( vNEXT_PARAM_UNLIT, t, m_pass_info[i].unlit, ivalid );

			// TT3: when Env Mapped Level geo is exported, automatically set the "unlit" flag
			//if (m_pass_info[i].mapping_mode == MAPPING_MODE_ENVIRONMENTMAPPED)
			//	pblock[block_idx]->SetValue( vNEXT_PARAM_UNLIT, t, TRUE );

			if( m_pass_info[i].map )
			{
				m_pass_info[i].map->Update( t, ivalid );			
			}	
		}
	}

	valid &= ivalid;

	UpdatePS2( orig_pass, m_pass_info );	
	SetViewportTexture();
}

void NExtMaterial::Reset()
{	
}

Interval NExtMaterial::Validity(TimeValue t)
{
	return FOREVER;
}

Color NExtMaterial::GetAmbient(int mtlNum, BOOL backFace)
{
	return m_pass_info[0].color_a;	
}

Color NExtMaterial::GetDiffuse(int mtlNum, BOOL backFace)
{
	int i;

	// return the last enabled passes' color as that is
	// what the material window will show if there is no texture
	for( i = (vNUM_PASSES - 1); i >= 0; i-- )
	{
		if( m_pass_info[i].enabled )
		{
			return m_pass_info[i].color;
		}
	}
	return Color( 0, 0, 0 );
}

Color NExtMaterial::GetSpecular(int mtlNum, BOOL backFace)
{
	return m_pass_info[0].color_s;
}

float NExtMaterial::GetShininess(int mtlNum, BOOL backFace)
{
	return 0.0f;
}

float NExtMaterial::GetShinStr(int mtlNum, BOOL backFace)
{
	return 0.0f;
}

float NExtMaterial::GetXParency(int mtlNum, BOOL backFace)
{
	return 0.0f;
}

void NExtMaterial::SetAmbient(Color c, TimeValue t)
{	
}		

void NExtMaterial::SetDiffuse(Color c, TimeValue t)
{
	int i;

	// return the last enabled passes' color as that is
	// what the material window will show if there is no texture
	for( i = (vNUM_PASSES - 1); i >= 0; i-- )
	{
		if( m_pass_info[i].enabled )
		{
			m_pass_info[i].color = c;
			pblock[vNEXT_PB_PASS_1+i]->SetValue(vNEXT_PARAM_COLOR, t, c);
			break;
		}
	}	
}

void NExtMaterial::SetSpecular(Color c, TimeValue t)
{
}

void NExtMaterial::SetShininess(float v, TimeValue t)
{
}

BOOL NExtMaterial::MapEnabled( int i )
{
	return ( m_pass_info[i].enabled && ( m_pass_info[i].map != NULL ));
}

BOOL NExtMaterial::PassEnabledInNetGames( int pass )
{
	return ( m_pass_info[pass].enabled && ( m_pass_info[pass].absent_in_netgames == FALSE ) &&
			( m_pass_info[pass].mapping_mode != MAPPING_MODE_ENVIRONMENTMAPPED ));
}

BOOL NExtMaterial::PassEnabled( int pass )
{
	return ( m_pass_info[pass].enabled );
}

Class_ID NExtMaterial::ClassID()
{
	return NEXT_MATERIAL_CLASS_ID;
}

void NExtMaterial::DeleteThis()
{
	delete this;
}

RefResult NExtMaterial::NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, 
	    	PartID& partID,  RefMessage message)
{
	switch( message )
	{
		case REFMSG_CHANGE:
		{
			int i;

			for( i = 0; i < vNUM_PASSES; i++ )
			{
				if( hTarget == m_pass_info[i].map )
				{
					//PS2LoadTexture( i );
				}
			}
			break;
		}
	}		
		
	return REF_SUCCEED;
}

Color NExtMaterial::ShadeUsingLights(ShadeContext& sc, int pass)
{
	AColor a_ambient, a_diffuse, a_specular;
	Color ambient, diffuse, specular;
	Color lightCol;
	Color diffwk(0.0f,0.0f,0.0f);
	Color specwk(0.0f,0.0f,0.0f);
	Color ambwk(0.0f,0.0f,0.0f);
	Point3 N = sc.Normal();
	Point3	R = sc.ReflectVector();
	LightDesc *l;
	float phongexp;

	phongexp = (float)pow(2.0, vNEXT_SHINE_AMT * 10.0f );
	
	for (int i = 0; i<sc.nLights; i++) {
		l = sc.Light(i);
		register float NL, diffCoef;
		Point3 L;
		if (!l->Illuminate(sc, N, lightCol, L, NL, diffCoef))
			continue;

		if (l->ambientOnly) {
			ambwk += lightCol;
			continue;
			}
		// diffuse
		if (l->affectDiffuse)
			diffwk += diffCoef*lightCol;
		// specular
		if (l->affectSpecular) {
			float c = DotProd(L,R);
			if (c>0.0f) {
				c = (float)pow((double)c, (double)phongexp); 
				specwk += c*lightCol*NL;   // multiply by NL to SOFTEN 
			}
		}
	}
	
	a_ambient = GetAmbientColor( pass );
	if( ColorEnabled( pass ))
	{
		a_diffuse = GetColor( pass );
	}
	else
	{
		a_diffuse = Color( 0.5f, 0.5f, 0.5f );
	}
	a_specular = GetSpecularColor( pass );

	ambient = Color( a_ambient.r, a_ambient.g, a_ambient.b );
	diffuse = Color( a_diffuse.r, a_diffuse.g, a_diffuse.b );
	specular = Color( a_specular.r, a_specular.g, a_specular.b );

	return ((.3f * ambient+ diffwk)*diffuse + specwk*specular+ambwk );
}

// The shading function is the same as the PS2 function; i.e (( A - B ) * C ) + D
// A, B and D are Colors, optionally Src, Dst, or Black
// C is Alpha, optionally Src, Dst or a Fixed value
void NExtMaterial::Shade(ShadeContext& sc)
{
	int i;

	for( i = 0; i < vNUM_PASSES; i++ )
	{
		if( m_pass_info[i].enabled )
		{
			AColor input_color;
			Color rc, pass_color;
			Color a, b, d;
			float c;
			Color lit_color;
			int params[4];
			
			lit_color = ShadeUsingLights( sc, i );
			lit_color *= 2;

			if( sc.doMaps && m_pass_info[i].map )
			{
				input_color = m_pass_info[i].map->EvalColor( sc );
				rc = /*m_pass_info[i].color*/ lit_color * Color( input_color.r, input_color.g, input_color.b );
			}
			else
			{
				//input_color = m_pass_info[i].color;
				//rc = Color( input_color.r, input_color.g, input_color.b );
				rc = Color( lit_color.r, lit_color.g, lit_color.b );				
			}
			
			switch( m_pass_info[i].blend_mode )
			{
				case vBLEND_MODE_DIFFUSE:				// ( 0 - 0 ) * 0 + Src
					params[0] = vPARAM_COLOR_ZERO;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_ZERO;
					params[3] = vPARAM_COLOR_SRC;
					break;
				case vBLEND_MODE_ADD:					// ( Src - 0 ) * Src + Dst
					params[0] = vPARAM_COLOR_SRC;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_SRC;
					params[3] = vPARAM_COLOR_DST;
					break;
				case vBLEND_MODE_SUBTRACT:				// ( 0 - Src ) * Src + Dst
					params[0] = vPARAM_COLOR_ZERO;
					params[1] = vPARAM_COLOR_SRC;
					params[2] = vPARAM_COLOR_SRC;
					params[3] = vPARAM_COLOR_DST;
					break;
				case vBLEND_MODE_BLEND:					// ( Src * Dst ) * Src + Dst
					params[0] = vPARAM_COLOR_SRC;
					params[1] = vPARAM_COLOR_DST;
					params[2] = vPARAM_COLOR_SRC;
					params[3] = vPARAM_COLOR_DST;
					break;
				case vBLEND_MODE_ADD_FIXED:				// ( Src - 0 ) * Fixed + Dst
					params[0] = vPARAM_COLOR_SRC;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_FIXED;
					params[3] = vPARAM_COLOR_DST;
					break;
				case vBLEND_MODE_SUB_FIXED:				// ( 0 - Src ) * Fixed + Dst
					params[0] = vPARAM_COLOR_ZERO;
					params[1] = vPARAM_COLOR_SRC;
					params[2] = vPARAM_COLOR_FIXED;
					params[3] = vPARAM_COLOR_DST;					
					break;
				case vBLEND_MODE_BLEND_FIXED:			// ( Src * Dst ) * Fixed + Dst	
					params[0] = vPARAM_COLOR_SRC;
					params[1] = vPARAM_COLOR_DST;
					params[2] = vPARAM_COLOR_FIXED;
					params[3] = vPARAM_COLOR_DST;					
					break;
				case vBLEND_MODE_MODULATE:				// ( Dst - 0 ) * Src + 0
					params[0] = vPARAM_COLOR_DST;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_SRC;
					params[3] = vPARAM_COLOR_ZERO;
					break;
				case vBLEND_MODE_MODULATE_FIXED:			// ( Dst - 0 ) * Fixed + 0
					params[0] = vPARAM_COLOR_DST;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_FIXED;
					params[3] = vPARAM_COLOR_ZERO;					
					break;
				case vBLEND_MODE_BRIGHTEN:				// ( Dst - 0 ) * Src + Dst
					params[0] = vPARAM_COLOR_DST;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_SRC;
					params[3] = vPARAM_COLOR_DST;					
					break;
				case vBLEND_MODE_BRIGHTEN_FIXED:			// ( Dst - 0 ) * Fixed + Dst	
					params[0] = vPARAM_COLOR_DST;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_FIXED;
					params[3] = vPARAM_COLOR_DST;					
					break;
				case vBLEND_MODE_BLEND_PREVIOUS_MASK:	// ( Src - Dst ) * Dst + Dst
					params[0] = vPARAM_COLOR_SRC;
					params[1] = vPARAM_COLOR_DST;
					params[2] = vPARAM_COLOR_DST;
					params[3] = vPARAM_COLOR_DST;					
					break;
				case vBLEND_MODE_BLEND_INVERSE_PREVIOUS_MASK:// ( Dst - Src ) * Dst + Src
					params[0] = vPARAM_COLOR_DST;
					params[1] = vPARAM_COLOR_SRC;
					params[2] = vPARAM_COLOR_DST;
					params[3] = vPARAM_COLOR_SRC;					
					break;	
			}

			switch( params[0] )
			{
				case vPARAM_COLOR_SRC:
					a = rc;
					break;
				case vPARAM_COLOR_DST:
					a = sc.out.c;
					break;
				case vPARAM_COLOR_ZERO:						
				case vPARAM_COLOR_RESERVED:
					a = Color( 0, 0, 0 );
					break;
			}

			switch( params[1] )
			{
				case vPARAM_COLOR_SRC:
					b = rc;
					break;
				case vPARAM_COLOR_DST:
					b = sc.out.c;		
					break;
				case vPARAM_COLOR_ZERO:						
				case vPARAM_COLOR_RESERVED:
					b = Color( 0, 0, 0 );
					break;
			}

			switch( params[2] )
			{
				case vPARAM_COLOR_SRC:
					c = input_color.a * 128.0f;	// input_color.a is [0,1], scale it to [0,255]
					break;
				case vPARAM_COLOR_DST:
					c = sc.out.t.r * 128.0f;		// sc.out.t.r is [0,1], scale it to [0,255]
					break;
				case vPARAM_COLOR_FIXED:
					c = (float) m_pass_info[i].fixed;
					break;
				case vPARAM_COLOR_RESERVED:
					c = 255;
					break;
			}

			switch( params[3] )
			{
				case vPARAM_COLOR_SRC:
					d = rc;
					break;
				case vPARAM_COLOR_DST:
					d = sc.out.c;
					break;
				case vPARAM_COLOR_ZERO:						
				case vPARAM_COLOR_RESERVED:
					d = Color( 0, 0, 0 );
					break;
			}
			
			// Mimic behavior on the PS2 where the product of the colors
			// and the alpha value are shifted right 7 before adding the final color value
			pass_color = ( a - b ) * c;
			pass_color /= 128;
			pass_color += d;

			sc.out.c = pass_color;
			sc.out.t.r = input_color.a;
			sc.out.t.g = input_color.a;
			sc.out.t.b = input_color.a;
		}
	}	
}

RefTargetHandle NExtMaterial::GetReference( int i )
{
	switch (i) 
	{
		case vNEXT_REF_MAT_PROPS:
			return pblock[vNEXT_REF_MAT_PROPS];			
		case vNEXT_REF_VC_WIBBLE:
			return pblock[vNEXT_REF_VC_WIBBLE];			
		case vNEXT_REF_DESIGN_PROPS:
			return pblock[vNEXT_REF_DESIGN_PROPS];
		case vNEXT_REF_PASS_1: 
			return pblock[vNEXT_REF_PASS_1];			
		case vNEXT_REF_PASS_2:
			return pblock[vNEXT_REF_PASS_2];			
		case vNEXT_REF_MAP_1:
			return m_pass_info[0].map;
		case vNEXT_REF_MAP_2:
			return m_pass_info[1].map;
#ifdef FOUR_PARAM_BLOCKS
		case vNEXT_REF_PASS_3: 
			return pblock[vNEXT_REF_PASS_3];
		case vNEXT_REF_PASS_4:
			return pblock[vNEXT_REF_PASS_4];
		case vNEXT_REF_MAP_3:
			return m_pass_info[2].map;
		case vNEXT_REF_MAP_4:
			return m_pass_info[3].map;
#endif
		default: return NULL;			
	}
}

ParamDlg* NExtMaterial::CreateParamDlg(HWND hwMtlEdit, IMtlParams *imp)
{
	IAutoMParamDlg *master_dlg;
	
	master_dlg = nextCD.CreateParamDlgs( hwMtlEdit, imp, this );
	//Enable();
	
	nextCD.RestoreRolloutState();
	return master_dlg;	
}

static Control *from_ctrl = NULL;
class NExtDlgProc : public ParamMap2UserDlgProc 
	{
	bool bForceDisableDrawOrder;
	public:
		NExtDlgProc() { bForceDisableDrawOrder = false; }
		BOOL DlgProc(TimeValue t, IParamMap2 *map, HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) 
		{	
			// Update texture on any map parameter changes
			/*
			if (msg != WM_MOUSEMOVE &&
				msg != WM_COMMAND && 
				msg != WM_NCHITTEST &&
				msg != 32)
			*/
			if (msg == 15)
			{
				IParamBlock2 *block;
				NExtMaterial *material;
					
				block = map->GetParamBlock();
				material = (NExtMaterial *) block->GetOwner();
				material->InvalidateViewportTexture();

				if (bForceDisableDrawOrder)
				{
					EnableWindow(GetDlgItem(hWnd,IDC_DRAW_ORDER_ID),FALSE);
					EnableWindow(GetDlgItem(hWnd,IDC_DRAW_ORDER_ID_SPINNER),FALSE);
				}
			}

			switch (msg) 
			{
				case CC_SPINNER_CHANGE:
				{
					int ctrl_id = (int) LOWORD(wParam);
					IParamBlock2 *block;
					NExtMaterial *material;
					block = map->GetParamBlock();
					material = (NExtMaterial *) block->GetOwner();
					Interval ivalid = FOREVER;

					if (ctrl_id == IDC_ALPHA_CUTOFF ||
						ctrl_id == IDC_ALPHA_CUTOFF_SPINNER)
					{
						int cutoff;
						material->pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_ALPHA_CUTOFF_NEW, t, cutoff, ivalid );
						
						if (cutoff >= 1)
							material->pblock[vNEXT_PB_MAT_PROPS]->SetValue( vNEXT_PARAM_USEDEFAC, t, FALSE);
					}
				}

				case WM_SHOWWINDOW:
				{
					HWND drop_down;
					int cur_sel;
					IParamBlock2 *block;
					BlockID id;
					NExtMaterial *material;
					int pass;
					
					block = map->GetParamBlock();
					material = (NExtMaterial *) block->GetOwner();
					id = block->ID();						

					if( id == vNEXT_PB_MAT_PROPS )
					{
						// If "use default alpha cutoff" is not checked, enable
						// the edit and spinners for the alpha cutoff control
						if (IsDlgButtonChecked(hWnd,IDC_USEDEFAC)!=BST_CHECKED)
						{
							ICustEdit* edit;
							ISpinnerControl* spinner;

							edit = GetICustEdit( GetDlgItem( hWnd, IDC_ALPHA_CUTOFF ));
							spinner = GetISpinner( GetDlgItem( hWnd, IDC_ALPHA_CUTOFF_SPINNER ));

							edit->Enable( true );
							spinner->Enable( true );						
						}					
					}
					pass = id - vFIRST_PASS_PARAM_BLOCK;
					if(	( id >= vFIRST_PASS_PARAM_BLOCK ) &&
						( id <= vLAST_PASS_PARAM_BLOCK ))
					{
						drop_down = GetDlgItem( hWnd, IDC_MAPPING_MODE );						
						cur_sel = SendMessage( drop_down, CB_GETCURSEL, 0, 0 );
						if( cur_sel != CB_ERR )
						{
							ICustEdit* edit;
							ISpinnerControl* spinner;
							bool is_env_mapped;
							
							is_env_mapped = ( cur_sel == MAPPING_MODE_ENVIRONMENTMAPPED );

							edit = GetICustEdit( GetDlgItem( hWnd, IDC_ENV_TILE_U ));
							spinner = GetISpinner( GetDlgItem( hWnd, IDC_ENV_TILE_U_SPINNER ));

							edit->Enable( cur_sel == MAPPING_MODE_ENVIRONMENTMAPPED );
							spinner->Enable( cur_sel == MAPPING_MODE_ENVIRONMENTMAPPED ); 

							edit = GetICustEdit( GetDlgItem( hWnd, IDC_ENV_TILE_V ));
							spinner = GetISpinner( GetDlgItem( hWnd, IDC_ENV_TILE_V_SPINNER ));

							edit->Enable( is_env_mapped );
							spinner->Enable( is_env_mapped );
							ReleaseICustEdit( edit );
							ReleaseISpinner( spinner );							
						}

						drop_down = GetDlgItem( hWnd, IDC_BLEND_MODE );						
						cur_sel = SendMessage( drop_down, CB_GETCURSEL, 0, 0 );
						if( cur_sel != CB_ERR )
						{
							if(	( cur_sel != vBLEND_MODE_ADD_FIXED ) &&
								( cur_sel != vBLEND_MODE_SUB_FIXED ) &&
								( cur_sel != vBLEND_MODE_BLEND_FIXED ) &&
								( cur_sel != vBLEND_MODE_MODULATE_FIXED ) &&
								( cur_sel != vBLEND_MODE_BRIGHTEN_FIXED ))
							{	
								ISpinnerControl *spin;
								ICustEdit* edit = GetICustEdit( GetDlgItem( hWnd, IDC_FIXED ));
								edit->Enable( false );
								ReleaseICustEdit( edit );							
								
								spin = GetISpinner (GetDlgItem (hWnd, IDC_FIXED_SPINNER));
								spin->Enable( false );
								ReleaseISpinner( spin );		
							}
						}									
					}				
					break;
				}
				
				case WM_INITDIALOG:
				{
					int i, id;
					HWND drop_down;
					IParamBlock2 *block;

					if( block = map->GetParamBlock())
					{
						id = block->ID();
						
						if( id == vNEXT_PB_MAT_PROPS )
						{
							// Setup Cutoff Function dropdown
							SendDlgItemMessage(hWnd,IDC_CUTOFFFUNC,CB_RESETCONTENT,0,0);
							SendDlgItemMessage(hWnd,IDC_CUTOFFFUNC,CB_ADDSTRING,0,(LPARAM)"No Update");
							SendDlgItemMessage(hWnd,IDC_CUTOFFFUNC,CB_ADDSTRING,0,(LPARAM)"Update FrameBuffer");							
						}

						if( id == vNEXT_PB_DESIGN_PROPS )
						{
							drop_down = GetDlgItem( hWnd, IDC_TERRAIN );
							SendMessage( drop_down, CB_RESETCONTENT, 0L, 0L );
							for( i =  vNUM_TERRAIN_TYPES - 1; 
									i >= 0; i-- )
							{
								SendMessage( drop_down, CB_INSERTSTRING, 0L, 
											(LPARAM) terrain_types[i] );	
							}										
						}

						if(	( id >= vFIRST_PASS_PARAM_BLOCK ) &&
							( id <= vLAST_PASS_PARAM_BLOCK ))
						{	
							NExtMaterial *material = (NExtMaterial *) block->GetOwner();
							
							drop_down = GetDlgItem( hWnd, IDC_BLEND_MODE );
							SendMessage( drop_down, CB_RESETCONTENT, 0L, 0L );
							
							
							if ( id == vFIRST_PASS_PARAM_BLOCK )
							{
								for( i = 0; i < vNUM_BLEND_MODES; i++ ) 
								{
									if( ( i == vBLEND_MODE_BLEND_PREVIOUS_MASK ) ||
										( i == vBLEND_MODE_BLEND_INVERSE_PREVIOUS_MASK ))
									{
										continue;
									}
									SendMessage( drop_down, CB_ADDSTRING, 0L, (LPARAM) blend_modes[i] );
								}
							}
							else
							{
								// Add a blank selection for diffuse
								// Getting rid of this will screw up consistency, break backward compat.
								// and since we have MAX handling the mapping between data and UI for
								// this we'd have to make some serious changes to how this works
								SendMessage( drop_down, CB_ADDSTRING, 0L, (LPARAM)"");

								// Skip diffuse blend mode for all non-first passes
								for( i = 1; i< vNUM_BLEND_MODES; i++ )
								{
									SendMessage( drop_down, CB_ADDSTRING, 0L, (LPARAM) blend_modes[i] );
								}
							}

							drop_down = GetDlgItem( hWnd, IDC_MAPPING_MODE );
							SendMessage( drop_down, CB_RESETCONTENT, 0L, 0L );
							for( i = 0; i < 2; i++ )
							{
								SendMessage( drop_down, CB_ADDSTRING, 0L, (LPARAM) mapping_modes[i] );
							}

							drop_down = GetDlgItem( hWnd, IDC_MIN_FILTERING_MODE );
							SendMessage( drop_down, CB_RESETCONTENT, 0L, 0L );
							for( i = 0; i < 6; i++ )
							{
								SendMessage( drop_down, CB_ADDSTRING, 0L, (LPARAM) min_filtering_modes[i] );
							}

							drop_down = GetDlgItem( hWnd, IDC_MAG_FILTERING_MODE );
							SendMessage( drop_down, CB_RESETCONTENT, 0L, 0L );
							for( i = 0; i < 2; i++ )
							{
								SendMessage( drop_down, CB_ADDSTRING, 0L, (LPARAM) mag_filtering_modes[i] );
							}
						}
					}

					return TRUE;
				}

				case WM_COMMAND:
				{
					int ctrl_id = (int) LOWORD(wParam);
					IParamBlock2 *block;
					NExtMaterial *material;					
					
					block = map->GetParamBlock();
					material = (NExtMaterial *) block->GetOwner();

					// Invalidate viewport texture on parameter changes
					material->InvalidateViewportTexture();

					//////////////
					//int ctrl_id = (int) LOWORD(wParam);
					Interval ivalid = FOREVER;

#ifdef __RESET_ALPHA_CUTOFF__
					BOOL bUseDefAc;
					material->pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_USEDEFAC, t, bUseDefAc, ivalid );

					if (bUseDefAc)
					{
						int blendMode;
						material->pblock[vFIRST_PASS_PARAM_BLOCK]->GetValue( vNEXT_PARAM_BLEND_MODE, t, blendMode, ivalid );

						if (blendMode == vBLEND_MODE_DIFFUSE)
							material->pblock[vNEXT_PB_MAT_PROPS]->SetValue( vNEXT_PARAM_ALPHA_CUTOFF_NEW, t, 0);
						else
							material->pblock[vNEXT_PB_MAT_PROPS]->SetValue( vNEXT_PARAM_ALPHA_CUTOFF_NEW, t, 1);
					}					
#endif


					if (ctrl_id == IDC_SORTED)
					{
						if (IsDlgButtonChecked(hWnd,IDC_SORTED)==BST_CHECKED)
						{
							HWND hwndDrawOrder = GetDlgItem(hWnd,IDC_DRAW_ORDER_ID);

							EnableWindow(GetDlgItem(hWnd,IDC_DRAW_ORDER_ID),FALSE);
							EnableWindow(GetDlgItem(hWnd,IDC_DRAW_ORDER_ID_SPINNER),FALSE);
							// MAX seems to override this
							bForceDisableDrawOrder = true;
							return TRUE;
						}
						else
						{
							bForceDisableDrawOrder = false;
							EnableWindow(GetDlgItem(hWnd,IDC_DRAW_ORDER_ID),TRUE);
							EnableWindow(GetDlgItem(hWnd,IDC_DRAW_ORDER_ID_SPINNER),TRUE);
							return TRUE;
						}
					}

					switch( HIWORD( wParam ))
					{
						case BN_CLICKED:
						{
							
							switch ( LOWORD( wParam ))
							{
							/*case IDC_HASCOLOR:
								if (IsDlgButtonChecked(hWnd, IDC_HASCOLOR)==BST_CHECKED)
									ShowWindow(GetDlgItem(hWnd, IDC_COLOR),SW_SHOW);
								else
									ShowWindow(GetDlgItem(hWnd, IDC_COLOR),SW_HIDE);
								break;*/

								case IDC_USEDEFAC:
								{
									ICustEdit* edit;
									ISpinnerControl* spinner;

									edit = GetICustEdit( GetDlgItem( hWnd, IDC_ALPHA_CUTOFF ));
									spinner = GetISpinner( GetDlgItem( hWnd, IDC_ALPHA_CUTOFF_SPINNER ));

									if (IsDlgButtonChecked(hWnd, IDC_USEDEFAC)==BST_CHECKED)
									{										
										edit->Enable( false );
										spinner->Enable( false );
									}
									else
									{
										edit->Enable( true );
										spinner->Enable( true );
									}
									break;
								}
							}

							break;							
						}

						case CBN_SELCHANGE:
						{
							HWND drop_down = (HWND) lParam;							
							
							if( ctrl_id == IDC_TERRAIN )
							{
								break;
							}
							
							if( ctrl_id == IDC_MAPPING_MODE )
							{
								int cur_sel;

								cur_sel = SendMessage( drop_down, CB_GETCURSEL, 0, 0 );
								if( cur_sel != CB_ERR )
								{
									ICustEdit* edit;
									ISpinnerControl* spinner;

									edit = GetICustEdit( GetDlgItem( hWnd, IDC_ENV_TILE_U ));
									spinner = GetISpinner( GetDlgItem( hWnd, IDC_ENV_TILE_U_SPINNER ));

									edit->Enable( cur_sel == MAPPING_MODE_ENVIRONMENTMAPPED );
									spinner->Enable( cur_sel == MAPPING_MODE_ENVIRONMENTMAPPED ); 

									edit = GetICustEdit( GetDlgItem( hWnd, IDC_ENV_TILE_V ));
									spinner = GetISpinner( GetDlgItem( hWnd, IDC_ENV_TILE_V_SPINNER ));

									edit->Enable( cur_sel == MAPPING_MODE_ENVIRONMENTMAPPED );
									spinner->Enable( cur_sel == MAPPING_MODE_ENVIRONMENTMAPPED ); 									
								}
							}
							if( ctrl_id == IDC_BLEND_MODE )
							{
								int cur_sel;

								cur_sel = SendMessage( drop_down, CB_GETCURSEL, 0, 0 );
								if( cur_sel != CB_ERR )
								{
									ICustEdit* edit = GetICustEdit( GetDlgItem( hWnd, IDC_FIXED ));
									ISpinnerControl *spin = GetISpinner (GetDlgItem (hWnd, IDC_FIXED_SPINNER));

									if ( block->ID() > vFIRST_PASS_PARAM_BLOCK )
									{
										if ( cur_sel == 0 )
										{
											MessageBox(gInterface->GetMAXHWnd(),"You must select a valid blending mode.","Blend Mode Invalid",MB_ICONWARNING|MB_OK);
											block->SetValue( vNEXT_PARAM_BLEND_MODE, 0, 1 );
											cur_sel = 1;
										}
									}
									else
									{
										// Auto select the transparent flag if 1st-pass blend mode is not diffuse
										if(	( cur_sel != vBLEND_MODE_DIFFUSE ) && 
											( !material->m_transparent ))
										{
											material->m_transparent = true;
											material->pblock[vNEXT_PB_MAT_PROPS]->SetValue( vNEXT_PARAM_TRANSPARENT, t, material->m_transparent );
										}	
										else if( ( cur_sel == vBLEND_MODE_DIFFUSE ) && 
												 ( material->m_transparent ))
										{
											material->m_transparent = false;
											material->pblock[vNEXT_PB_MAT_PROPS]->SetValue( vNEXT_PARAM_TRANSPARENT, t, material->m_transparent );
										}										
									}

									if(	( cur_sel == vBLEND_MODE_ADD_FIXED ) ||
										( cur_sel == vBLEND_MODE_SUB_FIXED ) ||
										( cur_sel == vBLEND_MODE_BLEND_FIXED ) ||
										( cur_sel == vBLEND_MODE_MODULATE_FIXED ) ||
										( cur_sel == vBLEND_MODE_BRIGHTEN_FIXED ))
									{										
										edit->Enable( true );
										spin->Enable( true );
									}
									else
									{
										edit->Enable( false );
										spin->Enable( false );
									}

									ReleaseICustEdit( edit );
									ReleaseISpinner( spin );								
								}
							}
							
							break;
						}						
					}
					break;
				}
			}
			return FALSE; 
		}
		void SetThing(ReferenceTarget *m) 
		{	
			m_Mtl = (NExtMaterial *)m;
			//if( mtl ) 
			//{
				//mtl->Enable();
			//}
		}

		void Update(TimeValue t) {}		
		void DeleteThis() {}		

		NExtMaterial *m_Mtl;
};

static NExtDlgProc NExtDlgProc;


class NExtPBAccessor : public PBAccessor
{
public:
	void Set(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t)    // set from v
	{
		NExtMaterial* p = (NExtMaterial*)owner;
		if (p!=NULL) 
		{
			/*IParamMap2 *map = p->pblock[tabIndex]->GetMap();
			if (map) 
			{
				switch( id )
				{
					case vNEXT_PARAM_MAP:
					{
						Texmap* tex = (Texmap *) v.r;
						//m->maps->ReplaceReference(2*tabIndex+1, tex);
						p->m_pass_info[tabIndex].map->ReplaceReference( 1, tex );
					}
				}
				switch (id)	{
					case matte_opaque_alpha:
						map->Enable(matte_affect_alpha, v.i? FALSE: TRUE);
						break;
					case matte_reflection_map:
				   		map->Enable(matte_reflection_amount, v.r?TRUE: FALSE);
						break;
					}
				}
			}*/
		}
	}
};

static NExtPBAccessor next_accessor;

static ParamBlockDescID pbdesc[] = 
{
	{ TYPE_RGBA, NULL, TRUE, vNEXT_PARAM_COLOR }
};   

static ParamBlockDesc2 next_mat_props_blk ( vNEXT_PB_MAT_PROPS, _T("Properties"),  0, &nextCD, P_AUTO_CONSTRUCT + P_AUTO_UI, vNEXT_REF_MAT_PROPS, 
	//rollout
	IDD_NEXT_MATERIAL_PROPS_PANEL, IDS_NEXT_PROPS, 0, APPENDROLL_CLOSED, &NExtDlgProc, 
	// params
	vNEXT_PARAM_ONE_SIDED, _T("One-Sided Material"),		TYPE_BOOL, 		0,	IDS_ONE_SIDED,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_ONE_SIDED, 
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_INVISIBLE, _T("Invisible"),		TYPE_BOOL, 		0,	IDS_INVISIBLE,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_INVISIBLE, 
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_FRONT_FACING, _T("Front-Facing"),TYPE_BOOL, 		0,	IDS_FRONT_FACING,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_FRONT_FACING, 
		p_accessor,		&next_accessor,
		end, 		
	vNEXT_PARAM_TRANSPARENT, _T("Transparent"),TYPE_BOOL, 		0,	IDS_TRANSPARENT,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_TRANSPARENT, 
		p_enable_ctrls,	2,	vNEXT_PARAM_DRAW_ORDER_ID, vNEXT_PARAM_SORTED,
		p_accessor,		&next_accessor,
		end, 				
	vNEXT_PARAM_DECAL, _T("Decal"),TYPE_BOOL, 		0,	IDS_DECAL,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_DECAL, 
		p_accessor,		&next_accessor,
		end, 						
	vNEXT_PARAM_DRAW_ORDER_ID,	_T("Draw Order ID"), TYPE_FLOAT,	P_ANIMATABLE,	0,
		p_default, 		500.0, 
		p_range, 		0.0, 1000.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_DRAW_ORDER_ID, IDC_DRAW_ORDER_ID_SPINNER, 0.01, 
		end, 			
	vNEXT_PARAM_BASE_PASS,	_T("Base Pass"), TYPE_INT,	P_ANIMATABLE,	0,
		p_default, 		1, 
		p_range, 		1, 12, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_INT, IDC_BASE_PASS, IDC_BASE_PASS_SPINNER, SPIN_AUTOSCALE,
		end, 			
	vNEXT_PARAM_SORTED, _T("Sorted"),TYPE_BOOL, 		0,	IDS_SORTED,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_SORTED, 
		p_accessor,		&next_accessor,		
		end, 						
	/*vNEXT_PARAM_ALPHA_CUTOFF,	_T("Alpha Cutoff"), TYPE_INT,	P_ANIMATABLE,	0,
		p_default, 		0, 
		p_range, 		0, 255, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_ALPHA_CUTOFF, IDC_ALPHA_CUTOFF_SPINNER, 1.0, 
		end, 		*/

	vNEXT_PARAM_ALPHA_CUTOFF_NEW,	_T("Alpha Cutoff"), TYPE_INT,	P_ANIMATABLE,	0,
		p_enabled,		FALSE,
		p_default, 		1, 
		p_range, 		0, 255, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_ALPHA_CUTOFF, IDC_ALPHA_CUTOFF_SPINNER, 1.0, 
		end,
	
	vNEXT_PARAM_CUTOFFFUNC, _T("Cuttoff Function"), TYPE_INT, 0, 0,
		p_default,      0,
		p_ui,			TYPE_INTLISTBOX, IDC_CUTOFFFUNC, 0,
		end,

	vNEXT_PARAM_2SIDED, _T("Two Sided"), TYPE_BOOL, 0, 0,
		p_default,      0,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_2SIDED,
		end,

	vNEXT_PARAM_RENDERMULTI, _T("Render Multiple passes in the MAX viewport"), TYPE_BOOL, 0, 0,
		p_default,      0,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_RENDERMULTI,
		end,

	vNEXT_PARAM_WATER, _T("Water"), TYPE_BOOL, 0, 0,
		p_default,      0,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_WATER,		
		end,	
	vNEXT_PARAM_GRASSIFY, _T("Grassify"), TYPE_BOOL, 0, 0,
		p_default,      0,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_GRASSIFY,
		p_enable_ctrls,	2, vNEXT_PARAM_GRASSHEIGHT, vNEXT_PARAM_GRASSLAYERS,
		end,

	vNEXT_PARAM_GRASSHEIGHT, _T("GrassHeight"), TYPE_FLOAT, 0, 0,
		p_enabled,		FALSE,
		p_default,		1.0,
		p_range,		0.0, 1000.0,
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_EDITHEIGHT, IDC_SPINHEIGHT, 0.01, 
		end,

	vNEXT_PARAM_GRASSLAYERS, _T("GrassLayers"), TYPE_INT, 0, 0,
		p_enabled,		FALSE,
		p_default,		1,
		p_range,		1,255,
		p_ui,			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_EDITLAYERS, IDC_SPINLAYERS, 1.0,
		end,

	vNEXT_PARAM_USEDEFAC, _T("UseDefCutoff"), TYPE_BOOL, 0, 0,
		p_enabled,      TRUE,
		p_default,      TRUE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_USEDEFAC,
		end,

	vNEXT_PARAM_SPECULAR_POWER, _T("SpecularPower"), TYPE_FLOAT, 0, 0,
		p_enabled,		FALSE,
		p_default,		16.0f,
		p_ui,			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_SPECPOW, IDC_SPECPOWSPIN, 0.01,
		end,

	vNEXT_PARAM_SPECULAR_COLOR, _T("SpecularColor"), TYPE_RGBA, 0, 0,
		p_enabled,		FALSE,
		p_default,		Color(1,1,1),
		p_ui,			TYPE_COLORSWATCH, IDC_SPECCOLOR,
		end,

	vNEXT_PARAM_USE_SPECULAR, _T("UseSpecular"), TYPE_BOOL, 0, 0,
		p_enabled,		TRUE,
		p_default,      FALSE,
		p_enable_ctrls, 2, vNEXT_PARAM_SPECULAR_POWER, vNEXT_PARAM_SPECULAR_COLOR,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_USESPECULAR,
		end,

	end
);

static ParamBlockDesc2 vc_wibble_blk ( vNEXT_PB_VC_WIBBLE, _T("VC Wibble Sequences"),  0, &nextCD, P_AUTO_CONSTRUCT + P_AUTO_UI, vNEXT_REF_VC_WIBBLE,
	//rollout
	IDD_NEXT_VCWIBBLE_PANEL, IDS_VC_WIBBLE_SEQ, 0, APPENDROLL_CLOSED, &NExtDlgProc,
	//params
	vNEXT_PARAM_VC_COLOR_1, _T("VC Wibble Color 1"),	TYPE_RGBA,				P_ANIMATABLE,	IDS_VC_WIBBLE_COLOR_1,
		p_default,		Color(1,1,1), 
		p_ui,			TYPE_COLORSWATCH, IDC_VC_COLOR_1, 
		end,
	vNEXT_PARAM_VC_COLOR_2, _T("VC Wibble Color 2"),	TYPE_RGBA,				P_ANIMATABLE,	IDS_VC_WIBBLE_COLOR_2,
		p_default,		Color(1,1,1), 
		p_ui,			TYPE_COLORSWATCH, IDC_VC_COLOR_2, 
		end,
	vNEXT_PARAM_VC_COLOR_3, _T("VC Wibble Color 3"),	TYPE_RGBA,				P_ANIMATABLE,	IDS_VC_WIBBLE_COLOR_3,
		p_default,		Color(1,1,1), 
		p_ui,			TYPE_COLORSWATCH, IDC_VC_COLOR_3, 
		end,
	vNEXT_PARAM_VC_COLOR_4, _T("VC Wibble Color 4"),	TYPE_RGBA,				P_ANIMATABLE,	IDS_VC_WIBBLE_COLOR_4,
		p_default,		Color(1,1,1), 
		p_ui,			TYPE_COLORSWATCH, IDC_VC_COLOR_4, 
		end,
	vNEXT_PARAM_VC_COLOR_5, _T("VC Wibble Color 5"),	TYPE_RGBA,				P_ANIMATABLE,	IDS_VC_WIBBLE_COLOR_5,
		p_default,		Color(1,1,1), 
		p_ui,			TYPE_COLORSWATCH, IDC_VC_COLOR_5,
		end,
	vNEXT_PARAM_VC_COLOR_6, _T("VC Wibble Color 6"),	TYPE_RGBA,				P_ANIMATABLE,	IDS_VC_WIBBLE_COLOR_6,
		p_default,		Color(1,1,1), 
		p_ui,			TYPE_COLORSWATCH, IDC_VC_COLOR_6,
		end,
	vNEXT_PARAM_VC_COLOR_7, _T("VC Wibble Color 7"),	TYPE_RGBA,				P_ANIMATABLE,	IDS_VC_WIBBLE_COLOR_7,
		p_default,		Color(1,1,1), 
		p_ui,			TYPE_COLORSWATCH, IDC_VC_COLOR_7,
		end,
	vNEXT_PARAM_VC_COLOR_8, _T("VC Wibble Color 8"),	TYPE_RGBA,				P_ANIMATABLE,	IDS_VC_WIBBLE_COLOR_8,
		p_default,		Color(1,1,1), 
		p_ui,			TYPE_COLORSWATCH, IDC_VC_COLOR_8,
		end,	
	vNEXT_PARAM_VC_ALPHA_1,	_T("VC Wibble Alpha 1"), TYPE_INT,	P_ANIMATABLE,	0,
		p_default, 		100, 
		p_range, 		0, 100, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_VC_ALPHA_1, IDC_VC_ALPHA_1_SPINNER, 1.0, 
		end,
	vNEXT_PARAM_VC_ALPHA_2,	_T("VC Wibble Alpha 2"), TYPE_INT,	P_ANIMATABLE,	0,
		p_default, 		100, 
		p_range, 		0, 100, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_VC_ALPHA_2, IDC_VC_ALPHA_2_SPINNER, 1.0, 
		end,
	vNEXT_PARAM_VC_ALPHA_3,	_T("VC Wibble Alpha 3"), TYPE_INT,	P_ANIMATABLE,	0,
		p_default, 		100, 
		p_range, 		0, 100, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_VC_ALPHA_3, IDC_VC_ALPHA_3_SPINNER, 1.0, 
		end,
	vNEXT_PARAM_VC_ALPHA_4,	_T("VC Wibble Alpha 4"), TYPE_INT,	P_ANIMATABLE,	0,
		p_default, 		100, 
		p_range, 		0, 100, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_VC_ALPHA_4, IDC_VC_ALPHA_4_SPINNER, 1.0, 
		end,
	vNEXT_PARAM_VC_ALPHA_5,	_T("VC Wibble Alpha 5"), TYPE_INT,	P_ANIMATABLE,	0,
		p_default, 		100, 
		p_range, 		0, 100, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_VC_ALPHA_5, IDC_VC_ALPHA_5_SPINNER, 1.0, 
		end,
	vNEXT_PARAM_VC_ALPHA_6,	_T("VC Wibble Alpha 6"), TYPE_INT,	P_ANIMATABLE,	0,
		p_default, 		100, 
		p_range, 		0, 100, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_VC_ALPHA_6, IDC_VC_ALPHA_6_SPINNER, 1.0, 
		end,
	vNEXT_PARAM_VC_ALPHA_7,	_T("VC Wibble Alpha 7"), TYPE_INT,	P_ANIMATABLE,	0,
		p_default, 		100, 
		p_range, 		0, 255, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_VC_ALPHA_7, IDC_VC_ALPHA_7_SPINNER, 1.0, 
		end,
	vNEXT_PARAM_VC_ALPHA_8,	_T("VC Wibble Alpha 8"), TYPE_INT,	P_ANIMATABLE,	0,
		p_default, 		100, 
		p_range, 		0, 100, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_VC_ALPHA_8, IDC_VC_ALPHA_8_SPINNER, 1.0, 
		end,	
	end
);

static ParamBlockDesc2 next_mat_design_props_blk ( vNEXT_PB_DESIGN_PROPS, _T("DesignProperties"),  0, &nextCD, P_AUTO_CONSTRUCT + P_AUTO_UI, vNEXT_REF_DESIGN_PROPS,
	//rollout
	IDD_SKATEFLAGS_MAT_PANEL, IDS_DESIGN_PROPS, 0, APPENDROLL_CLOSED, &NExtDlgProc,
	//params
	vNEXT_PARAM_TERRAIN_TYPE, _T("TerrainType"), TYPE_INT, 0, 0, 	
		p_default, 		0,//NxPlugin::CustomMaterialData::vTERRAIN_DEFAULT, 
		p_ui, 			TYPE_INTLISTBOX, IDC_TERRAIN, 0,
		p_accessor,		&next_accessor,
		end, 
	end
);

static ParamBlockDesc2 next_mat_pass1_blk ( vNEXT_PB_PASS_1, _T("Pass 1"),  0, &nextCD, P_AUTO_CONSTRUCT + P_AUTO_UI, vNEXT_REF_PASS_1, 
	//rollout
	IDD_NEXT_MATERIAL_PASS_PANEL, IDS_NEXT_PASS1, 0, 0, &NExtDlgProc, 
	// params

	vNEXT_PARAM_MAP,		_T("Map 1"), 		TYPE_TEXMAP_TAB, vNUM_TEX_PER_PASS,	P_NO_REF, _T("Map"),
		p_refno,		vNEXT_REF_MAP_1,
		p_subtexno,		0,
		p_ui, 			TYPE_TEXMAPBUTTON,  IDC_MAP,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_COLOR, _T("Color 1"),	TYPE_RGBA,				P_ANIMATABLE,	_T("Color"),
		p_default,		Color(0.5,0.5,0.5), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR, 
		end,
	vNEXT_PARAM_HASCOLOR, _T("Has Color 1"),  TYPE_BOOL, 0,	0,	// aml
		p_default,      FALSE,
		p_enable_ctrls,	1,	vNEXT_PARAM_COLOR,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_HASCOLOR,
		end,
	vNEXT_PARAM_BLEND_MODE, _T("Blend Mode 1"), TYPE_INT, 0, 0, 	
		p_default, 		0, 
		p_ui, 			TYPE_INTLISTBOX, IDC_BLEND_MODE, 0,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_FIXED, 	_T("Fixed 1"), 	TYPE_INT, 	P_ANIMATABLE, 	0, 
		p_default, 		0, 
		p_range, 		0, 255, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_FIXED, IDC_FIXED_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UVEL, 	_T("U Velocity 1"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		-1024.0, 1024.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_VEL, IDC_U_VEL_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_VVEL, 	_T("V Velocity 1"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		-1024.0, 1024.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_VEL, IDC_V_VEL_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_UFREQUENCY, 	_T("U Frequency 1"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_FREQUENCY, IDC_U_FREQUENCY_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VFREQUENCY, 	_T("V Frequency 1"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_FREQUENCY, IDC_V_FREQUENCY_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UAMP, 	_T("U Amplitude 1"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_AMPLITUDE, IDC_U_AMPLITUDE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VAMP, 	_T("V Amplitude 1"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_AMPLITUDE, IDC_V_AMPLITUDE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UPHASE, 	_T("U Phase 1"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_PHASE, IDC_U_PHASE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VPHASE, 	_T("V Phase 1"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_PHASE, IDC_V_PHASE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UV_ENABLED,	_T("UV Enable 1"),	TYPE_BOOL, 		0,	IDS_UV_ENABLE,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_UV_ENABLE,
		p_enable_ctrls,	8,	vNEXT_PARAM_UVEL, vNEXT_PARAM_VVEL, vNEXT_PARAM_UFREQUENCY, 
							vNEXT_PARAM_VFREQUENCY, vNEXT_PARAM_UAMP, vNEXT_PARAM_VAMP, 
							vNEXT_PARAM_UPHASE, vNEXT_PARAM_VPHASE,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_COLOR_A, _T("Ambient Color 1"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_A, 
		end,
	vNEXT_PARAM_COLOR_D, _T("Diffuse Color 1"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_D, 
		end,
	vNEXT_PARAM_COLOR_S, _T("Specular Color 1"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_S, 
		end,
	vNEXT_PARAM_ENABLED,	_T("Pass Enabled 1"),		TYPE_BOOL, 		0,	IDS_PASS_ENABLE,
		p_enabled,		FALSE,
		p_default, 		TRUE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_ENABLED, 
		p_accessor,		&next_accessor,
		end, 	
	vNEXT_PARAM_ABSENT_IN_NETGAMES,	_T("Absent in Net Games 1"),		TYPE_BOOL, 		0,	IDS_ABSENT_IN_NETGAMES,
		p_enabled,		FALSE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_ABSENT_IN_NET_GAMES, 
		p_accessor,		&next_accessor,
		end, 	
	vNEXT_PARAM_MAPPING_MODE, _T("Mapping Mode 1"), TYPE_INT, 0, 0, 	
		p_default, 		0, 
		p_ui, 			TYPE_INTLISTBOX, IDC_MAPPING_MODE, 0,
		p_accessor,		&next_accessor,
		end,
	vNEXT_PARAM_COLOR_LOCKED, _T("ColorLocked1"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_COLORLOCKED,
		end,
	vNEXT_PARAM_ENV_TILE_U,	_T("Env Tile U 1"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_enabled,		FALSE,
		p_default, 		3.0, 
		p_range, 		1.0, 8.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_ENV_TILE_U, IDC_ENV_TILE_U_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_ENV_TILE_V,	_T("Env Tile V 1"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_enabled,		FALSE,
		p_default, 		3.0, 
		p_range, 		1.0, 8.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_ENV_TILE_V, IDC_ENV_TILE_V_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_IGNORE_VERTEX_ALPHA, _T("Ignore Vertex Color Alpha 1"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_IGNORE_VERTEX_ALPHA,
		end,		
	
/*
	vNEXT_PARAM_UNLIT, _T("Unlit1"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_PASSUNLIT,
		end,
*/
	end
);

static ParamBlockDesc2 next_mat_pass2_blk ( vNEXT_PB_PASS_2, _T("Pass 2"),  0, &nextCD, P_AUTO_CONSTRUCT + P_AUTO_UI, vNEXT_REF_PASS_2, 
	//rollout
	IDD_NEXT_MATERIAL_PASS_PANEL, IDS_NEXT_PASS2, 0, APPENDROLL_CLOSED, &NExtDlgProc, 
	// params

	vNEXT_PARAM_MAP,	_T("Map 2"), 		TYPE_TEXMAP_TAB, vNUM_TEX_PER_PASS,	P_NO_REF, _T("Map"),
		p_refno,		vNEXT_REF_MAP_2,
		p_subtexno,		1,
		p_ui, 			TYPE_TEXMAPBUTTON,  IDC_MAP,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_COLOR, _T("Color 2"),	TYPE_RGBA,				P_ANIMATABLE,	_T("Color"),
		p_default,		Color(0.5,0.5,0.5), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR, 
		end,
	vNEXT_PARAM_HASCOLOR, _T("Has Color 2"),  TYPE_BOOL, 0,	0,	// aml
		p_default,      FALSE,
		p_enable_ctrls,	1,	vNEXT_PARAM_COLOR,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_HASCOLOR,
		end,
	vNEXT_PARAM_BLEND_MODE, _T("Blend Mode 2"), TYPE_INT, 0, 0, 	
		p_default, 		5, 
		p_ui, 			TYPE_INTLISTBOX, IDC_BLEND_MODE, 0,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_FIXED, 	_T("Fixed 2"), 	TYPE_INT, 	P_ANIMATABLE, 	0, 
		p_default, 		0, 
		p_range, 		0, 255, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_FIXED, IDC_FIXED_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UVEL, 	_T("U Velocity 2"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		-1024.0, 1024.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_VEL, IDC_U_VEL_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_VVEL, 	_T("V Velocity 2"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		-1024.0, 1024.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_VEL, IDC_V_VEL_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_UFREQUENCY, 	_T("U Frequency 2"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_FREQUENCY, IDC_U_FREQUENCY_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VFREQUENCY, 	_T("V Frequency 2"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_FREQUENCY, IDC_V_FREQUENCY_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UAMP, 	_T("U Amplitude 2"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_AMPLITUDE, IDC_U_AMPLITUDE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VAMP, 	_T("V Amplitude 2"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_AMPLITUDE, IDC_V_AMPLITUDE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UPHASE, 	_T("U Phase 2"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_PHASE, IDC_U_PHASE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VPHASE, 	_T("V Phase 2"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_PHASE, IDC_V_PHASE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UV_ENABLED,	_T("UV Enable 2"),	TYPE_BOOL, 		0,	IDS_UV_ENABLE,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_UV_ENABLE,
		p_enable_ctrls,	8,	vNEXT_PARAM_UVEL, vNEXT_PARAM_VVEL, vNEXT_PARAM_UFREQUENCY, 
							vNEXT_PARAM_VFREQUENCY, vNEXT_PARAM_UAMP, vNEXT_PARAM_VAMP, 
							vNEXT_PARAM_UPHASE, vNEXT_PARAM_VPHASE, 
		p_accessor,		&next_accessor,
		end,
	vNEXT_PARAM_COLOR_A, _T("Ambient Color 2"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_A, 
		end,
	vNEXT_PARAM_COLOR_D, _T("Diffuse Color 2"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_D, 
		end,
	vNEXT_PARAM_COLOR_S, _T("Specular Color 2"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_S, 
		end,
	vNEXT_PARAM_ENABLED,	_T("Pass Enabled 2"),		TYPE_BOOL, 		0,	IDS_PASS_ENABLE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_ENABLED, 
		p_enable_ctrls,	8,	vNEXT_PARAM_MAP, vNEXT_PARAM_COLOR, vNEXT_PARAM_BLEND_MODE, vNEXT_PARAM_FIXED,
							vNEXT_PARAM_UV_ENABLED, vNEXT_PARAM_MAPPING_MODE,
							vNEXT_PARAM_IGNORE_VERTEX_ALPHA, vNEXT_PARAM_ABSENT_IN_NETGAMES,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_ABSENT_IN_NETGAMES,	_T("Absent in Net Games 2"), TYPE_BOOL, 		0,	IDS_ABSENT_IN_NETGAMES,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_ABSENT_IN_NET_GAMES, 
		p_accessor,		&next_accessor,
		end, 		
	vNEXT_PARAM_MAPPING_MODE, _T("Mapping Mode 2"), TYPE_INT, 0, 0, 	
		p_default, 		0, 
		p_ui, 			TYPE_INTLISTBOX, IDC_MAPPING_MODE, 0,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_COLOR_LOCKED, _T("ColorLocked2"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_COLORLOCKED,
		end,
	vNEXT_PARAM_ENV_TILE_U,	_T("Env Tile U 2"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_enabled,		FALSE,
		p_default, 		3.0, 
		p_range, 		1.0, 8.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_ENV_TILE_U, IDC_ENV_TILE_U_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_ENV_TILE_V,	_T("Env Tile V 2"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_enabled,		FALSE,
		p_default, 		3.0, 
		p_range, 		1.0, 8.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_ENV_TILE_V, IDC_ENV_TILE_V_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_IGNORE_VERTEX_ALPHA, _T("Ignore Vertex Color Alpha 2"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_IGNORE_VERTEX_ALPHA,
		end,

/*
	vNEXT_PARAM_UNLIT, _T("Unlit2"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_PASSUNLIT,
		end,
*/
	end

);

#ifdef FOUR_PARAM_BLOCKS
static ParamBlockDesc2 next_mat_pass3_blk ( vNEXT_PB_PASS_3, _T("Pass 3"),  0, &nextCD, P_AUTO_CONSTRUCT + P_AUTO_UI, vNEXT_REF_PASS_3, 
	//rollout
	IDD_NEXT_MATERIAL_PASS_PANEL, IDS_NEXT_PASS3, 0, APPENDROLL_CLOSED, &NExtDlgProc, 
	// params

	vNEXT_PARAM_MAP,	_T("Map 3"), 		TYPE_TEXMAP_TAB, vNUM_TEX_PER_PASS,	P_NO_REF, _T("Map"),
		p_refno,		vNEXT_REF_MAP_3,
		p_subtexno,		2,
		p_ui, 			TYPE_TEXMAPBUTTON,  IDC_MAP,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_COLOR, _T("Color 3"),	TYPE_RGBA,				P_ANIMATABLE,	_T("Color"),
		p_default,		Color(0.5,0.5,0.5), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR, 
		end,
	vNEXT_PARAM_HASCOLOR, _T("Has Color 3"),  TYPE_BOOL, 0,	0,	// aml
		p_default,      FALSE,
		p_enable_ctrls,	1,	vNEXT_PARAM_COLOR,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_HASCOLOR,
		end,
	vNEXT_PARAM_BLEND_MODE, _T("Blend Mode 3"), TYPE_INT, 0, 0, 	
		p_default, 		5, 
		p_ui, 			TYPE_INTLISTBOX, IDC_BLEND_MODE, 0,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_FIXED, 	_T("Fixed 3"), 	TYPE_INT, 	P_ANIMATABLE, 	0, 
		p_default, 		0, 
		p_range, 		0, 255, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_FIXED, IDC_FIXED_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UVEL, 	_T("U Velocity 3"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		-1024.0, 1024.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_VEL, IDC_U_VEL_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_VVEL, 	_T("V Velocity 3"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		-1024.0, 1024.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_VEL, IDC_V_VEL_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_UFREQUENCY, 	_T("U Frequency 3"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_FREQUENCY, IDC_U_FREQUENCY_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VFREQUENCY, 	_T("V Frequency 3"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_FREQUENCY, IDC_V_FREQUENCY_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UAMP, 	_T("U Amplitude 3"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_AMPLITUDE, IDC_U_AMPLITUDE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VAMP, 	_T("V Amplitude 3"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_AMPLITUDE, IDC_V_AMPLITUDE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UPHASE, 	_T("U Phase 3"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_PHASE, IDC_U_PHASE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VPHASE, 	_T("V Phase 3"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_PHASE, IDC_V_PHASE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UV_ENABLED,	_T("UV Enable 3"),	TYPE_BOOL, 		0,	IDS_UV_ENABLE,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_UV_ENABLE,
		p_enable_ctrls,	8,	vNEXT_PARAM_UVEL, vNEXT_PARAM_VVEL, vNEXT_PARAM_UFREQUENCY, 
							vNEXT_PARAM_VFREQUENCY, vNEXT_PARAM_UAMP, vNEXT_PARAM_VAMP, 
							vNEXT_PARAM_UPHASE, vNEXT_PARAM_VPHASE, 
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_COLOR_A, _T("Ambient Color 3"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_A, 
		end,
	vNEXT_PARAM_COLOR_D, _T("Diffuse Color 3"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_D, 
		end,
	vNEXT_PARAM_COLOR_S, _T("Specular Color 3"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_S, 
		end,
	vNEXT_PARAM_ENABLED,	_T("Pass Enabled 3"),		TYPE_BOOL, 		0,	IDS_PASS_ENABLE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_ENABLED, 
		p_enable_ctrls,	8,	vNEXT_PARAM_MAP, vNEXT_PARAM_COLOR, vNEXT_PARAM_FIXED, vNEXT_PARAM_BLEND_MODE,
							vNEXT_PARAM_UV_ENABLED, vNEXT_PARAM_MAPPING_MODE,
							vNEXT_PARAM_IGNORE_VERTEX_ALPHA, vNEXT_PARAM_ABSENT_IN_NETGAMES,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_ABSENT_IN_NETGAMES,	_T("Absent in Net Games 3"), TYPE_BOOL, 		0,	IDS_ABSENT_IN_NETGAMES,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_ABSENT_IN_NET_GAMES, 
		p_accessor,		&next_accessor,
		end, 		
	vNEXT_PARAM_MAPPING_MODE, _T("Mapping Mode 3"), TYPE_INT, 0, 0, 	
		p_default, 		0, 
		p_ui, 			TYPE_INTLISTBOX, IDC_MAPPING_MODE, 0,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_COLOR_LOCKED, _T("ColorLocked3"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_COLORLOCKED,
		end,
	vNEXT_PARAM_ENV_TILE_U,	_T("Env Tile U 3"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_enabled,		FALSE,
		p_default, 		3.0, 
		p_range, 		1.0, 8.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_ENV_TILE_U, IDC_ENV_TILE_U_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_ENV_TILE_V,	_T("Env Tile V 3"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_enabled,		FALSE,
		p_default, 		3.0, 
		p_range, 		1.0, 8.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_ENV_TILE_V, IDC_ENV_TILE_V_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_IGNORE_VERTEX_ALPHA, _T("Ignore Vertex Color Alpha 3"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_IGNORE_VERTEX_ALPHA,
		end,

/*
	vNEXT_PARAM_UNLIT, _T("Unlit3"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_PASSUNLIT,
		end,
*/
	end
);

static ParamBlockDesc2 next_mat_pass4_blk ( vNEXT_PB_PASS_4, _T("Pass 4"),  0, &nextCD, P_AUTO_CONSTRUCT + P_AUTO_UI, vNEXT_REF_PASS_4, 
	//rollout
	IDD_NEXT_MATERIAL_PASS_PANEL, IDS_NEXT_PASS4, 0, APPENDROLL_CLOSED, &NExtDlgProc, 
	// params
	
	vNEXT_PARAM_MAP,	_T("Map 4"), 		TYPE_TEXMAP_TAB, vNUM_TEX_PER_PASS,	P_NO_REF, _T("Map"),
		p_refno,		vNEXT_REF_MAP_4,
		p_subtexno,		3,
		p_ui, 			TYPE_TEXMAPBUTTON,  IDC_MAP,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_COLOR, _T("Color 4"),	TYPE_RGBA,				P_ANIMATABLE,	_T("Color"),
		p_default,		Color(0.5,0.5,0.5), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR, 
		end,
	vNEXT_PARAM_HASCOLOR, _T("Has Color 4"),  TYPE_BOOL, 0,	0,	// aml
		p_default,      FALSE,
		p_enable_ctrls,	1,	vNEXT_PARAM_COLOR,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_HASCOLOR,
		end,
	vNEXT_PARAM_BLEND_MODE, _T("Blend Mode 4"), TYPE_INT, 0, 0, 	
		p_default, 		5, 
		p_ui, 			TYPE_INTLISTBOX, IDC_BLEND_MODE, 0,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_FIXED, 	_T("Fixed 4"), 	TYPE_INT, 	P_ANIMATABLE, 	0, 
		p_default, 		0, 
		p_range, 		0, 255, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_POS_INT, IDC_FIXED, IDC_FIXED_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UVEL, 	_T("U Velocity 4"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		-1024.0, 1024.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_VEL, IDC_U_VEL_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_VVEL, 	_T("V Velocity 4"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		-1024.0, 1024.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_VEL, IDC_V_VEL_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_UFREQUENCY, 	_T("U Frequency 4"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_FREQUENCY, IDC_U_FREQUENCY_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VFREQUENCY, 	_T("V Frequency 4"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_FREQUENCY, IDC_V_FREQUENCY_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UAMP, 	_T("U Amplitude 4"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_AMPLITUDE, IDC_U_AMPLITUDE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VAMP, 	_T("V Amplitude 4"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		1.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_AMPLITUDE, IDC_V_AMPLITUDE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UPHASE, 	_T("U Phase 4"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_U_PHASE, IDC_U_PHASE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_VPHASE, 	_T("V Phase 4"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_default, 		0.0, 
		p_range, 		0.0, 100.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_V_PHASE, IDC_V_PHASE_SPINNER, 1.0, 
		end, 
	vNEXT_PARAM_UV_ENABLED,	_T("UV Enable 4"),	TYPE_BOOL, 		0,	IDS_UV_ENABLE,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_UV_ENABLE,
		p_enable_ctrls,	8,	vNEXT_PARAM_UVEL, vNEXT_PARAM_VVEL, vNEXT_PARAM_UFREQUENCY, 
							vNEXT_PARAM_VFREQUENCY, vNEXT_PARAM_UAMP, vNEXT_PARAM_VAMP, 
							vNEXT_PARAM_UPHASE, vNEXT_PARAM_VPHASE, 
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_COLOR_A, _T("Ambient Color 4"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_A, 
		end,
	vNEXT_PARAM_COLOR_D, _T("Diffuse Color 4"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_D, 
		end,
	vNEXT_PARAM_COLOR_S, _T("Specular Color 4"),	TYPE_RGBA,		P_ANIMATABLE,	0,
		p_default,		Color(0,0,0), 
		p_ui,			TYPE_COLORSWATCH, IDC_COLOR_S, 
		end,
	vNEXT_PARAM_ENABLED,	_T("Pass Enabled 4"),		TYPE_BOOL, 		0,	IDS_PASS_ENABLE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_ENABLED, 
		p_enable_ctrls,	8,	vNEXT_PARAM_MAP, vNEXT_PARAM_COLOR, vNEXT_PARAM_FIXED, vNEXT_PARAM_BLEND_MODE,
							vNEXT_PARAM_UV_ENABLED, vNEXT_PARAM_MAPPING_MODE,
							vNEXT_PARAM_IGNORE_VERTEX_ALPHA, vNEXT_PARAM_ABSENT_IN_NETGAMES,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_ABSENT_IN_NETGAMES,	_T("Absent in Net Games 4"), TYPE_BOOL, 		0,	IDS_ABSENT_IN_NETGAMES,
		p_enabled,		TRUE,
		p_default, 		FALSE, 
		p_ui, 			TYPE_SINGLECHEKBOX, IDC_ABSENT_IN_NET_GAMES, 
		p_accessor,		&next_accessor,
		end, 		
	vNEXT_PARAM_MAPPING_MODE, _T("Mapping Mode 4"), TYPE_INT, 0, 0, 	
		p_default, 		0, 
		p_ui, 			TYPE_INTLISTBOX, IDC_MAPPING_MODE, 0,
		p_accessor,		&next_accessor,
		end, 
	vNEXT_PARAM_COLOR_LOCKED, _T("ColorLocked4"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_COLORLOCKED,
		end,
	vNEXT_PARAM_ENV_TILE_U,	_T("Env Tile U 4"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_enabled,		FALSE,
		p_default, 		3.0, 
		p_range, 		1.0, 8.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_ENV_TILE_U, IDC_ENV_TILE_U_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_ENV_TILE_V,	_T("Env Tile V 4"), 	TYPE_FLOAT, 	P_ANIMATABLE, 	0, 
		p_enabled,		FALSE,
		p_default, 		3.0, 
		p_range, 		1.0, 8.0, 
		p_ui, 			TYPE_SPINNER, EDITTYPE_FLOAT, IDC_ENV_TILE_V, IDC_ENV_TILE_V_SPINNER, 0.1, 
		end, 
	vNEXT_PARAM_IGNORE_VERTEX_ALPHA, _T("Ignore Vertex Color Alpha 4"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_IGNORE_VERTEX_ALPHA,
		end,
	
/*
	vNEXT_PARAM_UNLIT, _T("Unlit4"), TYPE_BOOL, 0, 0,
		p_default,      FALSE,
		p_ui,           TYPE_SINGLECHEKBOX, IDC_PASSUNLIT,
		end,
*/
	end
);
#endif


TSTR NExtMaterial::SubAnimName( int i ) 
{ 
	switch( i )
	{		
		case vNEXT_ANM_VC_WIBBLE:
			return _T("VC Wibble Sequences" );
		case vNEXT_ANM_REF_MAP_1: 
			return TSTR(GetString( IDS_ANIM_REF_MAP1 ));
		case vNEXT_ANM_REF_MAP_2: 
			return TSTR(GetString( IDS_ANIM_REF_MAP2 ));
#ifdef FOUR_PARAM_BLOCKS
		case vNEXT_ANM_REF_MAP_3: 
			return TSTR(GetString( IDS_ANIM_REF_MAP3 ));
		case vNEXT_ANM_REF_MAP_4: 
			return TSTR(GetString( IDS_ANIM_REF_MAP4 ));		
#endif
	}
	return TSTR("");
}		

Animatable* NExtMaterial::SubAnim( int i ) 
{
	switch( i ) 
	{
		case vNEXT_ANM_VC_WIBBLE: return pblock[vNEXT_PB_VC_WIBBLE];
		case vNEXT_ANM_REF_MAP_1: return m_pass_info[0].map;
		case vNEXT_ANM_REF_MAP_2: return m_pass_info[1].map;		
#ifdef FOUR_PARAM_BLOCKS
		case vNEXT_ANM_REF_MAP_3: return m_pass_info[2].map;
		case vNEXT_ANM_REF_MAP_4: return m_pass_info[3].map;
#endif		
		default: DbgAssert(0); return NULL;
	}
}

int NExtMaterial::SubNumToRefNum( int subNum ) 
{ 
	switch( subNum )
	{
		case vNEXT_ANM_VC_WIBBLE: return vNEXT_REF_VC_WIBBLE;
		case vNEXT_ANM_REF_MAP_1: return vNEXT_REF_MAP_1;
		case vNEXT_ANM_REF_MAP_2: return vNEXT_REF_MAP_2;
#ifdef FOUR_PARAM_BLOCKS
		case vNEXT_ANM_REF_MAP_3: return vNEXT_REF_MAP_3;
		case vNEXT_ANM_REF_MAP_4: return vNEXT_REF_MAP_4;
#endif		
		default: DbgAssert(0); return 0;
	}
}

void NExtMaterial::SetReference(int i, RefTargetHandle rtarg)
{
	switch (i)
	{
		case vNEXT_REF_MAT_PROPS:
			pblock[vNEXT_REF_MAT_PROPS] = (IParamBlock2*)rtarg;
			break;
		case vNEXT_REF_VC_WIBBLE:
			pblock[vNEXT_REF_VC_WIBBLE] = (IParamBlock2*)rtarg;
			break;
		case vNEXT_REF_DESIGN_PROPS:
			pblock[vNEXT_REF_DESIGN_PROPS] = (IParamBlock2*)rtarg;
			break;
		case vNEXT_REF_PASS_1: 
			pblock[vNEXT_REF_PASS_1] = (IParamBlock2*)rtarg;
			break;			
		case vNEXT_REF_PASS_2: 
			pblock[vNEXT_REF_PASS_2] = (IParamBlock2*)rtarg; 
			break;			
		case vNEXT_REF_MAP_1:
			if( rtarg != m_pass_info[0].map )
			{
				// We load textures when a new one is assigned (mostly done for load-time)
				// to bind archived textures to their new local path
				if( m_pass_info[0].map == NULL )
				{
					((Texmap*) rtarg )->LoadMapFiles( 0 );
				}
				m_pass_info[0].map = (Texmap *)rtarg;				
			}
			else
			{
				m_pass_info[0].map = (Texmap *)rtarg;
			}
			next_mat_pass1_blk.InvalidateUI( vNEXT_PARAM_MAP );
			break;
		case vNEXT_REF_MAP_2:
			if( rtarg != m_pass_info[1].map )
			{
				m_pass_info[1].map = (Texmap *)rtarg;				
				if( m_pass_info[1].map == NULL )
				{
					//PS2LoadTexture( 1 );
				}
			}
			else
			{
				m_pass_info[1].map = (Texmap *)rtarg;
			}
			next_mat_pass2_blk.InvalidateUI( vNEXT_PARAM_MAP );
			break;
#ifdef FOUR_PARAM_BLOCKS
		case vNEXT_REF_PASS_3: 
			pblock[vNEXT_REF_PASS_3] = (IParamBlock2*)rtarg; 
			break;			
		case vNEXT_REF_PASS_4: 
			pblock[vNEXT_REF_PASS_4] = (IParamBlock2*)rtarg; 
			break;			
		case vNEXT_REF_MAP_3:
			if( rtarg != m_pass_info[2].map )
			{
				m_pass_info[2].map = (Texmap *)rtarg;				
				if( m_pass_info[2].map == NULL )
				{
					//PS2LoadTexture( 2 );
				}
			}
			else
			{
				m_pass_info[2].map = (Texmap *)rtarg;
			}
			next_mat_pass3_blk.InvalidateUI( vNEXT_PARAM_MAP );
			break;
		case vNEXT_REF_MAP_4:
			if( rtarg != m_pass_info[3].map )
			{
				m_pass_info[3].map = (Texmap *)rtarg;				
				if( m_pass_info[3].map == NULL )
				{
					//PS2LoadTexture( 3 );
				}
			}
			else
			{
				m_pass_info[3].map = (Texmap *)rtarg;
			}
			next_mat_pass4_blk.InvalidateUI( vNEXT_PARAM_MAP );
			break;

#endif
	}	
}

void NExtMaterial::Enable( void )
{
	/*int i;

	for( i = 0; i < vNUM_PASSES; i++ )
	{
		if (pblock[i]) 
		{
			IParamMap2 *map = pblock[i]->GetMap();
			if (map) 
			{
				map->Enable( vNEXT_PARAM_MAP, map ? TRUE:FALSE);			
			}
		}
	}*/
}

bool	NExtMaterial::ColorEnabled( int pass )
{
	return m_pass_info[pass].colorEnabled;
}

Color	NExtMaterial::GetColor( int pass )
{
	assert( pass < vNUM_PASSES );
	return m_pass_info[pass].color;
}

Texmap *NExtMaterial::GetTexmap( int pass )
{
	assert( pass < vNUM_PASSES );
	
	return m_pass_info[pass].map;
}

int		NExtMaterial::GetBlendMode( int pass )
{
	assert( pass < vNUM_PASSES );

	return m_pass_info[pass].blend_mode;
}

int		NExtMaterial::GetFixedValue( int pass )
{
	assert( pass < vNUM_PASSES );
	return m_pass_info[pass].fixed;	
}

int		NExtMaterial::GetNumPasses( void )
{
	int i;
	int num_passes;
	
	num_passes = 0;
	for( i = 0; i < vNUM_PASSES; i++ )
	{
		if( m_pass_info[i].enabled )
		{
			num_passes++;
		}
	}

	return num_passes;
}
bool	NExtMaterial::IsOneSided( void )
{
	return ( m_one_sided != FALSE);
}

bool	NExtMaterial::IsTwoSided( void )
{
	return ( m_two_sided != FALSE);
}
bool	NExtMaterial::IsInvisible( void )
{
	return ( m_invisible != FALSE );
}

bool	NExtMaterial::IsTransparent( void )
{
	return ( m_transparent != FALSE );
}

bool	NExtMaterial::IsDecal( void )
{
	return ( m_decal != FALSE );
}

bool	NExtMaterial::IsFrontFacing( void )
{
	return ( m_front_facing != FALSE );
}

float	NExtMaterial::GetEnvTileU( int pass )
{
	return m_pass_info[pass].env_tile_u;
}

float	NExtMaterial::GetEnvTileV( int pass )
{
	return m_pass_info[pass].env_tile_v;
}

float	NExtMaterial::GetUVel( int pass )
{
	return m_pass_info[pass].u_vel;
}

float	NExtMaterial::GetVVel( int pass )
{
	return m_pass_info[pass].v_vel;
}

float	NExtMaterial::GetUFrequency( int pass )
{
	return m_pass_info[pass].u_frequency;
}

float	NExtMaterial::GetVFrequency( int pass )
{
	return m_pass_info[pass].v_frequency;
}

float	NExtMaterial::GetUAmplitude( int pass )
{
	return m_pass_info[pass].u_amp;
}

float	NExtMaterial::GetVAmplitude( int pass )
{
	return m_pass_info[pass].v_amp;
}

float	NExtMaterial::GetUPhase( int pass )
{
	return m_pass_info[pass].u_phase;
}

float	NExtMaterial::GetVPhase( int pass )
{
	return m_pass_info[pass].v_phase;
}

bool	NExtMaterial::UVWibbleDataEnabled( int pass )
{
	return ( m_pass_info[pass].uv_wibble_enabled != FALSE );
}


AColor	NExtMaterial::GetAmbientColor( int pass )
{
	AColor color;
	
	color.r = m_pass_info[pass].color_a.r;
	color.g = m_pass_info[pass].color_a.g;
	color.b = m_pass_info[pass].color_a.b;
	color.a = 1.0f;
	//color.a = m_pass_info[pass].alpha_a;

	return color;
}

AColor	NExtMaterial::GetDiffuseColor( int pass )
{
	AColor color;
	
	color.r = m_pass_info[pass].color_d.r;
	color.g = m_pass_info[pass].color_d.g;
	color.b = m_pass_info[pass].color_d.b;
	color.a = 1.0f;
	//color.a = m_pass_info[pass].alpha_d;

	return color;
}

AColor	NExtMaterial::GetSpecularColor( int pass )
{
	AColor color;
	
	color.r = m_pass_info[pass].color_s.r;
	color.g = m_pass_info[pass].color_s.g;
	color.b = m_pass_info[pass].color_s.b;
	color.a = 1.0f;
	//color.a = m_pass_info[pass].alpha_s;

	return color;
}

Color NExtMaterial::GetSpecularColor()
{
	return m_SpecularColor;
}

float NExtMaterial::GetSpecularPower()
{
	return m_SpecularPower;
}

BOOL NExtMaterial::GetUseSpecular()
{
	return m_UseSpecular;
}

// This idea will only make sense in a two-pass situation and must be redone for more than that
int	NExtMaterial::GetNumSurfacePropertySets( void )
{
	int i, num_sets;
	
	num_sets = 1;
	for( i = 1; i < vNUM_PASSES; i++ )
	{
		/*if( ( m_pass_info[i].override != FALSE ) &&
			(( GetAmbientColor( 0 ) != GetAmbientColor( i )) ||
			 ( GetDiffuseColor( 0 ) != GetDiffuseColor( i )) ||
			 ( GetSpecularColor( 0 ) != GetSpecularColor( i ))))
		{
			num_sets++;
		}*/
	}

	return num_sets;
}

int NExtMaterial::GetTerrainType( void )
{
	return m_design_props.m_TerrainType;
}

int		NExtMaterial::GetBasePass( void )
{
	return ( m_base_pass - 1 );	// convert from 1-based value to 0-based value
}

float	NExtMaterial::GetDrawOrderId( void )
{
	if( IsTransparent() )
	{
		return vBASE_ORDERED_TRANSPARENT_MATERIAL_DRAW_ID + m_draw_order_id;
	}
		
	return vBASE_OPAQUE_MATERIAL_DRAW_ID;	
}

bool	NExtMaterial::IsSorted( void )
{
	// If it's not transparent, ignore the "sorted" flag
	if( IsTransparent() == false )
	{
		return false;
	}

	return ( m_sorted != FALSE );
}

bool	NExtMaterial::IsWater( void )
{
	return m_water;
}

bool	NExtMaterial::IsGrassified( void )
{
	return m_grassify;
}

float	NExtMaterial::GetGrassHeight( void )
{
	return m_grassHeight;
}

int		NExtMaterial::GetGrassLayers( void )
{
	return m_grassLayers;
}

int		NExtMaterial::GetAlphaCutoff( void )
{
	if( m_useDefaultAlphaCutoff )
	{
		return 1;
	}

	return m_alpha_cutoff;
}

CutoffFunc NExtMaterial::GetCutoffFunc( void )
{
	return m_cutoff_func;
}

int		NExtMaterial::VCWibbleNumSequences( void )
{
	int i, num_sequences;

	num_sequences = 0;
	for( i = 0; i < 8; i++ )
	{
		if( VCWibbleNumKeyframes( i ) == 0 )
		{
			return num_sequences;
		}

		num_sequences++;
	}

	return num_sequences;
}

// Since we use a different controller for both the color and the alpha, we need to count
// up how many unique keyframes we have between them both
int		NExtMaterial::VCWibbleNumKeyframes( int sequence )
{	
	bool unique;
	int i, j, total_num_keys;
	IParamBlock2* wibble_block;
	Control* wibble_ctrl;
	IKeyControl *key_ctrl;
	ParamID param_id = vNEXT_PARAM_VC_COLOR_1 + sequence;
	Tab< TimeValue > color_time, alpha_time;
	TimeValue key_time;
	
	total_num_keys = 0;

	wibble_block = pblock[vNEXT_PB_VC_WIBBLE];

	// First enumerate the color keyframes
	wibble_ctrl = wibble_block->GetController( param_id );
	if( wibble_ctrl )
	{
		key_ctrl = GetKeyControlInterface( wibble_ctrl );
		if( key_ctrl )
		{
			for( i = 0; i < key_ctrl->GetNumKeys(); i++ )
			{			
				key_time = wibble_ctrl->GetKeyTime( i );
				color_time.Append( 1, &key_time ); 
			}
		}
	}

	// Next enumerate the alpha keyframes
	param_id = vNEXT_PARAM_VC_ALPHA_1 + sequence;
	wibble_ctrl = wibble_block->GetController( param_id );
	if( wibble_ctrl )
	{
		key_ctrl = GetKeyControlInterface( wibble_ctrl );
		if( key_ctrl )
		{
			for( i = 0; i < key_ctrl->GetNumKeys(); i++ )
			{			
				key_time = wibble_ctrl->GetKeyTime( i );
				alpha_time.Append( 1, &key_time ); 
			}
		}
	}

	// At start we have at least as many keyframes as we have color keyframes
	total_num_keys = color_time.Count();

	// Now count up how many unique alpha keyframes we have 
	for( i = 0; i < alpha_time.Count(); i++ )
	{
		unique = true;
		for( j = 0; j < color_time.Count(); j++ )
		{
			if( alpha_time[i] == color_time[j] )
			{
				unique = false;
				break;
			}
		}

		if( unique )
		{
			total_num_keys++;
		}
	}
	
	return total_num_keys;
}

int vc_frame_cmp( const void *elem1, const void *elem2 )
{
	WibbleKeyframe* key1, *key2;

	key1 = (WibbleKeyframe*) elem1;
	key2 = (WibbleKeyframe*) elem2;

	if( key1->m_Time < key2->m_Time )
	{
		return -1;
	}
	else if( key1->m_Time > key2->m_Time )
	{
		return 1;
	}

	return 0;
}

// Unfortunately, the only way I can think of doing this currently is to create a sorted list
// of (combined) color and alpha keys and then returning the proper keyframe from that combined list
WibbleKeyframe NExtMaterial::VCWibbleKeyFrame( int sequence, int keyframe )
{
	ParamID param_id = vNEXT_PARAM_VC_COLOR_1 + sequence;
	IParamBlock2* wibble_block;
	Control* color_ctrl, *alpha_ctrl;
	IKeyControl *color_key_ctrl, *alpha_key_ctrl;
	TimeValue key_time;
	Color color;
	Interval valid;	
	int i, j;
	float alpha;
	bool unique;
	WibbleKeyframe vc_frame;
	Tab< WibbleKeyframe > vc_keyframes;
	
	color_key_ctrl = NULL;
	alpha_key_ctrl = NULL;

	wibble_block = pblock[vNEXT_PB_VC_WIBBLE];
	color_ctrl = wibble_block->GetController( param_id );	
	param_id = vNEXT_PARAM_VC_ALPHA_1 + sequence;
	alpha_ctrl = wibble_block->GetController( param_id );

	if( color_ctrl )
	{
		color_key_ctrl = GetKeyControlInterface( color_ctrl );
	}
	if( alpha_ctrl )
	{
		alpha_key_ctrl = GetKeyControlInterface( alpha_ctrl );
	}
	if( color_key_ctrl )
	{
		for( i = 0; i < color_key_ctrl->GetNumKeys(); i++ )
		{
			key_time = color_ctrl->GetKeyTime( i );
			vc_frame.m_Time = TicksToSec( key_time ) * 1000;
			color_ctrl->GetValue( key_time, &color, valid );
			if( alpha_ctrl )
			{
				alpha_ctrl->GetValue( key_time, &alpha, valid );	
			}
			else
			{
				alpha = 100;
			}

			vc_frame.m_Color.r = ( color.r * 255.0f );
			vc_frame.m_Color.g = ( color.g * 255.0f );
			vc_frame.m_Color.b = ( color.b * 255.0f );	
			vc_frame.m_Color.a = ( alpha * 2.55f );	// alpha is a percent from 0 to 100

			vc_keyframes.Append( 1, &vc_frame );
		}
	}

	if( alpha_key_ctrl )
	{
		for( i = 0; i < alpha_key_ctrl->GetNumKeys(); i++ )
		{
			key_time = alpha_ctrl->GetKeyTime( i );
			vc_frame.m_Time = TicksToSec( key_time ) * 1000;
			unique = true;
			for( j = 0; j < vc_keyframes.Count(); j++ )
			{
				if( vc_keyframes[j].m_Time == vc_frame.m_Time )
				{
					unique = false;
					break;
				}
			}
			if( unique )
			{
				if( color_ctrl )
				{
					color_ctrl->GetValue( key_time, &color, valid );
				}
				else
				{
					color.r = 1.0f;
					color.g = 1.0f;
					color.b = 1.0f;
				}

				alpha_ctrl->GetValue( key_time, &alpha, valid );	

				vc_frame.m_Color.r = ( color.r * 255.0f );
				vc_frame.m_Color.g = ( color.g * 255.0f );
				vc_frame.m_Color.b = ( color.b * 255.0f );	
				vc_frame.m_Color.a = ( alpha * 2.55f );	// alpha is a percent from 0 to 100

				vc_keyframes.Append( 1, &vc_frame );
			}
		}
	}


	vc_keyframes.Sort( vc_frame_cmp );
	return vc_keyframes[keyframe];
}

int		NExtMaterial::GetMappingMode( int pass )
{
	return m_pass_info[pass].mapping_mode;
}

BOOL	NExtMaterial::GetColorLocked( int pass )
{
	return m_pass_info[pass].color_locked;
}
/*
BOOL	NExtMaterial::GetUnlit( int pass )
{
	return m_pass_info[pass].unlit;
}
*/

BOOL	NExtMaterial::VertexAlphaEnabled( int pass )
{
	// Currently, diffuse blend modes will ignore vertex alpha
	if( GetBlendMode( pass ) == vBLEND_MODE_DIFFUSE )
	{
		return FALSE;
	}

	return ( m_pass_info[pass].ignore_vertex_alpha == FALSE );
}

char*	INExtMaterial::GetTerrainName( int type )
{
	return terrain_types[type];
} 

void	NExtMaterial::SetViewportTexture()
{
	if (!bUpdateViewportTex)
		return;

	// Only assign the texture if multipass rendering is enabled for the material
	if (!pblock)
		return;
	
	BOOL bRenderMulti;
	Interval ival = FOREVER;
	pblock[vNEXT_PB_MAT_PROPS]->GetValue( vNEXT_PARAM_RENDERMULTI, 0, bRenderMulti, ival );

	if (!bRenderMulti)
	{
		//Texmap* tmap = GetSubTexmap(0);
		//SetActiveTexmap(tmap);
		//gInterface->ActivateTexture(tmap,this);
		bUpdateViewportTex = false;
		return;
	}

	// Load all the multipass textures (so we can display multi-texture in viewports)
	// (This will only execute as necessary [only will load once])
	LoadTextures();

	BMM_Color_fl fill_color = { 0,0,0,0 };
	PBITMAPINFO pbmi = NULL;				// a DIB for the image we're modifying
											// it will start with the first pass texture and we'll use this
											// DIB to combine additional passes to (it gets assigned
											// as the final texmap)

	PBITMAPINFO pbmiWork = NULL;			// a DIB used for resizing and quantization for each pass that
											// gets combined into pbmi

	BitmapInfo bif2;
	bif2.SetName(_T("xxxx67878"));
	bif2.SetType(BMM_TRUE_32);
	bif2.SetFlags(MAP_HAS_ALPHA);
	bif2.SetWidth(256);				
	bif2.SetHeight(256);

	Bitmap* vpBmp   = TheManager->Create(&bif2);
	Bitmap* workBmp = TheManager->Create(&bif2);

	for(int pass=0;pass<vNUM_PASSES;pass++)
	{
		Texmap* tmap = GetSubTexmap(pass);

		if (!tmap)
			continue;

		if (tmap->ClassID() == NEXT_TEXTURE_CLASS_ID)
		{
			BMTex* tex = (BMTex*)tmap;

			// The first pass will consist of copying the image into the buffer
			if (pass==0)
			{
				int rVal;

				if (tex->thebm)
				{
					rVal = vpBmp->CopyImage(tex->thebm,COPY_IMAGE_USE_CUSTOM, fill_color, &bif2);
					pbmi = vpBmp->ToDib();
				}
			}
			else
			{
				// Process image for additional passes to combine
				//if (tex->thebm && (!PassEnabled(pass) || pass == 0))
				if (tex->thebm && PassEnabled(pass))
				{
					int rVal;
					//rVal = workBmp->CopyImage(tex->thebm,COPY_IMAGE_RESIZE_LO_QUALITY, fill_color);
					rVal = workBmp->CopyImage(tex->thebm,COPY_IMAGE_RESIZE_LO_QUALITY, fill_color, &bif2);
					
					pbmiWork = workBmp->ToDib();

					BITMAPINFOHEADER* bmih = &pbmi->bmiHeader;
					
					unsigned char* imgBufWork = (unsigned char*)pbmiWork;
					imgBufWork += sizeof(BITMAPINFO);

					unsigned char* imgBuf = (unsigned char*)pbmi;
					imgBuf += sizeof(BITMAPINFO);

					//for(int i=0;i<bmih->biWidth*bmih->biHeight*2;i++)
					for(int i=0;i<bmih->biSizeImage-sizeof(BITMAPINFOHEADER);)
					{
						// Test additive blend
						//imgBuf[i] = (imgBuf[i] + imgBufWork[i]) & 0xFF;

						// Now combine the multiple passes into our new pass the way the PS2 does
						Color destColor;
						Color srcColor;
						
						destColor.r = (float)imgBuf[i  ] / 255.0f;
						destColor.g = (float)imgBuf[i+1] / 255.0f;
						destColor.b = (float)imgBuf[i+2] / 255.0f;
						
						srcColor.r = (float)imgBufWork[i  ] / 255.0f;
						srcColor.g = (float)imgBufWork[i+1] / 255.0f;
						srcColor.b = (float)imgBufWork[i+2] / 255.0f;

						CombineMultipass(destColor,srcColor,pass);

						imgBuf[i  ] = (char)(destColor.r * 255.0f);
						imgBuf[i+1] = (char)(destColor.g * 255.0f);
						imgBuf[i+2] = (char)(destColor.b * 255.0f);

						// Advance 24 bits (3 bytes)
						i+=3;

						//imgBuf[i] = imgBuf[i] * rand()/1000;
						//imgBuf[i] = (imgBuf[i-1] + imgBuf[i+1])/2;
					}

					/*
					for(int i=0;i<bmih->biSizeImage-sizeof(BITMAPINFOHEADER);i++)
					{
						Sampler* theSampler = GetPixelSampler();

						ULONG chanType = BMM_CHAN_TYPE_24;
						UCHAR* shaderBuf = (UCHAR*)tex->thebm->GetChannel(BMM_CHAN_COLOR,chanType);

						assert( chanType == BMM_CHAN_TYPE_24 );

						imgBuf[i  ] = shaderBuf[i  ];
					}
					*/

					LocalFree(pbmiWork);
				}
			}
		}
	}

	workBmp->DeleteThis();

	if (pbmi)
	{
		vpBmp->FromDib(pbmi);
		LocalFree(pbmi);
	}

	vptex->AssignBitmap(vpBmp);
	SetActiveTexmap(vptex);
	gInterface->ActivateTexture(vptex,this);
	bUpdateViewportTex = false;
}

void NExtMaterial::CombineMultipass(Color& dest,Color& src,int pass)
{
	Color lit_color = src;

	//for( pass = 0; pass < vNUM_PASSES; pass++ )
	{
		// m_pass_info isn't updated yet, so we want the opposite condition
		//if( pass==0 || !m_pass_info[pass].enabled )
		if( m_pass_info[pass].enabled )
		{
			AColor input_color;
			Color rc, pass_color;
			Color a, b, d;
			float c;
			int params[4];
			
			//lit_color = ShadeUsingLights( sc, i );
			//lit_color *= 2;

			if( m_pass_info[pass].map )
			{
				input_color = src;
				input_color.a = 1.0f;
				rc = lit_color;
				//rc = /*m_pass_info[i].color*/ lit_color * Color( input_color.r, input_color.g, input_color.b );
				//rc = m_pass_info[pass].color;
			}
			else
			{
				//input_color = src;
				//input_color = m_pass_info[pass].color;
				//rc = Color( input_color.r, input_color.g, input_color.b );
				//rc = Color( lit_color.r, lit_color.g, lit_color.b );
				rc = src;
			}
			
			switch( m_pass_info[pass].blend_mode )
			{
				case vBLEND_MODE_DIFFUSE:				// ( 0 - 0 ) * 0 + Src
					params[0] = vPARAM_COLOR_ZERO;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_ZERO;
					params[3] = vPARAM_COLOR_SRC;
					break;
				case vBLEND_MODE_ADD:					// ( Src - 0 ) * Src + Dst
					params[0] = vPARAM_COLOR_SRC;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_SRC;
					params[3] = vPARAM_COLOR_DST;
					break;
				case vBLEND_MODE_SUBTRACT:				// ( 0 - Src ) * Src + Dst
					params[0] = vPARAM_COLOR_ZERO;
					params[1] = vPARAM_COLOR_SRC;
					params[2] = vPARAM_COLOR_SRC;
					params[3] = vPARAM_COLOR_DST;
					break;
				case vBLEND_MODE_BLEND:					// ( Src * Dst ) * Src + Dst
					params[0] = vPARAM_COLOR_SRC;
					params[1] = vPARAM_COLOR_DST;
					params[2] = vPARAM_COLOR_SRC;
					params[3] = vPARAM_COLOR_DST;
					break;
				case vBLEND_MODE_ADD_FIXED:				// ( Src - 0 ) * Fixed + Dst
					params[0] = vPARAM_COLOR_SRC;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_FIXED;
					params[3] = vPARAM_COLOR_DST;
					break;
				case vBLEND_MODE_SUB_FIXED:				// ( 0 - Src ) * Fixed + Dst
					params[0] = vPARAM_COLOR_ZERO;
					params[1] = vPARAM_COLOR_SRC;
					params[2] = vPARAM_COLOR_FIXED;
					params[3] = vPARAM_COLOR_DST;					
					break;
				case vBLEND_MODE_BLEND_FIXED:			// ( Src * Dst ) * Fixed + Dst	
					params[0] = vPARAM_COLOR_SRC;
					params[1] = vPARAM_COLOR_DST;
					params[2] = vPARAM_COLOR_FIXED;
					params[3] = vPARAM_COLOR_DST;					
					break;
				case vBLEND_MODE_MODULATE:				// ( Dst - 0 ) * Src + 0
					params[0] = vPARAM_COLOR_DST;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_SRC;
					params[3] = vPARAM_COLOR_ZERO;
					break;
				case vBLEND_MODE_MODULATE_FIXED:			// ( Dst - 0 ) * Fixed + 0
					params[0] = vPARAM_COLOR_DST;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_FIXED;
					params[3] = vPARAM_COLOR_ZERO;					
					break;
				case vBLEND_MODE_BRIGHTEN:				// ( Dst - 0 ) * Src + Dst
					params[0] = vPARAM_COLOR_DST;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_SRC;
					params[3] = vPARAM_COLOR_DST;					
					break;
				case vBLEND_MODE_BRIGHTEN_FIXED:			// ( Dst - 0 ) * Fixed + Dst	
					params[0] = vPARAM_COLOR_DST;
					params[1] = vPARAM_COLOR_ZERO;
					params[2] = vPARAM_COLOR_FIXED;
					params[3] = vPARAM_COLOR_DST;					
					break;
			}

			switch( params[0] )
			{
				case vPARAM_COLOR_SRC:
					a = rc;
					break;
				case vPARAM_COLOR_DST:
					//a = sc.out.c;
					a = dest;
					break;
				case vPARAM_COLOR_ZERO:						
				case vPARAM_COLOR_RESERVED:
					a = Color( 0, 0, 0 );
					break;
			}

			switch( params[1] )
			{
				case vPARAM_COLOR_SRC:
					b = rc;
					break;
				case vPARAM_COLOR_DST:
					//b = sc.out.c;		
					b = dest;
					break;
				case vPARAM_COLOR_ZERO:						
				case vPARAM_COLOR_RESERVED:
					b = Color( 0, 0, 0 );
					break;
			}

			switch( params[2] )
			{
				case vPARAM_COLOR_SRC:
					c = input_color.a * 255.0f;	// input_color.a is [0,1], scale it to [0,255]
					//c = input_color.a;
					break;
				case vPARAM_COLOR_DST:
					//c = sc.out.t.r * 255.0f;		// sc.out.t.r is [0,1], scale it to [0,255]
					c = 255;						// add alpha later (32-bit)
					//c = 1.0f;
					break;
				case vPARAM_COLOR_FIXED:
					c = (float) m_pass_info[pass].fixed;
					//c = (float) m_pass_info[pass].fixed / 255.0f;
					break;
				case vPARAM_COLOR_RESERVED:
					c = 255;
					//c = 1.0f;
					break;
			}

			switch( params[3] )
			{
				case vPARAM_COLOR_SRC:
					d = rc;
					break;
				case vPARAM_COLOR_DST:
					//d = sc.out.c;
					d = dest;
					break;
				case vPARAM_COLOR_ZERO:						
				case vPARAM_COLOR_RESERVED:
					d = Color( 0, 0, 0 );
					break;
			}
			
			// Mimic behavior on the PS2 where the product of the colors
			// and the alpha value are shifted right 7 before adding the final color value
			pass_color = ( a - b ) * c;

			pass_color /= 128;
			//pass_color /= 256;
			pass_color += d;

			dest = pass_color;
			
			// Do clamping
			if (dest.r > 1.0f)
				dest.r = 1.0f;

			if (dest.g > 1.0f)
				dest.g = 1.0f;

			if (dest.b > 1.0f)
				dest.b = 1.0f;

			if (dest.r < 0.0f)
				dest.r = 0.0f;

			if (dest.g < 0.0f)
				dest.g = 0.0f;

			if (dest.b < 0.0f)
				dest.b = 0.0f;

			// Add alpha later (32-bit)
			//sc.out.t.r = input_color.a;
			//sc.out.t.g = input_color.a;
			//sc.out.t.b = input_color.a;
		}

		lit_color = dest;
	}
}

CStr NExtMaterial::GetName()
{
	return Mtl::GetName();
}
