/*
	ImageData.h
	Class for storing PNG format image data
*/

#ifndef __IMAGEDATA__
#define __IMAGEDATA__

#include "image/png.h"
#include "colors.h"

class ImageData
{
	void GetStdPal(png_structp png_ptr, png_infop info_ptr);
	void GetPal(png_structp png_ptr, png_infop info_ptr);
	void FreePals();

public:
	unsigned long  width,height;	// Width and Height

	int bit_depth;
	int nChannels;
	int color_type;
	int interlace_type;
	int compression_type;
	int filter_type;
	int imageSize;
	int pixel_depth;

	unsigned char*  buf;				// The buffer containing the image
	unsigned char** pRows;				// Pointer to scanlines of data in image

	png_color*      palette;			// Standard palette
	int             nPalEntries;		// Number of entries within the standard palette

	png_sPLT_tp     pals;				// List of used palettes in sPLT chunks
	int             nPals;				// number of palettes used

	png_byte*       tRNSpal;			// Transparency palette for palettized PNGs
	int             tRNSentries;		// Number of transparent entries in palette
	png_color_16    tRNStrans_values;	// Transparent values for grayscale images
	bool            btRNStransValid;	// True if tRNStrans_values is valid

	png_uint_16*    histogram;			// Maintains a histogram for use with dithering
										// (This is loaded from the PNG or generated by the quantizer)

	ImageData();
	ImageData(ImageData& src);			// Copy constructor
	~ImageData();

	ImageData& operator = (ImageData& right);
	void CopyNoImage(ImageData* src);

	// These function acquire a pixel from the image in the specified format
	// regardless of the format of the original image
	color32 GetColor32(unsigned int x, unsigned int y);
	color32 GetColor32(unsigned int idx);

	color24 GetColor24(unsigned int x, unsigned int y);
	color24 GetColor24(unsigned int idx);

	color16_555 GetColor16(unsigned int x, unsigned int y);
	color16_555 GetColor16(unsigned int idx);

	varColor GetColor(unsigned int x, unsigned int y, int depth);
	varColor GetColor(unsigned int idx, int depth);

	// Converts the current image data into a new given ImageData that is 32-bit RGBA
	void Convert32(ImageData* img);
	void Convert24(ImageData* img);
	void Convert16(ImageData* img);

	bool ReadPNG(char* filename,unsigned short* hist=NULL);	// Specify histogram for dithering
	bool WritePNG(char* filename);
	bool DumpTGA(char* filename);

	void BuildHist();
	bool SavePal(char* filename);
	bool LoadPal(char* filename);
};

#endif
