#ifndef __EXPORT_SKINEXPORT_H__
#define __EXPORT_SKINEXPORT_H__

#include <next.h>
#include <export/export.h>
#include <export/SkinExportOptions.h>
#include <export/ModelExport.h>

class ISkinExporter : public Exporter
{
public:
	virtual bool	GetSkinData( NxObject* pObject, INode* pNode, unsigned long& checksum, INode* pNodeRoot = NULL ) = 0;

	// From Exporter
	virtual	bool		DoExport( ExportType type ) = 0;
	virtual	bool		Save( void ) = 0;	

	virtual bool		SaveGeometry( IoUtils::CVirtualOutputFile &file ) = 0;

	virtual void		SetExportModel(NxModel* model) = 0;
};

ISkinExporter*		GetSkinExporter( void );

#endif // __EXPORT_SKINEXPORT_H__