/*
	AnimPreviewDlg.h
	2-13-03
*/

#ifndef ANIMPREVIEWDLG_H
#define ANIMPREVIEWDLG_H

#include "AnimExporter.h"
#include "../UI/MSWindow.h"
#include "../UI/ProgressBar.h"
#include "../UI/ListView.h"
#include "../UI/PropList.h"
#include "../UI/RichText.h"
#include "../PropEdit/RTFEditor.h"

class AnimPreviewDlg: public MSDlgWindow
{	
	FILE*        fpExport;		// Export file stream
	
	RTFEditor* scriptEdit;		// Script Editor
	ICustEdit* scriptName;		// Script Name
	
	// UI functions
	void AddAnimation( void );
	void Preview( void );
	void RunScript( char* anm_name );
	void Edit( void );
	void Delete( void );
	void FillDirList( void );
	void FillAnimList( void );
	bool AlreadyInList( char* anm_name );

	BOOL DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);
	

public:
	AnimPreviewDlg(HINSTANCE hInstance,HWND hwndParent,Interface* ip, bool bSilentExport = false);
	~AnimPreviewDlg();	
};

#endif
