// MessWin.cpp :
//
// Displays a window containing the passed text.
// Eg, messwin "Could not open file" "Check.exe assertion failed"
// will display a window with the first string in the main body, and the second string in the heading.
//
// Used by qcomp.exe.
// QComp is a console app that normally displays error messages to stderr. It used to be a windows app that
// displayed errors in a window, which was useful for when qcomp was invoked from within slickedit, but Jamie
// wanted it to fprintf to stderr for when it is invoked from within the build batch file.
// So I changed qcomp to be a console app, but it can optionally display error messages in a window by spawning
// messwin.

#include "stdafx.h"
#include "stdlib.h"
#include "conio.h"

void Assert(int Condition, char *pMessage)
{
	if (!Condition)
	{
		MessageBox(NULL,pMessage,"Messwin.exe assertion failed.",MB_OK);
		exit(EXIT_FAILURE);
	}
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	char *pCh=lpCmdLine;
	Assert(*pCh,"MessWin requires two strings to be passed to it,\nE.g.  messwin \"Could not open file\" \"Check.exe error\"");

	Assert(*pCh=='"',"First word must be enclosed in quotes");
	++pCh;
	char *pFirstString=pCh;

	// Skip pCh to the end of the first string.
	while (*pCh && *pCh!='"')
	{
		++pCh;
	}

	Assert(*pCh=='"',"First word must be enclosed in quotes");
	// Terminate it
	*pCh++=0;

	// Skip white space
	while (*pCh && (*pCh==' ' || *pCh=='\t' || *pCh==0x0d || *pCh==0x0a))
	{
		++pCh;
	}

	char *pSecondString="";
	if (*pCh)
	{
		Assert(*pCh=='"',"Second word must be enclosed in quotes");
		++pCh;
		pSecondString=pCh;

		// Skip pCh to the end of the second string.
		while (*pCh && *pCh!='"')
		{
			++pCh;
		}

		Assert(*pCh=='"',"Second word must be enclosed in quotes");
		// Terminate it
		*pCh++=0;
	}

	MessageBox(NULL,pFirstString,pSecondString,MB_OK);
	return 0;
}



