// XBOXDLL.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "windows.h"
#include "XBOXDLL.h"
#include "XBOX\XBOXConv.h"


BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

XBOXDLL_API int XBOXDLL_export( char * filename, char * dict_name, char * col_name, char * dst_scene, int platform, char * usg_name, char * cas_name, char * weightmap_name, bool optimized )
{
	char save_name[256];

			IXBoxConverter* xb_conv;
			xb_conv = GetXBoxConverter();
			xb_conv->EnableOptimization( optimized );
			xb_conv->LoadScene( filename );
			bool has_tex_dict = xb_conv->LoadTextureDictionary( dict_name );

			xb_conv->CollapseCollsionVertices(GENERATE_FIXED_POINT_COLLISION != 0);
			xb_conv->GenerateCollisionBSP();
			
			if (!xb_conv->SaveCollisionData( col_name ))
				return -1;
			
			if (!xb_conv->ConvertData())
				return -2;

			if (!xb_conv->SaveScene( dst_scene ))
				return -3;

			// Only save the texture dictionary if it has one...
			if( has_tex_dict )
			{
				strcpy( save_name, dict_name );

				if( optimized )
				{
					char drive[_MAX_DRIVE];
					char path[_MAX_PATH];
					char name[_MAX_FNAME];
					char ext[_MAX_EXT];

					_splitpath( dict_name, drive, path, name, ext );
					sprintf( save_name, "%s%s%s_net%s", drive, path, name, ext );
				}

				strcat( save_name, "." );
				strcat( save_name, Utils::GetPlatformExt(platform) );
			
				if (!xb_conv->SaveTextureDictionary( save_name, usg_name ))
					return -4;
			}

			xb_conv->SaveCASFlags( cas_name );
			xb_conv->SaveWeightMap( weightmap_name );

			ResetXBoxConverter();	// reset for next use

	return 0;
}

// This is the constructor of a class that has been exported.
// see XBOXDLL.h for the class definition
CXBOXDLL::CXBOXDLL()
{ 
	return; 
}

