// PS2DLL.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "windows.h"
#include "PS2DLL.h"
#include "PS2\PS2Conv.h"

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

PS2DLL_API int PS2DLL_export( char * filename, char * dict_name, char * col_name, char * dst_scene, int platform, char * usg_name, char * cas_name, char * geom_name, char * weight_map_name, bool optimized, bool generate_weight_map )
{
	char save_name[256];

			IPS2Converter* ps2_conv;
			ps2_conv = GetPS2Converter();
			ps2_conv->EnableOptimization( optimized );
			ps2_conv->EnableWeightMapGeneration( generate_weight_map );
			ps2_conv->LoadScene( filename );
			ps2_conv->LoadTextureDictionary( dict_name );
			strcpy( save_name, dict_name );
			if( optimized )
			{
				char drive[_MAX_DRIVE];
				char path[_MAX_PATH];
				char name[_MAX_FNAME];
				char ext[_MAX_EXT];

				_splitpath( dict_name, drive, path, name, ext );
				sprintf( save_name, "%s%s%s_net%s", drive, path, name, ext );
			}
			strcat( save_name, "." );
			strcat( save_name, Utils::GetPlatformExt(platform) );
			ps2_conv->CollapseCollsionVertices(GENERATE_FIXED_POINT_COLLISION != 0);
			ps2_conv->GenerateCollisionBSP();
			
			if (!ps2_conv->SaveCollisionData( col_name ))
				return -1;
			
			if (!ps2_conv->ConvertData())
				return -2;

			if (!ps2_conv->SaveScene( dst_scene ))
				return -3;

			if (!ps2_conv->SaveTextureDictionary( save_name, usg_name ))
				return -4;

			if (!ps2_conv->SaveGeom( save_name, dst_scene, geom_name ))
				return -5;

			ps2_conv->SaveCASFlags( cas_name );

			ps2_conv->SaveWeightMap( weight_map_name );

			ResetPS2Converter();	// reset for next use

	return 0;
}

// This is the constructor of a class that has been exported.
// see PS2DLL.h for the class definition
CPS2DLL::CPS2DLL()
{ 
	return; 
}

