#include <winsock2.h>
#include <stdlib.h>
#include <stdio.h>

#define	vRQ_MESSAGE_ID	34
#define vRQ_SERVER_PORT	10000

enum
{
	vPLAT_PS2,
	vPLAT_XBOX,
	vPLAT_NGC
};

char*	env_vars[] = {"VIEWER_IP", "XBOX_VIEWER_IP", "NGC_VIEWER_IP"};

void	main( int argc, char* argv[] )
{
	int err;
	WORD version_required;
	WSADATA wsa_data;
	SOCKET sock;
	char* server_ip;
	char* skate_path;
	struct	sockaddr_in	server_address;
	unsigned long argp = 1L;	// non-zero enables non-blocking mode
	char msg[1024];
	unsigned short size;
	char filepath[_MAX_PATH];
	char* path_ptr;
	int filename_index;
	int platform;
	bool should_move = false;
	

	if(( argc < 2 ) || ( argc > 4 ))
	{
		printf( "Usage: rq (-p[P,X or G]) [-m]  <path.qb>\n" );
		printf( "Ex: rq -pX runnow.qb\n" );
		printf( "or\n" );
		printf( "Ex: rq -pG -m c:\\skate5\\data\\levels\\default\\default_scripts.qb\n" );
		return;
	}	

	platform = vPLAT_PS2;
	if( argc == 2 )
	{
		filename_index = 1;
	}
	else
	{
		int i;

		for( i = 1; i < argc; i++ )
		{
			if( argv[i][0] == '-' )
			{
				if(( argv[i][1] == 'p' ) || ( argv[i][1] == 'P' ))
				{
					switch( argv[i][2] )
					{
						case 'x':
						case 'X':
							platform = vPLAT_XBOX;
							break;

						case 'g':
						case 'G':
							platform = vPLAT_NGC;
							break;
					};
				}
				else if(( argv[i][1] == 'm' ) || ( argv[i][1] == 'M' ))
				{
					should_move = true;
				}				
			}
			else
			{
				filename_index = i;
			}
		}		
	}

	version_required = MAKEWORD( 1, 1 );
	if( err = WSAStartup ( version_required, &wsa_data ))
	{
		WSACleanup();	
		return;
	}	
	if (	( LOBYTE( wsa_data.wVersion ) != 1 ) ||
			( HIBYTE( wsa_data.wVersion ) != 1 ))
	{
		WSACleanup();	
		return;
	}

	if(( sock = socket( AF_INET, SOCK_DGRAM, IPPROTO_UDP )) == INVALID_SOCKET )
	{
		return;
	}

	argp = 1;
	if( ioctlsocket( sock, FIONBIO, &argp ) == SOCKET_ERROR )
	{
		return;
	}	

	server_ip = getenv( env_vars[platform] );
	if( server_ip == NULL )
	{
		printf( "You must first define the %s environment variable to be that of your PS2's viewer server's IP\n", env_vars[platform] );
		return;
	}

	skate_path = getenv( "PROJ_ROOT" );
	if( skate_path == NULL )
	{
		printf( "You must first define the PROJ_ROOT environment variable to be that of the root of your skate path\n" );
		return;
	}

	if(( path_ptr = strstr( strlwr( argv[filename_index] ), strlwr( skate_path ))))
	{
		path_ptr += strlen( skate_path ) + strlen( "/data/" );		
		// We need to move compiled QB files to the skate5/ndata folder for NGC
		if( should_move )
		{				
			char dst_path[_MAX_PATH];

			sprintf( dst_path, "%s\\ndata\\%s", skate_path, path_ptr );
			CopyFile( argv[filename_index], dst_path, false );
		}		
		
		sprintf( filepath, strlwr( path_ptr ));
		
	}
	else
	{
		sprintf( filepath, strlwr( argv[filename_index] ));
	}	
	
	memset( &server_address, 0, sizeof( struct sockaddr_in ));
	server_address.sin_family = AF_INET;
	server_address.sin_port = htons( vRQ_SERVER_PORT );	
	server_address.sin_addr.S_un.S_addr = inet_addr( server_ip );
	memset ( &server_address.sin_zero, 0, 8 );  	


	connect( sock, (struct sockaddr *) &server_address, sizeof( server_address ));
	
	msg[0] = vRQ_MESSAGE_ID;
	size = strlen( filepath ) + 1;
	if( platform == vPLAT_NGC )
	{
		char* byte_size;
		
		// On the GC we need to reverse the endianness
		byte_size = (char*) &size;
		memcpy( &msg[2], byte_size, sizeof( char ));
		byte_size++;
		memcpy( &msg[1], byte_size, sizeof( char ));
	}
	else
	{
		memcpy( &msg[1], &size, sizeof( unsigned short ));
	}
	sprintf( &msg[3], strlwr( filepath ));
	send( sock, msg, 3 + strlen( filepath ) + 1, 0 );

	closesocket( sock );
	WSACleanup();	
}