#define __CORE_DEFINES_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>

#include "Genlib/Utility.h"
#include "Misc/Util.h"
//#include <stdio.h>
//#include <stdlib.h>
#include <process.h>
//#include <string.h>
//#include <fstream.h>
//
//#include <sys/stat.h>
//
//#include <core/defines.h>
//
#include "Genlib/Utility.h"
#include "Genlib/VirtualFile.h"

#include <assert.h>
#include <windows.h>
#include "Misc/GenCrc.h"
#include "NvDXT/DXTLib.h"
#include "Image.h"



//#include <stdlib.h>
//#include <process.h>
//#include <stdio.h>
//#include <assert.h>
//#include <string.h>
//#include <fstream.h>
//#include <windows.h>
//
//#include <sys/stat.h>
//
//#include <core/defines.h>
//
//#include "Image.h"
//#include "Genlib/Utility.h"
//#include "Genlib/VirtualFile.h"
//#include "Misc/Util.h"
//#include "Misc/GenCrc.h"
//#include "NvDXT/DXTLib.h"

const unsigned int TEXTURE_VERSION = 2;

//int				gDXTFormat;

// these are automatically reset when it's needed,
// so it wouldn't conflict with the batch processing
// of multiple png files
unsigned char*	gpCompressedData		= NULL;
int				gDXTBytesWritten;

#define	GXPackedRGB565(r,g,b)   \
	((unsigned short)((((r)&0xf8)<<8)|(((g)&0xfc)<<3)|(((b)&0xf8)>>3)))

#define	GXPackedRGBA4(r,g,b,a)  \
	((unsigned short)((((r)&0xf0)<<8)|(((g)&0xf0)<<4)|(((b)&0xf0)   )|(((a)&0xf0)>>4)))

#define	GXPackedRGB5A3(r,g,b,a) \
	((unsigned short)((a)>=224 ? \
	((((r)&0xf8)<<7)|(((g)&0xf8)<<2)|(((b)&0xf8)>>3)|(1<<15)): \
	((((r)&0xf0)<<4)|(((g)&0xf0)   )|(((b)&0xf0)>>4)|(((a)&0xe0)<<7))))

void WriteDTXnFile( DWORD count, void *buffer )
{
	// It seems this gets called three times per texture.
	// First with a 4-byte block - ID sanity check perhaps?
	// Second, with a 124-byte block - header information?
	// Third, with a block dependent on the size of the texture - the actual DXT compressed texture information.
	if(( count != 4 ) && ( count != 124 ))
	{
		memcpy( gpCompressedData, buffer, count );
		gpCompressedData	+= count;
		gDXTBytesWritten	+= count;
	}
}

void ReadDTXnFile(DWORD count, void * buffer)
{
}

/*>*******************************(*)*******************************<*/
// switch tuple and byte order within 16-bit words of an s3-packed tile
// to match hw.
// 1) switch 2-bit tuple order within bytes
//    from ( 0,1,2,3 ) to ( 3,2,1,0 ).
// 2) leave byte order within the word as is.
/*>*******************************(*)*******************************<*/
void TCFixCMPWord( unsigned short* data )
{
	unsigned short tmp;


	tmp = *data;

	// reverse tuple order within bytes
	*data = ( (tmp & 0x3 )   << 6 ) |
			( (tmp & 0xC )   << 2 ) |
			( (tmp & 0x30)   >> 2 ) |
			( (tmp & 0xC0)   >> 6 ) |

            ( (tmp & 0x300 ) << 6 ) |
			( (tmp & 0xC00 ) << 2 ) |
			( (tmp & 0x3000) >> 2 ) |
			( (tmp & 0xC000) >> 6 ) ;
}

/*>*******************************(*)*******************************<*/
// reverse the byte order within a block of bytes.
// do this only if TPL_BIG_END is defined
/*>*******************************(*)*******************************<*/ 
void TCFixEndian( unsigned char* src, unsigned int numBytes )
{
	unsigned char  tmp[8];  // large enough to hold a double
	unsigned int max, i;

//    TCAssertMsg( (numBytes <= 8), "TCFixEndian: numBytes > 8\n" );

	if( (numBytes == 0) || (numBytes == 1) )
	{
		return;
	}
					
	max = numBytes - 1;
	for(i=0; i< numBytes; i++)
	{
		tmp[(max - i)] = src[i];	
	}
	
	for(i=0; i< numBytes; i++)
	{
		src[i] = tmp[i];
	}
}

/*>*******************************(*)*******************************<*/ 
// TCPackTile_CMP
//
// pack a 2x2 tile block, each tile of 4x4 texels, into a single 
// 32B dst tile note: this assumes s3 algorithm pads out to a minimum 
// block size of 4x4 texels
/*>*******************************(*)*******************************<*/ 
void TCPackTile_CMP ( char * pData, int width, int height, unsigned int tileX, unsigned int tileY, unsigned short* dstPtr)
{
	unsigned int  x, y;
	unsigned short* srcPtr;
	unsigned short  tmp;
	unsigned int  srcTileOffset;
	unsigned int  subTileRows, subRowShorts;    // number of s3 4x4 tiles
	unsigned int  srcPadWidth, srcPadHeight;
	unsigned short* buffPtr;

	// set the padded size of the s3 source image out to a 4-texel boundary
	srcPadWidth  = ( (width  + 3) >> 2 );
	srcPadHeight = ( (height + 3) >> 2 );

	// number of bytes in a single row of 4x4 texel source tiles
	srcTileOffset = srcPadWidth * 8;

	// number of 4x4 (source) tile rows to copy ( will be 1 or 2 )
	subTileRows = 2;
	if( (srcPadHeight - tileY) < 2 )
		subTileRows = 1;

	// number of 4x4 tile cols to copy translated into number of short values
	// ( will be 4 or 8 )
	subRowShorts = 8;
	if( (srcPadWidth - tileX) < 2 )
		subRowShorts = 4;

	for( y=0; y < subTileRows; y++ )
	{
		srcPtr  = (unsigned short*)( (unsigned char*)(pData) + ((tileY + y) * srcTileOffset) + (tileX*8) ); 
		buffPtr = ( dstPtr + (y * 8) );        // 16 bytes per subRow = 8 shorts

		// process one or both 4x4 row tiles at once- 4 short each
		for( x=0; x < subRowShorts; x++ )
		{			
			switch( x )
			{

			// color table entries - switch bytes within a 16-bit world only
			case 0:	
			case 1:
			case 4:
			case 5:
				tmp = *srcPtr++;
				TCFixEndian( (unsigned char*)(&tmp), 2 );
				*buffPtr++ = tmp;
				break;
			
			// 2-bit color tuples;
			// reverse tuple order within bytes of a word
			case 2:
			case 3:
			case 6:
			case 7:
				tmp = *srcPtr++;
				TCFixCMPWord( &tmp );
				*buffPtr++ = tmp;
				break;

			} // end switch
		} // end for( subRowShorts )			
	} // end for( subTileRows )
}

/*>*******************************(*)*******************************<*/ 
// TCWriteTplImage_CMP
//
/*>*******************************(*)*******************************<*/ 
void FixCompressedTexture ( char * pData, int width, int height, char * pFixed )
{
	unsigned int tileRow, tileCol;
	unsigned int srcTileRows, srcTileCols;
	unsigned short* dstPtr;

	// each source tile is 4x4 texels, 8B
	srcTileRows   = ((height + 3) >> 2);
	srcTileCols   = ((width  + 3) >> 2);

	dstPtr = (unsigned short*)(pFixed);

	// each dst tile is 2x2 source tiles, so move by 2 each iteration
	for(tileRow = 0; tileRow < srcTileRows; tileRow += 2 )
	{
		for(tileCol = 0; tileCol < srcTileCols; tileCol += 2 )
		{
			TCPackTile_CMP( pData, width, height, tileCol, tileRow, dstPtr );
			dstPtr += 16; // 32B per dst tile, short ptr
		}
	}
}

NxTexture::NxTexture( void )
{
	int i;

	for( i = 0; i < vMAX_MIP_LEVELS; i++ )
	{
		m_width[i] = 0;
		m_height[i] = 0;
		m_texel_data[i] = NULL;
	}

	m_bpp = 0;
	m_palette_bpp = 0;
	m_pixel_format = v32_BIT;
	m_palette_format = v32_BIT;	
	m_palette_data = NULL;
	sprintf( m_name, "None" );
	//m_map = NULL;	
	m_mip_levels = 0;
	m_flags = 0;
	//m_transparent_color.r = 0.0f;
	//m_transparent_color.g = 0.0f;
	//m_transparent_color.b = 0.0f;
	m_valid = true;
}

NxTexture::~NxTexture( void )
{
	int i;

	for( i = 0; i < vMAX_MIP_LEVELS; i++ )
	{
		if( m_texel_data[i] )
		{			
			delete [] m_texel_data[i];
		}
	}

	if( m_palette_data )
	{
		delete [] m_palette_data;
	}
}

bool NxTexture::ShouldAutoGenerateMipMaps( void )
{
	return (( m_flags & mAUTO_GENERATE_MIPMAPS ) != 0 );
}

void NxTexture::SetNumMipLevels( int num_mip_levels )
{
	m_mip_levels = num_mip_levels;
}

int	NxTexture::GetNumMipLevels( void )
{
	return m_mip_levels;
}

int	NxTexture::GetPixelFormat( void )
{
	return m_pixel_format;
}

int	NxTexture::GetPaletteFormat( void )
{
	return m_palette_format;
}

char* NxTexture::GetTexelData( int mip_level )
{
	return m_texel_data[mip_level];
}

char* NxTexture::GetPaletteData( void )
{
	return m_palette_data;
}

char*	NxTexture::GetName( void )
{
	return m_name;
}

int	NxTexture::GetWidth( int mip_level )
{
	return m_width[mip_level];
}

int NxTexture::GetHeight( int mip_level )
{
	return m_height[mip_level];
}

void NxTexture::SetWidth( int mip_level, int width )
{
	m_width[mip_level] = width;
}
	
void NxTexture::SetHeight( int mip_level, int height )
{
	m_height[mip_level] = height;
}

bool NxTexture::IsPaletted( void )
{
	return (( m_pixel_format == v8_BIT ) || ( m_pixel_format == v4_BIT ));
}

int NxTexture::GetBpp( void )
{
	return m_bpp;
}

int NxTexture::GetPaletteBpp( void )
{
	return m_palette_bpp;
}

int NxTexture::GetNumPaletteEntries( void )
{
	return m_num_palette_entries;
}

int	NxTexture::GetTexelDataSize( int mip_level )
{
	int bits_of_texel_data;

	bits_of_texel_data = GetBpp() * GetWidth( mip_level) * GetHeight( mip_level );
	assert(( bits_of_texel_data % 8 ) == 0 );

	return bits_of_texel_data >> 3;
}

int NxTexture::GetPaletteDataSize( void )
{
	int bits_of_palette_data;

	bits_of_palette_data = GetPaletteBpp() * m_num_palette_entries;
	assert(( bits_of_palette_data % 8 ) == 0 );

	return bits_of_palette_data >> 3;
}

bool NxTexture::LoadImage2( char* path )
{
	char ext[_MAX_EXT];
	int i;

	assert( path );
	if( FileExists( path ) == false )
	{
		return false;
	}

	strcpy( m_name, path );
	_splitpath( path, NULL, NULL, NULL, ext );
	if( stricmp( ext, ".png" ) == 0 )
	{
		if( m_mip_levels == 0 )
		{
			if( load_png( path, 0 ) == false )
			{
				return false;
			}				
		}
		else
		{
			char palette_path[_MAX_PATH];
			char ult_mip_path[_MAX_PATH];
			char temp_mip_path[_MAX_PATH];
			char mip_path[_MAX_PATH];
			char drive[_MAX_DRIVE];
			char cur_path[_MAX_PATH];
			char cur_file[_MAX_FNAME];			
			int width, height;
						
			_splitpath( path, drive, cur_path, cur_file, NULL );
			sprintf( ult_mip_path, "%s%s\\mips", drive, cur_path );
			CreateDirectory( ult_mip_path, NULL );
			
			if( ShouldAutoGenerateMipMaps())
			{
				sprintf( mip_path, "c:/temp/%s_m0%s", cur_file, ext );
				// Copy the highest level of detail to the mips directory
				if( FileIsNewer( mip_path, path ))
				{
					CopyFile( path, mip_path, false );
				}			
			}
			else
			{
				sprintf( mip_path, "%s\\%s_m0%s", ult_mip_path, cur_file, ext );
				// Copy the highest level of detail to the mips directory
				if( !FileExists( mip_path ))
				{
					return false;
				}			
			}
			width = m_width[0];
			height = m_height[0];
			for( i = 1; i <= m_mip_levels; i++ )
			{	
				width >>= 1;
				height >>= 1;

				if(	( width < 8 ) ||
					( height < 8 ))
				{
					m_mip_levels = i;
					break;
				}
				sprintf( ult_mip_path, "%s%s\\mips\\%s_m%d%s", drive, cur_path, cur_file, i, ext );
				sprintf( temp_mip_path, "c:/temp/%s_m%d%s", cur_file, i, ext );
				
				// First generate the mips, if they need to be generated
				if( ShouldAutoGenerateMipMaps())
				{
					// Only generate it if it's actually newer
					if( FileIsNewer( ult_mip_path, path ))
					{
						int result;
						char *args[11];
						char width_str[32], height_str[32];													
						
						sprintf( width_str, "%d", width );
						sprintf( height_str, "%d", height );
						args[0] = "alchlong.exe";
						args[1] = "---n";
						args[2] = "-I";
						args[3] = "-o";
						args[4] = "-X";
						args[5] = width_str;
						args[6] = "-Y";
						args[7] = height_str;
						args[8] = path;
						args[9] = temp_mip_path;
						args[10] = NULL;

						result = ( spawnvp( _P_WAIT, args[0], args ) == 0 );				
					}
				}
				else
				{
					char ultimate_path[_MAX_PATH];

					sprintf( ultimate_path, "%s%s\\mips\\%s_m%d%s", drive, cur_path, cur_file, i, ext );

					if( !FileExists( ult_mip_path ))
					{
						return false;
					}
				}				
			}

			if( ShouldAutoGenerateMipMaps())
			{
				sprintf( palette_path, "%s%s\\mips\\%s.pal", drive, cur_path, cur_file );			
				// Only generate palette and re-palettize if palette is out of date
				if( FileIsNewer( palette_path, path ))
				{
					int result;
					char* first_args[7];
					char* second_args[10];
					char mip_wildcard[_MAX_PATH];
					char dest_dir[_MAX_PATH];

					// Create a generic palette for all the mips
					sprintf( mip_wildcard, "c:\\temp\\%s_m*%s", cur_file, ext );
					first_args[0] = "alchlong.exe";
					first_args[1] = "-o";
					first_args[2] = "--";
					first_args[3] = mip_wildcard;				
					first_args[4] = "-L";
					first_args[5] = palette_path;				
					first_args[6] = NULL;

					result = ( spawnvp( _P_WAIT, first_args[0], first_args ) == 0 );				

					// Now apply the created palette
					sprintf( dest_dir, "%s%s\\mips\\", drive, cur_path );
					second_args[0] = "alchlong.exe";
					second_args[1] = "-o";
					second_args[2] = "---n";
					second_args[3] = "-I";
					second_args[4] = "--";
					second_args[5] = mip_wildcard;
					second_args[6] = "-f";
					second_args[7] = palette_path;
					second_args[8] = dest_dir;
					second_args[9] = NULL;

					result = ( spawnvp( _P_WAIT, second_args[0], second_args ) == 0 );
				}
			}

			// Now load each mip level
			for( i = 0; i <= m_mip_levels; i++ )
			{
				sprintf( mip_path, "%s%s\\mips\\%s_m%d%s", drive, cur_path, cur_file, i, ext );
				if( load_png( mip_path, i ) == false )
				{
					return false;
				}				
			}
		}
		return true;
	}

	return false;
}

bool	NxTexture::ShouldCompressComponents( void )
{
	return (( m_flags & mFORCE_BYTE_PER_COMPONENT ) == 0 );
}

bool	NxTexture::ShouldChangeTransparentColor( void )
{
	return (( m_flags & mCHANGE_FULLY_TRANSPARENT_COLOR ) != 0 );
}

void	NxTexture::SetFlags( int flags )
{
	m_flags |= flags;
}

int		NxTexture::GetFlags( void )
{
	return m_flags;
}

unsigned long	NxTexture::GetChecksum( void )
{
	return m_checksum;
}

bool	NxTexture::operator==( NxTexture& texture )
{
	return( m_checksum == texture.GetChecksum());
}

int	NxTexture::GetTotalDataSize( void )
{
	int i;
	int total_size;

	total_size = GetPaletteDataSize();
	for( i = 0; i <= GetNumMipLevels(); i++ )
	{
		total_size += GetTexelDataSize( i );
	}

	return total_size;
}

void	NxTexture::SetValidity( bool valid )
{
	m_valid = valid;
}

bool	NxTexture::IsValid( void )
{
	return m_valid;
}

#define	vADC_ON		0
#define	vADC_OFF	0x00008000

#define vPSMCT32	0
#define vPSMCT24	1
#define vPSMCT16	2
#define vPSMT8		19
#define vPSMT4		20

bool NxTexture::Convert4BitPixelFormatTo8BitPixelFormat( void )
{
	if( !IsPaletted() || ( m_pixel_format != v4_BIT ))
	{
		return false;
	}

	for( int i = 0; i <= m_mip_levels; ++i )
	{
		unsigned int	texel_index			= 0;
		unsigned char*	p_8bit_texel_data	= new unsigned char[m_width[i] * m_height[i]];

		int texel_data_size = ( m_width[i] * m_height[i] ) / 2;
		for( int p = 0; p < texel_data_size; ++p )
		{
			// Read indices.
			unsigned int index0 = ((unsigned char)m_texel_data[i][p] >> 0 ) & 0xF;
			unsigned int index1 = ((unsigned char)m_texel_data[i][p] >> 4 ) & 0xF;

			p_8bit_texel_data[texel_index++] = index0;
			p_8bit_texel_data[texel_index++] = index1;
		}

		delete [] m_texel_data[i];

		m_texel_data[i]			= (char*)p_8bit_texel_data;
	}
			
	// Change the format.
	m_pixel_format	= v8_BIT;
	m_bpp			= 8;
	return true;
}



bool NxTexture::Convert16BitPaletteFormatTo32BitPaletteFormat( void )
{
	if( !IsPaletted() || ( m_palette_format != v16_BIT ))
	{
		return false;
	}

	unsigned int*	p_32bit_palette_data	= new unsigned int[m_num_palette_entries];

	for( int p = 0; p < m_num_palette_entries; ++p )
	{
		unsigned int entry	= ((unsigned short*)m_palette_data )[p];
		entry				= (( entry & 0x1F ) << 3 ) | ((( entry >> 5 ) & 0x1F ) << 11 ) | ((( entry >> 10 ) & 0x1F ) << 19 ) | (( entry & 0x8000 ) ? 0xFF000000 : 0x00 );

		p_32bit_palette_data[p] = entry;
	}

	delete [] m_palette_data;

	m_palette_data		= (char*)p_32bit_palette_data;
	m_palette_format	= v32_BIT;
	m_palette_bpp		= 32;

	return true;
}



bool NxTexture::Convert24BitPaletteFormatTo32BitPaletteFormat( void )
{
	if( !IsPaletted() || ( m_palette_format != v24_BIT ))
	{
		return false;
	}

	unsigned int	*p_32bit_palette_data	= new unsigned int[this->m_num_palette_entries];
	unsigned char	*p_24bit_palette_data	= (unsigned char*)m_palette_data;
	for( int p = 0; p < this->m_num_palette_entries; ++p )
	{
		unsigned int red	= *p_24bit_palette_data++;
		unsigned int grn	= *p_24bit_palette_data++;
		unsigned int blu	= *p_24bit_palette_data++;
		unsigned int entry	= red | ( grn << 8 ) | ( blu << 16 ) | 0xFF000000;

		p_32bit_palette_data[p] = entry;
	}

	delete [] m_palette_data;

	m_palette_data		= (char*)p_32bit_palette_data;
	m_palette_format	= v32_BIT;
	m_palette_bpp		= 32;

	return true;
}





bool NxTexture::Convert32BitRGBAPaletteFormatTo32BitBGRAPaletteFormat( void )
{
	if( !IsPaletted() || ( m_palette_format != v32_BIT ))
	{
		return false;
	}

	unsigned int *p_32bit_palette_data	= (unsigned int*)m_palette_data;
	for( int p = 0; p < this->m_num_palette_entries; ++p )
	{
		unsigned int old		= *p_32bit_palette_data;
		unsigned int red		= old & 0xFF;
		unsigned int grn		= ( old >> 8 ) & 0xFF;
		unsigned int blu		= ( old >> 16 ) & 0xFF;
		unsigned int alp		= ( old >> 24 ) & 0xFF;
		*p_32bit_palette_data++	= blu | ( grn << 8 ) | ( red << 16 ) | ( alp << 24 );
	}

	return true;
}



bool NxTexture::ConvertTo32BitPixelFormat( void )
{
	// Currently only supports 16 and 32 bit palettes (if a palette is present).
	if( IsPaletted() && ( m_palette_format != v32_BIT ) && ( m_palette_format != v24_BIT ) && ( m_palette_format != v16_BIT ))
	{
		return false;
	}

	switch( m_pixel_format )
	{
		case v4_BIT:
		{
			// Just convert to 8 bit pixel format, and fall through to next case.
			if( !Convert4BitPixelFormatTo8BitPixelFormat())
			{
				return false;
			}
		}
	
		case v8_BIT:
		{
			// Convert to 32 bit palette if not already.
			if( m_palette_format == v16_BIT )
			{
				if( !Convert16BitPaletteFormatTo32BitPaletteFormat())
				{
					return false;
				}
			}

			if( m_palette_format == v24_BIT )
			{
				if( !Convert24BitPaletteFormatTo32BitPaletteFormat())
				{
					return false;
				}
			}

			for( int i = 0; i <= this->m_mip_levels; ++i )
			{
				unsigned int	texel_index			= 0;
				unsigned int*	p_32bit_texel_data	= new unsigned int[m_width[i] * m_height[i]];

				int texel_data_size = m_width[i] * m_height[i];
				
				unsigned char*	p_texel_data	= (unsigned char*)m_texel_data[i];
				for( int p = 0; p < texel_data_size; ++p )
				{
					// Read indices.
					unsigned int entry;
					unsigned int index0					= *p_texel_data++;

					// Must be in 32 bit palette format at this stage.
					entry								= ((unsigned int*)m_palette_data )[index0];
					p_32bit_texel_data[texel_index++]	= entry;
				}

				delete [] m_texel_data[i];

				m_texel_data[i]			= (char*)p_32bit_texel_data;
			}
			
			// Now we can free up the palette data...
			delete [] m_palette_data;
			m_palette_data = NULL;

			// ...and change format..
			m_pixel_format	= v32_BIT;
			m_bpp			= 32;
			return true;
		}

		case v24_BIT:
		{
			for( int i = 0; i <= m_mip_levels; ++i )
			{
				unsigned int*	p_32bit_texel_data	= new unsigned int[m_width[i] * m_height[i]];
				unsigned char*	p_24bit_texel_data	= (unsigned char*)m_texel_data[i];

				for( int p = 0; p < ( m_width[i] * m_height[i] ); ++p )
				{
					// Read indices.
					unsigned int red		= *p_24bit_texel_data++;
					unsigned int grn		= *p_24bit_texel_data++;
					unsigned int blu		= *p_24bit_texel_data++;
					p_32bit_texel_data[p]	= red | ( grn << 8 ) | ( blu << 16 ) | 0xFF000000UL;
				}

				delete [] m_texel_data[i];

				m_texel_data[i]			= (char*)p_32bit_texel_data;
			}

			// Change the format.
			m_pixel_format	= v32_BIT;
			m_bpp			= 32;
			return true;
		}

		default:
		{
			break;
		}
	}

	// Cannot convert.
	return false;
}





bool NxTexture::Convert32BitRGBAPixelFormatTo32BitBGRAPixelFormat( void )
{
	if( m_pixel_format != v32_BIT )
	{
		return false;
	}

	for( int i = 0; i <= m_mip_levels; ++i )
	{
		unsigned int *p_32bit_texel_data	= (unsigned int*)m_texel_data[i];
		for( int p = 0; p < ( m_width[i] * m_height[i] ); ++p )
		{
			unsigned int old		= *p_32bit_texel_data;

			// Note - there appears to be an issue where zero-alpha pixels have their color set to 0x00FFFFFF.
			// Try setting to 0x0000000 in this case...
			if( old == 0x00FFFFFFUL )
				old = 0x00000000UL;
			
			unsigned int red		= old & 0xFF;
			unsigned int grn		= ( old >> 8 ) & 0xFF;
			unsigned int blu		= ( old >> 16 ) & 0xFF;
			unsigned int alp		= ( old >> 24 ) & 0xFF;
			*p_32bit_texel_data++	= blu | ( grn << 8 ) | ( red << 16 ) | ( alp << 24 );
		}
	}

	return true;
}




bool NxTexture::SwizzleTextureForXbox( void )
{
	if( !IsPowerOfTwo( m_width[0] ) || !IsPowerOfTwo( m_height[0] ))
	{
		// Is not be power of 2 aligned - do not swizzle.
		return false;
	}
	
	switch( m_pixel_format )
	{
		case NxTexture::v32_BIT:
		{
			unsigned int *p_swizzle_texel_data		= new unsigned int[m_width[0] * m_height[0] + 16];
			unsigned int *p_swizzle_texel_data_a16	= (unsigned int *)(((unsigned int)p_swizzle_texel_data + 15 ) & ~0x0F );

			SwizzleTexture( p_swizzle_texel_data_a16, m_texel_data[0], m_width[0], m_height[0], 32, m_width[0] );
			memcpy( m_texel_data[0], p_swizzle_texel_data_a16, m_width[0] * m_height[0] * 4 );
			delete [] p_swizzle_texel_data;
			break;
		}
		case NxTexture::v16_BIT:
		{
			unsigned short *p_swizzle_texel_data		= new unsigned short[m_width[0] * m_height[0] + 16];
			unsigned short *p_swizzle_texel_data_a16	= (unsigned short *)(((unsigned int)p_swizzle_texel_data + 15 ) & ~0x0F );

			SwizzleTexture( p_swizzle_texel_data_a16, m_texel_data[0], m_width[0], m_height[0], 16, m_width[0] );
			memcpy( m_texel_data[0], p_swizzle_texel_data_a16, m_width[0] * m_height[0] * 2 );
			delete [] p_swizzle_texel_data;
			break;
		}
		case NxTexture::v8_BIT:
		{
			unsigned char *p_swizzle_texel_data		= new unsigned char[m_width[0] * m_height[0] + 16];
			unsigned char *p_swizzle_texel_data_a16	= (unsigned char *)(((unsigned int)p_swizzle_texel_data + 15 ) & ~0x0F );

			SwizzleTexture( p_swizzle_texel_data_a16, m_texel_data[0], m_width[0], m_height[0], 8, m_width[0] );
			memcpy( m_texel_data[0], p_swizzle_texel_data_a16, m_width[0] * m_height[0] * 1 );
			delete [] p_swizzle_texel_data;
			break;
		}
		default:
		{
			exit( 666 );
		}
	}
	return true;
}



bool NxTexture::SaveTextureForXbox( char *path )
{
	static char	m_tex_buff[1024 * 1024 * 4];

	fstream file( path, ios::out | ios::binary );

	streampos cur_pos;
	int j;
	
	int final_bpp, final_palette_bpp, max_level;
	unsigned long checksum;

	file.write((const char*) &TEXTURE_VERSION, sizeof( unsigned int ));
				
	checksum = m_checksum;
	file.write((const char*) &checksum, sizeof( unsigned long ));

	if( 1 /*m_checksum != vINVALID_CHECKSUM*/ )
	{
		unsigned short orig_width, orig_height;
		int pixel_mode, clut_mode;								
		
		// Width and height.
		file.write((const char*)&m_width[0], sizeof( int ));
		file.write((const char*)&m_height[0], sizeof( int ));

		switch( m_pixel_format )
		{
			case NxTexture::v32_BIT:
			{
				Convert32BitRGBAPixelFormatTo32BitBGRAPixelFormat();
				pixel_mode = vPSMCT32;
				final_bpp = 32;
				final_palette_bpp = 0;
				break;
			}
			case NxTexture::v24_BIT:
			{
				ConvertTo32BitPixelFormat();
				Convert32BitRGBAPixelFormatTo32BitBGRAPixelFormat();
				pixel_mode = vPSMCT32;
				final_bpp = 32;
				final_palette_bpp = 0;
				break;
			}
			case NxTexture::v16_BIT:
			{
				pixel_mode = vPSMCT16;
				final_bpp = 16;
				final_palette_bpp = 0;
				break;
			}
			case NxTexture::v8_BIT:
			{
				pixel_mode = vPSMT8;
				final_bpp = 8;						
				break;
			}
			case NxTexture::v4_BIT:
			{
				// Convert to 8 bit.
				Convert4BitPixelFormatTo8BitPixelFormat();
				pixel_mode = vPSMT8;
				final_bpp = 8;						
				break;
			}
			default:
				return false;
		}

		if( IsPaletted())
		{
			switch( m_palette_format )
			{
				case NxTexture::v32_BIT:
				{
					clut_mode = vPSMCT32; 
					final_palette_bpp = 32;
					break;
				}
				case NxTexture::v24_BIT:
				{
					// Convert to 32 bit palette.
					Convert24BitPaletteFormatTo32BitPaletteFormat();
					clut_mode = vPSMCT32; 
					final_palette_bpp = 32;
					break;
				}
				case NxTexture::v16_BIT:
				{
					// Convert to 32 bit palette.
					Convert16BitPaletteFormatTo32BitPaletteFormat();
					clut_mode = vPSMCT32; 
					final_palette_bpp = 32;
					break;
				}
				default:
					return false;
			}

			Convert32BitRGBAPaletteFormatTo32BitBGRAPaletteFormat();
		}

		// Swizzle the texture.
		SwizzleTextureForXbox();
		
		// Get the max mip level
		max_level = m_mip_levels;

		// Get the original size
		orig_width = m_orig_width[0];
		orig_height = m_orig_height[0];
			
		// Write out pixel/clut storage modes
		file.write((const char*) &pixel_mode, sizeof( int ));
		file.write((const char*) &clut_mode, sizeof( int ));			
		//file.write((const char*) &max_level, sizeof( int ));
		file.write((const char*) &orig_width, sizeof( short ));
		file.write((const char*) &orig_height, sizeof( short ));

		// Write out palette data size.
		int palette_data_size = GetPaletteDataSize();
		file.write((const char*)&palette_data_size, sizeof( int ));
		
		if( IsPaletted())
		{
			// 16-byte align palette data
			cur_pos = file.tellp();
			if( cur_pos % 16 )
			{
				file.seekp( 16 - ( cur_pos % 16 ), ios::cur );
			}				

			if( m_palette_format == NxTexture::v32_BIT )
			{
				file.write((const char*) m_palette_data, GetPaletteDataSize() );
			}
			else
			{
				// Only 32 bit palette format supported on Xbox.
				exit( 666 );
			}
		}

		for( j = 0; j <= m_mip_levels; j++ )
		{
			// 16-byte align texture data
			cur_pos = file.tellp();
			if( cur_pos % 16 )
			{
				file.seekp( 16 - ( cur_pos % 16 ), ios::cur );
			}				
				
			// 24-bits will be converted to 16bit for PS2 unless overridden by user
			if(( m_pixel_format == NxTexture::v24_BIT ) || ( m_pixel_format == NxTexture::v4_BIT ))
			{
				exit( 666 );
			}
			else
			{
				// Write out the texel data
				file.write((const char*) m_texel_data[j], GetTexelDataSize(j) );
			}					
		}
	}

	file.close();

	return true;
}

bool NxTexture::SaveTextureForNGPS( char *path )
{
	bool success = false;

	//printf("Opening file '%s'\n", path);
	static char	m_tex_buff[1024 * 1024 * 4];

	IoUtils::CVirtualOutputFile theOutputFile;

	// 10-meg buffer
	theOutputFile.Init(6*1024*1024);

	int j, k;
	
	int final_bpp, final_palette_bpp, max_level;
	unsigned long checksum;

	theOutputFile.Write((const char*) &TEXTURE_VERSION, sizeof( unsigned int ));
				
	checksum = m_checksum;
	theOutputFile.Write((const char*) &checksum, sizeof( unsigned long ));
	if( 1 /*m_checksum != vINVALID_CHECKSUM*/ )
	{
		int log_width, log_height;
		unsigned short orig_width, orig_height;
		int pixel_mode, clut_mode;								
		
		log_width = GetLog2( m_width[0] );
		log_height = GetLog2( m_height[0] );
		theOutputFile.Write((const char*) &log_width, sizeof( int ));
		theOutputFile.Write((const char*) &log_height, sizeof( int ));

		switch( m_pixel_format )
		{
			case NxTexture::v32_BIT:
				pixel_mode = vPSMCT32;
				final_bpp = 32;
				final_palette_bpp = 0;
				break;
			case NxTexture::v24_BIT:
				if( m_flags & NxTexture::mFORCE_BYTE_PER_COMPONENT )
				{
					pixel_mode = vPSMCT24;
					final_bpp = 24;
					final_palette_bpp = 0;						
				}
				else
				{
					pixel_mode = vPSMCT16;
					final_bpp = 16;
					final_palette_bpp = 0;
				}
				break;
			case NxTexture::v16_BIT:
				pixel_mode = vPSMCT16;
				final_bpp = 16;
				final_palette_bpp = 0;
				break;
			case NxTexture::v8_BIT:
				pixel_mode = vPSMT8;
				final_bpp = 8;						
				break;
			case NxTexture::v4_BIT:
				pixel_mode = vPSMT4;
				final_bpp = 4;
				break;
			default:
				goto save_error;
		}

		switch( m_palette_format )
		{
			case NxTexture::v32_BIT:
				clut_mode = vPSMCT32; 
				final_palette_bpp = 32;
				break;
			case NxTexture::v16_BIT:
				clut_mode = vPSMCT16;
				final_palette_bpp = 16;
				break;
			case NxTexture::v24_BIT:
				if( m_flags & NxTexture::mFORCE_BYTE_PER_COMPONENT )
				{
					clut_mode = vPSMCT32; 
					final_palette_bpp = 32;
				}
				else
				{
					clut_mode = vPSMCT16;
					final_palette_bpp = 16;						
				}
				break;
			default:
				goto save_error;
		}			

		// Get the max mip level
		max_level = m_mip_levels;

		// Get the original size
		orig_width = m_orig_width[0];
		orig_height = m_orig_height[0];
			
		// Write out pixel/clut storage modes
		theOutputFile.Write((const char*) &pixel_mode, sizeof( int ));
		theOutputFile.Write((const char*) &clut_mode, sizeof( int ));			
		theOutputFile.Write((const char*) &max_level, sizeof( int ));
		theOutputFile.Write((const char*) &orig_width, sizeof( short ));
		theOutputFile.Write((const char*) &orig_height, sizeof( short ));

		if( IsPaletted())
		{
			// 16-byte align palette data
			theOutputFile.Align( 16 );

			if( m_palette_format == NxTexture::v32_BIT )
			{
				// PS2's alpha range goes from 0 (fully-transparent) to 128 (fully-opaque)
				// so scale down the standard 0-255 range here
				for( int m = 0; m < GetPaletteDataSize(); m += 4 )
				{
					unsigned int cur_alpha;
					cur_alpha = (unsigned char) m_palette_data[m + 3];
					m_palette_data[m + 3] = ((cur_alpha * 128) / 255);
				}
				theOutputFile.Write((const char*) m_palette_data, GetPaletteDataSize() );
			}
			else
			{
				int size;

				if( m_flags & NxTexture::mFORCE_BYTE_PER_COMPONENT )
				{
					
					int num_entries;
					unsigned char* src;
					unsigned char* dst;

					// Right now these are the only two we expect
					assert( m_palette_format == NxTexture::v24_BIT );

					// Convert 24-bit palette to 32-bit palette						
					src = (unsigned char*) m_palette_data;
					dst = (unsigned char*) m_tex_buff;
					num_entries = m_num_palette_entries;
					for( j = 0; j < num_entries; j++ )
					{
						*dst++ = *src++;
						*dst++ = *src++;
						*dst++ = *src++;
						*dst++ = 128;	// fully opaque
					}

					size = (int) dst - (int) m_tex_buff;
				}
				else
				{
					int num_entries;
					unsigned char* src;
					unsigned short* dst;

					// Right now these are the only two we expect
					assert( m_palette_format == NxTexture::v24_BIT );

					// Convert 24-bit palette to 16-bit palette						
					src = (unsigned char*) m_palette_data;
					dst = (unsigned short*) m_tex_buff;
					num_entries = m_num_palette_entries;
					for( j = 0; j < num_entries; j++ )
					{
						unsigned char red, blue, green;
						unsigned short color;

						red = ( *src++ ) >> 3;
						green = ( *src++ ) >> 3;
						blue = ( *src++ ) >> 3;
							
						color = 0x8000 | red | ( green << 5 ) | ( blue << 10 );
						*dst++ = color;						
					}

					size = (int) dst - (int) m_tex_buff;
				}

				// Write out the texel data
				theOutputFile.Write((const char*) m_tex_buff, size );
			}
		}

		for( j = 0; j <= m_mip_levels; j++ )
		{
			// 16-byte align texture data
			theOutputFile.Align( 16 );
				
			// 24-bits will be converted to 16bit for PS2 unless overridden by user
			if(	( m_pixel_format == NxTexture::v24_BIT ) &&
				( !( m_flags & NxTexture::mFORCE_BYTE_PER_COMPONENT )))
			{
				unsigned char* src;
				unsigned short* dst;
				int num_pixels;

				src = (unsigned char*) m_texel_data[j];
				dst = (unsigned short*) m_tex_buff;
				num_pixels = m_height[j] * m_width[j];
				for( k = 0; k < num_pixels; k++ )
				{
					unsigned char red, blue, green;
					unsigned short color;

					red = ( *src++ ) >> 3;
					green = ( *src++ ) >> 3;
					blue = ( *src++ ) >> 3;
						
					color = red | ( green << 5 ) | ( blue << 10 );
					*dst++ = color;						
				}				

				// Write out the texel data
				theOutputFile.Write((const char*) m_tex_buff, (int) dst - (int) m_tex_buff );
			}
			else if( m_pixel_format == NxTexture::v32_BIT )
			{
				// PS2's alpha range goes from 0 (fully-transparent) to 128 (fully-opaque)
				// so scale down the standard 0-255 range here
				for( int m = 0; m < GetTexelDataSize(j); m += 4 )
				{
					unsigned int cur_alpha;
					cur_alpha = (unsigned char) m_texel_data[j][m + 3];
					m_texel_data[j][m + 3] = ((cur_alpha * 128) / 255);
				}

				// Write out the texel data
				theOutputFile.Write((const char*) m_texel_data[j], GetTexelDataSize(j) );
			}
			else
			{
				// Write out the texel data
				theOutputFile.Write((const char*) m_texel_data[j], GetTexelDataSize(j) );
			}					
		}
	}

	// break the lock, if necessary
	SetFileAttributes( path, FILE_ATTRIBUTE_NORMAL );
	if ( !theOutputFile.Save( path ) )
	{
		goto save_error;
	}

	success = true;

save_error:

	return success;
}

bool NxTexture::writeNGC( fstream * p_file, unsigned int * p_image, int width, int height )
{
	int lp, lp2, lp3;
	bool rv = false;

	// Convert to BGRA
	unsigned int *p_rgba = p_image;
	unsigned int *p_bgra = new unsigned int[(width * height)];
	for( int p = 0; p < ( width * height ); ++p )
	{
		unsigned int old		= p_rgba[p];
		unsigned int red		= old & 0xFF;
		unsigned int grn		= ( old >> 8 ) & 0xFF;
		unsigned int blu		= ( old >> 16 ) & 0xFF;
		unsigned int alp		= ( old >> 24 ) & 0xFF;
		p_bgra[p]	= blu | ( grn << 8 ) | ( red << 16 ) | ( alp << 24 );
	}

	// Set alpha to 0 or 255.
	for ( lp = 0; lp < ( width * height ); lp++ )
	{
		int alpha = ( ( p_bgra[lp] >> 24 ) & 255 );
		if ( alpha > 0 )
		{
			p_bgra[lp] = ( p_bgra[lp] & 0x00ffffff ) | 0xff000000;
		}
		else
		{
			p_bgra[lp] = ( p_bgra[lp] & 0x00ffffff );
		}
	}

	// Grab another buffer to hold the DXT compressed version of the texture.
	unsigned int *pPixelData32	= new unsigned int[(width * height)];
	gpCompressedData			= (unsigned char*)pPixelData32;

	CompressionOptions compression_options;
	compression_options.bBinaryAlpha			= 1;								// Zero or one.
	compression_options.bMipMapsInImage			= false;							// mip have been loaded in during read
	compression_options.MipMapType				= dNoMipMaps;						// dNoMipMaps, dUseExistingMipMaps, dGenerateMipMaps
	compression_options.bNormalMap				= false;							// only renormalize MIP maps
	compression_options.bDuDvMap				= false;							// Is a DuDv map
	compression_options.bAlphaBorder			= false;							// make an alpha border
	compression_options.bBorder					= false;							// make a color border
	compression_options.bFade					= false;							// fade to color over MIP maps
	compression_options.bFadeAlpha				= false;							// fade to color over MIP maps
	compression_options.bDitherColor			= true;								// enable dithering during 16 bit conversion
	compression_options.TextureType				= dTextureType2D;					// regular decal, cube or volume: dTextureType2D, dTextureTypeCube, dTextureTypeImage
	compression_options.TextureFormat			= dDXT1a;	// dDXT1, dDXT1a, dDXT3, dDXT5, d4444, d1555, d565, d8888, d888, d555
	compression_options.bSwapRGB				= false;
			
	gDXTBytesWritten = 0;
	
	HRESULT hr = nvDXTcompress( (unsigned char*)( p_bgra ),							// pointer to data (24 or 32 bit)
								width,												// width in texels
								height,												// height in texels
								width * 4,											// pitch
								&compression_options,
								4,													// depth: 3 or 4
								NULL );												// callback for generated levels

	// This is to make loading screens uncompressed.
	if ( ( width >= 640 ) && ( height >= 448 ) )
	{
		hr = true;
	}

	if ( !hr )
	{
		// Write out compressed data.
		int compressed_size = gDXTBytesWritten;
		char * pFixed = (char *)malloc( compressed_size * 2);
		FixCompressedTexture ( (char *)pPixelData32, width, height, pFixed );
		free( pPixelData32 );

		p_file->write((const char*)pFixed, compressed_size );

		free( pFixed );
		rv = true;
	}
	else
	{
		// Couldn't compress, just use 32-bit
		unsigned short * p16 = (unsigned short *)malloc ( width * height * 4 );
		unsigned int * p32 = p_image;
		// Reorder in blocks.
		for ( lp = 0; lp < height; lp += 4 )
		{
			int xx = lp * width;
			for ( lp2 = 0; lp2 < width; lp2 += 4 )
			{
				for ( lp3 = 0; lp3 < 16; lp3++ )
				{
					p16[lp3+(lp2*8)+(xx*2)] =		( ( p32[(lp3&3)+(width*(lp3>>2))+lp2+xx] << 8  ) & 0x0000ff00 ) |
													( ( p32[(lp3&3)+(width*(lp3>>2))+lp2+xx] >> 24 ) & 0x000000ff );

					p16[16+lp3+(lp2*8)+(xx*2)] =	( ( p32[(lp3&3)+(width*(lp3>>2))+lp2+xx] >> 8  ) & 0x0000ff00 ) |
													( ( p32[(lp3&3)+(width*(lp3>>2))+lp2+xx] >> 8  ) & 0x000000ff );
				}
			}
		}

		// Write out the texel data
		p_file->write((const char*)p16, width * height * 4 );

		free( p16 );
		rv = false;
	}
	return rv;		// true = compressed, false = uncompressed.
}

bool NxTexture::SaveTextureForNGC( char *path, bool force8 )
{
	//printf("Opening file '%s'\n", path);
	static char	m_tex_buff[1024 * 1024 * 4];

	fstream file;
	file.open( path, ios::out | ios::binary );
	//printf("Opened file '%s'\n", path);

//	streampos cur_pos;
	int j;	//, k;
	
	int final_bpp, max_level;
	unsigned long checksum;

	writeBig32( file, &TEXTURE_VERSION );
				
	checksum = m_checksum;
	writeBig32( file, &checksum );
	if( 1 /*m_checksum != vINVALID_CHECKSUM*/ )
	{
		int orig_width, orig_height;
		int padded_width, padded_height;
		int pixel_mode;
		
		if ( !force8 )
		{
			// For now, we're only going to support 32-bit textures.
			ConvertTo32BitPixelFormat();
			pixel_mode = 32;
			final_bpp = 32;
		}

		// Get the max mip level
		max_level = m_mip_levels;

		// Get the original size
		orig_width = m_orig_width[0];
		orig_height = m_orig_height[0];
			
		// Calculate the padded width & height.
//		padded_width = ( orig_width + 3 ) & ~3;
//		padded_height = ( orig_height + 3 ) & ~3;
		padded_width = m_width[0];
		padded_height = m_height[0];

		// Write out pixel storage mode
		writeBig32( file, &orig_width );
		writeBig32( file, &orig_height );
		writeBig32( file, &pixel_mode );
		writeBig32( file, &max_level );

		// Write out all mip-levels.
		for( j = 0; j <= m_mip_levels; j++ )
		{
			if ( force8 )
			{
				writeBig32( file, &padded_width );
				writeBig32( file, &padded_height );

				// This is specifically used for icon data.
				if ( m_pixel_format == v8_BIT )
				{
					// Convert to 32 bit palette if not already.
					if( m_palette_format == v16_BIT )
					{
						Convert16BitPaletteFormatTo32BitPaletteFormat();
					}

					if( m_palette_format == v24_BIT )
					{
						Convert24BitPaletteFormatTo32BitPaletteFormat();
					}

					// Flip it & convert down to original size.
					int lp, lp2, lp3;
					unsigned char * ps = (unsigned char *)m_texel_data[0];
					unsigned char * pd = (unsigned char *)malloc ( orig_width * orig_height );
					for ( lp = 0; lp < m_height[0]; lp++ )
					{
						memcpy( &pd[orig_width*(orig_height-(lp+1))], &ps[m_width[0]*lp], orig_width );
					}

					// Write 8 bit paletted data.
					unsigned char * p8 = (unsigned char *)malloc ( orig_width * orig_height );
					unsigned char * pi = pd;
					// Reorder in blocks.
					for ( lp = 0; lp < orig_height; lp += 4 )
					{
						int xx = lp * orig_width;
						for ( lp2 = 0; lp2 < orig_width; lp2 += 8 )
						{
							for ( lp3 = 0; lp3 < 32; lp3++ )
							{
								p8[lp3+(lp2*4)+xx] = pi[(lp3&7)+(orig_width*(lp3>>3))+lp2+xx];
							}
						}
					}

					// Not used for icon files.
					short meaningful_alpha = 0;
					short has_holes = 0;
		    		writeBig16( file, &meaningful_alpha );
		    		writeBig16( file, &has_holes );

					// Write out the texel data
					file.write((const char*)p8, orig_width * orig_height );

					// Write out the palette data.
					unsigned short entry;
					int r, g, b, a;
					unsigned int * p32 = (unsigned int *)m_palette_data;
					for ( lp = 0; lp < 256; lp++ )
					{
						r = ( p32[lp] >>  0 ) & 255;
						g = ( p32[lp] >>  8 ) & 255;
						b = ( p32[lp] >> 16 ) & 255;
						a = ( p32[lp] >> 24 ) & 255;
						entry = GXPackedRGB5A3( r, g, b, a );
			    		writeBig16( file, &entry );
					}

					free( p8 );
					free( pd );

					printf( " 8" );
				}
				else
				{
					printf( " --- error: source not 8-bit" );
				}
			}
			else
			{
				// Calculate the padded width & height.
				padded_width = ( m_width[j] + 7 ) & ~7;
				padded_height = ( m_height[j] + 7 ) & ~7;

				writeBig32( file, &padded_width );
				writeBig32( file, &padded_height );

//				printf( "orig: %d,%d\n", orig_width, orig_height );
//				printf( "padded: %d,%d\n", padded_width, padded_height );

				// Convert to NGC-format.
				unsigned int * p32 = (unsigned int *)malloc ( padded_width * padded_height * 4 );
				unsigned int * pTex = (unsigned int *)m_texel_data[j];
				// Pad width/height.
//				memset( p32, 0, padded_width * padded_height * 4 );
//				for ( int lp = 0; lp < m_height[j]; lp++ ) {
//					memcpy( &p32[padded_width * (lp+(padded_height-m_height[j]))], &pTex[m_width[j] * lp], m_width[j] * 4 );
//				}
				int x;
				int y;
				for ( int lp = 0; lp < padded_height; lp++ )
				{
//					printf( "\nLine %2d:", lp );
					for ( int lp2 = 0; lp2 < padded_width; lp2++ )
					{
						x = lp2;
						if ( x >= m_width[j] ) x = m_width[j] - 1;
						y = lp;
						if ( y >= m_height[j] ) y = m_height[j] - 1;

//						printf( " %2d,%2d", x, y );
						p32[(padded_width*lp)+lp2] = pTex[(m_width[j] * y) + x];
					}
				}
				free( m_texel_data[j] );
				m_texel_data[j] = (char *)p32;

				// See if we have meaningful alpha. If we do, we need to write out an alpha map as well.
				unsigned int *p_rgba = (unsigned int *)m_texel_data[j];
				short meaningful_alpha = 0;
				short has_holes = 0;
				for( int p = 0; p < ( padded_width * padded_height ); ++p )
				{
					unsigned int alpha = ( p_rgba[p] >> 24 ) & 0xFF;
					if ( ( alpha > 0 ) && ( alpha < 255 ) )
					{
						meaningful_alpha = 1;
					}
					if ( alpha == 0 )
					{
						has_holes = 1;
					}
				}

				if ( j == 0 )
				{
		    		writeBig16( file, &meaningful_alpha );
		    		writeBig16( file, &has_holes );
				}

				// Convert to NGC-format.
				if ( writeNGC( &file, (unsigned int *)m_texel_data[j], padded_width, padded_height ) )
				{
					printf( " c" );
					if ( meaningful_alpha )
					{
						// We wrote out a compressed image.
						// Create alpha map.
						unsigned int *p_alpha = new unsigned int[(padded_width * padded_height)];
						for( int p = 0; p < ( padded_width * padded_height ); ++p )
						{
							unsigned int old		= p_rgba[p];
							unsigned int alp		= ( old >> 24 ) & 0xFF;
							p_alpha[p]	= ( alp << 0 ) | ( alp << 8 ) | ( alp << 16 ) | 0xff000000;
						}

						// Convert to NGC-format.
						if ( !writeNGC( &file, p_alpha, padded_width, padded_height ) )
						{
							printf( "\nError!!! For some reason the alpha map ended up being written as 32-bit" );
						}

						delete p_alpha;
						printf( "a" );
					}
				}
				else
				{
					printf( " u" );
				}
			}
		}
	}

	file.close();

	return false;
}

bool NxTexture::SaveTexture( char *path, int platform, bool force8 )
{
	bool result = false;

	switch ( platform ) {
		case Utils::vPLATFORM_PS2:
			result = SaveTextureForNGPS(path);
			break;
		case Utils::vPLATFORM_NGC:
			result = SaveTextureForNGC(path, force8);
			break;
		case Utils::vPLATFORM_XBOX:
			result = SaveTextureForXbox(path);
			break;
		default:
			fprintf( stderr, "Illegal platform!!!\n" );
			exit(1);
			break;
	}
	return result;
}
