/*
	colors.h
	Contains basic classes for color data stored in different bit depths
	7-24-01
*/

#ifndef __COLORS__
#define __COLORS__

#define MASK_R555  0x7C00
#define MASK_G555  0x3E0
#define MASK_B555  0x1F

#define MASK_R565  0xF800
#define MASK_G565  0x7E0
#define MASK_B565  0x1F

/*struct Point
{
	int x,y;

	inline Point(int sx, int sy)
	{
		x = sx;
		y = sy;
	}
};*/

template<class T>
struct Freq
{
	T            data;
	unsigned int freq;		// How frequent this data appeared within the sample area

	Freq() { freq = 0; }
};

struct color8		// Palletized texture
{
	unsigned char index;

	int operator== (color8& right)
	{
		return (index == right.index);
	}
};

struct color16_555
{
	enum
	{
		RED,
		GREEN,
		BLUE,
	};
	
	__int16 color;		// Contains the packed color in RGB555 format 5 bits (red, green, and blue)	

	inline unsigned char R()
	{
		return (color >> 10);
	}

	// Pack the red component into 555 format
	inline void R(unsigned char val)
	{
		color &= ~MASK_R555;		// Remove current red component
		color |= (val << 10);		// Pack in new value
	}

	inline unsigned char G()
	{
		return ((color & MASK_G555) >> 5);
	}

	inline void G(unsigned char val)
	{
		color &= ~MASK_G555;		// Remove current green component
		color |= (val << 5);		// Pack in new value
	}

	inline unsigned char B()
	{
		return (color & MASK_B555);
	}

	inline void B(unsigned char val)
	{
		color &= ~MASK_B555;		// Remove current blue component
		color |= val;				// Pack in new value
	}

	inline unsigned char operator[](int id)
	{
		switch(id)
		{
		case RED:
			return R();

		case GREEN:
			return G();			

		case BLUE:
			return B();
		}
	}

	int operator== (color16_555& right)
	{
		return (color == right.color);
	}
};

struct color16_565
{
	enum
	{
		RED,
		GREEN,
		BLUE,
	};

	__int16 color;		// Contains the packed color in RGB565 format 5 bits red, 6 bits green, 5 bits blue)

	inline unsigned char R()
	{
		return (color >> 10);
	}

	inline void R(unsigned char val)
	{
		color &= ~MASK_R565;		// Remove red component
		color |= (val << 10);		// Pack in new value
	}

	inline unsigned char G()
	{
		return ((color & MASK_G565) >> 5);
	}

	inline void G(unsigned char val)
	{
		color &= ~MASK_G565;		// Remove green component
		color |= (val << 5);		// Pack in new value
	}

	inline unsigned char B()
	{
		return (color & MASK_B565);
	}

	inline void B(unsigned char val)
	{
		color &= ~MASK_B565;		// Remove blue component
		color |= val;				// Pack in new value
	}

	inline unsigned char operator[](int id)
	{
		switch(id)
		{
		case RED:
			return R();

		case GREEN:
			return G();			

		case BLUE:
			return B();
		}
	}

	int operator== (color16_565& right)
	{
		return (color == right.color);
	}
};

struct color24
{
	unsigned char r,g,b;

	int operator== (color24& right)
	{
		return (r == right.r &&
			    g == right.g &&
				b == right.b);
	}
};

struct color32
{
	unsigned char r,g,b,a;

	int operator== (color32& right)
	{
		return (r == right.r &&
			    g == right.g &&
				b == right.b &&
				a == right.a);
	}
};

// Varient color
union varColor
{
	color8      c8;
	color16_555 c16_555;
	color16_565 c16_565;
	color24     c24;
	color32     c32;
};

#endif
