//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		NxPNG.h
//
//	Description:
//		Neversoft PNG Exporter. Will export PNGs as 1, 2, 4 and 8-bit images and optionally 4 or 8-bit with alpha.
//
//	Use:
//		Format modules are called from the Save, Save as,
//		and Save a copy dialogs.
//
//-------------------------------------------------------------------------------

#ifndef __NxPNG_H__	// Has this not been defined yet?
#define __NxPNG_H__	// Only include this once by predefining it

#include "PIDefines.h"
#include "PIFormat.h"					// Format Photoshop header file.
#include "PIUtilities.h"				// SDK Utility library.
#include "FileUtilities.h"				// File Utility library.
#include "NxPNGTerminology.h"	// Terminology for plug-in.

//-------------------------------------------------------------------------------
//	Structure -- FileHeader
//-------------------------------------------------------------------------------

typedef struct FileHeader
{
	
	char identifier [8];
	
	int16 mode;
	int16 depth;
	int16 rows;
	int16 cols;
	int16 planes;
	
	int32 resourceLength;
	
} FileHeader;

//-------------------------------------------------------------------------------
//	Globals -- structures
//-------------------------------------------------------------------------------

typedef struct Globals
{ // This is our structure that we use to pass globals between routines:

	short				*result;			// Must always be first in Globals.
	FormatRecord		*formatParamBlock;	// Must always be second in Globals.

	Boolean				queryForParameters;

	BufferID			pixelBuffer;
	Ptr					pixelData;
	
	int32				rowBytes;
	
	Boolean				fooValueForRead;
	Boolean				barValueForWrite;

	Str255				history;
	
} Globals, *GPtr, **GHdl;				// *GPtr = global pointer; **GHdl = global handle

struct Point2D
{
	int x,y;

	inline Point2D(int sx, int sy)
	{
		x = sx;
		y = sy;
	}
};
	
//-------------------------------------------------------------------------------
//	Globals -- definitions and macros
//-------------------------------------------------------------------------------

#define gResult				(*(globals->result))
#define gStuff				(globals->formatParamBlock)

#define gQueryForParameters	(globals->queryForParameters)

#define gPixelBuffer		(globals->pixelBuffer)
#define gPixelData			(globals->pixelData)
#define gRowBytes			(globals->rowBytes)

#define gFooRead			(globals->fooValueForRead)
#define gBarWrite			(globals->barValueForWrite)

#define gHistory			(globals->history)

//-------------------------------------------------------------------------------
//	Prototypes
//-------------------------------------------------------------------------------

// Everything comes in and out of PluginMain. It must be first routine in source:
DLLExport MACPASCAL void PluginMain (const short selector,
					  	             FormatRecord *formatParamBlock,
						             long *data,
						             short *result);

void InitGlobals (Ptr globalPtr);		  		// Initialize globals.
void DoAbout (AboutRecordPtr about); 	   		// Pop about box.

void ValidateParameters (GPtr globals);			// Validates (inits) parameters.
Boolean DoUI (GPtr globals);					// Show the UI.

// During read phase:
Boolean ReadScriptParamsOnRead (GPtr globals);	// Read any scripting params.
OSErr WriteScriptParamsOnRead (GPtr globals);	// Write any scripting params.

// During write phase:
Boolean ReadScriptParamsOnWrite (GPtr globals);	// Read any scripting params.
OSErr WriteScriptParamsOnWrite (GPtr globals);	// Write any scripting params.

//-------------------------------------------------------------------------------

#endif // __NxPNG_H__
