/*
	BitArray.h
	This class is responsible for traversing arrays at the bit level

	8-19-01 aml
*/

#ifndef __BITARRAY__
#define __BITARRAY__

class BArray
{
	unsigned char* loc;
	int            bitsPerEntry;

	void SwapEndian( unsigned char* src, unsigned int numBytes );

public:
	BArray(void* pdata, int bpe);
	BArray(void* pdata);
	~BArray();

	bool operator[](int i);
	void SetBit(int i);
	void ClearBit(int i);
	void GetVal(void* val, int idx);
	void GetVal(void* val, int valSize, int idx);
};

#endif

