// ADOBE SYSTEMS INCORPORATED
// Copyright  1993 - 2002 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this 
// file in accordance with the terms of the Adobe license agreement
// accompanying it.  If you have received this file from a source
// other than Adobe, then your use, modification, or distribution
// of it requires the prior written permission of Adobe.
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIMacUI.cpp
//
//	Description:
//		Macintosh only code for the UI elements
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------

#include "PIUI.h"
#include "DialogUtilities.h"
#include "PIUSuites.h"
#include "PIUIHooksSuite.h"

// Include issues on the Mac this is taken from ConditionalHeaders.h
#if !OPAQUE_TOOLBOX_STRUCTS
struct PopupPrivateData {
  MenuRef             mHandle;
  SInt16              mID;
};
typedef struct PopupPrivateData         PopupPrivateData;
typedef PopupPrivateData *              PopupPrivateDataPtr;
typedef PopupPrivateDataPtr *           PopupPrivateDataHandle;
#endif  /* !OPAQUE_TOOLBOX_STRUCTS */

int PIDialog::Modal(SPPluginRef pluginRef, char *, int dialogID)
{
	short item = -1;

	AutoSuite<PSUIHooksSuite1> sUIHooks(kPSUIHooksSuite, kPSUIHooksSuiteVersion1);
	ProcessEventProc processEvent = sUIHooks->processEvent;

	ResContext context(pluginRef);

	DialogTHndl dialogTemplate = (DialogTHndl) GetResource ('DLOG', dialogID);
	if (dialogTemplate == NULL) return item;

	HNoPurge ((Handle) dialogTemplate);
	
	CenterDialog (dialogTemplate);
	
	DialogPtr dialog = GetNewDialog( dialogID, nil, (WindowPtr)-1L );
	if (dialog == NULL) return item;

	(void) SetDialogDefaultItem(dialog, 1);
	(void) SetDialogCancelItem(dialog, 2);
	(void) SetDialogTracksCursor(dialog, TRUE);
	
	SetDialog(dialog);
	
	Init();

	Boolean doneWithDialog = false;
	
	while (doneWithDialog == false)
	{
		MoveableModalDialog(dialog,
						    processEvent,
						    nil,
						    &item);
		Notify(item);
		if (item == 1 || item == 2)
			doneWithDialog = true;
	}
	
	DisposeDialog(dialog);
	HPurge ((Handle) dialogTemplate);
	
	return item;

}

void PIComboBox::Clear(void)
{
	PIMenu menuItem = PIGetMenuHandleFromItemHandle(item);
	short menuCount = CountMenuItems(menuItem);
	
	while (menuCount > 0)
	{
		DeleteMenuItem(menuItem, menuCount);
		menuCount--;
	}
}

void PIComboBox::AppendItem(const char * in)
{
	PIMenu menuItem = PIGetMenuHandleFromItemHandle(item);
	Str255 pString;
	CToPStringCopy(pString, in);
	short menuCount = CountMenuItems(menuItem);
	InsertMenuItem(menuItem, "\p ", menuCount);
	menuCount++;
	SetMenuItemText(menuItem, menuCount, pString);	
	short controlCount = GetControlMaximum((ControlRef)item);
	if (menuCount != controlCount)
		SetControlMaximum((ControlRef)item, menuCount);
}

void PIComboBox::SetCurrentSelection(int16 index)
{
	SetControlValue((ControlRef)item, index);
}

char * PIComboBox::GetCurrentSelection(void)
{
	int16 menuIndex = GetControlValue((ControlRef)item);
	PIMenu menuItem = PIGetMenuHandleFromItemHandle(item);
	Str255 pString = "\p";
	GetMenuItemText(menuItem, menuIndex, pString);
	char * returnValue = new char[256];
	if (returnValue == NULL) return returnValue;
	PToCStringCopy(returnValue, pString);
	return returnValue;
}

void PIText::SetText(const char * in)
{
	Str255 pString;
	CToPStringCopy(pString, in);
	SetDialogItemText(item, pString);
}

char * PIText::GetText(void)
{
	char * returnValue = NULL;
	Str255 pString;
	GetDialogItemText(item, pString);
	returnValue = new char[256];
	if (returnValue == NULL) return returnValue;
	PToCStringCopy(returnValue, pString);
	return returnValue;
}

void PIRadioGroup::SetGroupRange(int32 first, int32 last)
{
	firstItem = first;
	lastItem = last;
}

void PIRadioGroup::SetSelected(int32 s)
{
	if (firstItem == -1 || lastItem == -1 || dialog == NULL) return;
	if (s > lastItem || s < firstItem) return;
	SetRadioGroupState(dialog, firstItem, lastItem, s);
}

int32 PIRadioGroup::GetSelected(void)
{	
	return GetRadioGroupState(dialog, firstItem, lastItem);
}

PIItem PIGetDialogItem(PIDialogPtr dialog, int16 itemNumber)
{
	Rect r;
	short itemType;		
	PIItem h = NULL;
	GetDialogItem(dialog, itemNumber, &itemType, &h, &r);
	return (h);
}

PIMenu PIGetMenuHandleFromItemHandle(PIItem itemHandle)
{
	PIMenu menuHandle = NULL;
	if (itemHandle == NULL)
	{
		return menuHandle;
	}

	#if TARGET_CARBON
		menuHandle = GetControlPopupMenuHandle((ControlRef)itemHandle);
	#else
		PopupPrivateDataHandle popupData;
		ControlRef popupControl;

		popupControl = (ControlRef)itemHandle;
		popupData = (PopupPrivateDataHandle)((*popupControl)->contrlData);
		if (popupData == NULL)
			return menuHandle;

		menuHandle = (*popupData)->mHandle;
	#endif
	
	return (menuHandle);		
}

void CToPStringCopy(StringPtr dst, const char * const src)
{
	dst[0] = strlen(src);
	short index = 0;
	while (index < dst[0])
	{
		dst[index+1] = src[index];
		index++;
	}
}

void PToCStringCopy(char * dst, const StringPtr src)
{
	short length = src[0];
	short index = 0;
	while (index < length)
	{
		dst[index] = src[index+1];
		index++;
	}
	dst[index] = 0;
}

ResContext::ResContext(SPPluginRef pluginRef) : oldContext(0), sSPAccess(kSPAccessSuite, kSPAccessSuiteVersion)
{	
	SPPlatformAccessRef resources = NULL;
	SPPlatformAccessRef oldResources = NULL;
	oldContext = CurResFile();
	SPAccessRef access = NULL;

	SPErr error = sSPAccess->GetPluginAccess(pluginRef, &access);
	if (!error && access != NULL)
	{
		SPPlatformAccessInfo info;
		error = sSPAccess->GetAccessInfo(access, &info);
		
		if (error == 0)
			if (info.resourceAccess != NULL)
				resources = info.resourceAccess;
			else
				resources = info.defaultAccess;
	}
	
	if (resources != NULL)
	#if TARGET_CARBON
		UseResFile(resources->fileRefNum);
	#else
		UseResFile(resources->CurMap);
	#endif
}

ResContext::~ResContext()
{	
	if (oldContext)
		UseResFile(oldContext);	
	sSPAccess.Unload();
}

void DoAbout(SPPluginRef plugin, int dialogID)
{
	short 			item;	// variable to receive item pressed (ignored)
	DialogPtr 		dp;		// dialog pointer for newly created dialog
	DialogTHndl 	dt;		// dialog handle for dialog resource
	StringHandle	h;		// string resource for about text
	
	ResContext context(plugin);

	h = GetString(dialogID);
	
	// Now go get the dialog information:
	dt = (DialogTHndl) GetResource ('DLOG', dialogID);

	HNoPurge ((Handle) dt); // mark it unpurgeable

	CenterDialog (dt); // center fully on the screen

	dp = GetNewDialog (dialogID, nil, (WindowPtr) -1); // instantiate the dialog
	
	// Standard routine to replace ^0, ^1, ^2, ^3 with text:
	ParamText (*h, NULL, NULL, NULL);
	
	SetArrowCursor (); // Requires QuickDraw globals
	
	(void) SetDialogDefaultItem (dp, ok); // hidden
	(void) SetDialogCancelItem (dp, ok); // either
	
	AutoSuite<PSUIHooksSuite1> sUIHooks(kPSUIHooksSuite, kPSUIHooksSuiteVersion1);
	ProcessEventProc processEvent = sUIHooks->processEvent;

	// This routine handles the moveable modal and returns an item hit:
	do 
	{
		MoveableModalDialog (dp, processEvent, NULL, &item);
		if (item == 4 || item == 5)
		{
			AutoSuite<PSGetFileListSuite4> sFileList(kPSGetFileListSuite, kPSGetFileListSuiteVersion4);
			const char * message;// = "";
			if (item == 4)
				message = "http://www.adobe.com";
			else
				message = "http://partners.adobe.com";
			try 
			{
				sFileList->BrowseUrl(message);
			}
			catch(...)
			{
				return;
			}
		}
	}
	while (item == 4 || item == 5);
		
	DisposeDialog (dp); // closes and disposes the dialog

	ReleaseResource((Handle)h); // Releases the text resource

	HPurge ((Handle) dt); // mark the dialog info as purgeable

	ReleaseResource((Handle) dt); // releases the dialog info resource
}
// end PIMacUI.cpp
