// ADOBE SYSTEMS INCORPORATED
// Copyright  1993 - 2002 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this 
// file in accordance with the terms of the Adobe license agreement
// accompanying it.  If you have received this file from a source
// other than Adobe, then your use, modification, or distribution
// of it requires the prior written permission of Adobe.
//-------------------------------------------------------------------
//
//	File:
//		PIStringTerminology.h
//
//	(c) Copyright 2000 Adobe Systems Incorporated.
//	All Rights Reserved.
//
//	Distribution:
//		PUBLIC
//
//	Description:
//*****************************************************************************
/* $Id: //photoshop/7.0/photoshop/sharedinterfaces/PIStringTerminology.h#40 $  */
/* $DateTime: 2002/02/18 16:11:21 $ */
/* $Change: 48457 $ */
/* $Author: mscarafo $ */

#ifndef __PIStringTerminology_h__
#define __PIStringTerminology_h__

#if PRAGMA_ONCE
#pragma once
#endif

//*****************************************************************************

// This file defines constants for the strings used to access descriptor
// events, keys, classes, enum types, and enum values. The name of each symbol is
// the same as the string it represents with "k" prepended and "Str" appended.
// The purpose of using these symbols instead of literal strings is to detect
// misspellings at call sites. 
//
// Check that your new names are unique by searching within UActionsTerminology.r
//
// * All event names must be different from all other event names.
// * All class names must be different from all other class names
// * All enumeration type names must be different from all other enumeration type names
// * All keys must be different from all other keys used in the same class or event.
// * All enumeration values must be different from all other enumeration values
//   in the same enumeration type.
// * A class, event, enumeration type, enumeration value, and a key can all have
//   the same name.
//
// Put generally, the names for things must only be unique within a particular
// category and scope, and in fact you shouldn't make things unique unnecessarily --
// generic terms are preferable, and if there's an existing word for something, use it.
//
// If you need to get the DescType value corresponding to any string, use
// GetStringID (stringValue). This is useful when you need to pass an event
// or other ID to a routine that has only a DescType parameter interface or
// when you have been passed a DescType event, class, etc. value and need
// to compare it against one of these string values.

#define k128BitFloatingPointStr "128BitFloatingPoint"
#define k16BitsPerPixelStr "16BitsPerPixel"
#define k1BitPerPixelStr "1BitPerPixel"
#define k2BitsPerPixelStr "2BitsPerPixel"
#define k32BitsPerPixelStr "32BitsPerPixel"
#define k3DAntiAliasStr "3DAntiAlias"
#define k3DTransformStr "3DTransform"
#define k4BitsPerPixelStr "4BitsPerPixel"
#define k5000Str "5000"
#define k5500Str "5500"
#define k6500Str "6500"
#define k72ColorStr "72Color"
#define k72GrayStr "72Gray"
#define k7500Str "7500"
#define k8BitsPerPixelStr "8BitsPerPixel"
#define k9300Str "9300"
#define kaboutAppStr "aboutApp"
#define kabsColorimetricStr "absColorimetric"
#define kabsoluteStr "absolute"
#define kacceleratedStr "accelerated"
#define kaccentedEdgesStr "accentedEdges"
#define kactionDataStr "actionData"
#define kactionReferenceStr "actionReference"
#define kactionSetStr "actionSet"
#define kactionStr "action"
#define kactualPixelsStr "actualPixels"
#define kadaptiveStr "adaptive"
#define kaddKnotToolStr "addKnotTool"
#define kaddNoiseStr "addNoise"
#define kaddressAttrStr "addressAttr"
#define kaddStr "add"
#define kaddToStr "addTo"
#define kadjustmentLayerStr "adjustmentLayer"
#define kadjustmentOptionsStr "adjustmentOptions"
#define kadjustmentStr "adjustment"
#define kadobeOnlineHomeStr "adobeOnlineHome"
#define kadobeOnlineRegistrationStr "adobeOnlineRegistration"
#define kadobeOnlineUpdatesStr "adobeOnlineUpdates"
#define kadobeRGB1998Str "adobeRGB1998"
#define kADSBottomsStr "ADSBottoms"
#define kADSCentersHStr "ADSCentersH"
#define kADSCentersVStr "ADSCentersV"
#define kADSHorizontalStr "ADSHorizontal"
#define kADSLeftsStr "ADSLefts"
#define kADSRightsStr "ADSRights"
#define kADSTopsStr "ADSTops"
#define kADSVerticalStr "ADSVertical"
#define kAEListStr "AEList"
#define kAERecordStr "AERecord"
#define kairbrushEraserStr "airbrushEraser"
#define kairbrushToolStr "airbrushTool"
#define kaliasStr "alias"
#define kalignDistributeSelectorStr "alignDistributeSelector"
#define kalignedStr "aligned"
#define kalignmentStr "alignment"
#define kalignmentTypeStr "alignmentType"
#define kalignStr "align"
#define kallCapsStr "allCaps"
#define kallEnumStr "allEnum"
#define kallExceptStr "allExcept"
#define kallowSystemShortcuts "allowSystemShortcuts"
#define kallStr "all"
#define kallToolOptionsStr "allToolOptions"
#define kalphaChannelOptionsClassStr "alphaChannelOptionsClass"
#define kalphaChannelOptionsStr "alphaChannelOptions"
#define kalphaChannelsStr "alphaChannels"
#define kaltligatureStr "altligature"
#define kaltTagStr "altTag"
#define kambientBrightnessStr "ambientBrightness"
#define kambientColorStr "ambientColor"
#define kamountHighStr "amountHigh"
#define kamountLowStr "amountLow"
#define kamountMediumStr "amountMedium"
#define kamountStr "amount"
#define kamplitudeMaxStr "amplitudeMax"
#define kamplitudeMinStr "amplitudeMin"
#define kanchorStr "anchor"
#define kangle1Str "angle1"
#define kangle2Str "angle2"
#define kangle3Str "angle3"
#define kangle4Str "angle4"
#define kangledStrokesStr "angledStrokes"
#define kangleDynamicsStr "angleDynamics"
#define kangleStr "angle"
#define kangleUnitStr "angleUnit"
#define kanisotropicStr "anisotropic"
#define kannotationStr "annotation"
#define kannotSoundStr "annotSound"
#define kannotTextStr "annotText"
#define kannotTypeStr "annotType"
#define kannotUnknownStr "annotUnknown"
#define kantiAliasCrispStr "antiAliasCrisp"
#define kantiAliasedPICTAcquireStr "antiAliasedPICTAcquire"
#define kAntialiasGlossStr "antialiasGloss"
#define kantiAliasHighStr "antiAliasHigh"
#define kantiAliasLowStr "antiAliasLow"
#define kantiAliasMediumStr "antiAliasMedium"
#define kantiAliasNoneStr "antiAliasNone"
#define kantiAliasSharpStr "antiAliasSharp"
#define kantiAliasSmoothStr "antiAliasSmooth"
#define kantiAliasStr "antiAlias"
#define kantiAliasStrongStr "antiAliasStrong"
#define kantiAliasTypeStr "antiAliasType"
#define kanyStr "any"
#define kAOLPreferencesStr "AOLPreferences"
#define kappendStr "append"
#define kappendCopyStr "appendCopy"
#define kappleEventStr "appleEvent"
#define kappleRGBStr "appleRGB"
#define kapplicationStr "application"
#define kapplSignatureStr "applSignature"
#define kapplyImageEnumStr "applyImageEnum"
#define kapplyImageEventStr "applyImageEvent"
#define kapplyLockingStr "applyLocking"
#define kapplyStr "apply"
#define kapplyStyleStr "applyStyle"
#define kappParametersStr "appParameters"
#define kareaSelectorStr "areaSelector"
#define kareaStr "area"
#define karoundCenterStr "aroundCenter"
#define karrangeStr "arrange"
#define karrowheadStr "arrowhead"
#define kartBrushToolStr "artBrushTool"
#define kASCIIStr "ASCII"
#define kaskLayeredTIFFStr "askLayeredTIFF"
#define kaskMismatchOpeningStr "askMismatchOpening"
#define kaskMismatchPastingStr "askMismatchPasting"
#define kaskMissingStr "askMissing"
#define kaskStr "ask"
#define kaskWhenOpeningStr "askWhenOpening"
#define kassertStr "assert"
#define kassignProfileStr "assignProfile"
#define kasStr "as"
#define kassumedCMYKStr "assumedCMYK"
#define kassumedGrayStr "assumedGray"
#define kassumedProfileStr "assumedProfile"
#define kassumedRGBStr "assumedRGB"
#define kassumeOptionsStr "assumeOptions"
#define kaStr "a"
#define katStr "at"
#define kauthorNameStr "authorName"
#define kautoContrastStr "autoContrast"
#define kautoEraseStr "autoErase"
#define kautoKernStr "autoKern"
#define kautoLeadingPercentageStr "autoLeadingPercentage"
#define kautoLeadingStr "autoLeading"
#define kautoStr "auto"
#define kautoBlackWhiteStr "autoBlackWhite"
#define kautoNeutralsStr "autoNeutrals"
#define kautoUpdateFileStr	"autoUpdateFiles"
#define kaxisStr "axis"
#define kbackgroundColorStr "backgroundColor"
#define kbackgroundEraserToolStr "backgroundEraserTool"
#define kbackgroundLayerStr "backgroundLayer"
#define kbackgroundLevelStr "backgroundLevel"
#define kbackgroundStr "background"
#define kbackLightStr "backLight"
#define kbackStr "back"
#define kbackwardEnumStr "backwardEnum"
#define kbackwardStr "backward"
#define kbalanceStr "balance"
#define kbaselineDirectionStr "baselineDirection"
#define kbaselineShiftStr "baselineShift"
#define kbaselineStr "baseline"
#define kbaseStr "base"
#define kbaseNameStr "baseName"
#define kbasReliefStr "basRelief"
#define kbatchFromDropletStr "batchFromDroplet"
#define kbatchSourceTypeStr "batchSourceType"
#define kbatchStr "batch"
#define kbeepWhenDoneStr "beepWhenDone"
#define kbeginRampStr "beginRamp"
#define kbeginSustainStr "beginSustain"
#define kbehindStr "behind"
#define kbelowStr "below"
#define kbestStr "best"
#define kbetterStr "better"
#define kbevelDirectionStr "bevelDirection"
#define kbevelEmbossStampStyleStr "bevelEmbossStampStyle"
#define kbevelEmbossStr "bevelEmboss"
#define kbevelEmbossStyleStr "bevelEmbossStyle"
#define kbevelStyleStr "bevelStyle"
#define kbevelTechniqueStr "bevelTechnique"
#define kbicubicStr "bicubic"
#define kbigNudgeHStr "bigNudgeH"
#define kbigNudgeVStr "bigNudgeV"
#define kbilinearStr "bilinear"
#define kbinaryStr "binary"
#define kbitDepth1Str "bitDepth1"
#define kbitDepth24Str "bitDepth24"
#define kbitDepth4Str "bitDepth4"
#define kbitDepth8Str "bitDepth8"
#define kbitDepthStr "bitDepth"
#define kbitmapModeStr "bitmapMode"
#define kbitmapStr "bitmap"
#define kblackAndWhiteStr "blackAndWhite"
#define kblackBodyStr "blackBody"
#define kblackClipStr "blackClip"
#define kblackGenerationCurveStr "blackGenerationCurve"
#define kblackGenerationStr "blackGeneration"
#define kblackGenerationTypeStr "blackGenerationType"
#define kblackIntensityStr "blackIntensity"
#define kblackLevelStr "blackLevel"
#define kblackLimitStr "blackLimit"
#define kblacksStr "blacks"
#define kblackStr "black"
#define kblastStr "blast"
#define kbleedStr "bleed"
#define kblendClippedStr "blendClipped"
#define kblendInteriorStr "blendInterior"
#define kblendModeStr "blendMode"
#define kblendOptionsStr "blendOptions"
#define kblendRangeStr "blendRange"
#define kblockEraserStr "blockEraser"
#define kblocksStr "blocks"
#define kblueBlackPointStr "blueBlackPoint"
#define kblueGammaStr "blueGamma"
#define kbluesStr "blues"
#define kblueStr "blue"
#define kblueWhitePointStr "blueWhitePoint"
#define kblueXStr "blueX"
#define kblueYStr "blueY"
#define kblurEventStr "blurEvent"
#define kblurMethodStr "blurMethod"
#define kblurMoreStr "blurMore"
#define kblurQualityStr "blurQuality"
#define kblurStr "blur"
#define kblurToolStr "blurTool"
#define kbMPFormatStr "bMPFormat"
#define kbokmalNorwegianLanguageStr "bokmalNorwegianLanguage"
#define kbolditalicStr "bolditalic"
#define kboldStr "bold"
#define kbookColorStr "bookColor"
#define kbookStr "book"
#define kbookIDStr	"bookID"
#define kbookColorKeyStr	"bookKey"
#define kbooleanStr "boolean"
#define kborderStr "border"
#define kborderThicknessStr "borderThickness"
#define kbothAxesStr	"bothAxes"
#define kbottomEnumStr "bottomEnum"
#define kbottomRightPixelColorStr "bottomRightPixelColor"
#define kbottomStr "bottom"
#define kboundsStr "bounds"
#define kboxStr "box"
#define kbrazilianPortugueseLanguageStr "brazilianPortugueseLanguage"
#define kbrightnessContrastStr "brightnessContrast"
#define kbrightnessEventStr "brightnessEvent"
#define kbrightnessStr "brightness"
#define kbroadcastKeyStr "broadcastKey"
#define kbrowserHeightStr "browserHeight"
#define kbrowserWidthStr "browserWidth"
#define kbrushDarkRoughStr "brushDarkRough"
#define kbrushDetailStr "brushDetail"
#define kbrushesAppendStr "brushesAppend"
#define kbrushesDefineStr "brushesDefine"
#define kbrushesDeleteStr "brushesDelete"
#define kbrushesLoadStr "brushesLoad"
#define kbrushesNewStr "brushesNew"
#define kbrushesOptionsStr "brushesOptions"
#define kbrushesResetStr "brushesReset"
#define kbrushesSaveStr "brushesSave"
#define kbrushesStr "brushes"
#define kbrushLightRoughStr "brushLightRough"
#define kbrushPresetStr "brushPreset"
#define kbrushSimpleStr "brushSimple"
#define kbrushSizeStr "brushSize"
#define kbrushSparkleStr "brushSparkle"
#define kbrushStr "brush"
#define kbrushTypeStr "brushType"
#define kbrushWideBlurryStr "brushWideBlurry"
#define kbrushWideSharpStr "brushWideSharp"
#define kbStr "b"
#define kbucketToolStr "bucketTool"
#define kbuiltInContourStr "builtInShapeCurve"
#define kbuiltinProfileStr "builtinProfile"
#define kbuiltinProofStr "builtinProof"
#define kbuiltinStr "builtin"
#define kbulgarianLanguageStr "bulgarianLanguage"
#define kbumpAmplitudeStr "bumpAmplitude"
#define kbumpChannelStr "bumpChannel"
#define kburasagariStr "burasagari"
#define kburnInHStr "burnInH"
#define kburnInMStr "burnInM"
#define kburnInSStr "burnInS"
#define kburnInToolStr "burnInTool"
#define kbuttonModeStr "buttonMode"
#define kbylineStr "byline"
#define kbylineTitleStr "bylineTitle"
#define kbyStr "by"
#define kbyteOrderStr "byteOrder"
#define kcachePrefsStr "cachePrefs"
#define kcalculationsStr "calculations"
#define kcalculationStr "calculation"
#define kcalculationTypeStr "calculationType"
#define kcalibrationBarsStr "calibrationBars"
#define kcanadianFrenchLanguageStr "canadianFrenchLanguage"
#define kcanvasSizeStr "canvasSize"
#define kcaptionStr "caption"
#define kcaptionWriterStr "captionWriter"
#define kcascadeStr "cascade"
#define kcaseSensitiveStr "caseSensitive"
#define kcatalanLanguageStr "catalanLanguage"
#define kcategoryStr "category"
#define kccittFaxStr "ccittFax"
#define kcellSizeStr "cellSize"
#define kcenterCropMarksStr "centerCropMarks"
#define kcenterDocumentWindows "centerDocumentWindows"
#define kcenteredFrameStr "centeredFrame"
#define kcenterGlowStr "centerGlow"
#define kcenterStr "center"
#define kchalkAreaStr "chalkArea"
#define kchalkCharcoalStr "chalkCharcoal"
#define kchannelMatrixStr "channelMatrix"
#define kchannelMixerStr "channelMixer"
#define kchannelNameStr "channelName"
#define kchannelOptionsStr "channelOptions"
#define kchannelReferenceStr "channelReference"
#define kchannelRestrictionsStr "channelRestrictions"
#define kchannelsInterleavedStr "channelsInterleaved"
#define kchannelsPaletteOptionsStr "channelsPaletteOptions"
#define kchannelsStr "channels"
#define kchannelStr "channel"
#define kcharcoalAmountStr "charcoalAmount"
#define kcharcoalAreaStr "charcoalArea"
#define kcharcoalStr "charcoal"
#define kcharStr "char"
#define kcheckAllStr "checkAll"
#define kcheckerboardLargeStr "checkerboardLarge"
#define kcheckerboardMediumStr "checkerboardMedium"
#define kcheckerboardNoneStr "checkerboardNone"
#define kcheckerboardSizeStr "checkerboardSize"
#define kcheckerboardSmallStr "checkerboardSmall"
#define kcheckForBackgroundLayerStr "checkForBackgroundLayer"
#define kcheckForOpenDocStr "checkForOpenDoc"
#define kcheckForRasterLayerStr "checkForRasterLayer"
#define kcheckForSelectionStr "checkForSelection"
#define kcheckForTextLayerStr "checkForTextLayer"
#define kcheckForVectorLayerStr "checkForVectorLayer"
#define kchokeMatteStr "chokeMatte"
#define kchromaStr "chroma"
#define kchromeFXClassStr "chromeFXClass"
#define kchromeFXStr "chromeFX"
#define kchromeStr "chrome"
#define kCIERGBStr "CIERGB"
#define kcityStr "city"
#define kclassColorStr "classColor"
#define kclassContour	"classFXShapeCurve"
#define kclassElementStr "classElement"
#define kclassExportStr "classExport"
#define kclassFormatStr "classFormat"
#define kclassHueSatHueSatV2Str "classHueSatHueSatV2"
#define kclassImportStr "classImport"
#define kclassModeStr "classMode"
#define kclassStr "class"
#define kclassStringFormatStr "classStringFormat"
#define kclassTextExportStr "classTextExport"
#define kclassTextImportStr "classTextImport"
#define kclearAmountStr "clearAmount"
#define kclearBrushControlsStr "clearBrushControls"
#define kclearEnumStr "clearEnum"
#define kclearEventStr "clearEvent"
#define kclearGuidesStr "clearGuides"
#define kclearSlicesStr "clearSlices"
#define kclearStyleStr "clearStyle"
#define kclipboardStr "clipboard"
#define kclippingInfoStr "clippingInfo"
#define kclippingPathEPSStr "clippingPathEPS"
#define kclippingPathFlatnessStr "clippingPathFlatness"
#define kclippingPathIndexStr "clippingPathIndex"
#define kclippingPathInfoStr "clippingPathInfo"
#define kclippingPathStr "clippingPath"
#define kcloneSourceStr "cloneSource"
#define kcloneStampToolStr "cloneStampTool"
#define kcloseAllStr "closeAll"
#define kclosedSubpathStr "closedSubpath"
#define kcloseQuickStartStr "closeQuickStart"
#define kcloseStr "close"
#define kcloudsStr "clouds"
#define kCMYK64Str "CMYK64"
#define kCMYKColorClassStr "CMYKColorClass"
#define kCMYKColorEnumStr "CMYKColorEnum"
#define kCMYKColorModeStr "CMYKColorMode"
#define kCMYKSetupEngineStr "CMYKSetupEngine"
#define kCMYKSetupStr "CMYKSetup"
#define kCMYKSpectrumStr "CMYKSpectrum"
#define kCMYKStr "CMYK"
#define kcoarseDotsStr "coarseDots"
#define kcolorBalanceStr "colorBalance"
#define kcolorBurnStr "colorBurn"
#define kcolorCastStr "colorCast"
#define kcolorChannelsStr "colorChannels"
#define kcolorChannelStr "colorChannel"
#define kcolorCorrectionStr "colorCorrection"
#define kcolorDodgeStr "colorDodge"
#define kcoloredPencilStr "coloredPencil"
#define kcolorHalftoneStr "colorHalftone"
#define kcolorimetricStr "colorimetric"
#define kcolorIndicatesStr "colorIndicates"
#define kcolorizeStr "colorize"
#define kcolorManagementStr "colorManagement"
#define kcolorMatchStr "colorMatch"
#define kcolorNoiseStr "colorNoise"
#define kcolorOverlayStr "colorOverlay"
#define kcolorPaletteStr "colorPalette"
#define kcolorPickerPrefsClassStr "colorPickerPrefsClass"
#define kcolorPickerPrefsStr "colorPickerPrefs"
#define kcolorRangeStr "colorRange"
#define kcolorReplacementBrushTool "colorReplacementBrushTool"
#define kcolorSamplerListStr "colorSamplerList"
#define kcolorSamplerStr "colorSampler"
#define kcolorSamplerToolStr "colorSamplerTool"
#define kcolorSettingsStr "colorSettings"
#define kcolorSettingsStr "colorSettings"
#define kcolorsListStr "colorsList"
#define kcolorSpaceStr "colorSpace"
#define kcolorsStr "colors"
#define kcolorStopStr "colorStop"
#define kcolorStopTypeStr "colorStopType"
#define kcolorStr "color"
#define kcolorTableStr "colorTable"
#define kcolumnWidthStr "columnWidth"
#define kcombineStr "combine"
#define kcommandKeyStr "commandKey"
#define kcommandStr "command"
#define kcompensationStr "compensation"
#define kcomponentStr "component"
#define kcompositeStr "composite"
#define kcompressionStr "compression"
#define kcompStr "comp"
#define kcomputedBrushStr "computedBrush"
#define kconcavityStr "concavity"
#define kconditionStr "condition"
#define kconstantStr "constant"
#define kconstrainProportionsStr "constrainProportions"
#define kconstrainStr "constrain"
#define kconstructionFOVStr "constructionFOV"
#define kconteCrayonStr "conteCrayon"
#define kcontentLayerStr "contentLayer"
#define kcontentStr "content"
#define kcontiguousStr "contiguous"
#define kcontinueStr "continue"
#define kcontinuityStr "continuity"
#define kContourCustomStr "shapeCurveCustom"
#define kContourDoubleStr "shapeCurveDouble"
#define kcontourEdgeStr "contourEdge"
#define kContourGaussianStr "shapeCurveGaussian"
#define kContourLinearStr "shapeCurveLinear"
#define kContourSingleStr "shapeCurveSingle"
#define kContourStr "shapingCurve"
#define kContourTripleStr "shapeCurveTriple"
#define kContourTypeStr "shapeCurveType"
#define kcontractStr "contract"
#define kcontrastStr "contrast"
#define kconvertKnotToolStr "convertKnotTool"
#define kconvertModeStr "convertMode"
#define kconvertStr "convert"
#define kconvertToCMYKStr "convertToCMYK"
#define kconvertToGrayStr "convertToGray"
#define kconvertToLabStr "convertToLab"
#define kconvertToProfileStr "convertToProfile"
#define kconvertToRGBStr "convertToRGB"
#define kconvertToShapeStr "convertToShape"
#define kcopyAsHTMLStr "copyAsHTML"
#define kcopyEffectsStr "copyEffects"
#define kcopyEventStr "copyEvent"
#define kcopyMergedStr "copyMerged"
#define kcopyBrushTextureStr "copyBrushTexture"
#define kcopyrightedWorkStr "copyrightedWork"
#define kcopyrightNoticeStr "copyrightNotice"
#define kcopyrightStatusStr "copyrightStatus"
#define kcopyrightStr "copyright"
#define kcopyStr "copy"
#define kcopyToLayerStr "copyToLayer"
#define kcornerCropMarksStr "cornerCropMarks"
#define kcornerStr "corner"
#define kcorrectionMethodStr "correctionMethod"
#define kcountDynamicsStr "countDynamics"
#define kcountryNameStr "countryName"
#define kcountStr "count"
#define kcrackBrightnessStr "crackBrightness"
#define kcrackDepthStr "crackDepth"
#define kcrackSpacingStr "crackSpacing"
#define kcraquelureStr "craquelure"
#define kcreateDropletStr "createDroplet"
#define kcreateDuplicateStr "createDuplicate"
#define kcreateInterpolationStr "createInterpolation"
#define kcreateLayersFromLayerFXStr "createLayersFromLayerFX"
#define kcreateWorkPathStr "createWorkPath"
#define kcreditStr "credit"
#define kcropStr "crop"
#define kcropToolStr "cropTool"
#define kcrosshatchStr "crosshatch"
#define kcrossoverStr "crossover"
#define kcrossStr "cross"
#define kcrystallizeStr "crystallize"
#define kctrlPPrint "ctrlPPrint"
#define kctrlPSystemPrint "ctrlPSystemPrint"
#define kctrlShiftZEnumStr "ctrlShiftZEnum"
#define kctrlYEnumStr "ctrlYEnum"
#define kctrlZEnumStr "ctrlZEnum"
#define kcurrentColorsStr "currentColors"
#define kcurrentHistoryStateStr "currentHistoryState"
#define kcurrentLayerStr "currentLayer"
#define kcurrentLightStr "currentLight"
#define kcurrentStr "current"
#define kcurrentToolOptionsStr "currentToolOptions"
#define kcursorKindStr "cursorKind"
#define kcurveFileStr "curveFile"
#define kcurvePointStr "curvePoint"
#define kcurvesAdjustmentStr "curvesAdjustment"
#define kcurvesStr "curves"
#define kcurveStr "curve"
#define kcustomEnumStr "customEnum"
#define kcustomForcedStr "customForced"
#define kcustomMatteStr "customMatte"
#define kcustomPaletteClassStr "customPaletteClass"
#define kcustomPaletteStr "customPalette"
#define kcustomPatternStr "customPattern"
#define kcustomPhosphorsStr "customPhosphors"
#define kcustomShapeStr	"customShape"
#define kcustomShapeToolStr "customShapeTool"
#define kcustomStopsStr "customStops"
#define kcustomStr "custom"
#define kcustomWhitePointStr "customWhitePoint"
#define kcutoutStr "cutout"
#define kcutStr "cut"
#define kcutToLayerStr "cutToLayer"
#define kcyansStr "cyans"
#define kcyanStr "cyan"
#define kczechLanguageStr "czechLanguage"
#define kdanishLanguageStr "danishLanguage"
#define kdarkenOnlyStr "darkenOnly"
#define kdarkenStr "darken"
#define kdarkIntensityStr "darkIntensity"
#define kdarknessStr "darkness"
#define kdarkStr "dark"
#define kdarkStrokesStr "darkStrokes"
#define kdashedLinesStr "dashedLines"
#define kdateCreatedStr "dateCreated"
#define kdatumStr "datum"
#define kDCSStr "DCS"
#define kddmmStr "ddmm"
#define kddmmyyStr "ddmmyy"
#define kdecimalStructStr "decimalStruct"
#define kdeepDepthStr "deepDepth"
#define kdeepStr "deep"
#define kdefaultFillStr "defaultFill"
#define kdefaultStyleStr "defaultStyle"
#define kdefineBrushStr "defineBrush"
#define kdefineCustomShapeStr "defineCustomShape"
#define kdefinePatternStr "definePattern"
#define kdefinitionStr "definition"
#define kdefringeStr "defringe"
#define kdeInterlaceStr "deInterlace"
#define kdeleteAllAnnotStr "deleteAllAnnot"
#define kdeleteContainedStr "deleteContained"
#define kdeleteKnotToolStr "deleteKnotTool"
#define kdeleteStr "delete"
#define kdeleteWorkspaceStr "deleteWorkspace"
#define kdensityStr "density"
#define kdensityUnitStr "densityUnit"
#define kdepthStr "depth"
#define kdesaturateStr "desaturate"
#define kdeselectStr "deselect"
#define kdespeckleStr "despeckle"
#define kdestBlackMaxStr "destBlackMax"
#define kdestBlackMinStr "destBlackMin"
#define kdestinationModeStr "destinationMode"
#define kdestWhiteMaxStr "destWhiteMax"
#define kdestWhiteMinStr "destWhiteMin"
#define kdetailStr "detail"
#define kdiameterStr "diameter"
#define kdiamondStr "diamond"
#define kdifferenceCloudsStr "differenceClouds"
#define kdifferenceStr "difference"
#define kdiffuseGlowStr "diffuseGlow"
#define kdiffuseModeStr "diffuseMode"
#define kdiffuseStr "diffuse"
#define kdiffusionDitherEnumStr "diffusionDitherEnum"
#define kdiffusionDitherStr "diffusionDither"
#define kdiffusionStr "diffusion"
#define kdirectionBalanceStr "directionBalance"
#define kdirectionStr "direction"
#define kdirectSelectToolStr "directSelectTool"
#define kdisableLayerFXStr "disableLayerFX"
#define kdisableLayerStyleStr "disableLayerStyle"
#define kdisableSingleFXEventStr "disableSingleFX"
#define kdiscardVectorMaskStr "discardVectorMask"
#define kdispatcherIDStr "dispatcherID"
#define kdisplaceFileStr "displaceFile"
#define kdisplacementMapStr "displacementMap"
#define kdisplaceStr "displace"
#define kdisplayCursorsPreferencesStr "displayCursorsPreferences"
#define kdisplayPrefsStr "displayPrefs"
#define kdissolveStr "dissolve"
#define kdistanceStr "distance"
#define kdistanceUnitStr "distanceUnit"
#define kdistortionStr "distortion"
#define kdistortStr "distort"
#define kdistributeStr "distribute"
#define kdistributionStr "distribution"
#define kditherAmountStr "ditherAmount"
#define kditherPreserveStr "ditherPreserve"
#define kditherQualityStr "ditherQuality"
#define kditherStr "dither"
#define kdivideStr "divide"
#define kdocumentIDStr "documentID"
#define kdocumentModeStr "documentMode"
#define kdocumentReferenceStr "documentReference"
#define kdocumentStr "document"
#define kdodgeHStr "dodgeH"
#define kdodgeMStr "dodgeM"
#define kdodgeSStr "dodgeS"
#define kdodgeToolStr "dodgeTool"
#define kdontRecordStr "dontRecord"
#define kdotGainCurvesStr "dotGainCurves"
#define kdotGainStr "dotGain"
#define kdotsStr "dots"
#define kdowngradeProfileStr "downgradeProfile"
#define kdraftStr "draft"
#define kdrawStr "draw"
#define kdropShadowStr "dropShadow"
#define kdryBrushStr "dryBrush"
#define kdualBrushStr "dualBrush"
#define kduotoneInkStr "duotoneInk"
#define kduotoneModeStr "duotoneMode"
#define kduotoneStr "duotone"
#define kduplicateStr "duplicate"
#define kdustAndScratchesStr "dustAndScratches"
#define kdutchLanguageStr "dutchLanguage"
#define kdynamicColorSlidersStr "dynamicColorSliders"
#define keasyTextSelection "easyTextSelection"
#define keBUITUStr "eBUITU"
#define kedgeBrightnessStr "edgeBrightness"
#define kedgeFidelityStr "edgeFidelity"
#define kedgeGlowStr "edgeGlow"
#define kedgeIntensityStr "edgeIntensity"
#define kedgeSimplicityStr "edgeSimplicity"
#define kedgeStr "edge"
#define kedgeThicknessStr "edgeThickness"
#define kedgeWidthStr "edgeWidth"
#define keffectBevelStr "effectBevel"
#define keffectColorOverlayStr "effectColorOverlay"
#define keffectDropShadowStr "effectDropShadow"
#define keffectGradientOverlayStr "effectGradientOverlay"
#define keffectInnerGlowStr "effectInnerGlow"
#define keffectInnerShadowStr "effectInnerShadow"
#define keffectNoneStr "effectNone"
#define keffectOuterGlowStr "effectOuterGlow"
#define keffectOverlayStr "effectOverlay"
#define keffectPatternOverlayStr "effectPatternOverlay"
#define keffectSatinStr "effectSatin"
#define keffectStr "effect"
#define keffectStrokeStr "effectStroke"
#define kelementReferenceStr "elementReference"
#define kelementStr "element"
#define keliminateEvenFieldsStr "eliminateEvenFields"
#define keliminateOddFieldsStr "eliminateOddFields"
#define kellipseStr "ellipse"
#define kellipseToolStr "ellipseTool"
#define kembedCMYKStr "embedCMYK"
#define kembedFontsStr "embedFonts"
#define kembedGrayStr "embedGray"
#define kembedLabStr "embedLab"
#define kembedProfilesStr "embedProfiles"
#define kembedRGBStr "embedRGB"
#define kembossStr "emboss"
#define kemulsionDownStr "emulsionDown"
#define kenabledStr "enabled"
#define kencodingStr "encoding"
#define kendArrowheadStr "endArrowhead"
#define kendIndentStr "endIndent"
#define kendRampStr "endRamp"
#define kendStr "end"
#define kendSustainStr "endSustain"
#define kengineStr "engine"
#define kenglishLanguageStr "englishLanguage"
#define kenumeratedStr "enumerated" // DON'T NAME THINGS "enumSomething"; just name them "something"
#define kEPSGenericFormatStr "EPSGenericFormat"
#define kEPSPICTPreviewStr "EPSPICTPreview"
#define kEPSPreviewStr "EPSPreview"
#define kEPSTIFFPreviewStr "EPSTIFFPreview"
#define kequalizeStr "equalize"
#define keraserKindStr "eraserKind"
#define keraserToolStr "eraserTool"
#define keraseToHistoryStr "eraseToHistory"
#define keventClassAttrStr "eventClassAttr"
#define keventIDAttrStr "eventIDAttr"
#define keventRecordStr "eventRecord"
#define keventSourceAttrStr "eventSourceAttr"
#define kexactPointsStr "exactPoints"
#define kexactStr "exact"
#define kexchangeStr "exchange"
#define kexcludeIntersectionStr "excludeIntersection"
#define kexclusionStr "exclusion"
#define kEXIFStr "EXIF"
#define kexpandStr "expand"
#define kexportClipboardStr "exportClipboard"
#define kexportStr "export"
#define kexposureStr "exposure"
#define kextendedQualityStr "extendedQuality"
#define kextendedStr "extended"
#define kextendStr "extend"
#define kextensionsQueryStr "extensionsQuery"
#define kextensionStr "extension"
#define kextrudeDepthStr "extrudeDepth"
#define kextrudeMaskIncompleteStr "extrudeMaskIncomplete"
#define kextrudeRandomStr "extrudeRandom"
#define kextrudeSizeStr "extrudeSize"
#define kextrudeSolidFaceStr "extrudeSolidFace"
#define kextrudeStr "extrude"
#define kextrudeTypeStr "extrudeType"
#define keyeDropperSampleStr "eyeDropperSample"
#define keyeDropperSampleTypeStr "eyeDropperSampleType"
#define keyedropperToolStr "eyedropperTool"
#define kfacetStr "facet"
#define kfadeoutStepsStr "fadeoutSteps"
#define kfadeStr "fade"
#define kfadeToStr "fadeTo"
#define kfalloffStr "falloff"
#define kfalseStr "false"
#define kfasterStr "faster"
#define kfeatherStr "feather"
#define kfiberLengthStr "fiberLength"
#define kfileBrowserStr "fileBrowser"
#define kfileCreatorStr "fileCreator"
#define kfileEnumStr "fileEnum"
#define kfileInfoStr "fileInfo"
#define kfileNamingComponentsStr "fileNamingComponents"
#define kfileNamingComponentStr "fileNamingComponent"
#define kfileNamingRulesStr "fileNamingRules"
#define kfileReferenceStr "fileReference"
#define kfileSavePrefsClassStr "fileSavePrefsClass"
#define kfileSavePrefsStr "fileSavePrefs"
#define kfileStr "file"
#define kfileTypeStr "fileType"
#define kfillBackStr "fillBack"
#define kfillColorStr "fillColor"
#define kfillContentsStr "fillContents"
#define kfillFirstStr "fillFirst"
#define kfillflashStr "fillflash" //rkulkarn 11/15/2000
#define kfillForeStr "fillFore"
#define kfillInverseStr "fillInverse"
#define kfillModeStr "fillMode"
#define kfillNeutralStr "fillNeutral"
#define kfillOpacityStr "fillOpacity"
#define kfillSameStr "fillSame"
#define kfillStr "fill"
#define kfilmGrainStr "filmGrain"
#define kfilterStr "filter"
#define kfindEdgesStr "findEdges"
#define kfindReplaceStr "findReplace"
#define kfindStr "find"
#define kfineDotsStr "fineDots"
#define kfingerpaintingStr "fingerpainting"
#define kfinnishLanguageStr "finnishLanguage"
#define kfirstIdleStr "firstIdle"
#define kfirstLineIndentStr "firstLineIndent"
#define kfirstStr "first"
#define kfitOnScreenStr "fitOnScreen"
#define kfixedStr "fixed"
#define kflareCenterStr "flareCenter"
#define kflashPixFormatStr "flashPixFormat"
#define kflatnessStr "flatness"
#define kflattenImageStr "flattenImage"
#define kflattenStr "flatten"
#define kflipStr "flip"
#define kfloatTypeStr "floatType"
#define kfloatUnitStr "floatUnit"
#define kflowStr "flow"
#define kfocusStr "focus"
#define kfoldersStr "folders"
#define kfontCapsStr "fontCaps"
#define kfontDesignAxesStr "fontDesignAxes"
#define kfontDesignAxesVectorsStr "fontDesignAxesVectors"
#define kfontNameStr "fontName"
#define kfontPostScriptNameStr "fontPostScriptName"
#define kfontScriptStr "fontScript"
#define kfontSizeStr "fontSize"
#define kfontStyleNameStr "fontStyleName"
#define kfontTechnologyStr "fontTechnology"
#define kforcedColorsStr "forcedColors"
#define kforegroundColorStr "foregroundColor"
#define kforegroundLevelStr "foregroundLevel"
#define kformatStr "format"
#define kforwardEnumStr "forwardEnum"
#define kforwardStr "forward"
#define kFourDigitStr "fourDigit"
#define kFPXCompressLossyJPEGStr "FPXCompressLossyJPEG"
#define kFPXCompressNoneStr "FPXCompressNone"
#define kFPXCompressStr "FPXCompress"
#define kFPXQualityStr "FPXQuality"
#define kFPXSizeStr "FPXSize"
#define kFPXViewStr "FPXView"
#define kfragmentStr "fragment"
#define kframeFillStr "frameFill"
#define kframeFXClassStr "frameFXClass"
#define kframeFXStr "frameFX"
#define kframeStyleStr "frameStyle"
#define kframeWidthStr "frameWidth"
#define kfreeformPenToolStr "freeformPenTool"
#define kfreeTransformCenterStateStr "freeTransformCenterState"
#define kfreeTransformStr "freeTransform"
#define kfrequencyStr "frequency"
#define kfrescoStr "fresco"
#define kfromBuiltinStr "fromBuiltin"
#define kfromModeStr "fromMode"
#define kfromStr "from"
#define kfrontStr "front"
#define kFSSStr "FSS"
#define kfullDocumentStr "fullDocument"
#define kfullSizeStr "fullSize"
#define kfunctionKeyStr "functionKey"
#define kfuzzinessStr "fuzziness"
#define kgammaStr "gamma"
#define kgamutWarningStr "gamutWarning"
#define kgaussianBlurStr "gaussianBlur"
#define kgaussianDistributionStr "gaussianDistribution"
#define kGCRStr "GCR"
#define kgeneralPreferencesStr "generalPreferences"
#define kgeneralPrefsStr "generalPrefs"
#define kgeometryToolModeStr "geometryToolMode"
#define kgetStr "get"
#define kGIF89aExportStr "GIF89aExport"
#define kGIFColorFileColorsStr "GIFColorFileColors"
#define kGIFColorFileColorTableStr "GIFColorFileColorTable"
#define kGIFColorFileMicrosoftPaletteStr "GIFColorFileMicrosoftPalette"
#define kGIFColorFileTypeStr "GIFColorFileType"
#define kGIFColorLimitStr "GIFColorLimit"
#define kGIFExportCaptionStr "GIFExportCaption"
#define kGIFFormatStr "GIFFormat"
#define kGIFMaskChannelIndexStr "GIFMaskChannelIndex"
#define kGIFMaskChannelInvertedStr "GIFMaskChannelInverted"
#define kGIFPaletteAdaptiveStr "GIFPaletteAdaptive"
#define kGIFPaletteExactStr "GIFPaletteExact"
#define kGIFPaletteFileStr "GIFPaletteFile"
#define kGIFPaletteOtherStr "GIFPaletteOther"
#define kGIFPaletteSystemStr "GIFPaletteSystem"
#define kGIFPaletteTypeStr "GIFPaletteType"
#define kGIFRequiredColorSpaceIndexedStr "GIFRequiredColorSpaceIndexed"
#define kGIFRequiredColorSpaceRGBStr "GIFRequiredColorSpaceRGB"
#define kGIFRequiredColorSpaceTypeStr "GIFRequiredColorSpaceType"
#define kGIFRowOrderInterlacedStr "GIFRowOrderInterlaced"
#define kGIFRowOrderNormalStr "GIFRowOrderNormal"
#define kGIFRowOrderTypeStr "GIFRowOrderType"
#define kGIFTransparentColorStr "GIFTransparentColor"
#define kGIFTransparentIndexBlueStr "GIFTransparentIndexBlue"
#define kGIFTransparentIndexGreenStr "GIFTransparentIndexGreen"
#define kGIFTransparentIndexRedStr "GIFTransparentIndexRed"
#define kGIFUseBestMatchStr "GIFUseBestMatch"
#define kglassStr "glass"
#define kglobalAltitudeStr "globalAltitude"
#define kglobalAngleStr "globalAngle"
#define kglobalClassStr "globalClass"
#define kglobalLightingAltitudeStr "globalAltitude"
#define kglobalLightingAngleStr "globalLightingAngle"
#define kglobalObjectStr "globalObject"
#define kglossStr "gloss"
#define kglowAmountStr "glowAmount"
#define kglowingEdgesStr "glowingEdges"
#define kglowTechniqueStr "glowTechnique"
#define kgoodStr "good"
#define kgradientClassEventStr "gradientClassEvent"
#define kgradientFillStr "gradientFill"
#define kgradientFormStr "gradientForm"
#define kgradientLayerStr "gradientLayer"
#define kgradientMapClassStr "gradientMapClass"
#define kgradientMapEventStr "gradientMapEvent"
#define kgradientOverlayStr "gradientOverlay"
#define kgradientStr "gradient"
#define kgradientToolStr "gradientTool"
#define kgradientTypeStr "gradientType"
#define kgrainClumpedStr "grainClumped"
#define kgrainContrastyStr "grainContrasty"
#define kgrainEnlargedStr "grainEnlarged"
#define kgrainHorizontalStr "grainHorizontal"
#define kgraininessStr "graininess"
#define kgrainRegularStr "grainRegular"
#define kgrainSoftStr "grainSoft"
#define kgrainSpeckleStr "grainSpeckle"
#define kgrainSprinklesStr "grainSprinkles"
#define kgrainStippledStr "grainStippled"
#define kgrainStr "grain"
#define kgrainTypeStr "grainType"
#define kgrainVerticalStr "grainVertical"
#define kgrainyDotsStr "grainyDots"
#define kgraphicPenStr "graphicPen"
#define kgraphicsStr "graphics"
#define kgray16Str "gray16"
#define kgray18Str "gray18"
#define kgray22Str "gray22"
#define kgray50Str "gray50"
#define kgrayBehaviorStr "grayBehavior"
#define kgrayscaleModeStr "grayscaleMode"
#define kgrayScaleRampStr "grayScaleRamp"
#define kgrayScaleStr "grayScale"
#define kgrayscaleStr "grayscale"
#define kgraySetupStr "graySetup"
#define kgrayStr "gray"
#define kgreekLanguageStr "greekLanguage"
#define kgreenBlackPointStr "greenBlackPoint"
#define kgreenGammaStr "greenGamma"
#define kgreensStr "greens"
#define kgreenStr "green"
#define kgreenWhitePointStr "greenWhitePoint"
#define kgreenXStr "greenX"
#define kgreenYStr "greenY"
#define kgridAlignmentStr "gridAlignment"
#define kgridColorStr "gridColor"
#define kgridCustomColorStr "gridCustomColor"
#define kgridMajorStr "gridMajor"
#define kgridMinorStr "gridMinor"
#define kgridStyleStr "gridStyle"
#define kgridUnitsStr "gridUnits"
#define kgroupEventStr "groupEvent"
#define kgroupStr "group"
#define kgroutWidthStr "groutWidth"
#define kgrowStr "grow"
#define kguideGridColorStr "guideGridColor"
#define kguideGridStyleStr "guideGridStyle"
#define kguidesColorStr "guidesColor"
#define kguidesCustomColorStr "guidesCustomColor"
#define kguidesGridPreferencesStr "guidesGridPreferences"
#define kguidesPrefsStr "guidesPrefs"
#define kguidesStr "guides"
#define kguidesStyleStr "guidesStyle"
#define kguideStr "guide"
#define kgutterWidthStr "gutterWidth"
#define khalftoneFileStr "halftoneFile"
#define khalftoneScreenStr "halftoneScreen"
#define khalftoneSizeStr "halftoneSize"
#define khalftoneSpecStr "halftoneSpec"
#define khandToolStr "handTool"
#define khangingRomanStr "hangingRoman"
#define khardLightStr "hardLight"
#define khardMixStr "hardMix"
#define khardnessStr "hardness"
#define khardProofStr "hardProof"
#define kHDTVStr "HDTV"
#define kheaderStr "header"
#define kheadlineStr "headline"
#define khealFromDest2SrcStr "healFromDest2Src"
#define khealFromSrc2DestStr "healFromSrc2Dest"
#define khealingBrushToolStr "healingBrushTool"
#define khealingDirectionStr "healingDirection"
#define khealJPEGStr "healJPEG"
#define khealSelectionStr "healSelection"
#define kheavyStr "heavy"
#define kheightStr "height"
#define khelpStr "help"
#define khiddenStr "hidden"
#define khideAllStr "hideAll"
#define khideSelectionStr "hideSelection"
#define khideStr "hide"
#define khighlightAreaStr "highlightArea"
#define khighlightColorStr "highlightColor"
#define khighlightLevelsStr "highlightLevels"
#define khighlightModeStr "highlightMode"
#define khighlightOpacityStr "highlightOpacity"
#define khighlightsStr "highlights"
#define khighlightStrengthStr "highlightStrength"
#define khighPassStr "highPass"
#define khighQualityStr "highQuality"
#define khighStr "high"
#define khistogramStr "histogram"
#define khistoryBrushSourceStr "historyBrushSource"
#define khistoryBrushToolStr "historyBrushTool"
#define khistoryPaletteOptionsStr "historyPaletteOptions"
#define khistoryPreferencesStr "historyPreferences"
#define khistoryPrefsClassStr "historyPrefsClass"
#define khistoryPrefsStr "historyPrefs"
#define khistoryStateSourceStr "historyStateSource"
#define khistoryStateSourceTypeStr "historyStateSourceType"
#define khistoryStatesStr "historyStates"
#define khistoryStateStr "historyState"
#define khistoryStr "history"
#define khorizontalLocationStr "horizontalLocation"
#define khorizontalOnlyStr "horizontalOnly"
#define khorizontalScaleStr "horizontalScale"
#define khorizontalStr "horizontal"
#define khostNameStr "hostName"
#define khostVersionStr "hostVersion"
#define kHSBColorClassStr "HSBColorClass"
#define kHSBColorEnumStr "HSBColorEnum"
#define kHSBColorModeStr "HSBColorMode"
#define kHSLColorStr "HSLColor"
#define khtmlTextStr "htmlText"
#define khueSatAdjustmentStr "hueSatAdjustment"
#define khueSatAdjustmentV2Str "hueSatAdjustmentV2"
#define khueSaturationStr "hueSaturation"
#define khueStr "hue"
#define khungarianLanguageStr "hungarianLanguage"
#define khyphenateCapitalizedStr "hyphenateCapitalized"
#define khyphenateLimitStr "hyphenateLimit"
#define khyphenatePostLengthStr "hyphenatePostLength"
#define khyphenatePreLengthStr "hyphenatePreLength"
#define khyphenateStr "hyphenate"
#define khyphenateWordSizeStr "hyphenateWordSize"
#define khyphenationZoneStr "hyphenationZone"
#define kIBMPCStr "IBMPC"
#define kICCEngineStr "ICCEngine"
#define kICCSetupNameStr "ICCSetupName"
#define kICCStr "ICC"
#define kicelandicLanguageStr "icelandicLanguage"
#define kicfbottomStr "icfbottom"
#define kicftopStr "icftop"
#define kiconStr "icon"
#define kidleStr "idle"
#define kidleVMStr "idleVM"
#define kIDStr "ID"
#define kIEEE32BitFloatingPointStr "IEEE32BitFloatingPoint"
#define kIEEE64BitFloatingPointStr "IEEE64BitFloatingPoint"
#define kignoreStr "ignore"
#define killustratorPathsExportStr "illustratorPathsExport"
#define kimageBalanceStr "imageBalance"
#define kimageCachePreferencesStr "imageCachePreferences"
#define kimageInterpolationStr "imageInterpolation"
#define kimagePointStr "imagePoint"
#define kimageReferenceStr "imageReference"
#define kimageSizeStr "imageSize"
#define kimageStr "image"
#define kimageTypeStr "imageType"
#define kimportAnnotsStr "importAnnots"
#define kimportStr "import"
#define kimpressionistStr "impressionist"
#define kinAPathStr "inAPath"
#define kincludeVectorDataStr "includeVectorData"
#define kindentStr "indent"
#define kindexedColorModeStr "indexedColorMode"
#define kindexedColorStr "indexedColor"
#define kinfoPaletteOptionsStr "infoPaletteOptions"
#define kinfoPaletteToggleSamplersStr "infoPaletteToggleSamplers"
#define kinheritsStr "inherits"
#define kinkBlackStr "inkBlack"
#define kinkColorsStr "inkColors"
#define kinkOutlinesStr "inkOutlines"
#define kinksStr "inks"
#define kinkTransferStr "inkTransfer"
#define kinnerBevelStr "innerBevel"
#define kinnerGlowSourceStr "innerGlowSource"
#define kinnerGlowSourceTypeStr "innerGlowSourceType"
#define kinnerGlowStr "innerGlow"
#define kinnerShadowStr "innerShadow"
#define kinputMapRangeStr "inputMapRange"
#define kinputRangeStr "inputRange"
#define kinputStr "input"
#define kinsetFrameStr "insetFrame"
#define kinsideStr "inside"
#define kinStr "in"
#define kintegerChannelStr "integerChannel"
#define kintegerStr "integer"
#define kintensityStr "intensity"
#define kintentStr "intent"
#define kinteractLevelAttrStr "interactLevelAttr"
#define kinterfaceBevelHighlightStr "interfaceBevelHighlight"
#define kinterfaceBevelShadowStr "interfaceBevelShadow"
#define kinterfaceBlackStr "interfaceBlack"
#define kinterfaceBorderStr "interfaceBorder"
#define kinterfaceButtonDarkShadowStr "interfaceButtonDarkShadow"
#define kinterfaceButtonDownFillStr "interfaceButtonDownFill"
#define kinterfaceButtonUpFillStr "interfaceButtonUpFill"
#define kinterfaceColorBlue2Str "interfaceColorBlue2"
#define kinterfaceColorBlue32Str "interfaceColorBlue32"
#define kinterfaceColorGreen2Str "interfaceColorGreen2"
#define kinterfaceColorGreen32Str "interfaceColorGreen32"
#define kinterfaceColorRed2Str "interfaceColorRed2"
#define kinterfaceColorRed32Str "interfaceColorRed32"
#define kinterfaceColorStr "interfaceColor"
#define kinterfaceIconFillActiveStr "interfaceIconFillActive"
#define kinterfaceIconFillDimmedStr "interfaceIconFillDimmed"
#define kinterfaceIconFillSelectedStr "interfaceIconFillSelected"
#define kinterfaceIconFrameActiveStr "interfaceIconFrameActive"
#define kinterfaceIconFrameDimmedStr "interfaceIconFrameDimmed"
#define kinterfaceIconFrameSelectedStr "interfaceIconFrameSelected"
#define kinterfacePaletteFillStr "interfacePaletteFill"
#define kinterfaceRedStr "interfaceRed"
#define kinterfaceToolTipBackgroundStr "interfaceToolTipBackground"
#define kinterfaceToolTipTextStr "interfaceToolTipText"
#define kinterfaceTransparencyBackgroundStr "interfaceTransparencyBackground"
#define kinterfaceTransparencyForegroundStr "interfaceTransparencyForeground"
#define kinterfaceWhiteStr "interfaceWhite"
#define kinterlaceCreateTypeStr "interlaceCreateType"
#define kinterlaceEliminateTypeStr "interlaceEliminateType"
#define kinterlaceStr "interlace"
#define kinterpolationMethodStr "interpolationMethod"
#define kinterpolationStr "interpolation"
#define kinterpolationTypeStr "interpolationType"
#define kintersectStr "intersect"
#define kintersectWithStr "intersectWith"
#define kinverseStr "inverse"
#define kinvertMaskStr "invertMask"
#define kinvertSource2Str "invertSource2"
#define kinvertStr "invert"
#define kinvertTextureStr "invertTexture"
#define kisDirtyStr "isDirty"
#define kitalianLanguageStr "italianLanguage"
#define kitalicStr "italic"
#define kitemIndexStr "itemIndex"
#define kjapaneseStr "japanese"
#define kjitterStr "jitter"
#define kjobNameStr "jobName"
#define kJPEGFormatStr "JPEGFormat"
#define kJPEGQualityStr "JPEGQuality"
#define kJPEGStr "JPEG"
#define kjumptoStr "jumpto"
#define kjustificationGlyphDesiredStr "justificationGlyphDesired"
#define kjustificationGlyphMaximumStr "justificationGlyphMaximum"
#define kjustificationGlyphMinimumStr "justificationGlyphMinimum"
#define kjustificationLetterDesiredStr "justificationLetterDesired"
#define kjustificationLetterMaximumStr "justificationLetterMaximum"
#define kjustificationLetterMinimumStr "justificationLetterMinimum"
#define kjustificationWordDesiredStr "justificationWordDesired"
#define kjustificationWordMaximumStr "justificationWordMaximum"
#define kjustificationWordMinimumStr "justificationWordMinimum"
#define kjustifyAllStr "justifyAll"
#define kjustifyCenterStr "justifyCenter"
#define kjustifyFullStr "justifyFull"
#define kjustifyLeftStr "justifyLeft"
#define kjustifyRightStr "justifyRight"
#define kkeepProfileStr "keepProfile"
#define kkelvinCustomWhitePointStr "kelvinCustomWhitePoint"
#define kkelvinStr "kelvin"
#define kkernelProcessIDStr "kernelProcessID"
#define kkerningStr "kerning"
#define kkeyboardPreferencesStr "keyboardPreferences"
#define kkeywordsStr "keywords"
#define kkeywordStr "keyword"
#define kkindStr "kind"
#define kkinsokuSetNameStr "kinsokuSetName"
#define kknockoutStr "knockout"
#define kknockoutBlockingStr "knockoutBlocking"
#define klab48Str "lab48"
#define klabColorModeStr "labColorMode"
#define klabColorStr "labColor"
#define klabelsStr "labels"
#define klabStr "lab"
#define klandscapeStr "landscape"
#define klargeStr "large"
#define klassoToolStr "lassoTool"
#define klastFilterStr "lastFilter"
#define klastStr "last"
#define klastTransformStr "lastTransform"
#define klayerConcealsStr "layerConceals"
#define klayerEffectsStr "layerEffects"
#define klayerFXVisibleStr "layerFXVisible"
#define klayerIDStr "layerID"
#define klayerLockingStr "layerLocking"
#define klayerMaskAsGlobalMaskStr "layerMaskAsGlobalMask"
#define klayerNameStr "layerName"
#define klayerOptionsStr "layerOptions"
#define klayerSectionContentStr "layerSectionContent"
#define klayerSectionEndStr "layerSectionEnd"
#define klayerSectionStartStr "layerSectionStart"
#define klayerSectionStr "layerSection"
#define klayerSectionTypeStr "layerSectionType"
#define klayerSetFromLinkedEventStr "layerSetFromLinkedEvent"
#define klayersPaletteOptionsStr "layersPaletteOptions"
#define klayersStr "layers"
#define klayerStr "layer"
#define kleadingAboveStr "leadingAbove"
#define kleadingBelowStr "leadingBelow"
#define kleadingStr "leading"
#define kleadingTypeStr "leadingType"
#define kleAdobeOnlineWebStr "leAdobeOnlineWeb"
#define kleftPluginStr "leftPlugin"
#define kleftStr "left"
#define kleHelpContentStr "leHelpContent"
#define kleHelpSupportStr "leHelpSupport"
#define klengthStr "length"
#define klensFlareStr "lensFlare"
#define klensStr "lens"
#define kleSystemInfoStr "leSystemInfo"
#define kleTutorialsStr "leTutorials"
#define kleUserForumsStr "leUserForums"
#define klevelBasedStr "levelBased"
#define klevelsAdjustmentStr "levelsAdjustment"
#define klevelsStr "levels"
#define klevelStr "level"
#define kligatureStr "ligature"
#define klightBlueStr "lightBlue"
#define klightDarkStr "lightDark"
#define klightDirBottomLeftStr "lightDirBottomLeft"
#define klightDirBottomRightStr "lightDirBottomRight"
#define klightDirBottomStr "lightDirBottom"
#define klightDirectionalStr "lightDirectional"
#define klightDirectionStr "lightDirection"
#define klightDirLeftStr "lightDirLeft"
#define klightDirRightStr "lightDirRight"
#define klightDirTopLeftStr "lightDirTopLeft"
#define klightDirTopRightStr "lightDirTopRight"
#define klightDirTopStr "lightDirTop"
#define klightenGroutStr "lightenGrout"
#define klightenOnlyStr "lightenOnly"
#define klightenStr "lighten"
#define klightGrayStr "lightGray"
#define klightingEffectsStr "lightingEffects"
#define klightIntensityStr "lightIntensity"
#define klightnessStr "lightness"
#define klightOmniStr "lightOmni"
#define klightPosBottomLeftStr "lightPosBottomLeft"
#define klightPosBottomRightStr "lightPosBottomRight"
#define klightPosBottomStr "lightPosBottom"
#define klightPositionStr "lightPosition"
#define klightPosLeftStr "lightPosLeft"
#define klightPosRightStr "lightPosRight"
#define klightPosTopLeftStr "lightPosTopLeft"
#define klightPosTopRightStr "lightPosTopRight"
#define klightPosTopStr "lightPosTop"
#define klightRedStr "lightRed"
#define klightSourceStr "lightSource"
#define klightSpotStr "lightSpot"
#define klightStr "light"
#define klightTypeStr "lightType"
#define klimitedStr "limited"
#define klinearBurnStr "linearBurn"
#define klinearDodgeStr "linearDodge"
#define klinearLightStr "linearLight"
#define klinearStr "linear"
#define klineClassStr "lineClass"
#define klinesStr "lines"
#define klineStr "line"
#define klineToolStr "lineTool"
#define klinkedLayerIDsStr "linkedLayerIDs"
#define klinkedStr "linked"
#define klinkStr "link"
#define klinkToOtherEffectsStr "linkToOtherEffects"
#define klocalLightingAltitudeStr "localLightingAltitude"
#define klocalLightingAngleStr "localLightingAngle"
#define klocalRangeStr "localRange"
#define klocationReferenceStr "locationReference"
#define klocationStr "location"
#define klogStr "log"
#define klongFloatStr "longFloat"
#define klongIntegerStr "longInteger"
#define klongLinesStr "longLines"
#define klongStrokesStr "longStrokes"
#define klowerCaseExtensionStr "lowerCaseExtension"
#define klowerCaseSerialStr "lowerCaseSerial"
#define klowerCaseStr "lowerCase"
#define klowerStr "lower"
#define klowQualityStr "lowQuality"
#define klowStr "low"
#define kluminanceStr "luminance"
#define kluminosityStr "luminosity"
#define kLUTAnimationStr "LUTAnimation"
#define kLZWCompressionStr "LZWCompression"
#define kmacintoshStr "macintosh"
#define kmacintoshSystemStr "macintoshSystem"
#define kmacPaintFormatStr "macPaintFormat"
#define kmacThumbnailStr "macThumbnail"
#define kmagentasStr "magentas"
#define kmagentaStr "magenta"
#define kmagicEraserToolStr "magicEraserTool"
#define kmagicPointStr "magicPoint"
#define kmagicStampToolStr "magicStampTool"
#define kmagicWandToolStr "magicWandTool"
#define kmagneticLassoToolStr "magneticLassoTool"
#define kmagnitudeStr "magnitude"
#define kmakeShapeLayersStr "makeShapeLayers"
#define kmakeStr "make"
#define kmakeVisibleStr "makeVisible"
#define kmanageStr "manage"
#define kmanipulationFOVStr "manipulationFOV"
#define kmapBlackStr "mapBlack"
#define kmappingShapeStr "mappingShape"
#define kmappingStr "mapping"
#define kmarqueeEllipToolStr "marqueeEllipTool"
#define kmarqueeRectToolStr "marqueeRectTool"
#define kmaskedAreasStr "maskedAreas"
#define kmaskIndicatorStr "maskIndicator"
#define kmaskStr "mask"
#define kmasterAdaptiveStr "masterAdaptive"
#define kmasterDiameterStr "masterDiameter"
#define kmasterFXSwitchStr "masterFXSwitch"
#define kmasterPerceptualStr "masterPerceptual"
#define kmasterSelectiveStr "masterSelective"
#define kmaterialStr "material"
#define kmatrixStr "matrix"
#define kmatteColorStr "matteColor"
#define kmatteStr "matte"
#define kmatteTechniqueStr "matteTechnique"
#define kmaximizeCompatibility "maximizeCompatibility"
#define kmaximumEnumStr "maximumEnum"
#define kmaximumQualityStr "maximumQuality"
#define kmaximumStatesStr "maximumStates"
#define kmaximumStr "maximum"
#define kmeasureToolStr "measureTool"
#define kmedianStr "median"
#define kmediumBlueStr "mediumBlue"
#define kmediumDotsStr "mediumDots"
#define kmediumLinesStr "mediumLines"
#define kmediumQualityStr "mediumQuality"
#define kmediumStr "medium"
#define kmediumStrokesStr "mediumStrokes"
#define kmemoryPreferencesStr "memoryPreferences"
#define kmemoryUsagePercentStr "memoryUsagePercent"
#define kmenuItemClassStr "menuItemClass"
#define kmenuItemTypeStr "menuItemType"
#define kmergeChannelsStr "mergeChannels"
#define kmergedLayersStr "mergedLayers"
#define kmergedStr "merged"
#define kmergeLayersStr "mergeLayers"
#define kmergeSpotChannelStr "mergeSpotChannel"
#define kmergeStr "merge"
#define kmergeVisibleStr "mergeVisible"
#define kmessageStr "message"
#define kmethodStr "method"
#define kmezzotintStr "mezzotint"
#define kmezzotintTypeStr "mezzotintType"
#define kmiddleStr "middle"
#define kmidpointStr "midpoint"
#define kmidtoneLevelsStr "midtoneLevels"
#define kmidtonesStr "midtones"
#define kmillimetersUnitStr "millimetersUnit"
#define kminDepthStr "minimumDepth"
#define kminDiameterStr "minimumDiameter"
#define kminimumStr "minimum"
#define kminRoundnessStr "minimumRoundness"
#define kminScaleStr "minimumScale"
#define kmismatchCMYKStr "mismatchCMYK"
#define kmismatchGrayStr "mismatchGray"
#define kmismatchRGBStr "mismatchRGB"
#define kmissedKeywordAttrStr "missedKeywordAttr"
#define kmmddStr "mmdd"
#define kmmddyyStr "mmddyy"
#define kmodeGrayStr "modeGray"
#define kmodeRGBStr "modeRGB"
#define kmodeStr "mode"
#define kmojiKumiNameStr "mojiKumiName"
#define kmojiZumeStr "mojiZume"
#define kmonitorCompressionStr "monitorCompression"
#define kmonitorRGBStr "monitorRGB"
#define kmonitorSetupStr "monitorSetup"
#define kmonitorStr "monitor"
#define kmonochromaticStr "monochromatic"
#define kmonotoneStr "monotone"
#define kmosaicPluginStr "mosaicPlugin"
#define kmosaicStr "mosaic"
#define kmotionBlurStr "motionBlur"
#define kmoveStr "move"
#define kmoveToolStr "moveTool"
#define kmoveToolOnCommit "moveToolOnCommit"
#define kmoveToStr "moveTo"
#define kmulti72ColorStr "multi72Color"
#define kmulti72GrayStr "multi72Gray"
#define kmultichannelModeStr "multichannelMode"
#define kmultichannelStr "multichannel"
#define kmultiNoCompositePSStr "multiNoCompositePS"
#define kmultiplyStr "multiply"
#define knameStr "name"
#define knavigatorPaletteOptionsStr "navigatorPaletteOptions"
#define knearestNeighborStr "nearestNeighbor"
#define knegativeStr "negative"
#define kneonGlowStr "neonGlow"
#define knetscapeGrayStr "netscapeGray"
#define kneutralsStr "neutrals"
#define knewDocPresetPrintResolutionStr "newDocPresetPrintResolution"
#define knewDocPresetPrintScaleStr "newDocPresetPrintScale"
#define knewDocPresetScreenResolutionStr "newDocPresetScreenResolution"
#define knewDocPresetScreenScaleStr "newDocPresetScreenScale"
#define knewGuideStr "newGuide"
#define knewStr "new"
#define knewViewStr "newView"
#define knextStr "next"
#define knikon105Str "nikon105"
#define knikonStr "nikon"
#define knoBreakStr "noBreak"
#define knoCompositePSStr "noCompositePS"
#define knoImageStr "noImage"
#define knoiseStr "noise"
#define knoneStr "none"
#define knoneUnitStr "noneUnit"
#define knonImageDataStr "nonImageData"
#define knonLinearStr "nonLinear"
#define knormalPathStr "normalPath"
#define knormalStr "normal"
#define knoStr "no"
#define knoteLocationStr "noteLocation"
#define knotePaperStr "notePaper"
#define knotifyStr "notify"
#define kNTSCColorsStr "NTSCColors"
#define kNTSCStr "NTSC"
#define knullStr "null"
#define knumberOfCacheLevelsStr "numberOfCacheLevels"
#define knumberOfChannelsStr "numberOfChannels"
#define knumberOfChildrenStr "numberOfChildren"
#define knumberOfDocumentsStr "numberOfDocuments"
#define knumberOfGeneratorsStr "numberOfGenerators"
#define knumberOfLayersStr "numberOfLayers"
#define knumberOfLevelsStr "numberOfLevels"
#define knumberOfPathsStr "numberOfPaths"
#define knumberOfRipplesStr "numberOfRipples"
#define knumberOfSiblingsStr "numberOfSiblings"
#define knumberStr "number"
#define knumLightsStr "numLights"
#define knynorskNorwegianLanguageStr "nynorskNorwegianLanguage"
#define kobjectNameStr "objectName"
#define kobjectReferenceStr "objectReference"
#define kobjectStr "object"
#define kobsoleteTextLayerStr "obsoleteTextLayer"
#define koceanRippleStr "oceanRipple"
#define koffsetStr "offset"
#define koffStr "off"
#define koldGermanLanguageStr "oldGermanLanguage"
#define koldStyleStr "oldStyle"
#define konACurveStr "onACurve"
#define koneDigitStr "oneDigit"
#define konOffStr "onOff"
#define konStr "on"
#define kopacityClassStr "opacityClass"
#define kopacityStr "opacity"
#define kopenAsStr "openAs"
#define kopenStr "open"
#define koptimizedStr "optimized"
#define koptionalKeywordAttrStr "optionalKeywordAttr"
#define korangeStr "orange"
#define kordinalStr "ordinal"
#define korientationStr "orientation"
#define koriginalAddressAttrStr "originalAddressAttr"
#define koriginalHeaderStr "originalHeader"
#define koriginalTransmissionReferenceStr "originalTransmissionReference"
#define kOS2Str "OS2"
#define kotherCursorsStr "otherCursors"
#define kouterBevelStr "outerBevel"
#define kouterGlowStr "outerGlow"
#define koutFromCenterStr "outFromCenter"
#define koutOfGamutStr "outOfGamut"
#define koutputStr "output"
#define koutsetFrameStr "outsetFrame"
#define koutsideStr "outside"
#define koverlapStr "overlap"
#define koverlayStr "overlay"
#define koverprintColorsStr "overprintColors"
#define koverrideOpenStr "overrideOpen"
#define koverridePrinterStr "overridePrinter"
#define koverrideSaveStr "overrideSave"
#define kP22EBUStr "P22EBU"
#define kpageFormatStr "pageFormat"
#define kpageNumberStr "pageNumber"
#define kpagePosCenteredStr "pagePosCentered"
#define kpagePositionStr "pagePosition"
#define kpagePosTopLeftStr "pagePosTopLeft"
#define kpageSetupStr "pageSetup"
#define kpaintbrushEraserStr "paintbrushEraser"
#define kpaintbrushToolStr "paintbrushTool"
#define kpaintDaubsStr "paintDaubs"
#define kpaintingCursorsStr "paintingCursors"
#define kpaintStr "paint"
#define kpaintStrokeStr "paintStroke"
#define kpaintTypeStr "paintType"
#define kpaletteFileStr "paletteFile"
#define kpaletteKnifeStr "paletteKnife"
#define kpaletteStr "palette"
#define kpalSecamStr "palSecam"
#define kpanaVisionStr "panaVision"
#define kpaperBrightnessStr "paperBrightness"
#define kpaperWhiteStr "paperWhite"
#define kparagraphStyleRangeStr "paragraphStyleRange"
#define kparagraphStyleStr "paragraphStyle"
#define kparentIndexStr "parentIndex"
#define kparentNameStr "parentName"
#define kpassThroughStr	"passThrough"
#define kpasswordsStr "passwords"
#define kpasteEffectsStr "pasteEffects"
#define kpasteIntoStr "pasteInto"
#define kpasteNewDocStr "pasteNewDocument"
#define kpasteOutsideStr "pasteOutside"
#define kpasteStr "paste"
#define kpatchSelectionStr "patchSelection"
#define kpatchworkStr "patchwork"
#define kpathClassStr "pathClass"
#define kpathComponentSelectToolStr "pathComponentSelectTool"
#define kpathComponentsStr "pathComponents"
#define kpathComponentStr "pathComponent"
#define kpathContentsStr "pathContents"
#define kpathKindStr "pathKind"
#define kpathNameStr "pathName"
#define kpathOperationStr "pathOperation"
#define kpathPointStr "pathPoint"
#define kpathReferenceStr "pathReference"
#define kpathsPaletteOptionsStr "pathsPaletteOptions"
#define kpathStr "path"
#define kpatternDitherStr "patternDither"
#define kpatternFillClassStr "patternFillClass"
#define kpatternFillStr	"patternFill"
#define kpatternKeyStr "patternKey"
#define kpatternLayerStr "patternLayer"
#define kpatternOverlayStr "patternOverlay"
#define kpatternStampToolStr "patternStampTool"
#define kpatternStr "pattern"
#define kpauseForAudioStr "pauseForAudio"
#define kpauseStr "pause"
#define kPDFGenericFormatStr "PDFGenericFormat"
#define kpencilEraserStr "pencilEraser"
#define kpencilToolStr "pencilTool"
#define kpencilWidthStr "pencilWidth"
#define kpenToolStr "penTool"
#define kpercentUnitStr "percentUnit"
#define kperceptualStr "perceptual"
#define kperformanceStr "performance"
#define kperspectiveIndexStr "perspectiveIndex"
#define kperspectiveStr "perspective"
#define kphaseStr "phase"
#define kphosphorsCustomPhosphorsStr "phosphorsCustomPhosphors"
#define kphosphorsStr "phosphors"
#define kphotocopyStr "photocopy"
#define kphotoshop20FormatStr "photoshop20Format"
#define kphotoshop35FormatStr "photoshop35Format"
#define kphotoshopDCS2FormatStr "photoshopDCS2Format"
#define kphotoshopDCSFormatStr "photoshopDCSFormat"
#define kphotoshopEPSFormatStr "photoshopEPSFormat"
#define kphotoshopPDFFormatStr "photoshopPDFFormat"
#define kphotoshopPickerStr "photoshopPicker"
#define kpickCMYKStr "pickCMYK"
#define kpickerIDStr "pickerID"
#define kpickerKindStr "pickerKind"
#define kpickerKindTypeStr "pickerKindType"
#define kpickGrayStr "pickGray"
#define kpickHSBStr "pickHSB"
#define kpickLabStr "pickLab"
#define kpickOptionsStr "pickOptions"
#define kpickRGBStr "pickRGB"
#define kpickWebStr "pickWeb"
#define kPICTFileFormatStr "PICTFileFormat"
#define kPICTResourceFormatStr "PICTResourceFormat"
#define kpillowEmbossStr "pillowEmboss"
#define kpinchStr "pinch"
#define kpInheritsStr "pInherits"
#define kpinLightStr "pinLight"
#define kpixelDoublingStr "pixelDoubling"
#define kpixelPaintFormatStr "pixelPaintFormat"
#define kpixelPaintSize1Str "pixelPaintSize1"
#define kpixelPaintSize2Str "pixelPaintSize2"
#define kpixelPaintSize3Str "pixelPaintSize3"
#define kpixelPaintSize4Str "pixelPaintSize4"
#define kpixelPaintSizeStr "pixelPaintSize"
#define kpixelsAcrossStr "pixelsAcross"
#define kpixelsDownStr "pixelsDown"
#define kpixelStr "pixel"
#define kpixelsUnitStr "pixelsUnit"
#define kplaceEnumStr "placeEnum"
#define kplaceEventStr "placeEvent"
#define kplasterStr "plaster"
#define kplasticWrapStr "plasticWrap"
#define kplatformStr "platform"
#define kplaybackOptionsStr "playbackOptions"
#define kplayStr "play"
#define kpluginFolderStr "pluginFolder"
#define kpluginPickerStr "pluginPicker"
#define kpluginPrefsStr "pluginPrefs"
#define kpluginsScratchDiskPreferencesStr "pluginsScratchDiskPreferences"
#define kPNGFilterAdaptiveStr "PNGFilterAdaptive"
#define kPNGFilterAverageStr "PNGFilterAverage"
#define kPNGFilterNoneStr "PNGFilterNone"
#define kPNGFilterPaethStr "PNGFilterPaeth"
#define kPNGFilterStr "PNGFilter"
#define kPNGFilterSubStr "PNGFilterSub"
#define kPNGFilterUpStr "PNGFilterUp"
#define kPNGFormatStr "PNGFormat"
#define kPNGInterlaceAdam7Str "PNGInterlaceAdam7"
#define kPNGInterlaceNoneStr "PNGInterlaceNone"
#define kPNGInterlaceTypeStr "PNGInterlaceType"
#define kpoint16Str "point16"
#define kpointillizeStr "pointillize"
#define kpointsStr "points"
#define kpointStr "point"
#define kpointsUnitStr "pointsUnit"
#define kpolarStr "polar"
#define kpolarToRectStr "polarToRect"
#define kpolicyCMYKStr "policyCMYK"
#define kpolicyGrayStr "policyGray"
#define kpolicyRGBStr "policyRGB"
#define kpolicyStr "policy"
#define kpolishLanguageStr "polishLanguage"
#define kpolygonStr "polygon"
#define kpolygonToolStr "polygonTool"
#define kpolySelToolStr "polySelTool"
#define kpondRipplesStr "pondRipples"
#define kpositionStr "position"
#define kposterEdgesStr "posterEdges"
#define kposterizationStr "posterization"
#define kposterizeStr "posterize"
#define kpostScriptColorStr "postScriptColor"
#define kpreciseMatteStr "preciseMatte"
#define kpreciseStr "precise"
#define kpredefinedColorsStr "predefinedColors"
#define kpreferEnhancedTIFFStr "preferEnhancedTIFF"
#define kpreferBuiltinStr "preferBuiltin"
#define kpreferencesClassStr "preferencesClass"
#define kpreferencesStr "preferences"
#define kpreferredKinsokuOrderStr "preferredKinsokuOrder"
#define kpreserveAdditionalStr "preserveAdditional"
#define kpreserveLuminosityStr "preserveLuminosity"
#define kpreserveStr "preserve"
#define kpreserveTransparencyStr "preserveTransparency"
#define kpresetManagerCommandStr "presetManager"
#define kpressureStr "pressure"
#define kpreviewBlackStr "previewBlack"
#define kpreviewCMYKEnumStr "previewCMYKEnum"
#define kpreviewCMYKStr "previewCMYK"
#define kpreviewCMYKTypeStr "previewCMYKType"
#define kpreviewCMYStr "previewCMY"
#define kpreviewCyanStr "previewCyan"
#define kpreviewFullSizeStr "previewFullSize"
#define kpreviewIconStr "previewIcon"
#define kpreviewMacThumbnailStr "previewMacThumbnail"
#define kpreviewMagentaStr "previewMagenta"
#define kpreviewOffStr "previewOff"
#define kpreviewsQueryStr "previewsQuery"
#define kpreviewStr "preview"
#define kpreviewWinThumbnailStr "previewWinThumbnail"
#define kpreviewYellowStr "previewYellow"
#define kpreviousStr "previous"
#define kprimariesStr "primaries"
#define kprintingInksSetupStr "printingInksSetup"
#define kprintOnWebStr "printOnWeb"
#define kprintOptionsStr "printOptions"
#define kprintResolutionStr "printerResolution"  // mscarafone 4/13/00
#define kprintSettingsStr "printSettings"
#define kprintSizeStr "printSize"
#define kprintStr "print"
#define kprintKeysStr "printKeys"
#define kprintKeysTypeStr "printKeysType"
#define kprintToFitStr "printToFit" // mscarafone 4/19/00
#define kprocessSerialNumberStr "processSerialNumber"
#define kprofileMismatchStr "profileMismatch"
#define kprofileSetupStr "profileSetup"
#define kprofileStr "profile"
#define kprofileToProfileStr "profileToProfile"
#define kPromptedForColorSetup "promptedForColorSetup"
#define kproofBlackStr "proofBlack"
#define kproofCMYKStr "proofCMYK"
#define kproofCMYStr "proofCMY"
#define kproofCustomStr "proofCustom"
#define kproofCyanStr "proofCyan"
#define kproofInkBlackStr "proofInkBlack"
#define kproofMacintoshStr "proofMacintosh"
#define kproofMagentaStr "proofMagenta"
#define kproofMonitorStr "proofMonitor"
#define kproofPaperWhiteStr "proofPaperWhite"
#define kproofSetupStr "proofSetup"
#define kproofWindowsStr "proofWindows"
#define kproofYellowStr "proofYellow"
#define kpropertyStr "property"
#define kproportionalNumbersStr "proportionalNumbers"
#define kProtectAllStr "protectAll"
#define kProtectCompositeStr "protectComposite"
#define kProtectNoneStr	"protectNone"
#define kProtectPositionStr "protectPosition"
#define kprotectTextureStr "protectTexture"
#define kProtectTransparencyStr "protectTransparency"
#define kprovinceStateStr "provinceState"
#define kpublicDomainStr "publicDomain"
#define kpurgeItemStr "purgeItem"
#define kpurgeStr "purge"
#define kpurityStr "purity"
#define kpurpleStr "purple"
#define kpushInStr "pushIn"
#define kpushOutStr "pushOut"
#define kpyramidsStr "pyramids"
#define kQCSAverageStr "QCSAverage"
#define kQCSCorner0Str "QCSCorner0"
#define kQCSCorner1Str "QCSCorner1"
#define kQCSCorner2Str "QCSCorner2"
#define kQCSCorner3Str "QCSCorner3"
#define kQCSIndependentStr "QCSIndependent"
#define kQCSSide0Str "QCSSide0"
#define kQCSSide1Str "QCSSide1"
#define kQCSSide2Str "QCSSide2"
#define kQCSSide3Str "QCSSide3"
#define kQDRectangleStr "QDRectangle"
#define kquadCenterStateStr "quadCenterState"
#define kquadCorner0Str "quadCorner0"
#define kquadCorner1Str "quadCorner1"
#define kquadCorner2Str "quadCorner2"
#define kquadCorner3Str "quadCorner3"
#define kquadrilateralStr "quadrilateral"
#define kquadtoneStr "quadtone"
#define kqualityStr "quality"
#define kqueryAlwaysStr "queryAlways"
#define kqueryAskStr "queryAsk"
#define kqueryNeverStr "queryNever"
#define kqueryStateStr "queryState"
#define kquickMaskStr "quickMask"
#define kquitStr "quit"
#define kradialBlurStr "radialBlur"
#define kradialStr "radial"
#define kradiusStr "radius"
#define krandomSeedStr "randomSeed"
#define krandomStr "random"
#define krangeStr "range"
#define krasterizeAllStr "rasterizeAll"
#define krasterizeContentStr "rasterizeContent"
#define krasterizeItemStr "rasterizeItem"
#define krasterizeLayerStr "rasterizeLayer"
#define krasterizeLinkedStr "rasterizeLinked"
#define krasterizeShapeStr "rasterizeShape"
#define krasterizeStr "rasterize"
#define krasterizeTypeLayerStr "rasterizeTypeLayer"
#define krasterizeVectorMaskStr "rasterizeVectorMask"
#define kratioStr "ratio"
#define krawDataStr "rawData"
#define krawFormatStr "rawFormat"
#define krecentFilesStr "recentFiles"
#define krect16Str "rect16"
#define krectangleStr "rectangle"
#define krectangleToolStr "rectangleTool"
#define krectStr "rect"
#define krectToPolarStr "rectToPolar"
#define kredBlackPointStr "redBlackPoint"
#define kredGammaStr "redGamma"
#define kredoStr "redo"
#define kredoTypeStr "redoType"
#define kredrawCompleteStr "redrawComplete"
#define kredsStr "reds"
#define kredStr "red"
#define kredWhitePointStr "redWhitePoint"
#define kredXStr "redX"
#define kredYStr "redY"
#define kreflectedStr "reflected"
#define kregistrationMarksStr "registrationMarks"
#define krelativeStr "relative"
#define kreliefStr "relief"
#define kremoveBlackMatteStr "removeBlackMatte"
#define kremoveLayerMaskStr "removeLayerMask"
#define kremoveWhiteMatteStr "removeWhiteMatte"
#define krenameStr "rename"
#define krenderFidelityStr "renderFidelity"
#define krepeatEdgePixelsStr "repeatEdgePixels"
#define krepeatStr "repeat"
#define kreplaceColorStr "replaceColor"
#define kreplaceExistingStr "replaceExisting"
#define kreplaceStr "replace"
#define kreplaceSubstitutesStr "replaceSubstitutes"
#define kresampleStr "resample"
#define kresetPalettesStr "resetPalettes"
#define kresetStr "reset"
#define kresizeStr "resize"
#define kresizeWindowsOnZoomStr "resizeWindowsOnZoom"
#define kresolutionStr "resolution"
#define kresourceIDStr "resourceID"
#define kresponseStr "response"
#define kretainHeaderStr "retainHeader"
#define kreticulationStr "reticulation"
#define kreturnIDAttrStr "returnIDAttr"
#define krevealAllStr "revealAll"
#define krevealSelectionStr "revealSelection"
#define kreverseStr "reverse"
#define krevertStr "revert"
#define kRGB48Str "RGB48"
#define kRGBBlendGammaStr "RGBBlendGamma"
#define kRGBColorModeStr "RGBColorMode"
#define kRGBColorStr "RGBColor"
#define kRGBSetupClassStr "RGBSetupClass"
#define kRGBSetupSourceStr "RGBSetupSource"
#define kRGBSetupStr "RGBSetup"
#define kRGBSpectrumStr "RGBSpectrum"
#define kRGBStr "RGB"
#define krightStr "right"
#define krippleMagnitudeStr "rippleMagnitude"
#define krippleSizeStr "rippleSize"
#define krippleStr "ripple"
#define kroundnessDynamicsStr "roundnessDynamics"
#define krolloverStr "rollover"
#define kromanStr "roman"
#define krotateEventEnumStr "rotateEventEnum"
#define krotateStr "rotate"
#define krotoscopingPreferencesStr "rotoscopingPreferences"
#define kroughPastelsStr "roughPastels"
#define kroundedRectangleToolStr "roundedRectangleTool"
#define kroundnessStr "roundness"
#define kroundStr "round"
#define krulerCmStr "rulerCm"
#define krulerInchesStr "rulerInches"
#define krulerMmStr "rulerMm"
#define krulerOriginHStr "rulerOriginH"
#define krulerOriginVStr "rulerOriginV"
#define krulerPercentStr "rulerPercent"
#define krulerPicasStr "rulerPicas"
#define krulerPixelsStr "rulerPixels"
#define krulerPointsStr "rulerPoints"
#define krulerUnitsStr "rulerUnits"
#define krumanianLanguageStr "rumanianLanguage"
#define krussianLanguageStr "russianLanguage"
#define ksample3x3Str "sample3x3"
#define ksample5x5Str "sample5x5"
#define ksampledBrushStr "sampledBrush"
#define ksampledDataStr "sampledData"
#define ksamplePointStr "samplePoint"
#define ksaturateStr "saturate"
#define ksaturationStr "saturation"
#define ksaturationToolStr "saturationTool"
#define ksaveAndCloseStr "saveAndClose"
#define ksaveCompositeStr "saveComposite"
#define ksavedStr "saved"
#define ksaveForWebStr "saveForWeb"
#define ksavePaletteLocationsStr "savePaletteLocations"
#define ksavePathsStr "savePaths"
#define ksavePyramidsStr "savePyramids"
#define ksaveStr "save"
#define ksaveTransparencyStr "saveTransparency"
#define ksaveWorkspaceStr "saveWorkspace"
#define ksavingFilesPreferencesStr "savingFilesPreferences"
#define ksavingStr "saving"
#define kscaleEffectsEventStr "scaleEffectsEvent"
#define kscaleEffectsStr "scaleEffects"
#define kscaleHorizontalStr "scaleHorizontal"
#define kscaleStr "scale"
#define kscaleVerticalStr "scaleVertical"
#define kscalingStr "scaling"
#define kscansStr "scans"
#define kscatterStr "scatter"
#define kscatterDynamicsStr "scatterDynamics"
#define kscitexCTFormatStr "scitexCTFormat"
#define kscratchDisksStr "scratchDisks"
#define kscreenCircleStr "screenCircle"
#define kscreenDotStr "screenDot"
#define kscreenFileStr "screenFile"
#define kscreenLineStr "screenLine"
#define kscreenStr "screen"
#define kscreenTypeStr "screenType"
#define ksectionHStr "sectionH"
#define kselectedAreasStr "selectedAreas"
#define kselectedItemsStr	"selectedItems"
#define kselectionClassStr "selectionClass"
#define kselectionEnumStr "selectionEnum"
#define kselectionStr "selection"
#define kselectiveColorStr "selectiveColor"
#define kselectiveStr "selective"
#define kselectStr "select"
#define kseparationSetupStr "separationSetup"
#define kseparationsStr "separations"
#define kseparationTablesStr "separationTables"
#define kserbianLanguageStr "serbianLanguage"
#define kserialStringStr "serialString"
#define ksessionIDStr "sessionID"
#define ksetStr "set"
#define kshadeStr "shade"
#define kshadingIntensityStr "shadingIntensity"
#define kshadingNoiseStr "shadingNoise"
#define kshadingShapeStr "shadingShape"
#define kshadowColorStr "shadowColor"
#define kshadowIntensityStr "shadowIntensity"
#define kshadowLevelsStr "shadowLevels"
#define kshadowModeStr "shadowMode"
#define kshadowOpacityStr "shadowOpacity"
#define kshadowsStr "shadows"
#define kshallowStr "shallow"
#define kshapeburstStr "shapeburst"
#define kshapeClassStr "shapeClass"
#define kshapeOperationStr "shapeOperation"
#define kshapeStr "shape"
#define ksharpenEdgesStr "sharpenEdges"
#define ksharpenMoreStr "sharpenMore"
#define ksharpenStr "sharpen"
#define ksharpenToolStr "sharpenTool"
#define ksharpnessStr "sharpness"
#define kshearEdStr "shearEd"
#define kshearPointsStr "shearPoints"
#define kshearStr "shear"
#define kshearStStr "shearSt"
#define kshiftKeyStr "shiftKey"
#define kshiftKeyToolSwitchStr "shiftKeyToolSwitch"
#define kshortFloatStr "shortFloat"
#define kshortIntegerStr "shortInteger"
#define kshortLinesStr "shortLines"
#define kshortNamesStr "shortNames"
#define kshortStrokesStr "shortStrokes"
#define kshowAllStr "showAll"
#define kshowBBoxStr "showBBox" // mscarafone 4/19/00
#define kshowCJKFeaturesStr "showCJKFeatures"
#define kshowEffectsPaletteStr "showEffectsPalette"
#define kshowEnglishFontNamesStr "showEnglishFontNames"
#define kshowFileBrowserPaletteStr "showFileBrowserPalette"
#define kshowFiltersPaletteStr "showFiltersPalette"
#define kshowHelpPaletteStr "showHelpPalette"
#define kshowHistoryPaletteStr "showHistoryPalette"
#define kshowInfoPaletteStr "showInfoPalette"
#define kshowLayersPaletteStr "showLayersPalette"
#define kshowMoreOptions "showMoreOptions" //mscarafone 4/19/00
#define kshowNavigatorPaletteStr "showNavigatorPalette"
#define kshowNoneStr "showNone"
#define kshowQuickStartPaletteStr "showQuickStartPalette"
#define kshowRecipesPaletteStr "showRecipesPalette"
#define kshowSliceNumbersStr "showSliceNumbers"
#define kshowStr "show"
#define kshowStylesPaletteStr "showStylesPalette"
#define kshowSwatchesPaletteStr "showSwatchesPalette"
#define kshowToolTipsStr "showToolTips"
#define kshowTransparencyStr "showTransparency"
#define ksidesStr "sides"
#define ksimilarStr "similar"
#define ksimplifyLayerStr "simplifyLayer"
#define ksingle72ColorStr "single72Color"
#define ksingle72GrayStr "single72Gray"
#define ksingleColumnStr "singleColumn"
#define ksingleNoCompositePSStr "singleNoCompositePS"
#define ksingleRowStr "singleRow"
#define ksInt16Str "sInt16"
#define ksInt32Str "sInt32"
#define ksInt64Str "sInt64"
#define ksizeStr "size"
#define kskewStr "skew"
#define ksliceBGColor "sliceBackgroundColor"
#define ksliceBGTypeStr "sliceBackgroundType"
#define ksliceColorStr "sliceColor"
#define ksliceFromLayerStr "sliceFromLayer"
#define ksliceImageTypeStr "sliceImageType"
#define kslicesAcrossStr "slicesAcross"
#define kslicesDownStr "slicesDown"
#define ksliceSelectToolStr "sliceSelectTool"
#define ksliceStr "slice"
#define ksliceToolStr "sliceTool"
#define ksliceTypeStr "sliceType"
#define kslopeLimitMatteStr "slopeLimitMatte"
#define ksmallCapsStr "smallCaps"
#define ksmallStr "small"
#define ksmartBlurModeEdgeOnlyStr "smartBlurModeEdgeOnly"
#define ksmartBlurModeNormalStr "smartBlurModeNormal"
#define ksmartBlurModeOverlayEdgeStr "smartBlurModeOverlayEdge"
#define ksmartBlurModeStr "smartBlurMode"
#define ksmartBlurQualityHighStr "smartBlurQualityHigh"
#define ksmartBlurQualityLowStr "smartBlurQualityLow"
#define ksmartBlurQualityMediumStr "smartBlurQualityMedium"
#define ksmartBlurQualityStr "smartBlurQuality"
#define ksmartBlurStr "smartBlur"
#define ksmartQuotesStr "smartQuotes"
#define ksMFloatStr "sMFloat"
#define ksMIntStr "sMInt"
#define ksmoothCornersStr "smoothCorners"
#define ksmoothIndentsStr "smoothIndents"
#define ksmoothnessStr "smoothness"
#define ksmoothStr "smooth"
#define ksmoothingStr "smoothing"
#define kSMPTECStr "SMPTEC"
#define ksmudgeStickStr "smudgeStick"
#define ksmudgeToolStr "smudgeTool"
#define ksnapAllStr "snapAll"
#define ksnapNoneStr "snapNone"
#define ksnapshotClassStr "snapshotClass"
#define ksnapshotEnumStr "snapshotEnum"
#define ksnapshotInitialStr "snapshotInitial"
#define ksnapStr "snap"
#define ksnapToDocBoundsStr "snapToDocBounds"
#define ksnapToGridStr "snapToGrid"
#define ksnapToGuidesStr "snapToGuides"
#define ksnapToLayerBoundsStr "snapToLayerBounds"
#define ksnapToSlicesStr "snapToSlices"
#define ksoftLightStr "softLight"
#define ksoftMatteStr "softMatte"
#define ksoftnessStr "softness"
#define ksolarizeStr "solarize"
#define ksolidColorLayerStr "solidColorLayer"
#define ksolidColorStr "solidColor"
#define ksolidFillStr "solidFill"
#define ksoundAnnotToolStr "soundAnnotTool"
#define ksource2Str "source2"
#define ksourceFolderStr "sourceFolder"
#define ksourceImportStr "sourceImport"
#define ksourceModeStr "sourceMode"
#define ksourceModeTypeStr "sourceModeType"
#define ksourceOpenFilesStr "sourceOpenFiles"
#define ksourceStr "source"
#define kspaceAfterStr "spaceAfter"
#define kspaceBeforeStr "spaceBefore"
#define kspacingStr "spacing"
#define kspanishLanguageStr "spanishLanguage"
#define kspatterStr "spatter"
#define kspecialInstructionsStr "specialInstructions"
#define kspectrumStr "spectrum"
#define kspellCheckStr "spellCheck"
#define kspherizeModeStr "spherizeMode"
#define kspherizeStr "spherize"
#define kspinStr "spin"
#define ksplitChannelsStr "splitChannels"
#define kspongeStr "sponge"
#define kspotColorChannelStr "spotColorChannel"
#define kspotColorStr "spotColor"
#define kspotStr "spot"
#define ksprayedStrokesStr "sprayedStrokes"
#define ksprayRadiusStr "sprayRadius"
#define ksquareSizeStr "squareSize"
#define ksquareStr "square"
#define ksrcBlackMaxStr "srcBlackMax"
#define ksrcBlackMinStr "srcBlackMin"
#define ksrcWhiteMaxStr "srcWhiteMax"
#define ksrcWhiteMinStr "srcWhiteMin"
#define ksRGBStr "sRGB"
#define kstaggerStr "stagger"
#define kstainedGlassStr "stainedGlass"
#define kstampInStr "stampIn"
#define kstampOutStr "stampOut"
#define kstampStr "stamp"
#define kstandardFrenchLanguageStr "standardFrenchLanguage"
#define kstandardGermanLanguageStr "standardGermanLanguage"
#define kstandardPortugueseLanguageStr "standardPortugueseLanguage"
#define kstandardStr "standard"
#define kstarStr "star"
#define kstartArrowheadStr "startArrowhead"
#define kstartIndentStr "startIndent"
#define kstartStr "start"
#define kstateStr "state"
#define kstdAStr "stdA"
#define kstdBStr "stdB"
#define kstdCStr "stdC"
#define kstdEStr "stdE"
#define kstepByStepStr "stepByStep"
#define kstopStr "stop"
#define kstrengthPluginStr "strengthPlugin"
#define kstrengthRatioStr "strengthRatio"
#define kstrengthStr "strength"
#define kstretchToFitStr "stretchToFit"
#define kstrikethroughStr "strikethrough"
#define kstringChannelStr "stringChannel"
#define kstringClassFormatStr "stringClassFormat"
#define kstringCompensationStr "stringCompensation"
#define kstringFSSStr "stringFSS"
#define kstringIntegerStr "stringInteger"
#define kstrokebehaviorStr "strokebehavior"
#define kstrokeColorStr "strokeColor"
#define kstrokeDetailStr "strokeDetail"
#define kstrokeDirectionStr "strokeDirection"
#define kstrokeDirectionTypeStr "strokeDirectionType"
#define kstrokeDirHorizontalStr "strokeDirHorizontal"
#define kstrokeDirLeftDiagStr "strokeDirLeftDiag"
#define kstrokeDirRightDiagStr "strokeDirRightDiag"
#define kstrokeDirVerticalStr "strokeDirVertical"
#define kstrokeEmbossStr "strokeEmboss"
#define kstrokeLengthStr "strokeLength"
#define kstrokeLocationStr "strokeLocation"
#define kstrokePressureStr "strokePressure"
#define kstrokeSizeStr "strokeSize"
#define kstrokeStr "stroke"
#define kstrokeWidthStr "strokeWidth"
#define kstyleBrushStr "styleBrush"
#define kstyleClassStr "styleClass"
#define kstylePresetStr "stylePreset"
#define kstylesAppendStr "stylesAppend"
#define kstylesDeleteStr "stylesDelete"
#define kstylesDetailViewStr	"stylesDetailView"
#define kstylesLoadStr "stylesLoad"
#define kstylesNewStr "stylesNew"
#define kstylesResetStr "stylesReset"
#define kstylesSaveStr "stylesSave"
#define kstylesSmallTextViewStr	"stylesSmallTextView"
#define kstylesSmallThumbnailViewStr	"stylesSmallThumbnailView"
#define kstylesStr "styles"
#define kstylesTextThumbnailViewStr	"stylesTextThumbnailView"
#define kstylesTextViewStr	"stylesTextView"
#define kstylesThumbnailViewStr	"stylesThumbnailView"
#define kstyleStr "style"
#define kstylusIsColorStr "stylusIsColor"
#define kstylusIsOpacityStr "stylusIsOpacity"
#define kstylusIsPressureStr "stylusIsPressure"
#define kstylusIsSizeStr "stylusIsSize"
#define ksubpathListKeyStr "subpathListKey"
#define ksubpathsListStr "subpathsList"
#define ksubpathStr "subpath"
#define ksubScriptStr "subScript"
#define ksubstitutesUsedStr "substitutesUsed"
#define ksubtractFromStr "subtractFrom"
#define ksubtractStr "subtract"
#define ksumieStr "sumie"
#define ksuperScriptStr "superScript"
#define ksupplementalCategoriesStr "supplementalCategories"
#define ksuppressWarningsStr "suppressWarnings"
#define kswatchesAppendStr "swatchesAppend"
#define kswatchesNewStr "swatchesNew"
#define kswatchesReplaceStr "swatchesReplace"
#define kswatchesResetStr "swatchesReset"
#define kswatchesSaveStr "swatchesSave"
#define kswatchesTextThumbnailViewStr "swatchesTextThumbnailView"
#define kswatchesThumbnailViewStr "swatchesThumbnailView"
#define kswedishLanguageStr "swedishLanguage"
#define kswissGermanLanguageStr "swissGermanLanguage"
#define ksyntheticBoldStr "syntheticBold"
#define ksyntheticItalicStr "syntheticItalic"
#define ksyntheticStyleStr "syntheticStyle"
#define ksystemCMYKStr "systemCMYK"
#define ksystemGrayStr "systemGray"
#define ksystemInfoStr "systemInfo"
#define ksystemMetricsStr "systemMetrics"
#define ksystemPaletteStr "systemPalette"
#define ksystemPickerStr "systemPicker"
#define ksystemRGBStr "systemRGB"
#define ktablesStr "tables"
#define ktakeMergedSnapshotStr "takeMergedSnapshot"
#define ktakeSnapshotStr "takeSnapshot"
#define ktargaFormatStr "targaFormat"
#define ktargetChannels "targetChannels"
#define ktargetEnumStr "targetEnum"
#define ktargetIDStr "targetID"
#define ktargetPathIndexStr "targetPathIndex"
#define ktargetPathStr "targetPath"
#define ktargetStr "target"
#define ktemplateStr "template"
#define ktextAllCapsStr "textAllCaps"
#define ktextAnnotToolStr "textAnnotTool"
#define ktextBurasagariStr "textBurasagari"
#define ktextClickPointStr "textClickPoint"
#define ktextDataStr "textData"
#define ktextEveryLineComposerStr "textEveryLineComposer"
#define ktextFauxBoldStr "textFauxBold"
#define ktextFauxItalicStr "textFauxItalic"
#define ktextFractionalWidthsStr "textFractionalWidths"
#define ktextGriddingStr "textGridding"
#define ktextHyphenationStr "textHyphenation"
#define ktextJustificationStr "textJustification"
#define ktextKeyStr "textKey"
#define ktextLanguageStr "textLanguage"
#define ktextLayerStr "textLayer"
#define ktextLigaturesStr "textLigatures"
#define ktextNewTextMode "textNewTextMode"
#define ktextNewTextOrientation "textNewTextOrientation"
#define ktextNoBreakStr "textNoBreak"
#define ktextOidashiStr "textOidashi"
#define ktextOikomiStr "textOikomi"
#define ktextOldStyleStr "textOldStyle"
#define ktextParagraphStr "textParagraph"
#define ktextRotateHankakuStr "textRotateHankaku"
#define ktextShapeStr "textShape"
#define ktextSingleLineComposerStr "textSingleLineComposer"
#define ktextSmallCapsStr "textSmallCaps"
#define ktextStr "text"
#define ktextStrikethroughStr "textStrikethrough"
#define ktextStyleRangeStr "textStyleRange"
#define ktextStyleStr "textStyle"
#define ktextSubscriptStr "textSubscript"
#define ktextSuperscriptStr "textSuperscript"
#define ktextTateChuuYokoStr "textTateChuuYoko"
#define ktextToolCharacterOptions "textToolCharacterOptions"
#define ktextToolOptions "textToolOptions"
#define ktextToolParagraphOptions "textToolParagraphOptions"
#define ktextTypeStr "textType"
#define ktextUnderlineStr "textUnderline"
#define ktextureBlendModeStr "textureBlendMode"
#define ktextureCoverageStr "textureCoverage"
#define ktextureDepthDynamicsStr "textureDepthDynamics"
#define ktextureDepthStr "textureDepth"
#define ktextureFileStr "textureFile"
#define ktextureFillStr "textureFill"
#define ktextureScaleStr "textureScale"
#define ktextureStr "texture"
#define ktextureTypeStr "textureType"
#define ktexturizerStr "texturizer"
#define ktexTypeBlocksStr "texTypeBlocks"
#define ktexTypeBrickStr "texTypeBrick"
#define ktexTypeBurlapStr "texTypeBurlap"
#define ktexTypeCanvasStr "texTypeCanvas"
#define ktexTypeFrostedStr "texTypeFrosted"
#define ktexTypeSandstoneStr "texTypeSandstone"
#define ktexTypeTinyLensStr "texTypeTinyLens"
#define kthreeDigitStr "threeDigit"
#define kthresholdClassEventStr "thresholdClassEvent"
#define kthresholdEnumStr "thresholdEnum"
#define kthresholdStr "threshold"
#define kthumbnailStr "thumbnail"
#define kTIFFFormatStr "TIFFFormat"
#define kTIFFStr "TIFF"
#define ktileNumberStr "tileNumber"
#define ktileOffsetStr "tileOffset"
#define ktilePluginStr "tilePlugin"
#define ktileSizeStr "tileSize"
#define ktilesStr "tiles"
#define ktileStr "tile"
#define ktiltScaleStr "tiltScale"
#define ktimeoutAttrStr "timeoutAttr"
#define ktitleStr "title"
#define ktoBuiltinStr "toBuiltin"
#define ktoggleActionsPaletteStr "toggleActionsPalette"
#define ktoggleAnnotsStr "toggleAnnots"
#define ktoggleAutoSlicesStr "toggleAutoSlices"
#define ktoggleBlackPreviewStr "toggleBlackPreview"
#define ktoggleBrushesExpandedViewStr "toggleBrushesExpandedView"
#define ktoggleBrushesPaletteStr "toggleBrushesPalette"
#define ktoggleBrushStylerPaletteStr "toggleBrushStylerPalette"
#define ktoggleChannelsPaletteStr "toggleChannelsPalette"
#define ktoggleCharacterPaletteStr "toggleCharacterPalette"
#define ktoggleCMYKPreviewStr "toggleCMYKPreview"
#define ktoggleCMYPreviewStr "toggleCMYPreview"
#define ktoggleColorPaletteStr "toggleColorPalette"
#define ktoggleCyanPreviewStr "toggleCyanPreview"
#define ktoggleEdgesStr "toggleEdges"
#define ktoggleEffectsPaletteStr "toggleEffectsPalette"
#define ktoggleFileBrowserPaletteStr "toggleFileBrowserPalette"
#define ktoggleFiltersPaletteStr "toggleFiltersPalette"
#define ktoggleGamutWarningStr "toggleGamutWarning"
#define ktoggleGridStr "toggleGrid"
#define ktoggleGuidesStr "toggleGuides"
#define ktoggleHintsPaletteStr "toggleHintsPalette"
#define ktoggleHistoryPaletteStr "toggleHistoryPalette"
#define ktoggleInfoPaletteStr "toggleInfoPalette"
#define ktoggleLayerMaskStr "toggleLayerMask"
#define ktoggleLayersPaletteStr "toggleLayersPalette"
#define ktoggleLockGuidesStr "toggleLockGuides"
#define ktoggleLockSlicesStr "toggleLockSlices"
#define ktoggleMagentaPreviewStr "toggleMagentaPreview"
#define ktoggleNavigatorPaletteStr "toggleNavigatorPalette"
#define ktoggleOptionsPaletteStr "toggleOptionsPalette"
#define ktoggleOthersStr "toggleOthers"
#define ktoggleParagraphPaletteStr "toggleParagraphPalette"
#define ktogglePathsPaletteStr "togglePathsPalette"
#define ktogglePathsStr "togglePaths"
#define ktoggleProofColorsStr "toggleProofColors"
#define ktoggleQuickStartPaletteStr "toggleQuickStartPalette"
#define ktoggleRecipesPaletteStr "toggleRecipesPalette"
#define ktoggleRGBMacPreviewStr "toggleRGBMacPreview"
#define ktoggleRGBUncompensatedPreviewStr "toggleRGBUncompensatedPreview"
#define ktoggleRGBWindowsPreviewStr "toggleRGBWindowsPreview"
#define ktoggleRulersStr "toggleRulers"
#define ktoggleShortcutsPaletteStr "toggleShortcutsPalette"
#define ktoggleShowExtrasStr "toggleShowExtras"
#define ktoggleSlicesStr "toggleSlices"
#define ktoggleSnapToGridStr "toggleSnapToGrid"
#define ktoggleSnapToGuidesStr "toggleSnapToGuides"
#define ktoggleStatusBarStr "toggleStatusBar"
#define ktoggleStylesPaletteStr "toggleStylesPalette"
#define ktoggleSwatchesPaletteStr "toggleSwatchesPalette"
#define ktoggleTextLayerTypeStr "toggleTextLayerType"
#define ktoggleToolPresetsPaletteStr "toggleToolPresetsPalette"
#define ktoggleToolsPaletteStr "toggleToolsPalette"
#define ktoggleVectorMaskStr "toggleVectorMask"
#define ktoggleYellowPreviewStr "toggleYellowPreview"
#define ktoleranceStr "tolerance"
#define ktoLinkedStr "toLinked"
#define ktoModeStr "toMode"
#define ktoolPresetStr "toolPreset"
#define ktoolStr "tool"
#define ktopLeftPixelColorStr "topLeftPixelColor"
#define ktopStr "top"
#define ktornEdgesStr "tornEdges"
#define ktoStr "to"
#define ktotalLimitStr "totalLimit"
#define ktraceContourStr "traceContour"
#define ktrackingStr "tracking"
#define ktransactionIDAttrStr "transactionIDAttr"
#define ktransferFunctionStr "transferFunction"
#define ktransferPointStr "transferPoint"
#define ktransferSpecClassStr "transferSpecClass"
#define ktransferSpecStr "transferSpec"
#define ktransformStr "transform"
#define ktransparencyEnumStr "transparencyEnum"
#define ktransparencyGamutPreferencesStr "transparencyGamutPreferences"
#define ktransparencyGridColorsStr "transparencyGridColors"
#define ktransparencyGridColorsTypeStr "transparencyGridColorsType"
#define ktransparencyGridSizeStr "transparencyGridSize"
#define ktransparencyGridStr "transparencyGrid"
#define ktransparencyPrefsStr "transparencyPrefs"
#define ktransparencyShapeStr "transparencyShape"
#define ktransparencyStopStr "transparencyStop"
#define ktransparencyStr "transparency"
#define ktransparencyShapesLayerStr "transparencyShapesLayer"
#define ktransparentIndexStr "transparentIndex"
#define ktransparentStr "transparent"
#define ktransparentWhitesStr "transparentWhites"
#define ktrapStr "trap"
#define ktrimBasedOnStr "trimBasedOn"
#define ktrimStr "trim"
#define ktrinitronStr "trinitron"
#define ktritoneStr "tritone"
#define ktrueStr "true"
#define ktsumeStr "tsume"
#define kturkishLanguageStr "turkishLanguage"
#define ktutorialsStr "tutorials"
#define ktwirlStr "twirl"
#define ktwistStr "twist"
#define ktwoDigitStr "twoDigit"
#define ktxStr "tx"
#define ktypeClassModeOrClassModeStr "typeClassModeOrClassMode"
#define ktypeCreateMaskToolStr "typeCreateMaskTool"
#define ktypeCreateOrEditToolStr "typeCreateOrEditTool"
#define ktypeStr "type"
#define ktypeUnitsStr "typeUnits"
#define ktypeVerticalCreateMaskToolStr "typeVerticalCreateMaskTool"
#define ktypeVerticalCreateOrEditToolStr "typeVerticalCreateOrEditTool"
#define ktyStr "ty"
#define kUCAStr "UCA"
#define kuIBitmapStr "uIBitmap"
#define kuICMYKStr "uICMYK"
#define kuIDuotoneStr "uIDuotone"
#define kuIGrayscaleStr "uIGrayscale"
#define kuIIndexedStr "uIIndexed"
#define kuILabStr "uILab"
#define kuIMultichannelStr "uIMultichannel"
#define kuInt32Str "uInt32"
#define kuIRGBStr "uIRGB"
#define kukenglishLanguageStr "ukenglishLanguage"
#define kukrainianLanguageStr "ukrainianLanguage"
#define kundefinedAreaStr "undefinedArea"
#define kunderlineStr "underline"
#define kunderpaintingStr "underpainting"
#define kundoEnumStr "undoEnum"
#define kundoEventStr "undoEvent"
#define kungroupStr "ungroup"
#define kuniformDistributionStr "uniformDistribution"
#define kuniformStr "uniform"
#define kunitsPrefsStr "unitsPrefs"
#define kunitsRulersPreferencesStr "unitsRulersPreferences"
#define kunixStr "unix"
#define kunlinkStr "unlink"
#define kunmarkedStr "unmarked"
#define kunsharpMaskStr "unsharpMask"
#define kunspecifiedColorStr "unspecifiedColor"
#define kuntitledStr "untitled"
#define kupdateLayoutsStr "updateLayouts"
#define kupperCaseExtensionStr "upperCaseExtension"
#define kupperCaseSerialStr "upperCaseSerial"
#define kupperCaseStr "upperCase"
#define kupperStr "upper"
#define kupperYStr "upperY"
#define kurgencyStr "urgency"
#define kURLStr "URL"
#define kuseAccurateScreensStr "useAccurateScreens"
#define kuseAdditionalPluginsStr "useAdditionalPlugins"
#define kuseCacheForHistogramsStr "useCacheForHistograms"
#define kuseColorDynamicsStr "useColorDynamics"
#define kuseCurvesStr "useCurves"
#define kuseDefaultStr "useDefault"
#define kuseDualBrushStr "useDualBrush"
#define kuseGlobalAngleStr "useGlobalAngle"
#define kuseICCProfileStr "useICCProfile"
#define kuseMaskStr "useMask"
#define kusePaintDynamicsStr "usePaintDynamics"
#define kuserDefinedStr	"userDefined"
#define kuserMaskEnabledStr "userMaskEnabled"
#define kuserMaskLinkedStr "userMaskLinked"
#define kuserMaskOptionsStr "userMaskOptions"
#define kuserStopStr "userStop"
#define kuserStr "user"
#define kuseScatterStr "useScatter"
#define kuseShapeStr "useShape"
#define kuseTextOutlinesStr "useTextOutlines"
#define kuseTextureStr "useTexture"
#define kuseTipDynamicsStr "useTipDynamics"
#define kusingStr "using"
#define kvalueListStr "valueList"
#define kvalueStr "value"
#define kvariationsStr "variations"
#define kvector0Str "vector0"
#define kvector1Str "vector1"
#define kvectorColorStr "vectorColor"
#define kvectorDataStr "vectorData"
#define kvectorMaskCurrentPathStr "vectorMaskCurrentPath"
#define kvectorMaskEnabledStr "vectorMaskEnabled"
#define kvectorMaskHideAllStr "vectorMaskHideAll"
#define kvectorMaskLinkedStr "vectorMaskLinked"
#define kvectorMaskRevealAllStr "vectorMaskRevealAll"
#define kvectorMaskStr "vectorMask"
#define kvectorMaskAsGlobalMaskStr "vectorMaskAsGlobalMask"
#define kversionFixStr "versionFix"
#define kversionMajorStr "versionMajor"
#define kversionMinorStr "versionMinor"
#define kversionStr "version"
#define kverticalLocationStr "verticalLocation"
#define kverticalOnlyStr "verticalOnly"
#define kverticalScaleStr "verticalScale"
#define kverticalStr "vertical"
#define kverticalUnderlineLeftStr "verticalUnderlineLeft"
#define kverticalUnderlinePostionStr "verticalUnderlinePosition"
#define kverticalUnderlineRightStr "verticalUnderlineRight"
#define kvideoAlphaStr "videoAlpha"
#define kvioletStr "violet"
#define kvisibleChannels "visibleChannels"
#define kvisibleStr "visible"
#define kvividLightStr "vividLight"
#define kvMPreferencesStr "vMPreferences"
#define kwaitStr "wait"
#define kwariChuCountStr "wariChuCount"
#define kwariChuOrphanStr "wariChuOrphan"
#define kwariChuScaleStr "wariChuScale"
#define kwariChuWidowStr "wariChuWidow"
#define kwarpArchStr "warpArch"
#define kwarpArcLowerStr "warpArcLower"
#define kwarpArcStr "warpArc"
#define kwarpArcUpperStr "warpArcUpper"
#define kwarpBulgeStr "warpBulge"
#define kwarpFisheyeStr "warpFisheye"
#define kwarpFishStr "warpFish"
#define kwarpFlagStr "warpFlag"
#define kwarpInflateStr "warpInflate"
#define kwarpNoneStr "warpNone"
#define kwarpPerspectiveOtherStr "warpPerspectiveOther"
#define kwarpPerspectiveStr "warpPerspective"
#define kwarpRiseStr "warpRise"
#define kwarpRotateStr "warpRotate"
#define kwarpShellLowerStr "warpShellLower"
#define kwarpShellUpperStr "warpShellUpper"
#define kwarpSqueezeStr "warpSqueeze"
#define kwarpStr "warp"
#define kwarpStyleStr "warpStyle"
#define kwarpTwistStr "warpTwist"
#define kwarpValueStr "warpValue"
#define kwarpWaveStr "warpWave"
#define kwatchSuspensionStr "watchSuspension"
#define kwatercolorStr "watercolor"
#define kwatermarkStr "watermark"
#define kwaterPaperStr "waterPaper"
#define kwavelengthMaxStr "wavelengthMax"
#define kwavelengthMinStr "wavelengthMin"
#define kwaveSineStr "waveSine"
#define kwaveSquareStr "waveSquare"
#define kwaveStr "wave"
#define kwaveTriangleStr "waveTriangle"
#define kwaveTypeStr "waveType"
#define kwebSafeRampStr "webSafeRamp"
#define kwebStr "web"
#define kwetEdgesStr "wetEdges"
#define kwhatStr "what"
#define kwhichEffectStr "whichEffect"
#define kwhichEffectTypeStr "whichEffectType"
#define kwhiteClipStr "whiteClip"
#define kwhiteIntensityStr "whiteIntensity"
#define kwhiteIsHighStr "whiteIsHigh"
#define kwhiteLevelStr "whiteLevel"
#define kwhitePointStr "whitePoint"
#define kwhitesStr "whites"
#define kwhiteStr "white"
#define kwholePathStr "wholePath"
#define kwholeWordStr "wholeWord"
#define kwideGamutRGBStr "wideGamutRGB"
#define kwidePhosphorsStr "widePhosphors"
#define kwidthStr "width"
#define kwildCardStr "wildCard"
#define kwindingFillStr "windingFill"
#define kwindMethodStr "windMethod"
#define kwindowsStr "windows"
#define kwindowsSystemStr "windowsSystem"
#define kwindStr "wind"
#define kwinThumbnailStr "winThumbnail"
#define kwithStr "with"
#define kwithStreamStr "withStream"
#define kworkingCMYKStr "workingCMYK"
#define kworkingGrayStr "workingGray"
#define kworkingRGBStr "workingRGB"
#define kworkingSpaceCodeStr "workingSpaceCode"
#define kworkingSpotStr "workingSpot"
#define kworkPathIndexStr "workPathIndex"
#define kworkPathStr "workPath"
#define kworkspaceDefaultFolderStr "workspaceDefaultFolder"
#define kworkspaceMenuStr	"workspaceMenu"
#define kworkspaceStr "workspace"
#define kwrapAroundStr "wrapAround"
#define kwrapStr "wrap"
#define kxorStr "xor"
#define kxStr "x"
#define kxxStr "xx"
#define kxyStr "xy"
#define kxYYColorStr "xYYColor"
#define kyellowColorStr "yellowColor"
#define kyellowsStr "yellows"
#define kyellowStr "yellow"
#define kyesNoStr "yesNo"
#define kyesStr "yes"
#define kyStr "y"
#define kyxStr "yx"
#define kyyddmmStr "yyddmm"
#define kyymmddStr "yymmdd"
#define kyyStr "yy"
#define kyyyymmddStr "yyyymmdd"
#define kzigZagStr "zigZag"
#define kzigZagTypeStr "zigZagType"
#define kzipStr "zip"
#define kzoomInStr "zoomIn"
#define kzoomOutStr "zoomOut"
#define kzoomStr "zoom"
#define kzoomToolStr "zoomTool"
#define kZoomViewStr "ZoomView"

//#define kmasksOnlyStr "masksOnly"

#if qWebdav
#define kcheckInStr "checkIn"
#define kcheckOutStr "checkOut"
#define kundoCheckOutStr "undoCheckOut"
#define kuploadToServerStr "uploadToServer"
#define kdownloadFromServerStr "downloadFromServer"
#define kaddToWorkflowStr "addToWorkflow"
#define kworkflowOptionsStr "workflowOptions"
#define kopenFromWorkflowStr "openFromWorkflow"
#define kverifyStateStr "verifyState"
#define klogoffAllServersStr "logoffAllServers"
#define kworkOfflineStr "workOffline"
#define kworkgroupServersStr "workgroupServers"
#define kworkgroupOptionsKeyStr "workgroupOptionsKey"
#define kworkflowStr "workflow"
#define kworkflowIsManagedStr "workflowIsManaged"
#define kworkflowURLStr "workflowURL"
#define kworkflowIsOwnedStr "workflowIsOwned"
#define kworkflowLockedLocallyStr "workflowLockedLocally"
#define kworkflowEditOfflineStr "workflowEditOffline"
#define kworkflowIsCurrentStr "workflowIsCurrent"
#define kworkflowIsModifiedStr "workflowIsModified"
#define kWorkflowEnabledPref "workflowEnabled"
#define kWorkflowUpdatePref "workflowUpdatePref"
#define kWorkflowCheckoutPref "workflowCheckoutPref"
#endif

//*****************************************************************************

#endif

