// PermAssetLister.cpp : 
// KSH 4 Mar, 2003

#include "stdafx.h"
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <process.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <gel/scripting/scriptcache.h> 
#include <gel\scripting\tokens.h>
#include <gel/scripting/init.h>
#include <gel/scripting/script.h>
#include <gel/scripting/symboltable.h>
#include <gel/scripting/parse.h>
#include <gel/scripting/checksum.h>
#include <gel/scripting/struct.h>
#include <gel/scripting/array.h>


#include <sys/config/config.h>

#include "Genlib/FileDatabase.h"
#include "Genlib/Utility.h"
#include "Genlib/VirtualFile.h"

#define PLATFORM_PS2	0
#define PLATFORM_XBOX	1
#define PLATFORM_NGC	2
int gPlatform = PLATFORM_PS2;

IoUtils::CVirtualOutputFile gSkaterSoundsTXT;
IoUtils::CVirtualOutputFile gAnimsTXT;
IoUtils::CVirtualOutputFile gUnloadableAnimsTXT;
IoUtils::CVirtualOutputFile gSpecialAnimsTXT;
IoUtils::CVirtualOutputFile gNetAnimsTXT;

const char *GetProjRoot()
{
	static const char *sp_proj_root = NULL;
	if (!sp_proj_root)
	{
		sp_proj_root=getenv( "PROJ_ROOT" );
		Dbg_MsgAssert(sp_proj_root!=NULL,("You must first define your PROJ_ROOT environment variable"));
	}
	return sp_proj_root;
}

bool TestExistence(char *filename)
{
	struct stat testStatBuf;
	return (stat(filename, &testStatBuf) != -1);
}

uint8 *LoadFileIntoMemory(const char *p_fileName)
{
	IoUtils::CVirtualInputFile theInputFile;
	int size = theInputFile.Load(p_fileName);
	if (!size)
	{
		//printf("File '%s' does not exist!\n",p_fileName);
		return NULL;
	}
	uint8* p_file = (uint8*)malloc(size);
	theInputFile.Read( (char*)p_file, size );
	return p_file;
}

void LoadQB(const char *p_qb_name)
{
	uint8* p_qb=LoadFileIntoMemory(p_qb_name);
	if (p_qb)
	{
		Script::ParseQB(p_qb_name,p_qb);
		// All the globals and scripts defined in the q file are now loaded, 
		// so no need to keep the qb any more.
		free(p_qb);
	}
}

bool ScriptPrintf(Script::CStruct *pParams, Script::CScript *pScript)
{
	const char *p_text="";
	pParams->GetString(NONAME,&p_text);
	printf("PCPrintf: %s\n",p_text);

	return true;
}

bool ScriptInNetGame(Script::CStruct *pParams, Script::CScript *pScript)
{
	return false;
}

bool ScriptGetArraySize(Script::CStruct *pParams, Script::CScript *pScript)
{
	Script::CArray* pArray;
	
	pParams->GetArray( NONAME, &pArray, Script::ASSERT );

	pScript->GetParams()->AddInteger( "array_size", pArray->GetSize() );

	return true;
}

bool ScriptLoadSound(Script::CStruct *pParams, Script::CScript *pScript)
{
	const char *p_file_name="";
	pParams->GetString(NONAME,&p_file_name);

	char p_full_sound_file_name[_MAX_PATH];
	switch (gPlatform)
	{
	case PLATFORM_PS2:
		sprintf(p_full_sound_file_name,"%s\\data\\sounds\\vag\\%s.vag",GetProjRoot(),p_file_name);
		break;
	case PLATFORM_XBOX:
		sprintf(p_full_sound_file_name,"%s\\data\\sounds\\pcm\\%s.pcm",GetProjRoot(),p_file_name);
		break;
	case PLATFORM_NGC:
		sprintf(p_full_sound_file_name,"%s\\data\\sounds\\dsp\\%s.dsp",GetProjRoot(),p_file_name);
		break;
	default:
		break;
	}

	if (TestExistence(p_full_sound_file_name))
	{
		gSkaterSoundsTXT.WriteString( p_full_sound_file_name, true );
	}

	return true;
}

bool ScriptLoadAnim(Script::CStruct *pParams, Script::CScript *pScript)
{
	const char *p_file_name="";
	pParams->GetString("name",&p_file_name);

	char p_full_anim_file_name[_MAX_PATH];
	switch (gPlatform)
	{
	case PLATFORM_PS2:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.ps2",GetProjRoot(),p_file_name);
		break;
	case PLATFORM_XBOX:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.xbx",GetProjRoot(),p_file_name);
		break;
	case PLATFORM_NGC:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.ngc",GetProjRoot(),p_file_name);
		break;
	default:
		break;
	}

	if (TestExistence(p_full_anim_file_name))
	{
		gAnimsTXT.WriteString( p_full_anim_file_name, true );
	}

	return true;
}

bool ScriptUnloadAnim(Script::CStruct *pParams, Script::CScript *pScript)
{
	const char *p_file_name="";
	pParams->GetString("name",&p_file_name);

	char p_full_anim_file_name[_MAX_PATH];
	switch (gPlatform)
	{
	case PLATFORM_PS2:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.ps2",GetProjRoot(),p_file_name);
		break;
	case PLATFORM_XBOX:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.xbx",GetProjRoot(),p_file_name);
		break;
	case PLATFORM_NGC:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.ngc",GetProjRoot(),p_file_name);
		break;
	default:
		break;
	}

	if (TestExistence(p_full_anim_file_name))
	{
		gUnloadableAnimsTXT.WriteString( p_full_anim_file_name, true );
	}

	return true;
}

bool ScriptSpecialAnim(Script::CStruct *pParams, Script::CScript *pScript)
{
	const char *p_file_name="";
	pParams->GetString("name",&p_file_name);

	char p_full_anim_file_name[_MAX_PATH];
	switch (gPlatform)
	{
	case PLATFORM_PS2:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.ps2",GetProjRoot(),p_file_name);
		break;
	case PLATFORM_XBOX:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.xbx",GetProjRoot(),p_file_name);
		break;
	case PLATFORM_NGC:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.ngc",GetProjRoot(),p_file_name);
		break;
	default:
		break;
	}

	if (TestExistence(p_full_anim_file_name))
	{
		gSpecialAnimsTXT.WriteString( p_full_anim_file_name, true );
	}

	return true;
}


bool ScriptNetAnim(Script::CStruct *pParams, Script::CScript *pScript)
{
	const char *p_file_name="";
	pParams->GetString("name",&p_file_name);

	char p_full_anim_file_name[_MAX_PATH];
	switch (gPlatform)
	{
	case PLATFORM_PS2:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.ps2",GetProjRoot(),p_file_name);
		break;
	case PLATFORM_XBOX:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.xbx",GetProjRoot(),p_file_name);
		break;
	case PLATFORM_NGC:
		sprintf(p_full_anim_file_name,"%s\\data\\%s.ngc",GetProjRoot(),p_file_name);
		break;
	default:
		break;
	}

	if (TestExistence(p_full_anim_file_name))
	{
		gNetAnimsTXT.WriteString( p_full_anim_file_name, true );
	}

	return true;
}


void RegisterCFuncs()
{
	Script::CSymbolTableEntry *p_new=NULL;
	
	p_new=Script::CreateNewSymbolEntry(0x2a621572/*LoadSound*/);
	p_new->mType=ESYMBOLTYPE_CFUNCTION;
	p_new->mpCFunction=ScriptLoadSound;

	p_new=Script::CreateNewSymbolEntry(0x89921f5b/*LoadAnim*/);
	p_new->mType=ESYMBOLTYPE_CFUNCTION;
	p_new->mpCFunction=ScriptLoadAnim;

	p_new=Script::CreateNewSymbolEntry(0x8bfbbcae/*UnloadAnim*/);
	p_new->mType=ESYMBOLTYPE_CFUNCTION;
	p_new->mpCFunction=ScriptUnloadAnim;

	p_new=Script::CreateNewSymbolEntry(0x8aca6808/*SpecialAnim*/);
	p_new->mType=ESYMBOLTYPE_CFUNCTION;
	p_new->mpCFunction=ScriptSpecialAnim;

	p_new=Script::CreateNewSymbolEntry(0xab9e7498/*NetAnim*/);
	p_new->mType=ESYMBOLTYPE_CFUNCTION;
	p_new->mpCFunction=ScriptNetAnim;

	p_new=Script::CreateNewSymbolEntry(0xa1da6fe9/*InNetGame*/);
	p_new->mType=ESYMBOLTYPE_CFUNCTION;
	p_new->mpCFunction=ScriptInNetGame;

	p_new=Script::CreateNewSymbolEntry(0x39b5c4b0/*GetArraySize*/);
	p_new->mType=ESYMBOLTYPE_CFUNCTION;
	p_new->mpCFunction=ScriptGetArraySize;

	p_new=Script::CreateNewSymbolEntry(0xef067f2c/*pcprintf*/);
	p_new->mType=ESYMBOLTYPE_CFUNCTION;
	p_new->mpCFunction=ScriptPrintf;
}

int main(int argc, char* argv[])
{
	if (argc==1)
	{
		printf("\n");
		printf("PermAssetLister.exe, %s\n\n",__DATE__);
		printf("Usage:\n");
		printf("PS2:  PermAssetLister -pp\n");
		printf("XBox: PermAssetLister -px\n");
		printf("NGC:  PermAssetLister -pg\n\n");
		printf("This will parse the script LoadPermSFX defined in %%PROJ_ROOT%%\\data\\scripts\\game\\skater\\skater_sfx.q looking for LoadSound commands, putting the file names found into %%PROJ_ROOT%%\\data\\skater_sounds.txt\n\n");
		printf("It will then parse the scripts load_permanent_anims and load_special_items defined in %%PROJ_ROOT%%\\data\\scripts\\game\\startup.q looking for LoadAnim commands, putting the file names found into %%PROJ_ROOT%%\\data\\anims.txt\n\n");
		printf("makepre.exe can then use these txt files to generate anims.pre and\nskater_sounds.pre\n");

		exit(1);
	}

	for (int i=1; i<argc; ++i)
	{
		if(( argv[i][0] == '-' ) && ( argv[i][1] == 'p' ))
		{
			if( argv[i][2] == 'x' )
			{
				gPlatform = PLATFORM_XBOX;
				printf("Switching to Xbox platform\n");
			}
			else if( argv[i][2] == 'g' )
			{
				gPlatform = PLATFORM_NGC;
				printf("Switching to Gamecube platform\n");
			}
			break;
		}
	}

	// A few essential calls for the script code.
	Config::Init(0,NULL);
	Mem::Manager::sSetUp();
	Script::CScriptCache::Create();

	Script::CreateSymbolHashTable();
	Script::AllocatePools();
	RegisterCFuncs();

	char p_skater_sfx_qb[_MAX_PATH];
	sprintf(p_skater_sfx_qb,"%s\\data\\scripts\\game\\skater\\skater_sfx.qb",GetProjRoot());
	LoadQB(p_skater_sfx_qb);

	char p_startup_qb[_MAX_PATH];
	sprintf(p_startup_qb,"%s\\data\\scripts\\game\\startup.qb",GetProjRoot());
	LoadQB(p_startup_qb);

	char p_allanims_qb[_MAX_PATH];
	sprintf(p_allanims_qb,"%s\\data\\scripts\\allanims.qb",GetProjRoot());
	LoadQB(p_allanims_qb);

	gSkaterSoundsTXT.Init( 2 * 1024 * 1024 );
	gAnimsTXT.Init( 2 * 1024 * 1024 );
	gUnloadableAnimsTXT.Init( 2 * 1024 * 1024 );
	gSpecialAnimsTXT.Init( 2 * 1024 * 1024 );
	gNetAnimsTXT.Init( 2 * 1024 * 1024 );

	Script::RunScript("LoadPermSFX");
	Script::RunScript("load_permanent_anims");

	Script::CStruct* pTempStruct = new Script::CStruct;
	pTempStruct->AddChecksum( "LoadFunction", Script::GenerateCRC( "UnloadAnim" ) );
	Script::RunScript("load_unloadable_anims", pTempStruct);
	delete pTempStruct;

	pTempStruct = new Script::CStruct;
	pTempStruct->AddChecksum( "LoadFunction", Script::GenerateCRC( "SpecialAnim" ) );
	Script::RunScript("load_special_anims", pTempStruct);
	delete pTempStruct;

	pTempStruct = new Script::CStruct;
	pTempStruct->AddChecksum( "LoadFunction", Script::GenerateCRC( "NetAnim" ) );
 //   Script::RunScript("load_permanent_anims", pTempStruct);
//	Script::RunScript("load_unloadable_anims", pTempStruct);
	Script::RunScript("load_net_anims", pTempStruct);
	delete pTempStruct;

	Script::RunScript("load_special_items");

	char p_skater_sounds_txt[_MAX_PATH];
	sprintf(p_skater_sounds_txt,"%s\\data\\skater_sounds.txt",GetProjRoot());
	if (!gSkaterSoundsTXT.Save(p_skater_sounds_txt))
	{
		Dbg_MsgAssert(0, ("Couldn't open file %s for writing\n",p_skater_sounds_txt));
	}

	char p_anims_txt[_MAX_PATH];
	sprintf(p_anims_txt,"%s\\data\\anims.txt",GetProjRoot());
	if (!gAnimsTXT.Save(p_anims_txt))
	{
		Dbg_MsgAssert(0, ("Couldn't open file %s for writing\n",p_anims_txt));
	}

	char p_unloadable_anims_txt[_MAX_PATH];
	sprintf(p_unloadable_anims_txt,"%s\\data\\unloadableanims.txt",GetProjRoot());
	if (!gUnloadableAnimsTXT.Save(p_unloadable_anims_txt))
	{
		Dbg_MsgAssert(0, ("Couldn't open file %s for writing\n",p_unloadable_anims_txt));
	}

	char p_special_anims_txt[_MAX_PATH];
	sprintf(p_special_anims_txt,"%s\\data\\specialanims.txt",GetProjRoot());
	if (!gSpecialAnimsTXT.Save(p_special_anims_txt))
	{
		Dbg_MsgAssert(0, ("Couldn't open file %s for writing\n",p_special_anims_txt));
	}

	char p_net_anims_txt[_MAX_PATH];
	sprintf(p_net_anims_txt,"%s\\data\\netanims.txt",GetProjRoot());
	if (!gNetAnimsTXT.Save(p_net_anims_txt))
	{
		Dbg_MsgAssert(0, ("Couldn't open file %s for writing\n",p_net_anims_txt));
	}

	return 0;
}
