#include "stdafx.h"
#include "engine.h"
#include "stdio.h"
#include "string.h"
#include "stdlib.h"
#include "resource.h"
#include "mycode.h"
#include "checksum.h"
#include "core/crc.h"
#include "monitor.h"
#include "utils.h"

#include "sk/gamenet/scriptdebugger.h"
#include "gel/scripting/symboltype.h"
#include "gel/scripting/debugger.h"
#include "gel/scripting/checksum.h"
#include "gel/scripting/init.h"
#include <sys/config/config.h>

#pragma comment (lib, "c:/skate5/tools/lib/ps2tmapi.lib")
#include "c:/skate5/tools/include/ps2tmapi/ps2tmapi.h"

extern CMonitorApp theApp;

namespace PS2TM
{

static char spTargetName[100]={0};
static bool sFoundTarget=false;
static SNPS2TargetInfo sTargetInfo;

int EnumCallBack(SNPS2TargetInfo* p_targetInfo)
{
	if (strcmp(p_targetInfo->pszName,spTargetName)==0)
	{
		sTargetInfo=*p_targetInfo;
		sFoundTarget=true;

		// Return 1 to terminate enumeration since we've found a match.
		return 1;
	}
	// Return 0 to continue enumeration.
    return 0;
}

bool Init()
{
	spTargetName[0]=0;

	// Determine the target's name by piping the output of ps2run -nd to a text
	// file, then opening the file and looking for the name in quotes.
	char *p_project_root=getenv("PROJ_ROOT");
	if (!p_project_root)
	{
		Printf("Error! PROJ_ROOT needs to be set");
		return false;
	}
	char p_temp_file[1000];
	sprintf(p_temp_file,"%s\\bin\\win32\\targetname.txt",p_project_root);

	char p_command[1000];
	sprintf(p_command,"ps2run -nd > %s",p_temp_file);

	system(p_command);


	// The output from the ps2run command is now stored in targetname.txt
	// Load in the file, and search for the target name, which will be in quotes.
	CFile file;
	if (!file.Open(TEXT(p_temp_file), CFile::modeRead))
	{
		Printf("Error! Could not open bin\\win32\\targetname.txt");
		return false;
	}

	int size=file.GetLength();
	if (!size)
	{
		Printf("Error! Zero size for bin\\win32\\targetname.txt");
		return false;
	}

	char *p_file=new char[size+1]; // +1 for a terminating zero.

	int bytes_read=file.Read(p_file,size);
	ASSERT(bytes_read==size);
	file.Close();

	// Put a terminating zero on the end so that the end can be detected easily.
	p_file[size]=0;

	char *p_dest=NULL;

	char *p_ch=p_file;
	bool done=false;
	while (*p_ch)
	{
		if (*p_ch=='"')
		{
			if (p_dest)
			{
				break;
			}
			else
			{
				p_dest=spTargetName;
			}
		}
		else
		{
			if (p_dest)
			{
				*p_dest++=*p_ch;
			}
		}

		++p_ch;
	}
	*p_dest=0;

	delete [] p_file;

	// Now the target name is safely stored away in spTargetName


	if (SNPS2Initialise() < 0)
	{
		Printf("SNPS2 failed to initialise");
		return false;
	}

    if (SNPS2EnumTargets((SNPS2EnumTargetsCB)EnumCallBack) < 0)
	{
		Printf("Failed to enumerate targets");
		return false;
	}


	if (!sFoundTarget)
	{
		Printf("Could not find the target");
		return false;
	}

    Printf("Connecting to target ...");
    if (SNPS2Connect(sTargetInfo.hTarget, NULL) < 0)
	{
		Printf("Failed to connect !");
		return false;
	}
	Printf("Succeeded");

	// Now that we've connected, read the checksum names from the game.
	Dbg::SChecksumNameInfo checksum_name_info;

    if (SNPS2GetMemory(sTargetInfo.hTarget,
					   UI_EECPU,
					   MEMSPACE_MAIN,
					   Dbg::SCRIPT_DEBUGGER_MEMORY_START,
					   sizeof(Dbg::SChecksumNameInfo),
					   &checksum_name_info) < 0)
	{
		Printf("SNPS2GetMemory failed");
		return false;
	}

	uint32 ps2_p_start=0;
	uint32 ps2_p_end=0;
    if (SNPS2GetMemory(sTargetInfo.hTarget,
					   UI_EECPU,
					   MEMSPACE_MAIN,
					   (uint32)checksum_name_info.mppStart,
					   4,
					   &ps2_p_start) < 0)
	{
		Printf("SNPS2GetMemory failed");
		return false;
	}
    if (SNPS2GetMemory(sTargetInfo.hTarget,
					   UI_EECPU,
					   MEMSPACE_MAIN,
					   (uint32)checksum_name_info.mppEnd,
					   4,
					   &ps2_p_end) < 0)
	{
		Printf("SNPS2GetMemory failed");
		return false;
	}

	if (ps2_p_end < ps2_p_start)
	{
		Printf("ps2_p_end < ps2_p_start ??");
		return false;
	}

	if (ps2_p_end==0 || ps2_p_start==0)
	{
		Printf("ps2_p_end and ps2_p_start not set.");
		return false;
	}

	uint32 names_size=ps2_p_end-ps2_p_start;
	if (names_size > 2000000)
	{
		Printf("Unusually large checksum names size ?");
		return false;
	}

	if (names_size==0)
	{
		return false;
	}

	char *p_names=(char*)malloc(names_size);
    if (SNPS2GetMemory(sTargetInfo.hTarget,
					   UI_EECPU,
					   MEMSPACE_MAIN,
					   ps2_p_start,
					   names_size,
					   p_names) < 0)
	{
		Printf("SNPS2GetMemory failed");
		return false;
	}

	if (p_names[names_size-1])
	{
		Printf("Error, unterminated checksum names array");
		return false;
	}

	int name_count=0;
	char *p_name=p_names;
	while (p_name < p_names+names_size)
	{
		Script::AddChecksumName(Script::GenerateCRC(p_name),(const char*)p_name);
		p_name+=strlen(p_name)+1;
		++name_count;
	}
	free(p_names);

	char p_foo[100];
	sprintf(p_foo,"Loaded %d names from PS2",name_count);
	Printf(p_foo);

	return true;
}

void UnInit()
{
    SNPS2UnInitialise();
}

} // namespace PS2TM
