// ScriptListView.cpp : implementation file
//

#include "stdafx.h"
#include "monitor.h"
#include "ScriptListView.h"
#include "mytreectrl.h"
#include "gel/scripting/debugger.h"
#include "sk/gamenet/scriptdebugger.h"
#include "engine.h"
#include "utils.h"
#include "mycode.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int WM_SCRIPT_LIST = RegisterWindowMessage ("SCRIPT_LIST");

/////////////////////////////////////////////////////////////////////////////
// CScriptListView

IMPLEMENT_DYNCREATE(CScriptListView, CView)

HWND CScriptListView::s_window=NULL;

CScriptListView::CScriptListView()
{
	s_window=NULL;
	m_width=350;
}

CScriptListView::~CScriptListView()
{
	s_window=NULL;
}


BEGIN_MESSAGE_MAP(CScriptListView, CView)
	//{{AFX_MSG_MAP(CScriptListView)
	ON_WM_CREATE()
	ON_REGISTERED_MESSAGE(WM_SCRIPT_LIST, OnScriptList)
	ON_REGISTERED_MESSAGE(WM_DEBUGGER_REFRESH, OnRefreshScriptList)
	ON_REGISTERED_MESSAGE(WM_DEBUGGER_HELP, OnHelp)
	ON_REGISTERED_MESSAGE(WM_SORT_TREE_BY_CPU_TIME,OnSortTreeByCPUTime)
	ON_REGISTERED_MESSAGE(WM_EXPAND_ALL,OnExpandAll)
	ON_REGISTERED_MESSAGE(WM_COLLAPSE_ALL,OnCollapseAll)
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
	ON_WM_ERASEBKGND()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScriptListView drawing

void CScriptListView::OnDraw(CDC* pDC)
{
	CMyListView::OnDraw(pDC);
}

HWND CScriptListView::sGetWindow()
{
	return s_window;
}

void CScriptListView::OnInitialUpdate() 
{
	CMyListView::OnInitialUpdate();
	support_profiling_info();
	add_expand_collapse_buttons();
}

/////////////////////////////////////////////////////////////////////////////
// CScriptListView diagnostics

#ifdef _DEBUG
void CScriptListView::AssertValid() const
{
	CMyListView::AssertValid();
}

void CScriptListView::Dump(CDumpContext& dc) const
{
	CMyListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CScriptListView message handlers

int CScriptListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMyListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	s_window=m_hWnd;

	return 0;
}

afx_msg LRESULT CScriptListView::OnScriptList(WPARAM wParam, LPARAM lParam)
{
	CDocument *p_doc=GetDocument();
	p_doc->SetTitle("Existing CScripts ... press F5 to refresh");

	uint32 *p_data=(uint32*)lParam;

	mp_tree->RemoveAllEntries();
	InsertCStructIntoTree(mp_tree,NULL,(uint8*)p_data);
	mp_tree->CopyToDisplayedTree();

	show_total_cpu_time();

	return (LRESULT)0;
}

// This gets called when F5 is pressed.
afx_msg LRESULT CScriptListView::OnRefreshScriptList(WPARAM wParam, LPARAM lParam)
{
	indicate_waiting_for_reply();

	// Send a refresh request to the PS2
	Net::MsgDesc msg;
	msg.m_Id = GameNet::vMSG_ID_DBG_SEND_CSCRIPT_LIST;
	gClient->EnqueueMessageToServer(&msg);

	return (LRESULT)0;
}

afx_msg LRESULT CScriptListView::OnHelp(WPARAM wParam, LPARAM lParam)
{
	BringUpHelpFile("Script_list_window");
	return (LRESULT)0;
}

void CScriptListView::OnSize(UINT nType, int cx, int cy) 
{
	CMyListView::OnSize(nType, cx, cy);
}

void CScriptListView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CMyListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

BOOL CScriptListView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: Add your message handler code here and/or call default

	return CMyListView::OnEraseBkgnd(pDC);
}
