// ScriptListTree.cpp : implementation file
//

#include "stdafx.h"
#include "monitor.h"
#include "ScriptListTree.h"
#include "checksum.h"
#include "utils.h"
#include "scriptselect.h"
#include "sk/gamenet/scriptdebugger.h"
#include "engine.h"
#include "ignore.h"
#include "mycode.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CScriptListTree

CScriptListTree::CScriptListTree()
{
	m_num_scripts=0;
}

CScriptListTree::~CScriptListTree()
{
}

void CScriptListTree::SetScriptInfo(Dbg::SCScriptInfo *p_info, int n)
{
	Dbg_MsgAssert(n<=Script::MAX_CSCRIPTS,("Bad n"));
	for (int i=0; i<n; ++i)
	{
		mp_script_info[i]=p_info[i];
	}
	m_num_scripts=n;
}

void CScriptListTree::CopyToDisplayedTree()
{
	char p_buf[1024];

	for (int i=0; i<m_num_scripts; ++i)
	{
		HTREEITEM h_parent=InsertItem(Script::FindChecksumName(mp_script_info[i].mBaseScript));
		sprintf(p_buf,"m_unique_id=0x%08x",mp_script_info[i].mId);
		if (mp_script_info[i].mIsSpawned)
		{
			strcat(p_buf,", spawned");
		}
		InsertItem(p_buf,h_parent);

		if (mp_script_info[i].mpObject)
		{
			sprintf(p_buf,"mpObject=0x%08x",mp_script_info[i].mpObject);
			HTREEITEM h_ob_parent=InsertItem(p_buf,h_parent);

			sprintf(p_buf,"m_id=%s",Script::FindChecksumName(mp_script_info[i].mObjectId));
			InsertItem(p_buf,h_ob_parent);

			sprintf(p_buf,"m_type=%s",GetObjectTypeName(mp_script_info[i].mObjectType));
			InsertItem(p_buf,h_ob_parent);
		}
		else
		{
			InsertItem("No object",h_parent);
		}
	}
}

BEGIN_MESSAGE_MAP(CScriptListTree, CTreeCtrl)
	//{{AFX_MSG_MAP(CScriptListTree)
	ON_NOTIFY_REFLECT(NM_RCLICK, OnRclick)
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScriptListTree message handlers

void CScriptListTree::OnRclick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// Figure out what tree item was clicked on.
	CPoint p(GetMessagePos());
    ScreenToClient (&p);
	HTREEITEM h_clicked_item=HitTest(p);

	// Check whether this entry is one of the script names, which it
	// will be if it has no parent.
	if (GetParentItem(h_clicked_item)==NULL)
	{
		// It is a script name, so find out its index by counting
		// from the start until it is found.
		int index=0;
		HTREEITEM h_item=GetRootItem();
		while (true)
		{
			if (h_item==h_clicked_item)
			{
				// Found it!

				// Select the item otherwise the highlight will briefly appear on the
				// item then go back to what it was highlighted on before which looks
				// glitchy.
				SelectItem(h_item);

				WatchScript(mp_script_info[index].mId);
				break;
			}
			if (h_item==NULL)
			{
				// Just for safety, to avoid an infinite loop
				break;
			}

			h_item=GetNextSiblingItem(h_item);
			++index;
		}
	}

	*pResult = 0;
}

void CScriptListTree::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// Note: CScriptListView also has a KeyDown handler, but the tree needs one too because
	// the CScriptListView will not get a keydown message if the tree is selected.
	ConvertKeyPressToMessage(nChar,GetParent());

	CTreeCtrl::OnKeyDown(nChar, nRepCnt, nFlags);
}
