#pragma once

#ifndef __CORE_DEFINES_H
#include "core/defines.h"
#endif

#include "mylistview.h"

// CScriptGlobalView view

class CScriptGlobalView : public CMyListView
{
	DECLARE_DYNCREATE(CScriptGlobalView)

protected:
	CScriptGlobalView();           // protected constructor used by dynamic creation
	virtual ~CScriptGlobalView();

public:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	void OnInitialUpdate();

	uint32 m_id;

protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg LRESULT OnScriptGlobalInfo(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnRefresh(WPARAM wParam, LPARAM lParam);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
};


