// ObjectView.cpp : implementation file
//

#include "stdafx.h"
#include "monitor.h"
#include "ObjectView.h"
#include "MyTreeCtrl.h"
#include "mycode.h"
#include "utils.h"
#include "sk/gamenet/scriptdebugger.h"
#include "engine.h"
#include "checksum.h"
#include "debuggerbutton.h"
#include <gel/scripting/checksum.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int WM_OBJECT_INFO = RegisterWindowMessage ("OBJECT_INFO");
int WM_OBJECT_VIEW_WINDOW__EVERY_FRAME	= RegisterWindowMessage ("OBJECT_VIEW_WINDOW__EVERY_FRAME");
int WM_OBJECT_VIEW_WINDOW__SINGLE_STEP	= RegisterWindowMessage ("OBJECT_VIEW_WINDOW__SINGLE_STEP");
int WM_OBJECT_VIEW_WINDOW__UNPAUSE		= RegisterWindowMessage ("OBJECT_VIEW_WINDOW__UNPAUSE");
int WM_OBJECT_VIEW_WINDOW__VIEW_OBJECT	= RegisterWindowMessage ("OBJECT_VIEW_WINDOW__VIEW_OBJECT");

/////////////////////////////////////////////////////////////////////////////
// CObjectView

IMPLEMENT_DYNCREATE(CObjectView, CView)

enum
{
	BUTTON_INDEX_EVERY_FRAME=0,
	BUTTON_INDEX_SINGLE_STEP=1,
	BUTTON_INDEX_UNPAUSE=2,
	BUTTON_INDEX_VIEW_OBJECT=3
};

CObjectView::CObjectView()
{
	m_id=0;
	m_width=500;
}

CObjectView::~CObjectView()
{
	// Since this window is being closed, ensure that the corresponding object
	// in the game will no longer be sending info every frame.
	ChangeObjectUpdateMode(m_id,Dbg::EVERY_FRAME,false);

	// Also make sure the game is not stuck in a paused state.
	ChangeObjectUpdateMode(m_id,Dbg::SINGLE_STEP,false);

	// and ensure that the camera is not left stuck looking at the object.
	SendViewObjectMessage(m_id,false);

	RemoveWindowFromHashTable(gpObjectWindowHashTable,m_id);
}

BEGIN_MESSAGE_MAP(CObjectView, CView)
	//{{AFX_MSG_MAP(CObjectView)
	ON_REGISTERED_MESSAGE(WM_OBJECT_INFO, OnObjectInfo)
	ON_REGISTERED_MESSAGE(WM_DEBUGGER_HELP, OnHelp)
	ON_REGISTERED_MESSAGE(WM_DEBUGGER_REFRESH, OnRefresh)
	ON_REGISTERED_MESSAGE(WM_OBJECT_VIEW_WINDOW__EVERY_FRAME,OnButtonEveryFrame)
	ON_REGISTERED_MESSAGE(WM_OBJECT_VIEW_WINDOW__SINGLE_STEP,OnButtonSingleStep)
	ON_REGISTERED_MESSAGE(WM_OBJECT_VIEW_WINDOW__UNPAUSE,OnButtonUnpause)
	ON_REGISTERED_MESSAGE(WM_OBJECT_VIEW_WINDOW__VIEW_OBJECT,OnButtonViewObject)
	ON_WM_SIZE()
	ON_WM_CREATE()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
	ON_WM_ERASEBKGND()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CObjectView drawing

void CObjectView::OnDraw(CDC* pDC)
{
	CMyListView::OnDraw(pDC);
}

void CObjectView::OnInitialUpdate() 
{
	CMyListView::OnInitialUpdate();

	// The order these buttons are added must match the indices in the enum above.
	// (The one containing BUTTON_INDEX_EVERY_FRAME etc)
	add_button("Every frame",WM_OBJECT_VIEW_WINDOW__EVERY_FRAME);
	add_button("Single step",WM_OBJECT_VIEW_WINDOW__SINGLE_STEP);
	add_button("Unpause",WM_OBJECT_VIEW_WINDOW__UNPAUSE);
	add_button("View object",WM_OBJECT_VIEW_WINDOW__VIEW_OBJECT);

	mp_buttons[BUTTON_INDEX_EVERY_FRAME]->SetToggleable();
	mp_buttons[BUTTON_INDEX_VIEW_OBJECT]->SetToggleable();

	// To start with the unpause button is disabled since it is only
	// meaningful when in single step mode.
	mp_buttons[BUTTON_INDEX_UNPAUSE]->EnableWindow(FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// CObjectView diagnostics

#ifdef _DEBUG
void CObjectView::AssertValid() const
{
	CMyListView::AssertValid();
}

void CObjectView::Dump(CDumpContext& dc) const
{
	CMyListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CObjectView message handlers

afx_msg LRESULT CObjectView::OnObjectInfo(WPARAM wParam, LPARAM lParam)
{
	GetParentFrame()->BringWindowToTop();

	uint32 *p_data=(uint32*)lParam;
	m_id=*p_data++;

	CDocument *p_doc=GetDocument();
	char p_title[1024];
	sprintf(p_title,"Composite object '%s'",Script::FindChecksumName(m_id));
	p_doc->SetTitle(p_title);

	mp_tree->RemoveAllEntries();
	InsertCStructIntoTree(mp_tree,NULL,(uint8*)p_data);
	mp_tree->CopyToDisplayedTree();

	return (LRESULT)0;
}

// This gets called when F5 is pressed.
afx_msg LRESULT CObjectView::OnRefresh(WPARAM wParam, LPARAM lParam)
{
	indicate_waiting_for_reply();

	// Send a refresh request to the PS2
	Net::MsgDesc msg;
	msg.m_Id = GameNet::vMSG_ID_DBG_SEND_COMPOSITE_OBJECT_INFO;
	msg.m_Length=4;
	msg.m_Data=&m_id;
	gClient->EnqueueMessageToServer(&msg);

	return (LRESULT)0;
}

// This gets called when F1 is pressed.
afx_msg LRESULT CObjectView::OnHelp(WPARAM wParam, LPARAM lParam)
{
	BringUpHelpFile("Object_Window");
	return (LRESULT)0;
}

afx_msg LRESULT CObjectView::OnButtonEveryFrame(WPARAM wParam, LPARAM lParam)
{
	bool every_frame_on=false;

	if (mp_buttons[BUTTON_INDEX_EVERY_FRAME]->GetToggleState())
	{
		// The button has been pressed down, so disable the single-step and
		// unpause buttons so that they cannot be clicked on.
		mp_buttons[BUTTON_INDEX_SINGLE_STEP]->EnableWindow(FALSE);
		mp_buttons[BUTTON_INDEX_UNPAUSE]->EnableWindow(FALSE);

		every_frame_on=true;
	}
	else
	{
		// The button has been toggled back to the up position, 
		// so enable the single-step button.
		mp_buttons[BUTTON_INDEX_SINGLE_STEP]->EnableWindow(TRUE);

		// but disable the unpause button because that is only valid when in
		// single step mode.
		mp_buttons[BUTTON_INDEX_UNPAUSE]->EnableWindow(FALSE);

		every_frame_on=false;
	}

	// Switch the object update mode for this object by sending a message to the PS2.
	ChangeObjectUpdateMode(m_id,Dbg::EVERY_FRAME,every_frame_on);

	return (LRESULT)0;
}

afx_msg LRESULT CObjectView::OnButtonSingleStep(WPARAM wParam, LPARAM lParam)
{
	ChangeObjectUpdateMode(m_id,Dbg::SINGLE_STEP,true);

	// Now that single-step mode is on, enable the unpause button, which allows
	// switching off of single step mode.
	mp_buttons[BUTTON_INDEX_UNPAUSE]->EnableWindow(TRUE);
	return (LRESULT)0;
}

afx_msg LRESULT CObjectView::OnButtonUnpause(WPARAM wParam, LPARAM lParam)
{
	ChangeObjectUpdateMode(m_id,Dbg::SINGLE_STEP,false);

	// Now that single-step mode is off, disable the unpause button since it
	// is only needed when single-step mode is on.
	mp_buttons[BUTTON_INDEX_UNPAUSE]->EnableWindow(FALSE);
	return (LRESULT)0;
}

afx_msg LRESULT CObjectView::OnButtonViewObject(WPARAM wParam, LPARAM lParam)
{
	if (mp_buttons[BUTTON_INDEX_VIEW_OBJECT]->GetToggleState())
	{
		SendViewObjectMessage(m_id,true);
	}
	else
	{
		SendViewObjectMessage(m_id,false);
	}

	return (LRESULT)0;
}

// Need this so that the tree adjusts its size to match that of the window.
void CObjectView::OnSize(UINT nType, int cx, int cy) 
{
	CMyListView::OnSize(nType, cx, cy);
}

int CObjectView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMyListView::OnCreate(lpCreateStruct) == -1)
		return -1;

	// Register itself in the hash table indexed by the object id, so that when
	// a message is received from the game the message can be sent to this window.

	m_id=gNewWindowParams.mId;

	gNewWindowParams.mInfo.mViewHWND=m_hWnd;
	gNewWindowParams.mInfo.mpDocument=GetDocument();

	CWindowInfo *p_new=new CWindowInfo;
	*p_new=gNewWindowParams.mInfo;
	gpObjectWindowHashTable->PutItem(m_id,p_new);
	
	return 0;
}

// Needed so that F5 presses can be detected.
void CObjectView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CMyListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

// Needed so that the background can be cleared to grey so as to match that of
// the tree control, otherwise the background will be white behind the buttons
// at the top.
BOOL CObjectView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: Add your message handler code here and/or call default

	return CMyListView::OnEraseBkgnd(pDC);
}
