// ObjectListView.cpp : implementation file
//

#include "stdafx.h"
#include "Monitor.h"
#include "ObjectListView.h"
#include "utils.h"
#include "mytreectrl.h"
#include "engine.h"
#include "sk/gamenet/scriptdebugger.h"
#include "core/crc.h"

int WM_OBJECT_LIST = RegisterWindowMessage ("OBJECT_LIST");

// CObjectListView

IMPLEMENT_DYNCREATE(CObjectListView, CView)

HWND CObjectListView::s_window=NULL;

CObjectListView::CObjectListView()
{
	m_width=350;
	s_window=NULL;
}

CObjectListView::~CObjectListView()
{
	s_window=NULL;
}

BEGIN_MESSAGE_MAP(CObjectListView, CView)
	ON_REGISTERED_MESSAGE(WM_OBJECT_LIST, OnObjectList)
	ON_REGISTERED_MESSAGE(WM_DEBUGGER_REFRESH, OnRefreshObjectList)
	ON_REGISTERED_MESSAGE(WM_DEBUGGER_HELP, OnHelp)
	ON_REGISTERED_MESSAGE(WM_SORT_TREE_BY_CPU_TIME,OnSortTreeByCPUTime)
	ON_REGISTERED_MESSAGE(WM_EXPAND_ALL,OnExpandAll)
	ON_REGISTERED_MESSAGE(WM_COLLAPSE_ALL,OnCollapseAll)
	ON_WM_CREATE()
	ON_WM_KEYDOWN()
	ON_WM_SIZE()
	ON_WM_ERASEBKGND()
END_MESSAGE_MAP()

// CObjectListView drawing

void CObjectListView::OnDraw(CDC* pDC)
{
	CMyListView::OnDraw(pDC);
}

// CObjectListView diagnostics

#ifdef _DEBUG
void CObjectListView::AssertValid() const
{
	CView::AssertValid();
}

void CObjectListView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

HWND CObjectListView::sGetWindow()
{
	return s_window;
}

void CObjectListView::OnInitialUpdate() 
{
	CMyListView::OnInitialUpdate();
	support_profiling_info();
	//add_expand_collapse_buttons();
}

// CObjectListView message handlers
afx_msg LRESULT CObjectListView::OnObjectList(WPARAM wParam, LPARAM lParam)
{
	CDocument *p_doc=GetDocument();
	p_doc->SetTitle("Existing CCompositeObjects ... press F5 to refresh");

	uint32 *p_data=(uint32*)lParam;

	mp_tree->RemoveAllEntries();
	InsertCStructIntoTree(mp_tree,NULL,(uint8*)p_data);
	mp_tree->CopyToDisplayedTree();

	show_total_cpu_time();
	
	return (LRESULT)0;
}

// This gets called when F5 is pressed.
afx_msg LRESULT CObjectListView::OnRefreshObjectList(WPARAM wParam, LPARAM lParam)
{
	indicate_waiting_for_reply();

	// Send a refresh request to the PS2
	Net::MsgDesc msg;
	msg.m_Id = GameNet::vMSG_ID_DBG_SEND_COMPOSITE_OBJECT_LIST;
	gClient->EnqueueMessageToServer(&msg);

	return (LRESULT)0;
}

int CObjectListView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMyListView::OnCreate(lpCreateStruct) == -1)
		return -1;

	s_window=m_hWnd;

	return 0;
}

// This gets called when F1 is pressed.
afx_msg LRESULT CObjectListView::OnHelp(WPARAM wParam, LPARAM lParam)
{
	BringUpHelpFile("Object_List_Window");
	return (LRESULT)0;
}

void CObjectListView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default
	CMyListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CObjectListView::OnSize(UINT nType, int cx, int cy)
{
	CMyListView::OnSize(nType, cx, cy);

	// TODO: Add your message handler code here
}

BOOL CObjectListView::OnEraseBkgnd(CDC* pDC)
{
	// TODO: Add your message handler code here and/or call default

	return CMyListView::OnEraseBkgnd(pDC);
}
