#include "stdafx.h"
#include <stdio.h>
#include <string.h>

#include "Engine.h"

#include <core/defines.h>
#include <sys/timer.h>
#include <gel/mainloop.h>

#include <gel/net/net.h>
#include <gel/net/server/netserv.h>
#include <gel/net/client/netclnt.h>

#include <Sk/Gamenet/ScriptDebugger.h>

#include "mycode.h"

extern HWND gHWnd;

Net::Client* gClient;

#define MAINLOOP_MEMMARKER 16

enum
{
	EVENT_TIMER_TICK
};

static	Spt::SingletonPtr< Mlp::Manager >	*mlp_manager;
static	Spt::SingletonPtr< Net::Manager >	*net_manager;

VOID CALLBACK	MainLoopTimerProc(  HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime )
{
	(*mlp_manager)->DoGameLogic();
}
 
	
Engine::Engine( void )
{
	char* server_ip;

	Dbg::SetUp();
	Mem::Manager::sSetUp();
	Mem::SetThreadSafe(false);		
	mlp_manager = new Spt::SingletonPtr< Mlp::Manager > ( true );	
	net_manager = new Spt::SingletonPtr< Net::Manager > ( true );
	
	Net::Manager * net_man = Net::Manager::Instance();
	
	gClient = net_man->CreateNewAppClient( 0, "Script Debugger", GameNet::vSCRIPT_DEBUG_PORT, inet_addr(net_man->GetLocalIP()),
										Net::App::mACCEPT_FOREIGN_CONN );
	
	switch (gPlatform)
	{
		case PLATFORM_XBOX:
			server_ip = getenv("XBOX_VIEWER_IP");
			if( server_ip == NULL )
			{
				MessageBox( gHWnd, "You must set up your XBOX_VIEWER_IP environment variable if you want script debugging",
								"Warning", MB_OK|MB_TASKMODAL);		
			}
			break;
		default:
			server_ip = getenv(vSERVER_IP_VARIABLE);
			if( server_ip == NULL )
			{
				MessageBox( gHWnd, "You must set up your VIEWER_IP environment variable if you want script debugging",
								"Warning", MB_OK|MB_TASKMODAL);		
			}
			break;
	}

	Dbg_MsgAssert(server_op,("NULL server_ip"));

	Net::Conn* conn;

	gClient->ConnectToServer( inet_addr( server_ip ), GameNet::vSCRIPT_DEBUG_PORT );
	conn = gClient->NewConnection( inet_addr( server_ip ), GameNet::vSCRIPT_DEBUG_PORT );
	conn->SetSendInterval(0);




	SetTimer( gHWnd, EVENT_TIMER_TICK, 33, MainLoopTimerProc );
}

Engine::~Engine( void )
{
	
	Net::Manager * net_man = Net::Manager::Instance();

	net_man->DestroyApp( gClient );

	delete mlp_manager;
	delete net_manager;

	KillTimer( gHWnd, EVENT_TIMER_TICK );

	Mem::Manager::sCloseDown();	
	Dbg::CloseDown();
}