#if !defined(AFX_MYTREECTRL_H__8399A98E_060D_43A2_8F18_882C1CC2A132__INCLUDED_)
#define AFX_MYTREECTRL_H__8399A98E_060D_43A2_8F18_882C1CC2A132__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// MyTreeCtrl.h : header file
//

class CMyTreeEntry
{
public:
	CMyTreeEntry();
	~CMyTreeEntry();

	enum
	{
		MAX_TEXT_LENGTH=255
	};
	char mpText[MAX_TEXT_LENGTH+1];

	CMyTreeEntry *mpNext;
	CMyTreeEntry *mpChild;
};

	/////////////////////////////////////////////////////////////////////////////
// CMyTreeCtrl window

class CMyTreeCtrl : public CTreeCtrl
{
// Construction
public:
	CMyTreeCtrl();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMyTreeCtrl)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMyTreeCtrl();

	void RemoveAllEntries();
	CMyTreeEntry *GetFirstEntry();
	CMyTreeEntry *AddEntry(const char *p_text, CMyTreeEntry *p_parent=NULL);
	void CopyToDisplayedTree(CMyTreeEntry *p_sourceParent, CMyTreeEntry *p_sourceItem,
							 HTREEITEM h_destParent, HTREEITEM h_destItem);
	void CopyToDisplayedTree();
	HTREEITEM CollapseAllSiblingsButExpandLast(HTREEITEM h_item);
	void ExpandAllSiblingsAndChildren(HTREEITEM h_item, UINT nCode=TVE_EXPAND);
	void ExpandAll(UINT nCode=TVE_EXPAND);
	void BringUpInfoOnItem(HTREEITEM h_item);

protected:
	CMyTreeEntry *mp_first_entry;

	// Generated message map functions
protected:
	//{{AFX_MSG(CMyTreeCtrl)
	afx_msg void OnSelchanging(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnNMDblclk(NMHDR *pNMHDR, LRESULT *pResult);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MYTREECTRL_H__8399A98E_060D_43A2_8F18_882C1CC2A132__INCLUDED_)
