#include "c:/skate5/tools/include/ps2tmapi/ps2tmapi.h"

#ifndef __CORE_LIST_HASHTABLE_H
#include "core/hashtable.h"
#endif

#ifndef __GEL_SCRIPTING_DEBUGGER_H__
#include "gel/scripting/debugger.h"
#endif

#define MOUSE_INFO_LOCATION 0x06E00080
extern SNPS2TargetInfo gTargetInfo;

// Several hash tables of these exist, indexed using the id of the window.
class CWindowInfo
{
public:
	CWindowInfo() {mViewHWND=NULL; mpDocument=NULL;}
	~CWindowInfo() {}

	HWND mViewHWND;
	CDocument *mpDocument;
};

// A global instance of this is used to pass params to the CMonitorView OnCreate function.
// Naughty to use a global to pass params I know, but the only way to create a new
// sub window is using the mpMultiDocTemplate->OpenDocumentFile(NULL); function,
// which is an MFC function so cannot take any extra params.
// So to create a new sub-window, put the id you want to give the window in the 
// mId member of gNewWindowParams, then call OpenDocumentFile.
// This will create the window, and the CMonitorView OnCreate will then
// fill in the CWindowInfo members, and add itself to the hash table.
class CNewWatchWindowParams 
{
public:
	CNewWatchWindowParams() {mId=0;}

	uint32 mId;
	CWindowInfo mInfo;
};

extern Lst::HashTable<CWindowInfo> *gpWindowHashTable;
extern CNewWatchWindowParams gNewWindowParams;

extern Lst::HashTable<CWindowInfo> *gpObjectWindowHashTable;
extern Lst::HashTable<CWindowInfo> *gpScriptGlobalWindowHashTable;

enum EPlatform 
{
	PLATFORM_PS2,
	PLATFORM_XBOX,
};

extern EPlatform gPlatform;

extern bool gMouseEdgeIsOnLeft;

void CleanUp();
void Assert(int Condition, char *pMessage);
void Printf(const char *p_message);
int EnumCallBack(SNPS2TargetInfo* p_targetInfo);
void MyCodeInit();
void SetMouseEdgeLeft();
void SetMouseEdgeRight();
void SetPlatformPS2();
void SetPlatformXBox();
void ExportChecksumNames();
void ConnectToServer();

void RemoveWindowFromHashTable(Lst::HashTable<CWindowInfo> *p_table, uint32 id);
void RemoveAllWindowsFromHashTable(Lst::HashTable<CWindowInfo> *p_table);
void WatchScript(uint32 script_id);
void ChangeObjectUpdateMode(uint32 objectId, Dbg::EObjectUpdateMode mode, bool on);
void SendViewObjectMessage(uint32 objectId, bool view_on);

