#include "FuncEnter.h"

/*
	NodeSelect.cpp
	Node selector control
	Assigns node name by clicking on a node in the viewport
*/

#include "NodeSelect.h"
#define  CUSTIDC_BUTTON         1
#define  CUSTIDC_BUTTONCHOOSER  2
#define  CUSTIDC_EDIT           3
#define  CUSTIDC_BUTTONSELECT   4

extern Interface* gInterface;

class NSAddCallback: public HitByNameDlgCallback
{
	NodeSelect *ns;

public:
	NSAddCallback(NodeSelect* ns) { FUNC_ENTER("NSAddCallback::NSAddCallback");  this->ns = ns; }

	void  SetNodeSelect(NodeSelect* ns) { FUNC_ENTER("NSAddCallback::SetNodeSelect");  this->ns = ns; }
	TCHAR *dialogTitle()	{ FUNC_ENTER("NSAddCallback::dialogTitle");  return _T("Select node (DynUI)"); }
	TCHAR *buttonText() 	{ FUNC_ENTER("NSAddCallback::buttonText");  return _T("Add"); }
	//BOOL singleSelect()		{ return TRUE; }
	BOOL singleSelect()		{ FUNC_ENTER("NSAddCallback::singleSelect");  return FALSE; }
	BOOL useFilter()		{ FUNC_ENTER("NSAddCallback::useFilter");  return TRUE; }
	int filter(INode *node)	{ FUNC_ENTER("NSAddCallback::filter");  return TRUE; }
	BOOL useProc()			{ FUNC_ENTER("NSAddCallback::useProc");  return TRUE; }
	
	void proc(INodeTab &nodeTab) 
	{ FUNC_ENTER("NSAddCallback::proc");  
		if (ns) 
		{
			if (nodeTab.Count() > 0)
				ns->SetNode(nodeTab[0]); 
		}
	}

	BOOL doCustomHilite()	{ FUNC_ENTER("NSAddCallback::doCustomHilite");  return FALSE; }
	BOOL doHilite(INode *node)	{ FUNC_ENTER("NSAddCallback::doHilite");  return FALSE; }
	BOOL showHiddenAndFrozen()	{ FUNC_ENTER("NSAddCallback::showHiddenAndFrozen");  return FALSE; }
};

class NodeSelectPicker : public PickModeCallback,
		public PickNodeCallback 
{
public:			
	NodeSelect *ns;
	NodeSelectPicker() { FUNC_ENTER("NodeSelectPicker::NodeSelectPicker");  ns = NULL; }
	BOOL HitTest(IObjParam *ip,HWND hWnd,ViewExp *vpt,IPoint2 m,int flags);		
	BOOL Pick(IObjParam *ip,ViewExp *vpt);		
	void EnterMode(IObjParam *ip);
	void ExitMode(IObjParam *ip);
	BOOL Filter(INode *node);
	PickNodeCallback *GetFilter() { FUNC_ENTER("NodeSelectPicker::GetFilter"); return this;}
	BOOL RightClick(IObjParam *ip,ViewExp *vpt) { FUNC_ENTER("NodeSelectPicker::RightClick"); return TRUE;}
};

static NodeSelectPicker theNodePickMode;

BOOL NodeSelectPicker::Filter(INode *node)
{ FUNC_ENTER("NodeSelectPicker::Filter"); 
	Object* obj=node->EvalWorldState(0).obj;

	if (obj->SuperClassID() == GEOMOBJECT_CLASS_ID ||
		obj->SuperClassID() == HELPER_CLASS_ID)
		return TRUE;

	return FALSE;
}

BOOL NodeSelectPicker::HitTest(IObjParam *ip,HWND hWnd,ViewExp *vpt,IPoint2 m,int flags)
{ FUNC_ENTER("NodeSelectPicker::HitTest"); 	
	if (ip->PickNode(hWnd,m,this))
		return TRUE;
	else
		return FALSE;
}

BOOL NodeSelectPicker::Pick(IObjParam *ip,ViewExp *vpt)
{ FUNC_ENTER("NodeSelectPicker::Pick"); 
	INode *node = vpt->GetClosestHit();
	
	if (node)
	{
		ns->SetNode(node);
		//ExitMode(ip);
		return TRUE;
	}

	return FALSE;
}

void NodeSelectPicker::EnterMode(IObjParam *ip)
{ FUNC_ENTER("NodeSelectPicker::EnterMode"); 
	if (ns && ns->ibutton)
	{
		ns->ibutton->SetCheck(TRUE);
	}

	GetCOREInterface()->PushPrompt("Select Node Target");
}

void NodeSelectPicker::ExitMode(IObjParam *ip)
{ FUNC_ENTER("NodeSelectPicker::ExitMode"); 
	if (ns && ns->ibutton)
		ns->ibutton->SetCheck(FALSE);

	GetCOREInterface()->PopPrompt();
}

/////////////////////////////////////////// End picker class

NodeSelect::NodeSelect(HINSTANCE hInstance) :
	UIControl(hInstance, CLASS)
{ FUNC_ENTER("NodeSelect::NodeSelect"); 
	iedit          = NULL;
	ibutton        = NULL;
	ibuttonChooser = NULL;
	ibuttonSelect  = NULL;
	addCB          = NULL;

	bLockChooser   = false;
}

NodeSelect::~NodeSelect()
{ FUNC_ENTER("NodeSelect::~NodeSelect"); 
	theNodePickMode.ns = NULL;
	
	if (addCB)
		addCB->SetNodeSelect(NULL);

	gInterface->ClearPickMode();

	if (ibutton)
		ReleaseICustButton(ibutton);

	if (ibuttonChooser)
		ReleaseICustButton(ibuttonChooser);

	if (ibuttonSelect)
		ReleaseICustButton(ibuttonSelect);

	if (iedit)
		ReleaseICustEdit(iedit);

	if (addCB)
		delete addCB;
}

NodeSelect::NodeSelect(NodeSelect& right) :
	UIControl(right.hInstance, CLASS)
{ FUNC_ENTER("NodeSelect::NodeSelect"); 
	iedit             = NULL;
	ibutton           = NULL;
	ibuttonChooser    = NULL;
	ibuttonSelect     = NULL;
	addCB             = NULL;

	hwndButton        = NULL;
	hwndButtonChooser = NULL;
	hwndEdit          = NULL;
	bLockChooser      = false;

	node              = right.node;
	value             = right.value;
}

NodeSelect& NodeSelect::operator = (NodeSelect& right)
{ FUNC_ENTER("NodeSelect::operator="); 
	iedit             = NULL;
	ibutton           = NULL;
	ibuttonChooser    = NULL;
	addCB             = NULL;

	hwndButton        = NULL;
	hwndButtonChooser = NULL;
	hwndEdit          = NULL;
	bLockChooser      = false;

	ibutton           = NULL;
	ibuttonChooser    = NULL;
	iedit             = NULL;
	node              = right.node;
	value             = right.value;
	
	addCB             = NULL;

	return *this;
}

HWND NodeSelect::GetFocusWindow()
{ FUNC_ENTER("NodeSelect::GetFocusWindow"); 
	return hwndEdit;
}

LRESULT NodeSelect::WndProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{ FUNC_ENTER("NodeSelect::WndProc"); 
	switch(msg)
	{
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case CUSTIDC_BUTTON:
			theNodePickMode.ns = this;
			gInterface->SetPickMode(&theNodePickMode);
			return TRUE;

		case CUSTIDC_BUTTONCHOOSER:
			if (bLockChooser)
				return TRUE;

			bLockChooser = true;
			gInterface->DoHitByNameDialog(addCB);
			bLockChooser = false;

			return TRUE;

		case CUSTIDC_BUTTONSELECT:
			Select();
			return TRUE;

		case CUSTIDC_EDIT:
			{
				switch(HIWORD(wParam))
				{
				case EN_CHANGE:
					{
						HWND hwndParent = GetParent(this->hwnd);

						int  ID = (int)GetWindowLong(hwnd,GWL_ID);
						//SendMessage(hwndParent,WM_CHILDGOTFOCUS,(WPARAM)ID,0);
						SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
						return TRUE;
					}

				case EN_SETFOCUS:
					{
						HWND hwndParent = GetParent(hwnd);
						int  ID = (int)GetWindowLong(hwnd,GWL_ID);
						SendMessage(hwndParent,WM_CHILDGOTFOCUS,(WPARAM)ID,0);
						return TRUE;
					}
				}
			}
		}
	}

	return UIControl::WndProc(hwnd, msg, wParam, lParam);
	//return DefWindowProc(hwnd,msg,wParam,lParam);
}

void NodeSelect::BuildControlUI()
{ FUNC_ENTER("NodeSelect::BuildControlUI"); 
	RECT wndRect;
	GetClientRect(hwnd,&wndRect);

	int width = wndRect.right - wndRect.left;

	hwndButton = CreateWindow("CustButton",
		                      "None",
							  WS_CHILD|WS_VISIBLE,
							  width-10,
							  0,
							  10,
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)CUSTIDC_BUTTON,
							  hInstance,
							  NULL);

	hwndButtonChooser = CreateWindow("CustButton",
		                             "None",
							         WS_CHILD|WS_VISIBLE,
							         width-20,
							         0,
							         10,
							         wndRect.bottom - wndRect.top,
							         hwnd,
							         (HMENU)CUSTIDC_BUTTONCHOOSER,
							         hInstance,
							         NULL);

	hwndSelect = CreateWindow("CustButton",
		                      "None",
							  WS_CHILD|WS_VISIBLE,
							  width - 30,
							  0,
							  10,
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)CUSTIDC_BUTTONSELECT,
							  hInstance,
							  NULL);

	hwndEdit = CreateWindow("CustEdit",
		                      "None",
							  WS_CHILD|WS_VISIBLE,
							  0,
							  0,
							  wndRect.right - wndRect.left - 30,
							  wndRect.bottom - wndRect.top,
							  hwnd,
							  (HMENU)CUSTIDC_EDIT,
							  hInstance,
							  NULL);

	ibutton        = GetICustButton(hwndButton);
	ibuttonChooser = GetICustButton(hwndButtonChooser);
	ibuttonSelect  = GetICustButton(hwndSelect);
	iedit          = GetICustEdit(hwndEdit);

	iedit->WantDlgNextCtl(TRUE);

	ibutton->SetText("P");
	ibuttonChooser->SetText("C");
	ibuttonSelect->SetText("S");

	ibutton->SetType(CBT_CHECK);
	SetValue(value,FALSE);

	addCB = new NSAddCallback(this);
}

CStr NodeSelect::GetValue()
{ FUNC_ENTER("NodeSelect::GetValue"); 
	char buf[256];
	iedit->GetText(buf,255);

	if (!buf || strcmp(buf, "[none]") == 0 ||
		strlen(buf) == 0)
		return CStr("[none]");

	return CStr(buf);
}

void NodeSelect::SetValue(CStr value, bool bNotify)
{ FUNC_ENTER("NodeSelect::SetValue"); 
	if (value == CStr("[none]"))
		value = "";
	
	if (iedit)
	{
		iedit->SetText(value);
	}

	this->value = value;

	if (bNotify)
	{
		HWND hwndParent = GetParent(hwnd);

		int  ID = (int)GetWindowLong(hwnd,GWL_ID);
		//SendMessage(hwndParent,WM_CHILDGOTFOCUS,(WPARAM)ID,0);
		//SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
	}
}

void NodeSelect::SetNode(INode* node)
{ FUNC_ENTER("NodeSelect::SetNode"); 
	this->node = node;
	
	if (iedit)
	{
		if (node)
			iedit->SetText(node->GetName());
		else
			iedit->SetText("");

		HWND hwndParent = GetParent(hwnd);

		int  ID = (int)GetWindowLong(hwnd,GWL_ID);
		//SendMessage(hwndParent,WM_CHILDGOTFOCUS,(WPARAM)ID,0);
		SendMessage(hwndParent,WM_CHILDUPDATED,(WPARAM)ID,0);
	}
}

INode* NodeSelect::GetNode()
{ FUNC_ENTER("NodeSelect::GetNode"); 
	CStr name = GetValue();
	return gInterface->GetINodeByName(name);
}

void NodeSelect::Select()
{ FUNC_ENTER("NodeSelect::Select"); 
	INode* node = GetNode();
	gInterface->SelectNode(node);
	gInterface->ForceCompleteRedraw();
}
