#include "FuncEnter.h"

#include <Trigger/Trigger.h>
#include <next.h>
#include <Link/LinkUI.h>

#define vHIDE_TRIGGER_CLASS_ID		Class_ID(0x55f35044, 0x17d947f2)
#define vHIDE_TRIGGER_SHORTCUT_ID	 0x17d947f2

#define NumElements(array) (sizeof(array) / sizeof(array[0]))

extern HINSTANCE hInstance;

ActionTable*	GetHideTriggerActions( void );

const ActionTableId hide_trigger_actions = vHIDE_TRIGGER_SHORTCUT_ID;
const ActionContextId hide_trigger_actions_context = vHIDE_TRIGGER_SHORTCUT_ID;

// action table
static ActionDescription s_hide_trigger_actions[] = 
{
	ID_HIDE_TRIGGERS,
    IDS_HIDE_TRIGGERS,
    IDS_HIDE_TRIGGERS,
    IDS_TRIGGER_ACTIONS,

    ID_UNHIDE_TRIGGERS,
    IDS_UNHIDE_TRIGGERS,
    IDS_UNHIDE_TRIGGERS,
    IDS_TRIGGER_ACTIONS,
};

class HideTrigger : public GUP 
{
	public:
      
		HideTrigger () { FUNC_ENTER("HideTrigger::HideTrigger"); }
		~HideTrigger	() { FUNC_ENTER("HideTrigger::~HideTrigger"); }
	
		// GUP Methods
		DWORD	Start			( );
		void	Stop			( );
		DWORD	Control			( DWORD parameter );	
};

static HideTrigger s_hide_trigger;

class HideTriggerClassDesc:public ClassDesc 
{
public:

	int 			IsPublic()					{ FUNC_ENTER("HideTriggerClassDesc::IsPublic");  return TRUE; }
	void *			Create( BOOL loading )		{ FUNC_ENTER("HideTriggerClassDesc::Create");  return &s_hide_trigger; }
	const TCHAR *	ClassName()					{ FUNC_ENTER("HideTriggerClassDesc::ClassName");  return _T("HideTrigger"); }
	SClass_ID		SuperClassID()				{ FUNC_ENTER("HideTriggerClassDesc::SuperClassID");  return GUP_CLASS_ID; }
	Class_ID 		ClassID()					{ FUNC_ENTER("HideTriggerClassDesc::ClassID");  return vHIDE_TRIGGER_CLASS_ID; }
	const TCHAR* 	Category()					{ FUNC_ENTER("HideTriggerClassDesc::Category");  return _T("");  }	
	
	//You only need to add the action stuff to one Class Desc
	int             NumActionTables() { FUNC_ENTER("HideTriggerClassDesc::NumActionTables");  return 1; }
	ActionTable*  GetActionTable(int i) { FUNC_ENTER("HideTriggerClassDesc::GetActionTable");  return GetHideTriggerActions(); }
};

static HideTriggerClassDesc	s_hide_trigger_cd;
ClassDesc* GetHideTriggerClassDesc( void ) { FUNC_ENTER("GetHideTriggerClassDesc");  return &s_hide_trigger_cd; }

// Accelerator table callback for Link operations
class HideTriggerActionCB : public ActionCallback 
{
public:		
	BOOL ExecuteAction( int id );
};

static HideTriggerActionCB *accel = NULL;

DWORD	HideTrigger::Start( void )
{ FUNC_ENTER("HideTrigger::Start"); 
	accel = new HideTriggerActionCB;
	gInterface->GetActionManager()->ActivateActionTable( accel, hide_trigger_actions );

	return GUPRESULT_KEEP;
}

void	HideTrigger::Stop( void )
{ FUNC_ENTER("HideTrigger::Stop"); 
}

DWORD	HideTrigger::Control( DWORD parameter )
{ FUNC_ENTER("HideTrigger::Control"); 
	return 0;
}

ActionTable* GetHideTriggerActions( void )
{ FUNC_ENTER("GetHideTriggerActions"); 
    TSTR name = "Hide Triggers";
    HACCEL hAccel = LoadAccelerators(hInstance,
                                     MAKEINTRESOURCE(IDR_HIDE_TRIGGER_ACCELERATOR));
    int numOps = NumElements( s_hide_trigger_actions );
    ActionTable* pTab;
    pTab = new ActionTable( hide_trigger_actions, hide_trigger_actions_context, name, hAccel, numOps,
                             s_hide_trigger_actions, hInstance);
    GetCOREInterface()->GetActionManager()->RegisterActionContext( hide_trigger_actions_context, name.data());

    return pTab;
}

BOOL HideTriggerActionCB::ExecuteAction( int id )
{ FUNC_ENTER("HideTriggerActionCB::ExecuteAction"); 
	switch( id )
	{
		case ID_HIDE_TRIGGERS:
		{
			INode* root;
			int i, num_children;

			root = gInterface->GetRootNode();
			num_children = root->NumberOfChildren();
			for( i = 0; i < num_children; i++ )
			{
				INode* node;
				Object *obj;
				
				node = root->GetChildNode( i );
				obj = node->EvalWorldState(0).obj;
				if( ( obj->ClassID() == vTRIGGER_CLASS_ID ) ||
					( obj->ClassID() == vLINK_OBJ_CLASS_ID ))
				{
					node->Hide( TRUE );
				}				
			}
			gInterface->ForceCompleteRedraw();
			break;
		}
		case ID_UNHIDE_TRIGGERS:
		{
			INode* root;
			int i, num_children;

			root = gInterface->GetRootNode();
			num_children = root->NumberOfChildren();
			for( i = 0; i < num_children; i++ )
			{
				INode* node;
				Object *obj;
				
				node = root->GetChildNode( i );
				obj = node->EvalWorldState(0).obj;
				if( ( obj->ClassID() == vTRIGGER_CLASS_ID ) ||
					( obj->ClassID() == vLINK_OBJ_CLASS_ID ))
				{
					node->Hide( FALSE );
				}
			}
			gInterface->ForceCompleteRedraw();
			break;
		}
	}

	return TRUE;
}
