/*
	SubClassWnd.h
	Subclassed Window Manager
	2-5-01
*/

#ifndef __SUBCLASSWND__
#define __SUBCLASSWND__

#include <windows.h>
#include "../misc/llist.h"

struct SubClassWnd
{
	HWND    hwnd;
	WNDPROC oldWndProc;
};

class SubClassWndMan
{
	LinkList<SubClassWnd> wndDB;
	WNDPROC newWndProc;

public:
	SubClassWndMan(WNDPROC newProc);
	~SubClassWndMan();

	inline void RegisterNewWndProc(WNDPROC newProc) { newWndProc=newProc; }

	WNDPROC GetOldProc(HWND hwnd);
	void RegisterWnd(HWND hwnd);
	void UnRegisterWnd(HWND hwnd);
	void UnRegisterAllWindows();
};

#endif
