#include "FuncEnter.h"

/*
	SubClassWnd.cpp
	Subclassed Window Manager
	2-5-01
*/

#include "SubClassWnd.h"

SubClassWndMan::SubClassWndMan(WNDPROC newProc)
{ FUNC_ENTER("SubClassWndMan::SubClassWndMan"); 
	RegisterNewWndProc(newProc);
}

SubClassWndMan::~SubClassWndMan()
{ FUNC_ENTER("SubClassWndMan::~SubClassWndMan"); 
	UnRegisterAllWindows();
}

void SubClassWndMan::RegisterWnd(HWND hwnd)
{ FUNC_ENTER("SubClassWndMan::RegisterWnd"); 
	SubClassWnd newWnd;

	newWnd.hwnd=hwnd;
	newWnd.oldWndProc=(WNDPROC)GetWindowLong(hwnd,GWL_WNDPROC);
	SetWindowLong(hwnd,GWL_WNDPROC,(LONG)newWndProc);
	SetWindowLong(hwnd,GWL_USERDATA,(LONG)newWnd.oldWndProc);
}

void SubClassWndMan::UnRegisterWnd(HWND hwnd)
{ FUNC_ENTER("SubClassWndMan::UnRegisterWnd"); 
	Link<SubClassWnd>* curNode=wndDB.GetHead();

	while(curNode)
	{
		if (curNode->data.hwnd==hwnd)
		{
			SetWindowLong(hwnd,GWL_WNDPROC,(LONG)curNode->data.oldWndProc);
			wndDB.Remove(curNode);
			return;
		}

		curNode=curNode->next;
	}
}

void SubClassWndMan::UnRegisterAllWindows()
{ FUNC_ENTER("SubClassWndMan::UnRegisterAllWindows"); 
	Link<SubClassWnd>* curNode=wndDB.GetHead();

	while(curNode)
	{
		SetWindowLong(curNode->data.hwnd,GWL_WNDPROC,(LONG)curNode->data.oldWndProc);
		curNode=curNode->next;
	}

	wndDB.Clear();
}

WNDPROC SubClassWndMan::GetOldProc(HWND hwnd)
{ FUNC_ENTER("SubClassWndMan::GetOldProc"); 
	Link<SubClassWnd>* curNode = wndDB.GetHead();

	while(curNode)
	{
		if (curNode->data.hwnd == hwnd)
			return curNode->data.oldWndProc;

		curNode=curNode->next;
	}

	return NULL;
}
