#include "FuncEnter.h"

/*
	PreProcessor.cpp
	This class provides a DynUI command // @program | [ms file]
	where ms file is a MAXScript file that generates a template for .q scripts
	The generated template file is filled in by the preprocessor with the
	values of the parameters within the property list in the UIautomatic script generation for an object type in scripts.ini or
	for a parameter set attached to a function (script or C code)

	MAXScript commands
*/

#include <windows.h>
#include "PreProcessor.h"
#include "../UI/PropList.h"
#include "../MaxScriptInt.h"
#include "Next.h"
#include "appdata.h"
#include "path.h"
#include "../PropEdit/ParseFuncs.h"
#include "../UI/RichText.h"
#include "../Export/SceneExportOptions.h"
#include "../Export/ScriptExport.h"
#include "UserConfig.h"

#define MAX_POST_BUFFER_SIZE  1024 * 1024		// Allocate 1 Meg to be used to communicate with the DLX

extern Interface* gInterface;
extern CRITICAL_SECTION gCriticalSection;
extern HINSTANCE hInstance;

DynScriptPreprocessor::DynScriptPreprocessor()
{ FUNC_ENTER("DynScriptPreprocessor::DynScriptPreprocessor"); 
	bLock = false;

	pMemNode=NULL;
	pMemPropDataSize=NULL;
	pMemPropData=NULL;
	hMemNode=NULL;
	hMemPropDataSize=NULL;
	hMemPropData=NULL;
	hMemSharedData=NULL;
	pSharedData=NULL;
	AllocMemMaps();
}

DynScriptPreprocessor::~DynScriptPreprocessor()
{ FUNC_ENTER("DynScriptPreprocessor::~DynScriptPreprocessor"); 
	// Cleanup IPC stuff
	FlushMemMaps();
}

void DynScriptPreprocessor::AllocMemMaps()
{ FUNC_ENTER("DynScriptPreprocessor::AllocMemMaps"); 
	FlushMemMaps();

	// Create the necessary Windows memory file mappings for IPC
	hMemNode = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                         NULL,
								 PAGE_READWRITE,
								 0,
								 sizeof(INode*),
								 "NExtGUPCurrentNode");

	if (!hMemNode)
		OutputDebugString("DynScriptPreProcessor: IPC init failed (hMemNode)\n");

	hMemPropDataSize = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                                 NULL,
										 PAGE_READWRITE,
										 0,
										 sizeof(int),
										 "NExtGUPPropDataSize");

	if (!hMemPropDataSize)
		OutputDebugString("DynScriptPreProcessor: IPC init failed (hMemPropDataSize)\n");

	hMemSharedData = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                               NULL,
									   PAGE_READWRITE,
									   0,
									   sizeof(int),
									   "NExtSharedData");

	if (!hMemSharedData)
		OutputDebugString("DynScriptPreProcessor: IPC init failed (hMemPropDataSize)\n");

	// hMemPropData must be created later since it is of variable size
	hMemPropData = NULL;
	pMemPropData = NULL;

	pMemNode = (INode**)MapViewOfFile(hMemNode,
		                              FILE_MAP_ALL_ACCESS,
							          0,0,0);

	*pMemNode = NULL;

	if (!pMemNode)
		OutputDebugString("DynScriptPreProcessor: IPC init failed (pMemNode)\n");

	pMemPropDataSize = (int*)MapViewOfFile(hMemPropDataSize,
		                                   FILE_MAP_ALL_ACCESS,
									       0,0,0);

	*pMemPropDataSize = 0;

	if (!pMemPropDataSize)
		OutputDebugString("DynScriptPreProcessor: IPC init failed (pMemPropDataSize)\n");

	pSharedData = (SharedData*)MapViewOfFile(hMemSharedData,
		                                     FILE_MAP_ALL_ACCESS,
											 0,0,0);

	ZeroMemory(pSharedData,sizeof(SharedData));
	//AssignSharedData();
}

void DynScriptPreprocessor::AssignSharedData()
{ FUNC_ENTER("DynScriptPreprocessor::AssignSharedData"); 
	if (pSharedData)
	{
		SceneExportOptions seo;

		GetSceneExportOptions(&seo);
		strcpy(pSharedData->LevelName,seo.m_SceneName);

		pSharedData->maxParticles = -1;
	}
}

void DynScriptPreprocessor::AssignSharedParticleMax(int max)
{ FUNC_ENTER("DynScriptPreprocessor::AssignSharedParticleMax"); 
	if (pSharedData)
	{
		pSharedData->maxParticles = max;
	}
}

void DynScriptPreprocessor::AssignEmitScript(char* buf)
{ FUNC_ENTER("DynScriptPreprocessor::AssignEmitScript"); 
	if (pSharedData)
	{
		strcpy(pSharedData->EmitScript, buf);
	}
}

void DynScriptPreprocessor::FlushMemMaps()
{ FUNC_ENTER("DynScriptPreprocessor::FlushMemMaps"); 
	if (pMemNode)
	{
		UnmapViewOfFile(pMemNode);
		pMemNode=NULL;
	}

	if (pMemPropDataSize)
	{
		UnmapViewOfFile(pMemPropDataSize);
		pMemPropDataSize=NULL;
	}

	if (pMemPropData)
	{
		UnmapViewOfFile(pMemPropData);
		pMemPropData=NULL;
	}

	if (pSharedData)
	{
		UnmapViewOfFile(pSharedData);
		pSharedData=NULL;
	}

	if (hMemNode)
	{
		CloseHandle(hMemNode);
		hMemNode=NULL;
	}

	if (hMemPropDataSize)
	{
		CloseHandle(hMemPropDataSize);
		hMemPropDataSize=NULL;
	}

	if (hMemPropData)
	{
		CloseHandle(hMemPropData);
		hMemPropData=NULL;
	}

	if (hMemSharedData)
	{
		CloseHandle(hMemSharedData);
		hMemSharedData=NULL;
	}
}

void DynScriptPreprocessor::ReplaceFlags(CStr& buf,CStr& colorbuf,DWORD flags,DWORD mask,CStr name)
{ FUNC_ENTER("DynScriptPreprocessor::ReplaceFlags"); 
	char* cname = strrchr(name,'/');

	if (cname)
		cname++;
	else
		cname = name;

	CStr tagName = CStr("<") + CStr(cname) + CStr(">");

	if (flags & mask)
	{
		buf      = ReplaceStr(strTemplate,tagName,"TRUE");
		colorbuf = ReplaceStr(strTemplate,tagName,SRTF_RED + SRTF_UNDERLINE + "TRUE" + SRTF_UNDERLINEOFF + SRTF_BLACK);
	}
	else
	{
		buf      = ReplaceStr(strTemplate,tagName,"FALSE");
		colorbuf = ReplaceStr(strTemplate,tagName,SRTF_RED + SRTF_UNDERLINE + "FALSE" + SRTF_UNDERLINEOFF + SRTF_BLACK);
	}
}

void DynScriptPreprocessor::BuildTemplate(LinkList<ConfigProp>* cprops,DWORD flags)
{ FUNC_ENTER("DynScriptPreprocessor::BuildTemplate"); 
	strTemplate = RetrieveMAXScriptData();
	strColorTemplate = strTemplate;

	// Replace any tags in the MAXScript data with the appropriate values from the
	// property list

	Link<ConfigProp>* curprop = cprops->GetHead();

	while(curprop)
	{
		char* name = strrchr(curprop->data.name,'/');

		if (name)
			name++;
		else
			name = curprop->data.name;

		CStr tagName   = CStr("<") + CStr(name) + CStr(">");
		CStr tagValue, tagValueColor;

		tagValueColor = SRTF_RED + SRTF_UNDERLINE + curprop->data.value + SRTF_UNDERLINEOFF + SRTF_BLACK;
		tagValue      = curprop->data.value;

		strTemplate      = ReplaceStr(strTemplate,tagName,tagValue);
		strColorTemplate = ReplaceStr(strColorTemplate,tagName,tagValueColor);

		curprop=curprop->next;
	}

//	ReplaceFlags(strTemplate,strColorTemplate,flags,CCLASS_CREATEDATSTART,"CreatedAtStart");
//	ReplaceFlags(strTemplate,strColorTemplate,flags,CCLASS_ABSENTINNETGAMES,"AbsentInNetGames");
	ReplaceFlags(strTemplate,strColorTemplate,flags,CCLASS_TRICKOBJECT,"TrickObject");
//	ReplaceFlags(strTemplate,strColorTemplate,flags,CCLASS_OCCLUDER,"Occluder");
}

CStr DynScriptPreprocessor::GetTemplateScript(Link<ScriptBuf>* buf,LinkList<ConfigProp>* cprops)
{ FUNC_ENTER("DynScriptPreprocessor::GetTemplateScript"); 
	CStr strTemplate =  buf->data.buffer;
	Link<ConfigProp>* curprop = cprops->GetHead();

	while(curprop)
	{
		char* name = strrchr(curprop->data.name,'/');
		
		if (name)
			name++;
		else
			name = curprop->data.name;

		CStr tagName  = CStr("<") + CStr(name) + CStr(">");
		CStr tagValue;
		tagValue      = curprop->data.value;

		strTemplate      = ReplaceStr(strTemplate,tagName,tagValue);
		curprop=curprop->next;
	}

	return strTemplate;
}

void DynScriptPreprocessor::BuildTemplate(PropList* plist)
{ FUNC_ENTER("DynScriptPreprocessor::BuildTemplate"); 
	strTemplate = RetrieveMAXScriptData();
	strColorTemplate = strTemplate;

	// Replace any tags in the MAXScript data with the appropriate values from the
	// property list

	int count = plist->NumProps();

	for(int i=0;i<count;i++)
	{
		CStr strName = plist->GetName(i);

		char* name = strrchr(strName,'/');

		if (name)
			name++;
		else
			name = strName;

		CStr tagName   = CStr("<") + CStr(name) + CStr(">");
		CStr tagValue, tagValueColor;

		plist->GetValue(i,tagValue);
		tagValueColor = SRTF_RED + SRTF_UNDERLINE + tagValue + SRTF_UNDERLINEOFF + SRTF_BLACK;

		strTemplate      = ReplaceStr(strTemplate,tagName,tagValue);
		strColorTemplate = ReplaceStr(strColorTemplate,tagName,tagValueColor);
	}

	if (IsInstr(strTemplate,"<MaxParticles>"))
	{
		int zzz;
		zzz = 0;
	}
}

void DynScriptPreprocessor::PostMAXScriptNode(INode* node)
{ FUNC_ENTER("DynScriptPreprocessor::PostMAXScriptNode"); 
	/*  This method is unreliable, MAX has some internal problems calling RemoveAppDataChunk
	    from within NExtScript.dlx  probably due to attempting to free data from another
		process
	AppDataChunk* appdata;
	INode* root = gInterface->GetRootNode();

	appdata = root->GetAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_SE_MAXSCRIPT_NODE_OUTPUT_ID);

	if (appdata &&
		appdata->data)
	{
		root->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_SE_MAXSCRIPT_NODE_OUTPUT_ID);
	}

	INode** data = (INode**)malloc(sizeof(INode*));
	*data = node;

	root->AddAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_SE_MAXSCRIPT_NODE_OUTPUT_ID,
		                  sizeof(INode*),data);	
	*/

	// We'll use a Windows memory-mapped file for IPC purposes  (aml)
	// Copy our data into the memory mapping

	*pMemNode = node;
}

/*
void DynScriptPreprocessor::PostMAXScriptData(LinkList<ConfigProp>* cprops,DWORD flags)
{
	INode* node = gInterface->GetRootNode();
	char*  data;
	char*  pos;

	EnterCriticalSection(&gCriticalSection);

	// Assign the size of the data to shared memory
	*pMemPropDataSize = sizeof(int)+sizeof(PropertyData)*(cprops->GetSize()+NUM_CCLASSES);

	if (pMemPropData)
		UnmapViewOfFile(pMemPropData);

	if (hMemPropData)
		CloseHandle(hMemPropData);

	hMemPropData = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                             NULL,
							         PAGE_READWRITE,
							         0,
							         sizeof(int)+sizeof(PropertyData)*(cprops->GetSize()+NUM_CCLASSES),
							         "NExtGUPPropertyData");

	if (!hMemPropData)
	{
		OutputDebugString("DynScriptPreprocessor::PostMAXScriptData:  Failed to create file mapping for IPC (propdata)\n");
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	pMemPropData = (char*)MapViewOfFile(hMemPropData,
								        FILE_MAP_ALL_ACCESS,
								        0,0,sizeof(int)+sizeof(PropertyData)*(cprops->GetSize()+NUM_CCLASSES));

	if (!pMemPropData)
	{
		DWORD dwErr = GetLastError();
		OutputDebugString("DynScriptPreprocessor::PostMAXScriptData:  Failed to create file map window for IPC (propdata)\n");
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	//data  = (char*)malloc(sizeof(int)+sizeof(PropertyData)*(cprops->GetSize()+NUM_CCLASSES));
	data = pMemPropData;

	*((int*)data) = cprops->GetSize() + NUM_CCLASSES;
	pos  = data + sizeof(int);

	// Write flag properties
	PropertyData *pdata = (PropertyData*)pos;

	strcpy(pdata->name,"CreatedAtStart");

	if (flags & CCLASS_CREATEDATSTART)
		strcpy(pdata->value,"TRUE");
	else
		strcpy(pdata->value,"FALSE");

	pdata->type = PROPTYPE_CHECK;

	pos += sizeof(PropertyData);

	pdata = (PropertyData*)pos;

	strcpy(pdata->name,"AbsentInNetGames");

	if (flags & CCLASS_ABSENTINNETGAMES)
		strcpy(pdata->value,"TRUE");
	else
		strcpy(pdata->value,"FALSE");

	pdata->type = PROPTYPE_CHECK;

	pos += sizeof(PropertyData);

	pdata = (PropertyData*)pos;

	strcpy(pdata->name,"TrickObject");

	if (flags & CCLASS_TRICKOBJECT)
		strcpy(pdata->value,"TRUE");
	else
		strcpy(pdata->value,"FALSE");

	pdata->type = PROPTYPE_CHECK;

	pos += sizeof(PropertyData);

	pdata = (PropertyData*)pos;

	strcpy(pdata->name,"Occluder");
	
	if (flags & CCLASS_OCCLUDER)
		strcpy(pdata->value,"TRUE");
	else
		strcpy(pdata->value,"FALSE");

	pdata->type = PROPTYPE_CHECK;

	pos += sizeof(PropertyData);

	PropList tempList(hInstance,1);

	BuildPropList(&tempList,cprops);

	// Add property list content to data chunk
	int count = cprops->GetSize();
	Link<ConfigProp>* curprop = cprops->GetHead();

	for(int i=0;i<count;i++)
	{
		PropertyData* pdata = (PropertyData*)pos;
		CStr          value;

		assert(tempList.GetName(i).Length()<255);
		assert(value.Length()<255);

		CStr strName = tempList.GetName(i);

		char* name = strrchr(strName,'/');
		if (name)
			name++;
		else
			name = strName;

		strcpy(pdata->name,name);
		strcpy(pdata->value,curprop->data.value);
		pdata->type = tempList.GetType(i);

		pos += sizeof(PropertyData);
		curprop = curprop->next;
	}

	/* This method causes the MAX SDK to attempt to free invalid memory on a call to RemoveAppDataChunk
	   in NExtScript.dlx  probably due to freeing accross process boundaries.
	AppDataChunk* appdata;

	appdata = node->GetAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_PE_MAXSCRIPT_OUTPUT_ID);

	if (appdata &&
		appdata->data)
	{
		node->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_PE_MAXSCRIPT_OUTPUT_ID);
	}

	node->AddAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_PE_MAXSCRIPT_OUTPUT_ID,
		                  sizeof(int)+sizeof(PropertyData)*(cprops->GetSize() + NUM_CCLASSES),data);	
	*/
/*
	LeaveCriticalSection(&gCriticalSection);
}
*/

void DynScriptPreprocessor::PostMAXScriptData(LinkList<ConfigProp>* cprops,DWORD flags)
{ FUNC_ENTER("DynScriptPreprocessor::PostMAXScriptData"); 
	INode* node = gInterface->GetRootNode();
	char*  data;
	char*  pos;

	EnterCriticalSection(&gCriticalSection);

	// Assign the size of the data to shared memory
	*pMemPropDataSize = sizeof(int)+sizeof(PropertyData)*(cprops->GetSize()+NUM_CCLASSES);

//	if (pMemPropData)
//		UnmapViewOfFile(pMemPropData);

//	if (hMemPropData)
//		CloseHandle(hMemPropData);

	if (!hMemPropData)
	hMemPropData = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                             NULL,
							         PAGE_READWRITE,
							         0,
							         sizeof(int)+sizeof(PropertyData)*(cprops->GetSize()+NUM_CCLASSES),
							         "NExtGUPPropertyData");

	if (!hMemPropData)
	{
		OutputDebugString("DynScriptPreprocessor::PostMAXScriptData:  Failed to create file mapping for IPC (propdata)\n");
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	if (!pMemPropData)
	pMemPropData = (char*)MapViewOfFile(hMemPropData,
								        FILE_MAP_ALL_ACCESS,
								        0,0,sizeof(int)+sizeof(PropertyData)*(cprops->GetSize()+NUM_CCLASSES));

	if (!pMemPropData)
	{
		DWORD dwErr = GetLastError();
		OutputDebugString("DynScriptPreprocessor::PostMAXScriptData:  Failed to create file map window for IPC (propdata)\n");
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	//data  = (char*)malloc(sizeof(int)+sizeof(PropertyData)*(cprops->GetSize()+NUM_CCLASSES));
	data = pMemPropData;

	*((int*)data) = cprops->GetSize() + NUM_CCLASSES;
	pos  = data + sizeof(int);

	// Write flag properties
	PropertyData *pdata = (PropertyData*)pos;

//	strcpy(pdata->name,"CreatedAtStart");
//
//	if (flags & CCLASS_CREATEDATSTART)
//		strcpy(pdata->value,"TRUE");
//	else
//		strcpy(pdata->value,"FALSE");
//
//	pdata->type = PROPTYPE_CHECK;
//
//	pos += sizeof(PropertyData);
//
//	pdata = (PropertyData*)pos;
//
//	strcpy(pdata->name,"AbsentInNetGames");
//
//	if (flags & CCLASS_ABSENTINNETGAMES)
//		strcpy(pdata->value,"TRUE");
//	else
//		strcpy(pdata->value,"FALSE");
//
//	pdata->type = PROPTYPE_CHECK;
//
//	pos += sizeof(PropertyData);
//
//	pdata = (PropertyData*)pos;

	strcpy(pdata->name,"TrickObject");

	if (flags & CCLASS_TRICKOBJECT)
		strcpy(pdata->value,"TRUE");
	else
		strcpy(pdata->value,"FALSE");

	pdata->type = PROPTYPE_CHECK;

	pos += sizeof(PropertyData);

//	pdata = (PropertyData*)pos;
//
//	strcpy(pdata->name,"Occluder");
//	
//	if (flags & CCLASS_OCCLUDER)
//		strcpy(pdata->value,"TRUE");
//	else
//		strcpy(pdata->value,"FALSE");
//
//	pdata->type = PROPTYPE_CHECK;
//
//	pos += sizeof(PropertyData);

	PropList tempList(hInstance,1);

	BuildPropList(&tempList,cprops);

	// Add property list content to data chunk
	int count = cprops->GetSize();
	Link<ConfigProp>* curprop = cprops->GetHead();

	for(int i=0;i<count;i++)
	{
		PropertyData* pdata = (PropertyData*)pos;
		CStr          value;

		assert(tempList.GetName(i).Length()<255);
		assert(value.Length()<255);

		CStr strName = tempList.GetName(i);

		char* name = strrchr(strName,'/');
		if (name)
			name++;
		else
			name = strName;

		strcpy(pdata->name,name);

		CStr propvalue;
		tempList.GetValue(i,propvalue); 

		strcpy(pdata->value,propvalue);
		pdata->type = tempList.GetType(i);

		pos += sizeof(PropertyData);
		curprop = curprop->next;
	}

	/* This method causes the MAX SDK to attempt to free invalid memory on a call to RemoveAppDataChunk
	   in NExtScript.dlx  probably due to freeing accross process boundaries.
	AppDataChunk* appdata;

	appdata = node->GetAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_PE_MAXSCRIPT_OUTPUT_ID);

	if (appdata &&
		appdata->data)
	{
		node->RemoveAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_PE_MAXSCRIPT_OUTPUT_ID);
	}

	node->AddAppDataChunk(vNEXT_CLASS_ID,GUP_CLASS_ID,vNAPP_PE_MAXSCRIPT_OUTPUT_ID,
		                  sizeof(int)+sizeof(PropertyData)*(cprops->GetSize() + NUM_CCLASSES),data);	
	*/

	LeaveCriticalSection(&gCriticalSection);
}

void DynScriptPreprocessor::PostMAXScriptData(PropList* plist)
{ FUNC_ENTER("DynScriptPreprocessor::PostMAXScriptData"); 
	EnterCriticalSection(&gCriticalSection);

	char*  data;
	char*  pos;

	// Assign the size of the data to shared memory
	*pMemPropDataSize = sizeof(int)+sizeof(PropertyData)*(plist->NumProps());

	if (*pMemPropDataSize > MAX_POST_BUFFER_SIZE)
	{
		MessageBox(gInterface->GetMAXHWnd(),"WARNING! The property data exceeds the maximum space allowed for IPC!  Tell Adam.\nProperty data will not be posted for external access!","IPC Limit Exceeded",MB_ICONWARNING|MB_OK);
		return;
	}

//	if (pMemPropData)
//		UnmapViewOfFile(pMemPropData);

//	if (hMemPropData)
//		CloseHandle(hMemPropData);

	if (!hMemPropData)
	hMemPropData = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                             NULL,
							         PAGE_READWRITE,
							         0,
							         MAX_POST_BUFFER_SIZE /**pMemPropDataSize*/, // 1M buffer data
							         "NExtGUPPropertyData");

	if (!hMemPropData)
	{
		OutputDebugString("DynScriptPreprocessor::PostMAXScriptData:  Failed to create file mapping for IPC (propdata)\n");
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	if (!pMemPropData)
	pMemPropData = (char*)MapViewOfFile(hMemPropData,
								        FILE_MAP_ALL_ACCESS,
								        0,0,MAX_POST_BUFFER_SIZE);

//	pMemPropData = (char*)MapViewOfFile(hMemPropData,
//								        FILE_MAP_ALL_ACCESS,
//								        0,0,*pMemPropDataSize);

	if (!pMemPropData)
	{
		OutputDebugString("DynScriptPreprocessor::PostMAXScriptData:  Failed to create file map window for IPC (propdata)\n");
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	//data  = (char*)malloc(sizeof(int)+sizeof(PropertyData)*(cprops->GetSize()+NUM_CCLASSES));
	data = pMemPropData;
	
	int count = plist->NumProps();

	*((int*)data) = count;
	pos  = data + sizeof(int);

	for(int i=0;i<count;i++)
	{
		PropertyData* pdata = (PropertyData*)pos;
		CStr          value;

		plist->GetValue(i,value);

		assert(plist->GetName(i).Length()<255);
		assert(value.Length()<255);

		CStr strName = plist->GetName(i);

		char* name = strrchr(strName,'/');

		if (name)
			name++;
		else
			name = strName;

		strcpy(pdata->name,name);
		strcpy(pdata->value,value);
		pdata->type = plist->GetType(i);

		pos+=sizeof(PropertyData);
	}

	LeaveCriticalSection(&gCriticalSection);
}

/*
void DynScriptPreprocessor::PostMAXScriptData(PropList* plist)
{
	EnterCriticalSection(&gCriticalSection);

	char*  data;
	char*  pos;

	// Assign the size of the data to shared memory
	*pMemPropDataSize = sizeof(int)+sizeof(PropertyData)*(plist->NumProps());

	if (pMemPropData)
		UnmapViewOfFile(pMemPropData);

	if (hMemPropData)
		CloseHandle(hMemPropData);

	hMemPropData = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                             NULL,
							         PAGE_READWRITE,
							         0,
							         *pMemPropDataSize,
							         "NExtGUPPropertyData");

	if (!hMemPropData)
	{
		OutputDebugString("DynScriptPreprocessor::PostMAXScriptData:  Failed to create file mapping for IPC (propdata)\n");
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	pMemPropData = (char*)MapViewOfFile(hMemPropData,
								        FILE_MAP_ALL_ACCESS,
								        0,0,*pMemPropDataSize);

	if (!pMemPropData)
	{
		OutputDebugString("DynScriptPreprocessor::PostMAXScriptData:  Failed to create file map window for IPC (propdata)\n");
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	//data  = (char*)malloc(sizeof(int)+sizeof(PropertyData)*(cprops->GetSize()+NUM_CCLASSES));
	data = pMemPropData;
	
	int count = plist->NumProps();

	*((int*)data) = count;
	pos  = data + sizeof(int);

	for(int i=0;i<count;i++)
	{
		PropertyData* pdata = (PropertyData*)pos;
		CStr          value;

		plist->GetValue(i,value);

		assert(plist->GetName(i).Length()<255);
		assert(value.Length()<255);

		CStr strName = plist->GetName(i);

		char* name = strrchr(strName,'/');

		if (name)
			name++;
		else
			name = strName;

		strcpy(pdata->name,name);
		strcpy(pdata->value,value);
		pdata->type = plist->GetType(i);

		pos+=sizeof(PropertyData);
	}

	LeaveCriticalSection(&gCriticalSection);
}
*/

CStr DynScriptPreprocessor::RetrieveMAXScriptData()
{ FUNC_ENTER("DynScriptPreprocessor::RetrieveMAXScriptData"); 
	HANDLE hMemBufSize = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                                   NULL,
										   PAGE_READONLY,
										   0,
										   sizeof(int),
										   "NExtDLXScriptBufSize");

	if (!hMemBufSize)
		return CStr("");

	int* pMemBufSize = (int*)MapViewOfFile(hMemBufSize,
		                                   FILE_MAP_READ,
										   0,0,0);

	if (!pMemBufSize)
	{
		CloseHandle(hMemBufSize);
		return CStr("");
	}

	HANDLE hMemBuf = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                               NULL,
									   PAGE_READONLY,
									   0,
									   *pMemBufSize,
									   "NExtDLXScriptBuf");

	if (!hMemBuf)
	{
		UnmapViewOfFile(pMemBufSize);
		CloseHandle(hMemBufSize);
		return CStr("");
	}

	char* pMemBuf = (char*)MapViewOfFile(hMemBuf,
		                                 FILE_MAP_READ,
										 0,0,0);

	if (!pMemBuf)
	{
		UnmapViewOfFile(pMemBufSize);
		CloseHandle(hMemBufSize);
		CloseHandle(hMemBuf);
		return CStr("");
	}

	CStr buffer = pMemBuf;

	UnmapViewOfFile(pMemBufSize);
	UnmapViewOfFile(pMemBuf);
	CloseHandle(hMemBufSize);
	CloseHandle(hMemBuf);

	return buffer;
}

void DynScriptPreprocessor::RetrieveExtMAXScriptData()
{ FUNC_ENTER("DynScriptPreprocessor::RetrieveExtMAXScriptData"); 
	EnterCriticalSection(&gCriticalSection);

	scriptBuffers.Clear();

	HANDLE hMemBufSize = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                                   NULL,
										   PAGE_READONLY,
										   0,
										   sizeof(int),
										   "NExtDLXBufSize");

	if (!hMemBufSize)
		return;

	int* pMemBufSize = (int*)MapViewOfFile(hMemBufSize,
		                                   FILE_MAP_READ,
										   0,0,0);

	if (!pMemBufSize)
	{
		CloseHandle(hMemBufSize);
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	HANDLE hMemBuf = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                               NULL,
									   PAGE_READONLY,
									   0,
									   *pMemBufSize,
									   "NExtDLXBuf");

	if (!hMemBuf)
	{
		UnmapViewOfFile(pMemBufSize);
		CloseHandle(hMemBufSize);
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	char* pMemBuf = (char*)MapViewOfFile(hMemBuf,
		                                 FILE_MAP_READ,
										 0,0,0);

	if (!pMemBuf)
	{
		UnmapViewOfFile(pMemBufSize);
		CloseHandle(hMemBufSize);
		CloseHandle(hMemBuf);
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	char* pos = pMemBuf;

	int numBuffers = *((int*)pos);
	pos+=sizeof(int);

	for(int i=0;i<numBuffers;i++)
	{
		ScriptBuf sbuf;

		int scriptNameLen = *((int*)pos);
		pos+=sizeof(int);

		char* buf = new char[scriptNameLen];
		strcpy(buf,pos);
		pos+=scriptNameLen;
		
		sbuf.scriptName = buf;
		delete buf;
		
		int bufferLen = *((int*)pos);
		pos+=sizeof(int);

		buf = new char[bufferLen];
		strcpy(buf,pos);
		pos+=bufferLen;

		sbuf.buffer = buf;
		scriptBuffers.Add(&sbuf);
	}

	UnmapViewOfFile(pMemBufSize);
	UnmapViewOfFile(pMemBuf);
	CloseHandle(hMemBufSize);
	CloseHandle(hMemBuf);

	LeaveCriticalSection(&gCriticalSection);
}

void DynScriptPreprocessor::RetrieveMAXScriptValues(PropList* plist)
{ FUNC_ENTER("DynScriptPreprocessor::RetrieveMAXScriptValues"); 
	EnterCriticalSection(&gCriticalSection);

	// Retrieve the property data from shared memory
	HANDLE hMemBufSize = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                                   NULL,
										   PAGE_READONLY,
										   0,
										   sizeof(int),
										   "NExtGUPPropDataSize");

	if (!hMemBufSize)
	{
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	int* pMemBufSize = (int*)MapViewOfFile(hMemBufSize,
		                                   FILE_MAP_READ,
										   0,0,0);

	if (!pMemBufSize)
	{
		CloseHandle(hMemBufSize);
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	HANDLE hMemBuf = CreateFileMapping((HANDLE)0xFFFFFFFF,
		                               NULL,
									   PAGE_READONLY,
									   0,
									   *pMemBufSize,
									   "NExtGUPPropertyData");

	if (!hMemBuf)
	{
		UnmapViewOfFile(pMemBufSize);
		CloseHandle(hMemBufSize);
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	char* pMemBuf = (char*)MapViewOfFile(hMemBuf,
		                                 FILE_MAP_READ,
										 0,0,0);

	if (!pMemBuf)
	{
		UnmapViewOfFile(pMemBufSize);
		CloseHandle(hMemBufSize);
		CloseHandle(hMemBuf);
		LeaveCriticalSection(&gCriticalSection);
		return;
	}

	int   num = *((int*)pMemBuf);
	char* pos = ((char*)pMemBuf)+sizeof(int);

	PropertyData* pdata;
	
	for(int i=0;i<num;i++)
	{
		pdata = (PropertyData*)pos;
		plist->SetValue(pdata->name,pdata->value);

		pos+=sizeof(PropertyData);
	}

	UnmapViewOfFile(pMemBuf);
	UnmapViewOfFile(pMemBufSize);
	CloseHandle(hMemBuf);
	CloseHandle(hMemBufSize);

	LeaveCriticalSection(&gCriticalSection);
}

bool DynScriptPreprocessor::LoadScript(char* filename)
{ FUNC_ENTER("DynScriptPreprocessor::LoadScript"); 
	FILE* fp;
	char  lineBuf[1024];

	//if (scriptName==CStr(filename))
	//	return true;

	//CStr path = getenv(APP_ENV);
	//path+=CStr(TEMPLATE_PATH)+filename;

	CStr path = GetTemplatePath();
	
	scriptName = filename;

	fp = fopen(path,"r");

	if (!fp)
		return false;

	scriptData = "";

	while(!feof(fp))
	{
		fgets(lineBuf,1023,fp);
		scriptData+=lineBuf;
	}

	fclose(fp);
	return true;
}

void DynScriptPreprocessor::UpdateDynUIScripts(PropList* plist,CStr strScript)
{ FUNC_ENTER("DynScriptPreprocessor::UpdateDynUIScripts"); 
	if (bLock)
		return;

	bLock = true;

	PostMAXScriptData(plist);

	// Load in the script
	if (!LoadScript(strScript))
		return;

	if (pMemNode)
		RunScriptCommand(scriptData, *pMemNode, scriptName);
	else
		RunScriptCommand(scriptData);
	
	// Set any values in the property list that the MAXScript may have reassigned
	RetrieveMAXScriptValues(plist);
	
	BuildTemplate(plist);

	bLock = false;
}

void DynScriptPreprocessor::UpdateDynUIScripts(LinkList<ConfigProp>* cprops,DWORD flags,CStr strScript)
{ FUNC_ENTER("DynScriptPreprocessor::UpdateDynUIScripts"); 
	if (bLock)
		return;

	bLock = true;

	PostMAXScriptData(cprops,flags);

	// Load in the script
	if (!LoadScript(strScript))
	{
		bLock = false;
		return;
	}

	if (pMemNode)
		RunScriptCommand(scriptData, *pMemNode, scriptName);
	else
		RunScriptCommand(scriptData);

	BuildTemplate(cprops,flags);

	bLock = false;
}

void DynScriptPreprocessor::ClearAltScripts()
{ FUNC_ENTER("DynScriptPreprocessor::ClearAltScripts"); 
	RunScriptCommand("nsClearScripts()\n");
}
